/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.XYDataPair;
import com.jrefinery.data.XYDataset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;

public class DefaultXYDataset
extends AbstractSeriesDataset
implements XYDataset {
    private List seriesNames;
    private List allSeriesData;

    public DefaultXYDataset() {
        this.seriesNames = new ArrayList();
        this.allSeriesData = new ArrayList();
    }

    public DefaultXYDataset(Object[][][] objectArray) {
        this(DefaultXYDataset.seriesNameListFromDataArray((Object[][])objectArray), objectArray);
    }

    public DefaultXYDataset(String[] stringArray, Object[][][] objectArray) {
        this(Arrays.asList(stringArray), objectArray);
    }

    public DefaultXYDataset(List list, Object[][][] objectArray) {
        this.seriesNames = list;
        int n = objectArray.length;
        this.allSeriesData = new ArrayList(n);
        int n2 = 0;
        while (n2 < n) {
            ArrayList<XYDataPair> arrayList = new ArrayList<XYDataPair>();
            int n3 = objectArray[n2].length;
            int n4 = 0;
            while (n4 < n3) {
                Object object = objectArray[n2][n4][0];
                if (object != null) {
                    Serializable serializable;
                    Number number = null;
                    if (object instanceof Number) {
                        number = (Number)object;
                    } else if (object instanceof Date) {
                        serializable = (Date)object;
                        number = new Long(serializable.getTime());
                    } else {
                        number = new Integer(0);
                    }
                    serializable = (Number)objectArray[n2][n4][1];
                    arrayList.add(new XYDataPair(number, (Number)serializable));
                }
                ++n4;
            }
            Collections.sort(arrayList);
            this.allSeriesData.add(n2, arrayList);
            ++n2;
        }
    }

    public int getSeriesCount() {
        return this.allSeriesData.size();
    }

    public int getItemCount(int n) {
        List list = (List)this.allSeriesData.get(n);
        return list.size();
    }

    public String getSeriesName(int n) {
        return this.seriesNames.get(n).toString();
    }

    public void setSeriesNames(String[] stringArray) {
        this.seriesNames = Arrays.asList(stringArray);
        this.fireDatasetChanged();
    }

    public Number getXValue(int n, int n2) {
        List list = (List)this.allSeriesData.get(n);
        XYDataPair xYDataPair = (XYDataPair)list.get(n2);
        return xYDataPair.getX();
    }

    public Number getYValue(int n, int n2) {
        List list = (List)this.allSeriesData.get(n);
        XYDataPair xYDataPair = (XYDataPair)list.get(n2);
        return xYDataPair.getY();
    }

    public static List seriesNameListFromDataArray(Object[][] objectArray) {
        String string = "com.jrefinery.data.resources.DataPackageResources";
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        String string2 = resourceBundle.getString("series.default-prefix") + " ";
        int n = objectArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(string2 + (n2 + 1));
            ++n2;
        }
        return arrayList;
    }
}

