/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: DocumentFragment.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:56:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.xmlsearch.xml.qe;

import java.io.*;
import com.sun.xmlsearch.tree.TocTree;

public final class DocumentFragment implements Externalizable {
    // flags
    private static final int TREE = 1;
    private static final int PATH = TREE << 1;
    
    private TocTree  _tree;
    private int[]    _path;
    private byte[]   _html;
    private int      _nHighlights;
    
    public DocumentFragment() { /* for Externalizable */ }

    public byte[] getHTML() {
	return _html;
    }

    public int getNumberOfHighlights() {
	return _nHighlights;
    }

    public void setNumberOfHighlights(int n) {
	_nHighlights = n;
    }

    public InputStream getInputStream() {
	return new ByteArrayInputStream(_html);
    }

    public TocTree.TocNode[] nodes() {
	return _tree.getNodes(_path);
    }

    public TocTree getTocTree() {
	return _tree;
    }

    public int[] getPath() {
	return _path;
    }

    public void setTOC(TocTree tocTree) {
	_tree = tocTree;
    }
  
    public void setHTML(byte[] html) {
	_html = html;
    }

    public void setPath(int[] path) {
	_path = path;
    }

    public void readExternal(ObjectInput in)
	throws ClassNotFoundException, IOException {
	int flags  = in.readInt();
	int nBytes = in.readInt();
	_nHighlights = in.readInt();
	if ((flags & TREE) > 0)
	    (_tree = new TocTree()).readExternal(in);
	if ((flags & PATH) > 0)
	    _path = (int[]) in.readObject();
	if (nBytes > 0)
	    in.readFully(_html = new byte[nBytes]);
    }
  
    public void writeExternal(ObjectOutput out) throws IOException {
	out.writeInt((_tree != null ? TREE : 0) | (_path != null ? PATH : 0));
	out.writeInt(_html != null ? _html.length : 0);
	out.writeInt(_nHighlights);
	if (_tree != null)
	    _tree.writeExternal(out);
	if (_path != null)
	    out.writeObject(_path);
	if (_html != null)
	    out.write(_html);
    }
}
  
