/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dlg_InsertStatistic.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:27:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CHART2_DLG_INSERT_STATISTIC_GRID_HXX
#define _CHART2_DLG_INSERT_STATISTIC_GRID_HXX

// header for class ModalDialog
#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif
// header for class FixedLine
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
// header for class CheckBox
#ifndef _SV_BUTTON_HXX
#include <vcl/button.hxx>
#endif
// header for class SfxItemSet
#ifndef _SFXITEMSET_HXX
#include <svtools/itemset.hxx>
#endif
// header for class MetricField
#ifndef _SV_FIELD_HXX
#include <vcl/field.hxx>
#endif
// header for class ValueSet
#ifndef _VALUESET_HXX
#include <svtools/valueset.hxx>
#endif
// header for enum SvxChartKindError
#include "SchSfxItemIds.hxx"
#include "SchAllDefinesFor_svx_chrtitem.hxx"
#ifndef _SVX_CHRTITEM_HXX
#include <svx/chrtitem.hxx>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

/*************************************************************************
|*
|* Datenbeschriftungen-Dialog
|*
\************************************************************************/
class SchDataStatisticsDlg : public ModalDialog
{
private:
	CheckBox            aCbxAverage;
	RadioButton         aRbtNone;
	RadioButton         aRbtVariant;
	RadioButton         aRbtSigma;
	RadioButton         aRbtPercent;
	RadioButton         aRbtBigError;
	RadioButton         aRbtConst;
	FixedLine			aFlDescr;
	MetricField         aMtrFldPercent;
	MetricField         aMtrFldBigError;
	FixedText		    aFTConstPlus;
	MetricField         aMtrFldConstPlus;
	FixedText		    aFTConstMinus;
	MetricField         aMtrFldConstMinus;
	FixedText		    aFTIndicate;
	FixedText		    aFTRegress;
	ValueSet 		    aSet;
	ValueSet 		    aRegression;
	OKButton			aBtnOK;
	CancelButton		aBtnCancel;
	HelpButton			aBtnHelp;
    bool                m_bEnableRegression;

	const SfxItemSet    &rInAttrs;
	SvxChartKindError   m_eErrorKind;
    bool                m_bErrorKindUnique;
	SvxChartIndicate    m_eIndicate;
    bool                m_bIndicatorUnique;
	SvxChartRegress     m_eRegression;
    bool                m_bRegressionUnique;

    bool                m_bPlusUnique;
    bool                m_bMinusUnique;

	DECL_LINK(CbxClick, CheckBox *);
	DECL_LINK(RBtnClick, Button *);
	DECL_LINK(SelectIndicate, void *);
	DECL_LINK(SelectRegression, void *);
// 	DECL_LINK(EditLoseFocusHdl, Control*);

	void Reset();
    void FillValueSets();

public:
	SchDataStatisticsDlg (Window           *pParent,
						  const SfxItemSet &rMyAttrs);

	virtual ~SchDataStatisticsDlg ();

	void GetAttr(SfxItemSet &rOutAttrs);

    virtual void	DataChanged( const DataChangedEvent& rDCEvt );

    void EnableRegression( bool bEnable = true );
};

//.............................................................................
} //namespace chart
//.............................................................................

#endif

