/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: datarow.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:48:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop
#include <svx/svditer.hxx>

#include "datarow.hxx"
#include "glob.hxx"



/*************************************************************************
|*
|* Datenreihen-Index ermitteln
|*
\************************************************************************/

SchDataRow* GetDataRow(const SdrObject& rObj)
{
	USHORT i=rObj.GetUserDataCount();//#63904 2x Schleife (15%), 50% pData, 18% id
	while(i--)
	{
		SdrObjUserData *pData = rObj.GetUserData(i);
		if (pData && pData->GetId() == SCH_DATAROW_ID)
			return (SchDataRow*)pData;
	}

	return NULL;
}

/*************************************************************************
|*
|* Objekt mit Datenreihen-Index suchen;
|* liefert NULL, wenn kein Objekt gefunden wurde.
|*
\************************************************************************/

SdrObject* GetObjWithRow(short nRow, const SdrObjList& rObjList,
						 ULONG* pIndex)
{
	ULONG nIndex = 0;

	SdrObjListIter aIterator(rObjList, IM_FLAT);
	while (aIterator.IsMore())
	{
		SdrObject* pObj = aIterator.Next();
		SchDataRow* pDataRow = GetDataRow(*pObj);
		if (pDataRow && pDataRow->GetRow() == nRow)
		{
			if (pIndex)
				*pIndex = nIndex;
			return pObj;
		}

		nIndex++;
	}

	return NULL;
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchDataRow::SchDataRow() :
	SdrObjUserData(SchInventor, SCH_DATAROW_ID, 0),
	nRow(0)
{
}

/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchDataRow::SchDataRow(short nR) :
	SdrObjUserData(SchInventor, SCH_DATAROW_ID, 0),
	nRow(nR)
{
}

/*************************************************************************
|*
|* Kopier-Konstruktor
|*
\************************************************************************/

SchDataRow::SchDataRow(const SchDataRow& rDataRow) :
	SdrObjUserData(rDataRow),
	nRow(rDataRow.nRow)
{
}

/*************************************************************************
|*
|* Kopie erzeugen
|*
\************************************************************************/

SdrObjUserData* SchDataRow::Clone(SdrObject *pObj) const
{
	return new SchDataRow(*this);
}

/*************************************************************************
|*
|* Daten in Stream schreiben
|*
\************************************************************************/

//BFS01void SchDataRow::WriteData(SvStream& rOut)
//BFS01{
//BFS01	SdrObjUserData::WriteData(rOut);
//BFS01
//BFS01	rOut << (INT16)nRow;
//BFS01}

/*************************************************************************
|*
|* Daten aus Stream lesen
|*
\************************************************************************/

//BFS01void SchDataRow::ReadData(SvStream& rIn)
//BFS01{
//BFS01	SdrObjUserData::ReadData(rIn);
//BFS01
//BFS01	INT16 nInt16;
//BFS01
//BFS01	rIn >> nInt16; nRow = (short)nInt16;
//BFS01}



