/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: futransform.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:51:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _FUTRANSFORM_HXX_
#define _FUTRANSFORM_HXX_

#include "fupoor.hxx"

#ifndef _SVX_RECTENUM_HXX
#include <svx/rectenum.hxx>
#endif

class SchFuTransform : public SchFuPoor
{
private:
    static Rectangle CreateNewDiagrammRectangle(
        const Rectangle& rNewSnapRect, const Rectangle& rOldSnapRect
        , const Rectangle& rDiagrammRectangle);
public:
	TYPEINFO();

	SchFuTransform( SchViewShell* pViewShell, SchWindow* pWindow, SchView* pView,
                    ChartModel* pModel, SfxRequest& rRequest );

	virtual ~SchFuTransform();

	virtual void Activate();
	virtual void Deactivate();

	Point	GetPoint( Rectangle aRect, RECT_POINT eRP );
};

#endif	// _FUTRANSFORM_HXX_
