#*************************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: makefile.mk,v $
#
#   $Revision: 1.9 $
#
#   last change: $Author: rt $ $Date: 2005/09/09 11:45:53 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
#*************************************************************************

PRJ=..$/..

PRJNAME=sysui
TARGET=cde

# --- Settings -----------------------------------------------------

.INCLUDE :  settings.mk

# --- Product Version Information ----------------------------------

.INCLUDE :  ../productversion.mk

# --- Files --------------------------------------------------------

.IF "$(OS)"=="SOLARIS"

# menu launcher files
LAUNCHERDIR = $(MISC)$/$(TARGET)
LAUNCHERFLAGFILE = $(MISC)$/$(TARGET)/$(UNIXFILENAME).flag

ULFDIR = $(COMMONMISC)$/desktopshare

.ENDIF # "$(OS)"=="SOLARIS"

# --- Targets ------------------------------------------------------

.INCLUDE :  target.mk

.IF "$(OS)"=="SOLARIS"
ALLTAR : $(LAUNCHERFLAGFILE)

$(LAUNCHERFLAGFILE) : brand.pl merge.pl translate.pl makefile.mk $(ULFDIR)/launcher_name.ulf

$(LAUNCHERFLAGFILE): {writer calc draw impress math base printeradmin}.{fp dt}
	@$(MKDIRHIER) $(LAUNCHERDIR)/types
	-@$(RM) -rf $(LAUNCHERDIR)/types/*
	@echo Patching CDE frontpanel templates ..
	@$(PERL) brand.pl -p "$(LONGPRODUCTNAME)" -u $(@:b) $< $(LAUNCHERDIR)/types/C
	@echo Translating CDE frontpanel templates ..
	@$(PERL) translate.pl -p "$(LONGPRODUCTNAME)" -d $(LAUNCHERDIR)/types -k "fp,LABEL,PUSH_ACTION" -k "dt,LABEL,EXEC_STRING" $(ULFDIR)/launcher_name.ulf
	@echo Merging translated CDE frontpanel files ..
	@$(PERL) merge.pl -d $(LAUNCHERDIR)/types -u $(@:b) $<
	@touch $@

.ENDIF # "$(OS)"=="SOLARIS"
