/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: shortcut.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:43:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef __TOOLS_SHORTCUT_HXX
#define __TOOLS_SHORTCUT_HXX

#include <vos/macros.hxx>
#include <osl/mutex.hxx>
#include <list.hxx>
#include <fastfsunx.hxx>

#include <stdio.h>

struct ShortcutEntry
{
	String aName;
	String aValue;

	ShortcutEntry( const String& rName, const String& rValue ) :
			aName( rName ), aValue( rValue ) {}
	ShortcutEntry( const ShortcutEntry& rEntry ) :
			aName( rEntry.aName ), aValue( rEntry.aValue ) {}
};

DECLARE_LIST( ShortcutEntryList, ShortcutEntry* );

class ShortcutGroup
{
	String									m_aGroupname;
	ShortcutEntryList						m_aEntries;
public:
	ShortcutGroup( const String& rName ) : m_aGroupname( rName ) {}
	~ShortcutGroup();

	const String& getName() const { return m_aGroupname; }
	const String& getKeyName( UINT32 nIndex ) const;
	UINT32 getKeyCount() const { return m_aEntries.Count(); }
	const String& getValue( const String& rKey ) const;
	void setValue( const String& rKey, const String& rValue );
	void writeEntries( FILE* fp, BOOL bUnixLineEnds = FALSE ) const;
};

DECLARE_LIST( ShortcutGroupList, ShortcutGroup* );

class UnxShortcut : public IfcShortcut
{
protected:
	::osl::Mutex							m_aMutex;

	ShortcutFormat							m_eOldFormat;
	ItemIDPath								m_aFolderPath;
	String									m_aFilename;
	String									m_aQualifier;
	ShortcutGroup*							m_pQualGroup;
	ShortcutGroupList						m_aGroups;

#if OSL_DEBUG_LEVEL > 1
	void printGroups();
#endif

public:
	UnxShortcut( const ItemIDPath& rFolderPath, const String rQualifier);
	virtual ~UnxShortcut();

	virtual UINT32 GetValueNameCount() const;
	virtual const String& GetValueName( UINT32 nIndex ) const;
	virtual const String& GetValueContent( const String & crValueName ) const;

	virtual void SetValueContent( const String & crValueName, const String & crValueContent );

	virtual FSysError Load( const ItemIDPath & crIDPath );
	virtual FSysError Store( const String & crTitle, ItemIDPath & crNewIDPath,
		ShortcutFormat ePreferred = SHORTCUT_FORMAT_BESTFIT );
};

#endif // __TOOLS_SHORTCUT_HXX
