.\" $NCDId: @(#)auvoxware.man,v 1.1 1996/04/24 17:05:45 greg Exp $
.TH AUVOXWARE 1 "" ""
.SH NAME
auvoxware \- Network Audio System server for PCs with the VOXware audio interface
.SH SYNOPSIS
.B auvoxware
[:listen port offset] [\-option ...]
.SH DESCRIPTION
.I auvoxware
is the NAS server used on PC Unix platforms that support the VOXware device
drivers for popular sound cards. It is able to discover what each device has
in the way of ability and configure itself appropriately. The known list of
platforms that support the VOXware interface are Linux, FreeBSD, SCO,
Unixware and the generic SVR4.2 unixes.
.SH "STARTING THE SERVER"
The server is usually started from /etc/rc or a user's startup script.
.PP
When the Network Audio System server starts up, it takes over /dev/dsp &
/dev/dsp1, according to the instructions in its configuration file, if any.
Note
that applications that attempt to access these devices themselves will
fail while it is running.
It will look for a configuration file of the name nasd.conf in the
config directory, e.g. /etc/nas/nasd.conf. If it finds one, it will
then open it and parse the contents, setting up the inputs and outputs as
required.
.SH OPTIONS
All of the Network Audio System servers accept the following command line options:
.TP 8
.B \-aa
Allows clients on any host to connect.  By default, access is allowed
only to clients on the local host.
.SH SIGNALS
The Network Audio System server attaches special meaning to the following signals:
.TP 8
.I SIGHUP
This signal causes the server to close all existing connections, free all
resources, and restore all defaults.
.TP 8
.I SIGTERM
This signal causes the server to exit cleanly.
.TP 8
.I SIGUSR1
This signal is used quite differently from either of the above.  When the
server starts, it checks to see if it has inherited SIGUSR1 as SIG_IGN
instead of the usual SIG_DFL.  In this case, the server sends a SIGUSR1 to
its parent process after it has set up the various connection schemes.
.SH DIAGNOSTICS
Too numerous to list them all.
If run from \fIinit(8)\fP, errors are typically logged
in the file \fI/usr/adm/audio*msgs\fP,
.SH FILES
.TP 30
/tmp/.sockets/audio*
Unix domain socket
.TP 30
/usr/adm/audio*msgs
.TP 30
/dev/audio
Audio device
.SH "SEE ALSO"
nas(1), auinfo(1), auplay(1), auctl(1), nasd.conf(1)
.SH BUGS
.PP
If
.I au
dies before its clients, new clients won't be able to connect until all
existing connections have their TCP TIME_WAIT timers expire.
.PP
The current access control support is weak at best.
.PP
.SH COPYRIGHT
Copyright 1993, Network Computing Devices, Inc.
.br
.SH AUTHORS
The auvoxware server contains much code from the sun sample server, written
originally by Greg Renda and Dave Lemke of NCD, who in turn borrowed much
code from the sample X server. The original VOXware server for Linux was
written by Amancio Hasty (hasty@rah.star-gate.com) and was merged with the
SVR4 VOXware server, written by Stephen Hocking (sysseh@devetir.qld.gov.au).
Christian Schlichtherle (s_schli@ira.uka.de) then added some more Linux
fixes, code to allow full duplex operation on those cards that supported it
(GUS, PAS16, AudioTriX) and did some work on the 16 bit code. Stephen Hocking
made sure it ran under FreeBSD. Shawn M. (shawnm@sco.com) fixed it up to run
under SCO Unix and added code to dynamically adjust the buffer sizes.
Stephen Hocking then added code for the server to use a configuration file.
.sp
The sample X server was originally written by Susan Angebranndt, Raymond
Drewry, Philip Karlton, and Todd Newman, from Digital Equipment
Corporation, with support from a large cast.  It has since been
extensively rewritten by Keith Packard and Bob Scheifler, from MIT.
