/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    int callWindowProc(int hwnd, int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefWindowProc(hwnd, msg, wParam, lParam);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int scrolledHandle = this.scrolledHandle();
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        int bits1 = OS.GetWindowLong(scrolledHandle, -16);
        int bits2 = OS.GetWindowLong(scrolledHandle, -20);
        OS.AdjustWindowRectEx(rect, bits1, false, bits2);
        if (this.horizontalBar != null) {
            rect.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rect.right += OS.GetSystemMetrics(2);
        }
        int nWidth = rect.right - rect.left;
        int nHeight = rect.bottom - rect.top;
        return new Rectangle(rect.left, rect.top, nWidth, nHeight);
    }

    ScrollBar createScrollBar(int type) {
        ScrollBar bar = new ScrollBar(this, type);
        if ((this.state & 2) != 0) {
            bar.setMaximum(100);
            bar.setThumb(10);
        }
        return bar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rect = new RECT();
        int scrolledHandle = this.scrolledHandle();
        OS.GetClientRect(scrolledHandle, rect);
        int x = rect.left;
        int y = rect.top;
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        if (scrolledHandle != this.handle) {
            OS.GetClientRect(this.handle, rect);
            OS.MapWindowPoints(this.handle, scrolledHandle, rect, 2);
            x = -rect.left;
            y = -rect.top;
        }
        return new Rectangle(x, y, width, height);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void releaseChildren(boolean destroy) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(destroy);
    }

    int scrolledHandle() {
        return this.handle;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle();
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | 0x10000;
        if ((this.style & 0x100) != 0) {
            bits |= 0x100000;
        }
        if ((this.style & 0x200) != 0) {
            bits |= 0x200000;
        }
        return bits;
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    int windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_HSCROLL(int wParam, int lParam) {
        LRESULT result = super.WM_HSCROLL(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.horizontalBar != null && (lParam == 0 || lParam == this.handle)) {
            return this.wmScroll(this.horizontalBar, (this.state & 2) != 0, this.handle, 276, wParam, lParam);
        }
        return result;
    }

    LRESULT WM_MOUSEWHEEL(int wParam, int lParam) {
        Event event;
        int position;
        LRESULT result = super.WM_MOUSEWHEEL(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.state & 2) != 0) {
            int msg;
            boolean horizontal;
            if ((wParam & 0xC) != 0) {
                return result;
            }
            boolean vertical = this.verticalBar != null && this.verticalBar.getEnabled();
            boolean bl = horizontal = this.horizontalBar != null && this.horizontalBar.getEnabled();
            int n = vertical ? 277 : (msg = horizontal ? 276 : 0);
            if (msg == 0) {
                return result;
            }
            int[] value = new int[1];
            OS.SystemParametersInfo(104, 0, value, 0);
            int delta = wParam >> 16;
            int code = 0;
            int count = 0;
            if (value[0] == -1) {
                code = delta < 0 ? 3 : 2;
                count = Math.abs(delta / 120);
            } else {
                code = delta < 0 ? 1 : 0;
                if ((delta = Math.abs(delta)) < 120) {
                    return result;
                }
                count = msg == 277 ? value[0] * delta / 120 : delta / 120;
            }
            int i = 0;
            while (i < count) {
                OS.SendMessage(this.handle, msg, code, 0);
                ++i;
            }
            return LRESULT.ZERO;
        }
        int vPosition = this.verticalBar == null ? 0 : this.verticalBar.getSelection();
        int hPosition = this.horizontalBar == null ? 0 : this.horizontalBar.getSelection();
        int code = this.callWindowProc(this.handle, 522, wParam, lParam);
        if (this.verticalBar != null && (position = this.verticalBar.getSelection()) != vPosition) {
            event = new Event();
            event.detail = position < vPosition ? 0x1000005 : 0x1000006;
            this.verticalBar.sendEvent(13, event);
        }
        if (this.horizontalBar != null && (position = this.horizontalBar.getSelection()) != hPosition) {
            event = new Event();
            event.detail = position < hPosition ? 0x1000005 : 0x1000006;
            this.horizontalBar.sendEvent(13, event);
        }
        return new LRESULT(code);
    }

    LRESULT WM_SIZE(int wParam, int lParam) {
        int code = this.callWindowProc(this.handle, 5, wParam, lParam);
        super.WM_SIZE(wParam, lParam);
        if (code == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(code);
    }

    LRESULT WM_VSCROLL(int wParam, int lParam) {
        LRESULT result = super.WM_VSCROLL(wParam, lParam);
        if (result != null) {
            return result;
        }
        if (this.verticalBar != null && (lParam == 0 || lParam == this.handle)) {
            return this.wmScroll(this.verticalBar, (this.state & 2) != 0, this.handle, 277, wParam, lParam);
        }
        return result;
    }

    LRESULT wmScroll(ScrollBar bar, boolean update, int hwnd, int msg, int wParam, int lParam) {
        LRESULT result = null;
        if (update) {
            int type = msg == 276 ? 0 : 1;
            SCROLLINFO info = new SCROLLINFO();
            info.cbSize = 28;
            info.fMask = 21;
            OS.GetScrollInfo(hwnd, type, info);
            info.fMask = 4;
            int code = wParam & 0xFFFF;
            switch (code) {
                case 8: {
                    return null;
                }
                case 4: 
                case 5: {
                    info.nPos = info.nTrackPos;
                    break;
                }
                case 6: {
                    info.nPos = info.nMin;
                    break;
                }
                case 7: {
                    info.nPos = info.nMax;
                    break;
                }
                case 1: {
                    info.nPos += bar.getIncrement();
                    break;
                }
                case 0: {
                    int increment = bar.getIncrement();
                    info.nPos = Math.max(info.nMin, info.nPos - increment);
                    break;
                }
                case 3: {
                    info.nPos += bar.getPageIncrement();
                    break;
                }
                case 2: {
                    int pageIncrement = bar.getPageIncrement();
                    info.nPos = Math.max(info.nMin, info.nPos - pageIncrement);
                }
            }
            OS.SetScrollInfo(hwnd, type, info, true);
        } else {
            int code = this.callWindowProc(hwnd, msg, wParam, lParam);
            result = code == 0 ? LRESULT.ZERO : new LRESULT(code);
        }
        bar.wmScrollChild(wParam, lParam);
        return result;
    }
}

