/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.swt.tools.internal.CleanupClass;

public class CleanupNatives
extends CleanupClass {
    String[] getArgNames(Method method) {
        int parantesesStart;
        int n_args = method.getParameterTypes().length;
        if (n_args == 0) {
            return new String[0];
        }
        String name = method.getName();
        String params = "";
        int index = 0;
        do {
            if ((index = this.classSource.indexOf(name, index + 1)) == -1) {
                return null;
            }
            parantesesStart = this.classSource.indexOf("(", index);
        } while (this.classSource.substring(index + name.length(), parantesesStart).trim().length() != 0);
        int parantesesEnd = this.classSource.indexOf(")", parantesesStart);
        params = this.classSource.substring(parantesesStart + 1, parantesesEnd);
        String[] names = new String[n_args];
        StringTokenizer tk = new StringTokenizer(params, ",");
        int i = 0;
        while (i < names.length) {
            String s = tk.nextToken().trim();
            StringTokenizer tk1 = new StringTokenizer(s, " ");
            String s1 = null;
            while (tk1.hasMoreTokens()) {
                s1 = tk1.nextToken();
            }
            names[i] = s1.trim();
            ++i;
        }
        return names;
    }

    public void generate(Class clazz) {
        this.usedCount = 0;
        this.unusedCount = 0;
        super.generate(clazz);
        Method[] methods = clazz.getDeclaredMethods();
        this.generate(methods);
        this.output("used=" + this.usedCount + " unused=" + this.unusedCount + " total=" + (this.unusedCount + this.usedCount));
    }

    public void generate(Method[] methods) {
        CleanupNatives.sort(methods);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
            }
            ++i;
        }
    }

    public void generate(Method method) {
        String name = method.getName();
        Enumeration keys = this.files.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            String str = (String)this.files.get(key);
            if (str.indexOf(name) == -1) continue;
            int modifiers = method.getModifiers();
            Class<?> clazz = method.getDeclaringClass();
            String modifiersStr = Modifier.toString(modifiers);
            this.output(modifiersStr);
            if (modifiersStr.length() > 0) {
                this.output(" ");
            }
            this.output(CleanupNatives.getTypeSignature3(method.getReturnType()));
            this.output(" ");
            this.output(method.getName());
            this.output("(");
            Class<?>[] paramTypes = method.getParameterTypes();
            String[] paramNames = this.getArgNames(method);
            int i = 0;
            while (i < paramTypes.length) {
                Class<?> paramType = paramTypes[i];
                if (i != 0) {
                    this.output(", ");
                }
                String sig = CleanupNatives.getTypeSignature3(paramType);
                if (clazz.getPackage().equals(paramType.getPackage())) {
                    sig = CleanupNatives.getClassName(paramType);
                }
                this.output(sig);
                this.output(" ");
                this.output(paramNames[i]);
                ++i;
            }
            this.outputln(");");
            ++this.usedCount;
            return;
        }
        ++this.unusedCount;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java CleanupNatives <OS className> <src path> <class source>");
            return;
        }
        try {
            CleanupNatives gen = new CleanupNatives();
            String clazzName = args[0];
            String[] sourcePath = new String[]{args[1]};
            String classSource = args[2];
            Class<?> clazz = Class.forName(clazzName);
            gen.setSourcePath(sourcePath);
            gen.setClassSourcePath(classSource);
            gen.generate(clazz);
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

