/*******************************************************************************
 * Copyright (c) 2000, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ccvs.core.client;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;

/**
 * A specialized update that will ignore unmanaged local content.
 * It is the same os CheckoutWithOverwrite.
 */
public class UpdateWithOverwrite extends Update {

	/**
	 * This class overrides the "Created" handler but uses the "Updated"
	 * behavior which will overwrite existing files.
	 */
	public class CreatedResponseHandler extends UpdatedHandler {
		public CreatedResponseHandler() {
			super(UpdatedHandler.HANDLE_UPDATED);
		}
		public String getResponseID() {
			return "Created"; //$NON-NLS-1$
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.team.internal.ccvs.core.client.Command#doExecute(org.eclipse.team.internal.ccvs.core.client.Session, org.eclipse.team.internal.ccvs.core.client.Command.GlobalOption[], org.eclipse.team.internal.ccvs.core.client.Command.LocalOption[], java.lang.String[], org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener, org.eclipse.core.runtime.IProgressMonitor)
	 */
	protected IStatus doExecute(
			Session session,
			GlobalOption[] globalOptions,
			LocalOption[] localOptions,
			String[] arguments,
			ICommandOutputListener listener,
			IProgressMonitor monitor)
	throws CVSException {
		
		ResponseHandler newCreated = new CreatedResponseHandler();
		ResponseHandler oldCreated = session.getResponseHandler(newCreated.getResponseID());
		session.registerResponseHandler(newCreated);
		try {
			return super.doExecute(
					session,
					globalOptions,
					localOptions,
					arguments,
					listener,
					monitor);
		} finally {
			session.registerResponseHandler(oldCreated);
		}
	}
}
