/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include <qfile.h>
#include <qtextstream.h>

#include <kdebug.h>
#include <klocale.h>

#include "misc.h"
#include "kftpservermanagement.h"
#include "servermanagement/listview.h"

KFTPServerManagement::Manager *FTPServerManagement;

namespace KFTPServerManagement {

Manager::Manager(QObject *parent, const char *name)
 : QObject(parent, name)
{
  setDefault();
}


Manager::~Manager()
{
}

void Manager::load(const QString& filename)
{
  m_filename = filename;

  QFile file(filename);
  if (!file.open(IO_ReadOnly)) {
    // Create a new empty XMqL
    this->setDefault();

    return;
  }
}

void Manager::setDefault()
{
  QDomElement root;
  QDomElement server;
  QDomElement category;
  QDomElement command;
  QDomElement tag;
  QDomText text;

  m_document = QDomDocument("KFTPGrabber Server Administration");

  // root Element
  root = m_document.createElement("sites");
  root.setAttribute("version", 2);
  m_document.appendChild(root);

  // GlFTPd server
  server = m_document.createElement("server");
  server.setAttribute("name", "GlFTPd");
  root.appendChild(server);

  // Server GlFTPd - new category
  category = addCategory(server, "Change - Info");
    // Server GlFTPd - category Change - Info
    command = addCommand(category, "site idle");
    addTextToElement(command, "Description", i18n("Display your idle time"));
    addTextToElement(command, "Whats This", i18n(
      "Display your idle time"));

    // Server GlFTPd - category Change - Info
    command = addCommand(category, "site idle <value>");
    addTextToElement(command, "Value Range", "0-7200");
    addTextToElement(command, "Description", i18n("Set your idle-time (per-session only)"));
    addTextToElement(command, "Whats This", i18n(
      "Set your idle-time (per-session only).""<br>"
      "This sets your idle-time (the amount of time you can be online without""<br>"
      "doing something). Max idle-time is 7200 sec.""<br>"));

    // Server GlFTPd - category Change - Info
    command = addCommand(category, "site passwd <password>");
    addTextToElement(command, "Description", i18n("This will change your password"));
    addTextToElement(command, "Whats This", i18n(
      "This will change your password.""<br>"
      "Passwords can only be 8 characters long."));

    // Server GlFTPd - category Change - Info
    command = addCommand(category, "site grp <group>");
    addTextToElement(command, "Description", i18n("Display the group info"));
    addTextToElement(command, "Whats This", i18n(
      "Display the group info""<br>"));

    // Server GlFTPd - category Change - Info
    command = addCommand(category, "site alias");
    addTextToElement(command, "Description", i18n("Show current aliases"));
    addTextToElement(command, "Whats This", i18n(
      "Show current aliases"));

    // Server GlFTPd - category Change - Info
    command = addCommand(category, "site cdpath");
    addTextToElement(command, "Description", i18n("Show current cdpaths"));
    addTextToElement(command, "Whats This", i18n(
      "Show current cdpaths"));

    command = addCommand(category, "site vers");
    addTextToElement(command, "Description", i18n("Show current glftpd version"));
    addTextToElement(command, "Whats This", i18n(
      "Show current glftpd version""<br>"));

    command = addCommand(category, "site who");
    addTextToElement(command, "Description", i18n("Display users currently online"));
    addTextToElement(command, "Whats This", i18n(
      "Display users currently online""<br>"));

    command = addCommand(category, "site welcome");
    addTextToElement(command, "Description", i18n("Display the welcome screen"));
    addTextToElement(command, "Whats This", i18n(
      "Display the welcome screen""<br>"));

    command = addCommand(category, "site time");
    addTextToElement(command, "Description", i18n("Display current time on the site"));
    addTextToElement(command, "Whats This", i18n(
      "Display current time on the site""<br>"));

    command = addCommand(category, "site unnukes");
    addTextToElement(command, "Description", i18n("Display recently unnuked releases"));
    addTextToElement(command, "Whats This", i18n(
      "Display recently unnuked releases""<br>"));

  // Server GlFTPd - new category
  category = addCategory(server, "User Management");
    // Server GlFTPd - category User Management
    // Server GlFTPd - category User Management
    command = addCommand(category, "site deluser <user>");
    addTextToElement(command, "Description", i18n("Delete a user, may be readded with site READD"));
    addTextToElement(command, "Whats This", i18n(
      "Delete a user, may be readded with site READD""<br>"
      "<br>"
      "<i>Example:</i> site deluser Archimede""<br>"
      "<br>"
      "This will activate the flag DELETED (6) for the user 'Archimede'.""<br>"
      "In order to fully delete this user you will need to do a 'site purge'""<br>"));

    // Server GlFTPd - category User Management
    command = addCommand(category, "site chpass <user> <password>");
    addTextToElement(command, "Description", i18n("Change user's password"));
    addTextToElement(command, "Whats This", i18n(
      "Change user's password""<br>"
      "<i>Example:</i> site chpass Archimede newpassword""<br>"
      "This would change the password to 'newpassword' for the""<br>"
      "user 'Archimede'.""<br>"
      "<br>"
      "See \"site passwd\" for more info if you get a Password is not secure""<br>"
      "enough error.""<br>"
      "<br>"
      "* Denotes any password, <i>Example:</i> site chpass arch *""<br>"
      "This will allow arch to login with any password""<br>"
      "<br>"
      "@ Denotes any email-like password, <i>Example:</i> site chpass arch @""<br>"
      "This will allow arch to login with a@b.com but not ab.com""<br>"));

    // Server GlFTPd - category User Management
    command = addCommand(category, "site chgadmin <user> <group>");
    addTextToElement(command, "Description", i18n("Toggle the user's gadmin status for the given group"));
    addTextToElement(command, "Whats This", i18n(
      "Toggle the user's gadmin status for the given group"
      "<br>"
      "<b>NOTE:</b> When a user becomes a gadmin they will automatically get""<br>"
      "flag 2 added. When a user stops to become a gadmin of""<br>"
      "any of their groups the gadmin flag will be automatically""<br>"
      "removed.""<br>"));

    // Server GlFTPd - category User Management
    command = addCommand(category, "site flags [<user>]");
    addTextToElement(command, "Description", i18n("Display a user's flags"));
    addTextToElement(command, "Whats This", i18n(
      "Display a user's flags""<br>"
      "<br>"
      "<i>Example:</i> site flags""<br>"
      "<br>"
      "This will show your own flags.""<br>"
      "<br>"
      "<i>Example:</i> site flags Archimede""<br>"
      "<br>"
      "This will show flags of user Archimede.""<br>"));

    // Server GlFTPd - category User Management
    command = addCommand(category, "site kick <user>");
    addTextToElement(command, "Description", i18n("Kick a user off the site"));
    addTextToElement(command, "Whats This", i18n(
      "Kick a user off the site""<br>"
      "<br>"
      "<i>Example:</i> site kick Archimede""<br>"
      "<br>"
      "This will kill all connections for the user 'Archimede'""<br>"));

    command = addCommand(category, "site purge [<user>]");
    addTextToElement(command, "Description", i18n("Remove deleted users, site READD will NOT work for purged uers."));
    addTextToElement(command, "Whats This", i18n(
      "Remove deleted users, site READD will NOT work for purged uers.""<br>"
      "<br>"
      "<i>Example:</i> site purge""<br>"
      "This will REMOVE ALL users who have the DELETED flag.""<br>"
      "<br>"
      "<i>Example:</i> site purge frank""<br>"
      "This will remove just frank and leave the rest of deleted users on site""<br>"
      "<br>"
      "If you are a gadmin, you can only purge users from your group (that is,""<br>"
      "if you are given access to this command in the config file).""<br>"));

    command = addCommand(category, "site readd [<user>]");
    addTextToElement(command, "Description", i18n("Readd user"));
    addTextToElement(command, "Whats This", i18n(
      "Readd user""<br>"
      "<br>"
      "<i>Example:</i> site readd""<br>"
      "<br>"
      "This will show a list of users that can be readded.""<br>"
      "(You can also achieve this with \"site users deleted\")""<br>"
      "<br>"
      "<i>Example:</i> site readd Archimede""<br>"
      "<br>"
      "This will remove the DELETED flag for user 'Archimede'.""<br>"
      "<br>"
      "<b>NOTE:</b> When readding a user from a group the group must have available slots""<br>"
      "left, even when you are a siteop.""<br>"));

    command = addCommand(category, "site stats [<user>]");
    addTextToElement(command, "Description", i18n("Display a user's upload/download statistics"));
    addTextToElement(command, "Whats This", i18n(
      "Display a user's upload/download statistics""<br>"
      "<br>"
      "Definable in '/ftp-data/text/user.stats'""<br>"
      "<br>"
      "If you have multiple sections then this will display stats from""<br>"
      "all sections.  (But you have to copy this file to SECTIONuser.stats.""<br>"
      "exmp: if you have a section called GAMES then glftpd will look""<br>"
      "for the files user.stats and GAMESuser.stats in the /ftp-data/text dir.""<br>"));

    command = addCommand(category, "site user [<user>]");
    addTextToElement(command, "Description", i18n("Lists users / Shows detailed info about a user"));
    addTextToElement(command, "Whats This", i18n(
      "Lists users / Shows detailed info about a user""<br>"
      "<br>"
      "<i>Example:</i> site user""<br>"
      "<br>"
      "This will display a list of all users currently on site.""<br>"
      "<br>"
      "<i>Example:</i> site user Archimede""<br>"
      "<br>"
      "This will show detailed information about user 'Archimede'.""<br>"));

  // Server GlFTPd - new category
  category = addCategory(server, "Group Management");
    // Server GlFTPd - category Group Management
    command = addCommand(category, "site groups");
    addTextToElement(command, "Description", i18n("Shows available groups"));
    addTextToElement(command, "Whats This", i18n(
      "Shows available groups"));

    // Server GlFTPd - category Group Management
    command = addCommand(category, "site ginfo <group>");
    addTextToElement(command, "Description", i18n("Shows detailed info on a group"));
    addTextToElement(command, "Whats This", i18n(
      "Shows detailed info on a group""<br>"
      "<br>"
      "<i>Example:</i> site ginfo ftp""<br>"
      "<br>"
      "This will show detailed info on the group 'ftp'.""<br>"
      "If a user is deleted, their tagline will be replaced by \"***DELETED***\".""<br>"));

    // Server GlFTPd - category Group Management
    command = addCommand(category, "site grpadd <group> [<description>]");
    addTextToElement(command, "Description", i18n("Add a new group"));
    addTextToElement(command, "Whats This", i18n(
      "Add a new group""<br>"
      "<br>"
      "<i>Example:</i> site grpadd group new_group""<br>"
      "<br>"
      "This would add the group 'group' with the description 'new_group'.""<br>"));

    // Server GlFTPd - category Group Management
    command = addCommand(category, "site grpdel <group>");
    addTextToElement(command, "Description", i18n("Delete a group"));
    addTextToElement(command, "Whats This", i18n(
      "Delete a group""<br>"
      "<br>"
      "<i>Example:</i> site grpdel group""<br>"
      "<br>"
      "This would delete the group 'group'.""<br>"));

    command = addCommand(category, "site group [<group>]");
    addTextToElement(command, "Description", i18n("Shows your current groups or leaves/joins a group"));
    addTextToElement(command, "Whats This", i18n(
      "Shows your current groups or leaves/joins a group""<br>"
      "To join a group simply pass the groupname as a parameter to the""<br>"
      "command. You must leave all groups before you can join a new one.""<br>"
      "Only users with the siteop flag enabled can change private""<br>"
      "groups (see site CHGRP).""<br>"
      "<br>"
      "<i>Example:</i> site group""<br>"
      "<br>"
      "This will display the groups you are in.""<br>"
      "<br>"
      "<i>Example:</i> site group ftp""<br>"
      "<br>"
      "With this you will join/leave group 'ftp'.""<br>"));

    command = addCommand(category, "site grpnfo <group> <description>");
    addTextToElement(command, "Description", i18n("Change description for a group"));
    addTextToElement(command, "Whats This", i18n(
      "Change description for a group""<br>"
      "<br>"
      "<i>Example:</i> site grpnfo ftp new_description""<br>"
      "<br>"
      "This will change the current description for the group 'ftp' to""<br>"
      "'new_description'.""<br>"));

  // Server GlFTPd - new category
//   category = addCategory(server, "Group");

  // Server GlFTPd - new category
  category = addCategory(server, "Statistics");

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site stat");
    addTextToElement(command, "Description", i18n("Display your current status line"));
    addTextToElement(command, "Whats This", i18n(
      "Display your current status line"));

    // Server GlFTPd - category Statistics
    // @TODO USAGE: site aldn [number] [<section>]
    command = addCommand(category, "site aldn");
    addTextToElement(command, "Description", i18n("Display all-time downloaders"));
    addTextToElement(command, "Whats This", i18n(
      "Display alltime downloaders"));

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site aldn =[<group>]");
    addTextToElement(command, "Description", i18n("Display all-time downloaders who belong to the group"));
    addTextToElement(command, "Whats This", i18n(
      "Display all-time downloaders.""<br>"
      "<group> is also optional. Specifying it will only show users who""<br>"
      "belong to that group, but the user doing it has to have special""<br>"
      "access in glftpd.conf to do it. This is controlled by the -grpstats""<br>"
      "setting."));

    // Server GlFTPd - category Statistics
    // @TODO USAGE: site alup [number] [<section>]
    command = addCommand(category, "site alup");
    addTextToElement(command, "Description", i18n("Display all-time uploaders"));
    addTextToElement(command, "Whats This", i18n(
      "Display all-time uploaders"));

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site alup =[<group>]");
    addTextToElement(command, "Description", i18n("Display all-time uploaders who belong to the group"));
    addTextToElement(command, "Whats This", i18n(
      "Display all-time uploaders.""<br>"
      "<group> is also optional. Specifying it will only show users who""<br>"
      "belong to that group, but the user doing it has to have special""<br>"
      "access in glftpd.conf to do it. This is controlled by the -grpstats""<br>"
      "setting."));

    // Server GlFTPd - category Statistics
    // @TODO USAGE: site dayup [number] [<section>]
    command = addCommand(category, "site dayup");
    addTextToElement(command, "Description", i18n("Display daytop upload"));
    addTextToElement(command, "Whats This", i18n(
      "Display daytop upload"));

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site dayup =[<group>]");
    addTextToElement(command, "Description", i18n("Display daytop uploaders who belong to the group"));
    addTextToElement(command, "Whats This", i18n(
      "Display daytop upload.""<br>"
      "<group> is also optional. Specifying it will only show users who""<br>"
      "belong to that group, but the user doing it has to have special""<br>"
      "access in glftpd.conf to do it. This is controlled by the -grpstats""<br>"
      "setting."));

    // Server GlFTPd - category Statistics
    // @TODO USAGE: site daydn [number] [<section>]
    command = addCommand(category, "site daydn");
    addTextToElement(command, "Description", i18n("Display daytop download"));
    addTextToElement(command, "Whats This", i18n(
      "Display daytop download"));

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site daydn =[<group>]");
    addTextToElement(command, "Description", i18n("Display daytop downloaders who belong to the group"));
    addTextToElement(command, "Whats This", i18n(
      "Display daytop download.""<br>"
      "<group> is also optional. Specifying it will only show users who""<br>"
      "belong to that group, but the user doing it has to have special""<br>"
      "access in glftpd.conf to do it. This is controlled by the -grpstats""<br>"
      "setting."));

    // Server GlFTPd - category Statistics
    // @TODO USAGE: site monthup [number] [<section>]
    command = addCommand(category, "site monthup");
    addTextToElement(command, "Description", i18n("Display monthtop upload"));
    addTextToElement(command, "Whats This", i18n(
      "Display monthtop upload"));

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site monthup =[<group>]");
    addTextToElement(command, "Description", i18n("Display monthtop uploaders who belong to the group"));
    addTextToElement(command, "Whats This", i18n(
      "Display monthtop upload.""<br>"
      "<group> is also optional. Specifying it will only show users who""<br>"
      "belong to that group, but the user doing it has to have special""<br>"
      "access in glftpd.conf to do it. This is controlled by the -grpstats""<br>"
      "setting."));

    // Server GlFTPd - category Statistics
    // @TODO USAGE: site monthdn [number] [<section>]
    command = addCommand(category, "site monthdn");
    addTextToElement(command, "Description", i18n("Display monthtop download"));
    addTextToElement(command, "Whats This", i18n(
      "Display monthtop download"));

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site monthdn =[<group>]");
    addTextToElement(command, "Description", i18n("Display monthtop downloaders who belong to the group"));
    addTextToElement(command, "Whats This", i18n(
      "Display monthtop download.""<br>"
      "<group> is also optional. Specifying it will only show users who""<br>"
      "belong to that group, but the user doing it has to have special""<br>"
      "access in glftpd.conf to do it. This is controlled by the -grpstats""<br>"
      "setting."));

    // Server GlFTPd - category Statistics
    // @todo USAGE: site nuketop [number] [<section>]
    command = addCommand(category, "site nuketop");
    addTextToElement(command, "Description", i18n("Display all-time nuketop"));
    addTextToElement(command, "Whats This", i18n(
      "Display alltime nuketop"));

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site nuketop =[<group>]");
    addTextToElement(command, "Description", i18n("Display all-time nuketop who belongs to the group"));
    addTextToElement(command, "Whats This", i18n(
      "Display alltime nuketop.""<br>"
      "<group> is also optional. Specifying it will only show users who""<br>"
      "belong to that group, but the user doing it has to have special""<br>"
      "access in glftpd.conf to do it. This is controlled by the -grpstats""<br>"
      "setting."));

    // Server GlFTPd - category Statistics
    // @todo USAGE: site wkup [number] [<section>]
    command = addCommand(category, "site wkup");
    addTextToElement(command, "Description", i18n("Display weektop uploaders"));
    addTextToElement(command, "Whats This", i18n(
      "Display weektop uploaders"));

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site wkup =[<group>]");
    addTextToElement(command, "Description", i18n("Display weektop uploaders who belong to the group"));
    addTextToElement(command, "Whats This", i18n(
      "Display weektop uploaders.""<br>"
      "<group> is also optional. Specifying it will only show users who""<br>"
      "belong to that group, but the user doing it has to have special""<br>"
      "access in glftpd.conf to do it. This is controlled by the -grpstats""<br>"
      "setting."));

    // Server GlFTPd - category Statistics
    // @todo USAGE: site wkdn [number] [<section>]
    command = addCommand(category, "site wkdn");
    addTextToElement(command, "Description", i18n("Display weektop downloaders"));
    addTextToElement(command, "Whats This", i18n(
      "Display weektop downloaders"));

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site wkdn =[<group>]");
    addTextToElement(command, "Description", i18n("Display weektop downloaders who belong to the group"));
    addTextToElement(command, "Whats This", i18n(
      "Display weektop downloaders.""<br>"
      "<group> is also optional. Specifying it will only show users who""<br>"
      "belong to that group, but the user doing it has to have special""<br>"
      "access in glftpd.conf to do it. This is controlled by the -grpstats""<br>"
      "setting."));

    // Server GlFTPd - category Statistics
    command = addCommand(category, "site traffic");
    addTextToElement(command, "Description", i18n("Display server traffic"));
    addTextToElement(command, "Whats This", i18n(
      "Display server traffic""<br>"
      "Display total uploads/downloads by all existing users in all sections"));

    // Server GlFTPd - category Statistics
    // @todo USAGE: site gpal [number] [<section>]
    command = addCommand(category, "site gpal");
    addTextToElement(command, "Description", i18n("Display alltime group upload"));
    addTextToElement(command, "Whats This", i18n(
      "Display alltime group upload""<br>"));

    // Server GlFTPd - category Statistics
    // @todo USAGE: site gpmonthup [number] [<section>]
    command = addCommand(category, "site gpmonthup");
    addTextToElement(command, "Description", i18n("Display month group upload"));
    addTextToElement(command, "Whats This", i18n(
      "Display month group upload""<br>"));

    // Server GlFTPd - category Statistics
    // @todo USAGE: site gpmonthdn [number] [<section>]
    command = addCommand(category, "site gpmonthdn");
    addTextToElement(command, "Description", i18n("Display month group download"));
    addTextToElement(command, "Whats This", i18n(
      "Display month group download""<br>"));

    // Server GlFTPd - category Statistics
    // @todo USAGE: site gpwk [number] [<section>]
    command = addCommand(category, "site gpwk");
    addTextToElement(command, "Description", i18n("Display weektop group upload"));
    addTextToElement(command, "Whats This", i18n(
      "Display weektop group upload""<br>"));

    // Server GlFTPd - category Statistics
    // @todo USAGE: site gpwd [number] [<section>]
    command = addCommand(category, "site gpwd");
    addTextToElement(command, "Description", i18n("Display weektop group download"));
    addTextToElement(command, "Whats This", i18n(
      "Display weektop group download""<br>"));

    // Server GlFTPd - category Statistics
    // @todo USAGE: site gpad [number] [<section>]
    command = addCommand(category, "site gpad");
    addTextToElement(command, "Description", i18n("Display alltime group download"));
    addTextToElement(command, "Whats This", i18n(
      "Display alltime group download""<br>"));

  category = addCategory(server, "To Sort In");
    command = addCommand(category, "site emulate <user>");
    addTextToElement(command, "Description", i18n("Load user's userfile into your process' memory, essentially becoming that user."));
    addTextToElement(command, "Whats This", i18n(
      "Load user's userfile into your process' memory, essentially becoming""<br>"
      "that user (although some things, like home directory or 'site who'""<br>"
      "display, will not change). Need -emulate permission in config file.""<br>"
      "This was created for special scripts, so they can act as some user""<br>"
      "without having to know their password and logging in as that user. Most""<br>"
      "siteops will find no use for this.""<br>"
      "<br>"
      "Note: This is not TRUE emulation, you should not use this to do serious""<br>"
      "things. Some things will not work; others will work incorrectly. The""<br>"
      "only way to achieve 'true' emulation is to log in as that user.""<br>"));

    command = addCommand(category, "site help");
    addTextToElement(command, "Description", i18n("Display helpscreen"));
    addTextToElement(command, "Whats This", i18n(
      "Display helpscreen""<br>"));

    // @todo site logins [<number>] [<searchstring>]
    command = addCommand(category, "site logins");
    addTextToElement(command, "Description", i18n("Display failed logins"));
    addTextToElement(command, "Whats This", i18n(
      "Display failed logins""<br>"
      "<br>"
      "This displays '/glftpd/ftp-data/logs/login.log'""<br>"
      "See info about \"site syslog\" for syntax.""<br>"));

    command = addCommand(category, "site nukes");
    addTextToElement(command, "Description", i18n("Display recently nuked releases"));
    addTextToElement(command, "Whats This", i18n(
      "Display recently nuked releases""<br>"));

    command = addCommand(category, "site seen <user>");
    addTextToElement(command, "Description", i18n("Check when a user was last online"));
    addTextToElement(command, "Whats This", i18n(
      "Check when a user was last online""<br>"
      "<br>"
      "<i>Example:</i> site seen Archimede""<br>"
      "<br>"
      "This will display the last time Archimede logged in.""<br>"));

    command = addCommand(category, "site show <user>");
    addTextToElement(command, "Description", i18n("Displays the userfile in raw format"));
    addTextToElement(command, "Whats This", i18n(
      "Displays the userfile in raw format""<br>"));

    command = addCommand(category, "site swho");
    addTextToElement(command, "Description", i18n("Shows detailed information about users online"));
    addTextToElement(command, "Whats This", i18n(
      "Shows detailed information about users online""<br>"));

//   category = addCategory(server, "implement in dialog");
//
//     command = addCommand(category, "site adduser <user> <password> [<ident@ip>]");
//     addTextToElement(command, "Description", i18n("Adds a user"));
//     addTextToElement(command, "Whats This", i18n(
//       "Adds a user. You can have wild cards for users that have dynamic ips<br>"
//       "<i>Examples:</i> *@192.168.1.* , frank@192.168.*.* , bob@192.*.*.*<br>"
//       "(*@192.168.1.1[5-9] will allow only 192.168.1.15-19 to connect but no one else)<br>"
//       "<br>"
//       "If a user is added by a groupadmin, that user will have the GLOCK<br>"
//       "flag enabled and will inherit the home directory from the default.user<br>"
//       "or default.<groupname> file.<br>"
//       "<br>"
//       "All default values for the user are read from file default.user in<br>"
//       "/glftpd/ftp-data/users. Comments inside describe what is what.<br>"
//       "Gadmins can be assigned their own default.<group> userfiles<br>"
//       "as templates to be used when they add a user, if one is not found,<br>"
//       "default.user will be used.<br>"
//       "default.groupname files will also be used for \"site gadduser\"."
//       "<br>"
//       "<i>Example:</i> site ADDUSER Archimede mypassword""<br>"
//       "This would add the user 'Archimede' with the password 'mypassword'.""<br>"
//       "<br>"
//       "<i>Example:</i> site ADDUSER Archimede mypassword *@127.0.0.1""<br>"
//       "<br>"
//       "This would do the same as above + add the ip '*@127.0.0.1' at the""<br>"
//       "same time.""<br>"
//       "<br>"
//       "HOMEDIRS:""<br>"
//       "After login, the user will automatically be transferred into his/her""<br>"
//       "homedir. As of 1.16.x this dir is now \"kinda\" chroot'ed and they are""<br>"
//       "now unable to \"cd ..\".*/""<br>"));
//
//     command = addCommand(category, "site addip <user> <ident@ip#1 ... ident@ip#10>");
//     addTextToElement(command, "Description", i18n("Add IP to user"));
//     addTextToElement(command, "Whats This", i18n(
//       "Add IP to user""<br>"
//       "<br>"
//       "Note: if you don't know what ident is, you need to read your""<br>"
//       "internet-for-dummies book first.""<br>"
//       "<br>"
//       "<i>Example:</i> site addip Archimede Archimede@127.0.0.1 *@10.10.""<br>"
//       "This would add the ident@ip 'Archimede@127.0.0.1' and mask '*@10.10.*'""<br>"
//       "to user 'Archimede'. (* at the end is optional in this case)""<br>"
//       "<br>"
//       "<i>Example:</i> site addip Archimede Archimede@blah.net Archimede@209.44.* *@24.1.64.20""<br>"
//       "This would add all 3 ip masks to user 'Archimede'.""<br>"
//       "<br>"
//       "<i>Example:</i> site addip lamer someident@3.1.2.1[2-5]?""<br>"
//       "This mask will match IPs 3.1.2.120 through 3.1.2.159""<br>"
//       "Warning: You can't use [] to declare range of numbers > 9, so [10-79]""<br>"
//       "will not work. Use [1-7]? or [1-7][0-9] instead. Ranges that don't start""<br>"
//       "at a power of 10 or don't end at 9 are not possible unless you add""<br>"
//       "more than 1 mask.""<br>"
//       "<br>"
//       "<b>NOTE:</b> There is a maximum of 10 IPs that can go into the userfile.""<br>"
//       "If you need more than 10, you need to add them to a text file, each one""<br>"
//       "on a line by itself, in the format ident@ip.  To make glftpd use this""<br>"
//       "file, the first IP in the userfile (IP0 in site user) has to look like""<br>"
//       "this:""<br>"
//       "IP !/path/to/iplist.txt""<br>"
//       "Glftpd won't let you add an IP like that; you need to edit the userfile""<br>"
//       "manually (in /glftpd/ftp-data/users) and add it.""<br>"
//       "Make sure there are no DOS carriage returns at the end of each line in""<br>"
//       "the file containing the list of IPs.""<br>"
//       "If an entry in that file starts with !, it will be banned (meaning if""<br>"
//       "the user connects from that ident@ip, he will NOT be allowed to log in,""<br>"
//       "even if there is a different IP below that would let him in).""<br>"
//       "<br>"
//       "The file can contain comments following each IP. Separate the comment""<br>"
//       "from the IP with spaces/tabs followed by the # character. Exmp:""<br>"
//       "!1.2.3.4  #this user is not allowed to connect from this ip""<br>"
//       "2.3.4.    #user's home ip mask (same as 2.3.4.*)""<br>"));
//
//     command = addCommand(category, "site chgrp <user> <group> [<group>]");
//     addTextToElement(command, "Description", i18n("Adds/removes a user from group(s)"));
//     addTextToElement(command, "Whats This", i18n(
//       "Adds/removes a user from group(s)""<br>"
//       "<i>Example:</i> site chgrp archimede ftp""<br>"
//       "This would change the group to 'ftp' for the user 'archimede'.""<br>"
//       "<br>"
//       "ex1. site chgrp archimede ftp""<br>"
//       "This would remove the group ftp from the user 'archimede'.""<br>"
//       "<br>"
//       "ex2. site chgrp archimede ftp eleet""<br>"
//       "This moves archimede from ftp group to eleet group.""<br>"
//       "<br>"
//       "<b>NOTE:</b> When adding a user to a group the group must have available slots""<br>"
//       "left, even when you are a siteop.""<br>"));
//
//     command = addCommand(category, "site chmod <mask> <pathname>");
//     addTextToElement(command, "Description", i18n("Changes a file's permissions to mask"));
//     addTextToElement(command, "Whats This", i18n(
//       "Changes a file's permissions to mask""<br>"
//       "<i>Example:</i> site chmod 444 file.zip""<br>"
//       "<i>Example:</i> site chmod 777 /site/incoming""<br>"));
//
//     command = addCommand(category, "site color [on/off/show]");
//     addTextToElement(command, "Description", i18n("Enable/Disable the use of colors"));
//     addTextToElement(command, "Whats This", i18n(
//       "Enable/Disable the use of colors""<br>"
//       "<br>"
//       "If no arguments are specified, this will toggle color.""<br>"
//       "<br>"
//       "<b>NOTE:</b> This will screw up many windows clients if enabled""<br>"));
//
//     command = addCommand(category, "site delip <user> <ident@ip> ...");
//     addTextToElement(command, "Description", i18n("Delete IP from user, you can also use the ip number"));
//     addTextToElement(command, "Whats This", i18n(
//       "Delete IP from user, you can also use the ip number""<br>"
//       "(Takes up to 10 arguments)""<br>"
//       "<br>"
//       "<i>Example:</i> site delip Archimede Archimede@127.0.0.1""<br>"
//       "<br>"
//       "This would remove the ident@ip 'Archimede@127.0.0.1' from the""<br>"
//       "user 'Archimede'.""<br>"
//       "<br>"
//       "<i>Example:</i> site delip Archimede 1""<br>"
//       "<br>"
//       "This would remove ident@ip #1 from the user 'Archimede'.""<br>"
//       "(Get list with site user <user>)""<br>"));
//
//     command = addCommand(category, "site errlog [<number>] [<searchstring>]");
//     addTextToElement(command, "Description", i18n("Display the error log"));
//     addTextToElement(command, "Whats This", i18n(
//       "Display the error log""<br>"
//       "<br>"
//       "This displays '/glftpd/ftp-data/logs/error.log'""<br>"
//       "See info about \"site syslog\" for syntax.""<br>"));
//
//     command = addCommand(category, "site gadduser <group> <user> <password> [<ident@ip#1 .. ident@ip#5>]");
//     addTextToElement(command, "Description", i18n("Adds a user and changes his/her group to <group>"));
//     addTextToElement(command, "Whats This", i18n(
//       "Adds a user and changes his/her group to <group>""<br>"
//       "If default.group exists, it will be used as a base instead of default.user.""<br>"
//       "<br>"
//       "Only public groups can be used as <group>.""<br>"
//       "<br>"
//       "<b>NOTE:</b> When adding a user to a group the group must have available slots""<br>"
//       "left, even when you are a siteop.""<br>"));
//
//     command = addCommand(category, "site give <user> <kbytes>[gGmM] [<message>]");
//     addTextToElement(command, "Description", i18n("Gives credits to user (Taken from you"));
//     addTextToElement(command, "Whats This", i18n(
//       "Gives credits to user (Taken from you""<br>"
//       "<br>"
//       "<i>Example:</i> site give Archimede 100000 there you go""<br>"
//       "The optional g/m suffix will take the number to be gigabytes or megabytes.""<br>"
//       "This will give around 100mb of credits to user 'Archimede' and send""<br>"
//       "the message 'there you go'.""<br>"));
//
//     command = addCommand(category, "site grpren <groupname> <NEWgroupname>");
//     addTextToElement(command, "Description", i18n("Rename a group"));
//     addTextToElement(command, "Whats This", i18n(
//       "Rename a group""<br>"
//       "<br>"
//       "<i>Example:</i> site grpren ftp new_ftp""<br>"
//       "<br>"
//       "This would change the group name 'ftp' to 'new_ftp'.""<br>"
//       "All users in group 'ftp' will now automatically belong to 'new_ftp'.""<br>"));
//
//     command = addCommand(category, "site kill <pid>");
//     addTextToElement(command, "Description", i18n("Kill a PID"));
//     addTextToElement(command, "Whats This", i18n(
//       "Kill a PID""<br>"
//       "<br>"
//       "<i>Example:</i> site kill 345""<br>"
//       "<br>"
//       "This will kill pid# 345 (if it belongs to a glftpd user).""<br>"));
//
//     command = addCommand(category, "site nuke <directory> <multiplier> <message>");
//     addTextToElement(command, "Description", i18n("Nuke a director"));
//     addTextToElement(command, "Whats This", i18n(
//       "Nuke a director""<br>"
//       "<br>"
//       "<i>Example:</i> site nuke shit 2 CRAP""<br>"
//       "<br>"
//       "This will nuke the directory 'shit' and remove x2 credits with the""<br>"
//       "comment 'CRAP'.""<br>"
//       "<br>"
//       "<b>NOTE:</b> You can enclose the directory in braces if you have spaces in the name""<br>"
//       "<i>Example:</i> site NUKE {My directory name} 1 because_i_dont_like_it""<br>"));
//
//     command = addCommand(category, "site new [.] [<#>]");
//     addTextToElement(command, "Description", i18n("Display newest created directories (taken from dirlog)"));
//     addTextToElement(command, "Whats This", i18n(
//       "Display newest created directories (taken from dirlog)""<br>"
//       "<br>"
//       "<i>Example:</i> site new""<br>"
//       "This will display the 10 newest directories.""<br>"
//       "<br>"
//       "<i>Example:</i> site new .""<br>"
//       "This will show new directories in the current dir tree""<br>"
//       "<br>"
//       "<i>Example:</i> site new 40""<br>"
//       "This will display the 40 newest directories everywhere.""<br>"
//       "<br>"
//       "<i>Example:</i> site new . 20""<br>"
//       "This will show the last 20 dirs made in the current dir tree.""<br>"
//       "<br>"
//       "<b>NOTE:</b> Users are only able to see directories created under""<br>"
//       "their home directory.  If your homedir is /site/public, you will""<br>"
//       "not see directories created in /site/private by using site new.""<br>"
//       "To achieve this, you need to set up a %NEW cookie in a text file""<br>"
//       "with /site/private as a parameter, and use msgpath or a custom""<br>"
//       "command to display it.""<br>"));
//
//     command = addCommand(category, "site onel [<string>]");
//     addTextToElement(command, "Description", i18n("Show/Add oneliner"));
//     addTextToElement(command, "Whats This", i18n(
//       "Show/Add oneliner""<br>"
//       "<br>"
//       "<i>Example:</i> site onel""<br>"
//       "<br>"
//       "This will display the current oneliners.""<br>"
//       "<br>"
//       "<i>Example:</i> site onel Archimede was here""<br>"
//       "<br>"
//       "This will add 'Archimede was here' to the oneliners.""<br>"));
//
//     command = addCommand(category, "site renuser <old_username> <new_username>");
//     addTextToElement(command, "Description", i18n("Rename a use"));
//     addTextToElement(command, "Whats This", i18n(
//       "Rename a use""<br>"
//       "<br>"
//       "<i>Example:</i> site renuser usurper Usurper""<br>"
//       "This will make usurper look bigger and meaner""<br>"));
//
//     command = addCommand(category, "site request [<string>]");
//     addTextToElement(command, "Description", i18n("Add/Display Requests"));
//     addTextToElement(command, "Whats This", i18n(
//       "Add/Display Requests""<br>"
//       "<br>"
//       "<i>Example:</i> site request""<br>"
//       "<br>"
//       "This will display the current requests.""<br>"
//       "<br>"
//       "<i>Example:</i> site request A new super-duper-fast computer!""<br>"
//       "<br>"
//       "This will add my request to the requestlist.""<br>"
//       "<br>"
//       "If logging is enabled, new requests are logged to glftpd.log""<br>"));
//
//     command = addCommand(category, "site reqfilled <#>");
//     addTextToElement(command, "Description", i18n("Fill a request"));
//     addTextToElement(command, "Whats This", i18n(
//       "Fill a request""<br>"
//       "<br>"
//       "<i>Example:</i> site reqfilled 3""<br>"
//       "<br>"
//       "This will remove request number 3 from the request list and send""<br>"
//       "mail to the user who made the request saying you filled it.""<br>"
//       "(List requests with site request)""<br>"
//       "<br>"
//       "If logging is enabled, filled requests get logged to glftpd.log.""<br>"
//       "They are also always logged to request.log.""<br>"));
//
//     command = addCommand(category, "site reqlog [<number>] [<searchstring>]");
//     addTextToElement(command, "Description", i18n("Show the log of filled requests"));
//     addTextToElement(command, "Whats This", i18n(
//       "Show the log of filled requests""<br>"
//       "<br>"
//       "This displays '/glftpd/ftp-data/logs/request.log'""<br>"
//       "See info about \"site syslog\" for syntax.""<br>"));
//
//     command = addCommand(category, "site search <string> [<string2> ...]");
//     addTextToElement(command, "Description", i18n("Searches the entire site for matching directory names"));
//     addTextToElement(command, "Whats This", i18n(
//       "Searches the entire site for matching directory names""<br>"
//       "<br>"
//       "(ftp-data/logs/dirlog is what's being searched.  If this command""<br>"
//       "finds old non-existing directories, you need to run the""<br>"
//       "\"olddirclean2\" utility to clean your dirlog. Best run it from crontab.)""<br>"
//       "<br>"
//       "<i>Example:</i> site search quake""<br>"
//       "This will search the entire site for directories containing the""<br>"
//       "string 'quake'. The search is NOT case-sensitive.""<br>"
//       "<br>"
//       "<i>Example:</i> site search linux gnu""<br>"
//       "This will find all directories that contain both \"linux\" and \"gnu\"""<br>"));
//
//     command = addCommand(category, "site tagline [<tagline>]");
//     addTextToElement(command, "Description", i18n("Shows/Sets your taglin"));
//     addTextToElement(command, "Whats This", i18n(
//       "Shows/Sets your taglin""<br>"
//       "<br>"
//       "<i>Example:</i> site tagline""<br>"
//       "<br>"
//       "This will show your current tagline.""<br>"
//       "<br>"
//       "<i>Example:</i> site tagline Archimede owns""<br>"
//       "<br>"
//       "This will set your tagline to 'Archimede owns'.""<br>"));
//
//     command = addCommand(category, "site take <user> <kbytes>[gGmM] [<message>]");
//     addTextToElement(command, "Description", i18n("Removes credit from use"));
//     addTextToElement(command, "Whats This", i18n(
//       "Removes credit from user""<br>"
//       "<br>"
//       "<i>Example:</i> site take Archimede 100000 haha""<br>"
//       "The optional g/m suffix will take the number to be gigabytes or megabytes.""<br>"
//       "This will remove 100mb of credits from the user 'Archimede' and""<br>"
//       "send the message haha to him.""<br>"));
//
//     command = addCommand(category, "site users [keyword|flag|=group|usernam*]");
//     addTextToElement(command, "Description", i18n("Lists users and shows their group, ul stats, dl stats, and credits"));
//     addTextToElement(command, "Whats This", i18n(
//       "Lists users and shows their group, ul stats, dl stats, and credits""<br>"
//       "<br>"
//       "Use a keyword to limit the display to specific users.""<br>"
//       "A keyword can be: deleted,siteop,gadmin,leech,anonymous,glock,exempt,""<br>"
//       "useredit,nuke,unnuke,undupe,kick,kill,take,give,users,idler.""<br>"
//       "<br>"
//       "Specifying a group's name instead of a keyword will only list users""<br>"
//       "that belong to that group. Specifying a flag will only lists users with""<br>"
//       "that flag. Exmp: site users 1 (list all siteops), site users 5 (all""<br>"
//       "users with color turned on), site users =STAFF (all users in group""<br>"
//       "STAFF).""<br>"
//       "<br>"
//       "You can use partial username with a * at the end to find all users""<br>"
//       "whose name starts with those letters.  <i>Example:</i> site users f*""<br>"
//       "This will find frank, frog, etc.""<br>"));
//
//     command = addCommand(category, "site update <string>");
//     addTextToElement(command, "Description", i18n("Adds all dirs matching <string> in current directory to irlog (for \"site new\")"));
//     addTextToElement(command, "Whats This", i18n(
//       "Adds all dirs matching <string> in current directory to irlog (for \"site new\")""<br>"
//       "<br>"
//       "<i>Example:</i> site update A*""<br>"
//       "<br>"
//       "This will add all directories in current path that start with A to the dirlog.""<br>"));
//
//     command = addCommand(category, "site syslog [<number>] [<searchstring>]");
//     addTextToElement(command, "Description", i18n("Display the user changes log (ftp-data/logs/sysop.log)"));
//     addTextToElement(command, "Whats This", i18n(
//       "Display the user changes log (ftp-data/logs/sysop.log)""<br>"
//       "<br>"
//       "If you don't specify a number, the whole log will be shown.""<br>"
//       "If you do specify a number, it will only show changes that number of days old.""<br>"
//       "<i>Example:</i> site syslog 5""<br>"
//       "<br>"
//       "If you specify a searchstring, only entries containing that string will be shown.""<br>"
//       "<i>Example:</i> site syslog 10 deleted""<br>"
//       "<i>Example:</i> site syslog added   -OR-   site syslog 0 added""<br>"));
//
//     command = addCommand(category, "site unnuke <directory> <message>");
//     addTextToElement(command, "Description", i18n("Unnuke a directory"));
//     addTextToElement(command, "Whats This", i18n(
//       "Unnuke a directory""<br>"
//       "<br>"
//       "<i>Example:</i> site unnuke shit NOT CRAP""<br>"
//       "<br>"
//       "This will unnuke the directory 'shit' with the comment 'NOT CRAP'.""<br>"
//       "<br>"
//       "<b>NOTE:</b> You can enclose the directory in braces if you have spaces in the name""<br>"
//       "<i>Example:</i> site unnuke {My directory name} justcause""<br>"
//       "<br>"
//       "You need to configure glftpd to keep nuked files if you want to unnuke.""<br>"
//       "See the section about glftpd.conf.""<br>"));
//
//     command = addCommand(category, "site undupe <string>");
//     addTextToElement(command, "Description", i18n("Remove filename(s) from ftp-data/logs/dupefil"));
//     addTextToElement(command, "Whats This", i18n(
//       "Remove filename(s) from ftp-data/logs/dupefil""<br>"
//       "<br>"
//       "<i>Example:</i> site undupe cls*""<br>"
//       "<br>"
//       "This will remove all files that start with the string 'cls' from""<br>"
//       "the dupe database.""<br>"));
//
//     command = addCommand(category, "site predupe <filename>");
//     addTextToElement(command, "Description", i18n("Adds <filename> to the dupefile database, so that it can't e uploaded."));
//     addTextToElement(command, "Whats This", i18n(
//       "Adds <filename> to the dupefile database, so that it can't e uploaded.""<br>"
//       "<br>"
//       "Users need access to -predupe in glftpd.conf to use this.""<br>"
//       "<br>"
//       "Files that match those listed under ignore_type in glftpd.conf will""<br>"
//       "not be added.""<br>"));
//
//     command = addCommand(category, "site wipe [-r] <file/directory>");
//     addTextToElement(command, "Description", "");
//     addTextToElement(command, "Whats This", i18n(
//       "This is similar to the UNIX rm command.""<br>"
//       "In glftpd, if you just delete a file, the uploader loses credits and""<br>"
//       "upload stats for it.  There are many people who didn't like that and""<br>"
//       "were unable/too lazy to write a shell script to do it for them, so I""<br>"
//       "wrote this command to get them off my back.""<br>"
//       "<br>"
//       "If the argument is a file, it will simply be deleted. If it's a""<br>"
//       "directory, it and the files it contains will be deleted.  If the""<br>"
//       "directory contains other directories, the deletion will be aborted.""<br>"
//       "<br>"
//       "To remove a directory containing subdirectories, you need to use""<br>"
//       "\"site wipe -r dirname\". BE CAREFUL WHO YOU GIVE ACCESS TO THIS COMMAND.""<br>"
//       "Glftpd will check if the parent directory of the file/directory you're""<br>"
//       "trying to delete is writable by its owner. If not, wipe will not""<br>"
//       "execute, so to protect directories from being wiped, make their parent""<br>"
//       "555.""<br>"
//       "<br>"
//       "Also, wipe will only work where you have the right to delete (in""<br>"
//       "glftpd.conf). Delete right and parent directory's mode of 755/777/etc""<br>"
//       "will cause glftpd to SWITCH TO ROOT UID and wipe the file/directory.""<br>"
//       "\"site wipe -r /\" will not work, but \"site wipe -r /incoming\" WILL, SO""<br>"
//       "BE CAREFUL.""<br>"
//       "<br>"
//       "This command will remove the deleted files/directories from the dirlog""<br>"
//       "and dupefile databases.""<br>"
//       "<br>"
//       "To give access to this command, add \"-wipe -user flag =group\" to the""<br>"
//       "config file (similar to other site commands).""<br>"
//       "<br>"
//       "<b>NOTE:</b>  The two commands below require unzip to reside in the /bin directory""<br>"
//       "(it's /bin in the chroot'ed environment, so /glftpd/bin in reality)""<br>"));
//
//     command = addCommand(category, "site xdupe [mode]");
//     addTextToElement(command, "Description", "");
//     addTextToElement(command, "Whats This", i18n(
//       "If mode is present, xdupe mode will be set to it. If not, glftpd will""<br>"
//       "print currently set mode.""<br>"
//       "<br>"
//       "Xdupe will allow clients that keep queues of files to be uploaded to""<br>"
//       "quickly remove files from their queue if they already exist on""<br>"
//       "the glftpd site, without the need to refresh. This should minimize the""<br>"
//       "number of 'dupe' errors as clients try to upload files that have""<br>"
//       "already been uploaded by someone else to the current directory. When""<br>"
//       "this is turned on (through 'site xdupe'), glftpd will give a list of""<br>"
//       "files, preceded by the string \"X-DUPE:\", right before the usual \"this\"""<br>"
//       "file is a dupe message. The files are first matched against a list""<br>"
//       "of file masks on the \"xdupe\" line in glftpd.conf. See the included""<br>"
//       "x-dupe-info.txt for more details. Currently, pftp is the only client""<br>"
//       "which supports this feature.""<br>"
//       "<br>"
//       "example config file entry:""<br>"
//       "xdupe *.zip *.rar *.r[0-9][0-9] *.gz *.tgz *.arj""<br>"));

//     command = addCommand(category, "");
//     addTextToElement(command, "Description", "");
//     addTextToElement(command, i18n("Whats This"), "");
//
//     command = addCommand(category, "");
//     addTextToElement(command, "Description", "");
//     addTextToElement(command, "Whats This", "");
//
//     command = addCommand(category, "");
//     addTextToElement(command, "Description", "");
//     addTextToElement(command, "Whats This", "");


//   server = m_document.createElement("server");
//   server.setAttribute("name", "ioFTPd");
//   root.appendChild(server);
//
//     command = m_document.createElement("command");
//     command.setAttribute("name", "site stat");
//     server.appendChild(command);

}

QDomElement Manager::addCategory(QDomElement &parent, QString categoryText)
{
  QDomElement category;

  category = m_document.createElement("category");
  category.setAttribute("name", categoryText);
  parent.appendChild(category);

  return category;
}
QDomElement Manager::addCommand(QDomElement &parent, QString elementText)
{
  QDomElement command;

  command = m_document.createElement("command");
  command.setAttribute("name", elementText);
  parent.appendChild(command);

  return command;
}

void Manager::addTextToElement(QDomElement &parent, QString elementText, QString textNodeText)
{
  QDomElement tag;
  QDomText text;

  tag = m_document.createElement(elementText);
  text = m_document.createTextNode(textNodeText);
  tag.appendChild(text);
  parent.appendChild(tag);
}

void Manager::save()
{
  // Save the new XML file
  if (m_filename.isEmpty()) {
    qDebug("WARNING: No open XML file, will NOT save.");
    return;
  }

  QFile file(m_filename);
  if (!file.open(IO_WriteOnly)) {
    qDebug("WARNING: Unable to open xml for writing!");
    return;
  }

  // Write the XML data to the stream
  QTextStream fileStream(&file);
  fileStream << m_document.toString();
  file.flush();
  file.close();

}

void Manager::guiPopulateServerManagementTree(KFTPWidgets::ServerManagement::ListView *tree, QDomNode parent, KFTPWidgets::ServerManagement::ListViewItem *item)
{
  if (!item)
    // Clear the tree
    tree->clear();

  QDomNode n = parent.firstChild();

  // As long as there are nodes
  while (!n.isNull()) {
    // Node must be a Element
    if (n.isElement()) {
      QDomElement e = n.toElement();

      // current element is a sub folder - category
      if (e.tagName() == "category") {
        KFTPWidgets::ServerManagement::ListViewItem *cat;

        if (!item)
          cat = new KFTPWidgets::ServerManagement::ListViewItem(tree, e.attribute("name"));
        else
          cat = new KFTPWidgets::ServerManagement::ListViewItem(item, e.attribute("name"));

        cat->setPixmap(0, KFTPGrabberBase::loadSmallPixmap("folder"));

        // call this method itself and add all sub elements/folders
        guiPopulateServerManagementTree(tree, n, cat);
      } else if (e.tagName() == "command") {
        KFTPWidgets::ServerManagement::ListViewItem *serv;

        if (!item)
          serv = new KFTPWidgets::ServerManagement::ListViewItem(tree, e.attribute("name"));
        else
          serv = new KFTPWidgets::ServerManagement::ListViewItem(item, e.attribute("name"));

        // go through of all text nodes in the element
        for (QDomNode n = e.firstChild(); !n.isNull(); n = n.nextSibling()) {
          if (n.toElement().tagName() == "Description") {
            serv->setDescription(n.toElement().text());
          }
          if (n.toElement().tagName() == "Whats This") {
            serv->setWhatThis(n.toElement().text());
          }
          if (n.toElement().tagName() == "Value Range" ) {
            serv->setValueRange(n.toElement().text());
          }
        }
      }
    }
    n = n.nextSibling();
  }
}



}
#include "kftpservermanagement.moc"
