
#ifndef QCUT_H
#define QCUT_H

class QString;

/*!
 * @short Cut a QString
 * @author Blacknator
 * @version 1.0 - 12.03.2005
 *
 * define 2 QStrings sequences ( seperators ):
 * @li define the field position of the first string sequence
 * @li define the field position of the second string sequence
 * @li define to print the first string sequence
 * @li define to print the second string sequence
 */
class QCut
{
  private:

  public:
    QCut();
    ~QCut();

    /*!
     * cut a qstring
     *
     * @param sep1 begin from this string, empty if no string
     * @param sep2 end   at   this string, empty if no string
     * @param cutString string to cut
     * @param field1 1, 2, 3 etc, counting from the left, -1, -2, -3, etc. counting from the right, 0 line begin
     * @param field2 1, 2, 3 etc, counting from the left, -1, -2, -3, etc. counting from the right, 0 line end
     * @param show1  false - don't print sep1 string
     * @param show2  false - don't print sep2 string
     *
     * Example:
     * \code
     * QString cut = QCut().cut( "", "[", "This is a [text]", 0, 1 );
     * \endcode
     * Result:<br>
     *   This is a [
     *
     * Example:
     * \code
     * QString cut = QCut().cut( "[", "]", "This is a [text] [more text]", 1, 1 );
     * \endcode
     * Result:<br>
     *   text
     *
     * Example:
     * \code
     * QString cut = QCut().cut( "[", "]", "This is a [text] [more text]", 1, -1 );
     * \endcode
     * Result:<br>
     *   text] [more text
     *
     * Example:
     * \code
     * QString cut = QCut().cut( "[", "]", "This is a [text] [more text]", -1, -1 );
     * \endcode
     * Result:<br>
     *   more text
     *
     * Example:
     * \code
     * QString cut = QCut().cut( "[", "", "This is a [text] [more text]", 1, 0 );
     * \endcode
     * Result:<br>
     *   text] [more text]
     *
     */
    QString cut( QString sep1, QString sep2, QString cutString, int field1, int field2, bool show1=false, bool show2=false );
};

#endif
