/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 *
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */
#include <qlabel.h>
#include <qlineedit.h>
#include <qlayout.h>
#include <qspinbox.h>

#include <kpassdlg.h>
#include <kdebug.h>
#include <klocale.h>

#include "listview.h"
#include "dialogwidget.h"

namespace KFTPWidgets {

namespace ServerManagement {

DialogWidget::DialogWidget(ListViewItem *item, QString arg, QWidget *parent, const char *name)
 : QWidget(parent, name)
 , m_item(item)
 , m_arg(arg)
 , m_attribute(NO)
{
  init();
}


DialogWidget::~DialogWidget()
{
}

void DialogWidget::init()
{
  // user must enter a value
  if (m_arg.contains("<value>"))
    createValue("Value Range");

  // user must enter a username
  if (m_arg.contains("<user>"))
    createString(i18n("Username"), i18n("Enter a username or press cancel"));

  // user must enter a group
  if (m_arg.contains("<group>"))
    createString(i18n("Group name"), i18n("Enter a group or press cancel"));

  // user must enter a description
  if (m_arg.contains("<description>"))
    createString(i18n("Description name"), i18n("Enter a description or press cancel"));

  // user must enter a password
  if (m_arg.contains("<password>"))
    createPassword(i18n("Passwords do not match"));
}

void DialogWidget::checkOptional()
{
  // argument is optional
  if (m_arg.left(1) == "[") {
    m_attribute = OPTIONAL;

    m_label->setText(m_label->text() + " (" + i18n("Optional") + ")");
  }
}

void DialogWidget::createValue( QString label )
{
  m_argWidget = VALUE;

  // create a layout
  m_layout = new QGridLayout(this, 0, 0, 11, 6, "dialogLayout");

  m_label = new QLabel(label, this, "dialogLabel");
  m_spinBox = new QSpinBox(this, "dialogSpinBox");

  // set minimun value
  if (m_item->m_valueMin)
    m_spinBox->setMinValue(m_item->m_valueMin);

  // set maximum value
  if (m_item->m_valueMax)
    m_spinBox->setMaxValue(m_item->m_valueMax);

  // set the label
  if (!m_item->m_valueMinMax.isEmpty())
    m_label->setText(m_label->text() + " (" + m_item->m_valueMinMax + ")");

  // check if the entry is optional or not
  checkOptional();

  // add to layout
  m_layout->addWidget(m_label, 0, 0);
  m_layout->addWidget(m_spinBox, 0, 1);
}

void DialogWidget::createString( QString label, QString error )
{
  m_argWidget = STRING;
  m_argError = error;

  // create a layout
  m_layout = new QGridLayout(this, 0, 0, 11, 6, "dialogLayout");

  m_label = new QLabel(label, this, "dialogLabel");
  m_lineEdit = new QLineEdit(this, "dialogUserEdit");

  // check if the entry is optional or not
  checkOptional();

  // add to layout
  m_layout->addWidget(m_label, 0, 0);
  m_layout->addWidget(m_lineEdit, 0, 1);
}

void DialogWidget::createPassword(QString error)
{
  m_argWidget = PASSWORD;
  m_argError = error;

  // create a layout
  m_layout = new QGridLayout(this, 0, 0, 11, 6, "dialogLayout");

  // create the labels
  m_passwordLabel1 = new QLabel(i18n("Password:"), this, "dialogPasswordLabel1");
  m_passwordLabel2 = new QLabel(i18n("Password retype:"), this, "dialogPasswordLabel2");
  // create the password edit
  m_passwordEdit1 = new KPasswordEdit(KPasswordEdit::OneStar, this, "dialogPasswordEdit1");
  m_passwordEdit2 = new KPasswordEdit(KPasswordEdit::OneStar, this, "dialogPasswordEdit2");

  // add to layout
  m_layout->addWidget(m_passwordLabel1, 0, 0);
  m_layout->addWidget(m_passwordEdit1, 0, 1);
  m_layout->addWidget(m_passwordLabel2, 1, 0);
  m_layout->addWidget(m_passwordEdit2, 1, 1);
}

QString DialogWidget::text()
{
  switch (m_argWidget) {
    case VALUE: {
      return " " + m_spinBox->text();
      break;
    }
    case STRING: {
      if (m_attribute == OPTIONAL) {
        return " " + m_lineEdit->text();
        break;
      } else {
          if (m_lineEdit->text().isEmpty())
            return "";
          else
            return " " + m_lineEdit->text();
      }
      break;
    }
    case PASSWORD: {
      QString pass1 = m_passwordEdit1->password();
      QString pass2 = m_passwordEdit2->password();

      if (pass1 != pass2) {
        return "";
      } else {
        return " " + pass1;
      }
      break;
    }
  }

  return "";
}

}

}

#include "dialogwidget.moc"
