/***************************************************************************
*   Copyright (C) 2003 by Mark Kretschmann                                *
*   markey@web.de                                                         *
*   based on work by Charles Samuels <charles@kde.org>                    *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef MODPLUGPLAYER_IMPL_H
#define MODPLUGPLAYER_IMPL_H

#define APP_VERSION "0.5"


namespace Arts
{

    class ModplugPlayObject_impl
                : public ModplugPlayObject_skel, public StdSynthModule
    {
    public:
        ModplugPlayObject_impl();
        ~ModplugPlayObject_impl();

        void loadConfig();
        void saveConfig();
        void updateConfig();

        bool loadMedia( const std::string &filename );
        std::string description();
        poTime currentTime();
        poTime overallTime();
        poCapabilities capabilities();
        std::string mediaName();
        poState state();
        void play();
        void halt();
        void seek( const class poTime &t );
        void pause();
        void streamInit();
        void streamStart();
        void calculateBlock( unsigned long samples );
        void streamEnd();

        float xbass_depth();
        void xbass_depth( float newval );
        float xbass_range();
        void xbass_range( float newval );

        float reverb_depth();
        void reverb_depth( float newval );
        float reverb_delay();
        void reverb_delay( float newval );

        float surround_depth();
        void surround_depth( float newval );
        float surround_delay();
        void surround_delay( float newval );

        string resampling_mode();
        void resampling_mode( const string &newval );

    protected:

// ATTRIBUTES --------
        int m_fd;
        int m_size;
        int m_len;
        unsigned char *m_map;

        unsigned int m_xbassDepth, m_xbassRange;
        unsigned int m_reverbDepth, m_reverbDelay;
        unsigned int m_surroundDepth, m_surroundDelay;
        string m_resamplingMode;
        map<string, unsigned int> m_resamplingMap;

        ConfigParser m_configParser;
        CSoundFile m_mod;

        unsigned long m_bufLen;
        signed short *m_pBuffer;

        poState m_state;
    };

};

#endif
