/***************************************************************************
 *   Copyright (C) 2003 by Mark Kretschmann                                *
 *   markey@web.de                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <cstdlib>
#include <string>
#include <fstream>
#include <sstream>

#include <debug.h>

#include <configparser.h>


using namespace std;


ConfigParser::ConfigParser()
{}


ConfigParser::~ConfigParser()
{}


//METHODS ----------------------------------------------------------------------------

void ConfigParser::readConfig( const string &fileName )
{
    m_fileName = fileName;
    ifstream input( fileName.c_str() );

    if ( input )
    {
        char ch;
        while ( input.get( ch ) )
            m_configStr += ch;
    }

    input.close();
}


void ConfigParser::writeConfig()
{
    m_configStr.resize( m_configStr.find_last_of( "\n" ) + 1 );  // truncate config file after last "\n"

    m_pOutput = new ofstream( m_fileName.c_str() );
    *m_pOutput << m_configStr;
    m_pOutput->close();

    delete m_pOutput;
}


string ConfigParser::getValue( const string &key )
{
    uint valPos;
    uint valLen;

    findValue( valPos, valLen, key );

    if ( valPos == std::string::npos )
    {
        return string();
    }
    else
    {
        return m_configStr.substr( valPos, valPos + valLen );
    }
}


void ConfigParser::replaceValue( const string &key, const string &value )
{
    uint valPos;
    uint valLen;

    findValue( valPos, valLen, key );

    if ( valPos == std::string::npos )
    {
        m_configStr += key;
        m_configStr += string( " = " );
        m_configStr += value;
        m_configStr += string( "\n" );
    }
    else
    {
        m_configStr.replace( valPos, valLen, value );
    }
}


void ConfigParser::findValue( uint &valPos, uint &valLen, const string& key )
{
    valPos = m_configStr.find( key );

    if ( valPos != std::string::npos )
    {
        valPos = m_configStr.find( "=", valPos );
        valPos = m_configStr.find_first_not_of( " ", valPos + 1 );
        valLen = m_configStr.find( "\n", valPos ) - valPos;
    }
}


int ConfigParser::readIntEntry( const string &key, int defaultVal )
{
    string str = getValue( key );

    if ( str.empty() )
        return defaultVal;
    else
        return atoi( str.c_str() );
}


unsigned int ConfigParser::readUintEntry( const string &key, unsigned int defaultVal )
{
    string str = getValue( key );
    arts_debug( "getValue: " );
    arts_debug( str.c_str() );

    if ( str.empty() )
        return defaultVal;
    else
        return static_cast<unsigned int>( atoi( str.c_str() ) );
}


string ConfigParser::readStringEntry( const string &key, string defaultVal )
{
    string str = getValue( key );

    if ( str.empty() )
        return defaultVal;
    else
        return str;
}


void ConfigParser::writeEntry( const string &key, int value )
{
    stringstream convertStream;
    convertStream << value;

    string str;
    convertStream >> str;

    replaceValue( key, str );
}


void ConfigParser::writeEntry( const string &key, unsigned int value )
{
    stringstream convertStream;
    convertStream << value;

    string str;
    convertStream >> str;

    replaceValue( key, str );
}


void ConfigParser::writeEntry( const string &key, string value )
{
    stringstream convertStream;
    convertStream << value;

    string str;
    convertStream >> str;

    replaceValue( key, str );
}
