#!/bin/sh
#
# ptetex -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#

. ./common.sh
SRC=$1/tetex-src-$TETEX_VER

## arg check
if test -z "$1"; then
cat <<EOF
usage : $0 'src-directory'
ex.:    $0 /usr/local/src
EOF
exit 1
fi

if test "$TEXSRC_EXTRACT" = "yes"; then
    shouldnotexist $SRC
    $MKDIR $SRC
    enoughspace $SRC 450000
fi

## start
test "$TEXSRC_EXTRACT" = "yes" && tarx $SRC_DIR/tetex-src-$TETEX_VER.tar.gz $1
# Fix parallel builds. (impoted from FC4)
cpatch archive/tetex-3.0-makej.patch  1 $SRC
# Fix usage of uninitialized variable (impoted from FC4)
cpatch archive/tetex-3.0-dcb314.patch 1 $SRC

# Fix hi-resolution pk font generation error caused by 'dvips -Ppdf'
cpatch archive/tetex-3.0-magstep.patch 1 $SRC
# add --nostop option: don't stop even if a map file is not found
cpatch archive/updmap-nostop.patch    0 $SRC/texk/tetex

# xdvi update
zpatch archive/xdvik-tetex-3.0-22.84.10.diff.gz 1 $SRC
# compile xdvi earlier, compile pdvipsk and pxdvik
perlprint "s/^(PKGS=')/\1 dvipsk pdvipsk xdvik pxdvik/; s/tth xdvik\$/tth/g;
	s/dvipng dvipsk gsftopk/dvipng gsftopk/g" \
    $SRC/texk/configure

## use TEXMFMAIN for TEXMFDIST etc. instead of absolute path
perlprint 's/\@texmf\@-/\$TEXMFMAIN-/g' \
    $SRC/texk/kpathsea/texmf.in-teTeX
perlprint 'print "#" if /echo .*TEXMF(LOCAL|DIST|%g)/' \
    $SRC/texk/kpathsea/Makefile.in

## if TEXMFDIST is specified
if test -n "$TEXMFDIST"; then
    perlprint "s|^(TEXMFDIST) = .*|\1 = $TEXMFDIST|g" \
	$SRC/texk/kpathsea/texmf.in-teTeX
fi

## also find files which aren't listed in ls-R
## give priority to $TEXMFLOCAL over $TEXMFMAIN (Bug?)
perlprint  's/^TEXMF = {!!\$TEXMFCONFIG,!!\$TEXMFVAR,\$TEXMFHOME,!!\$TEXMFSYSCONFIG,!!\$TEXMFSYSVAR,!!\$TEXMFMAIN,!!\$TEXMFLOCAL,!!\$TEXMFDIST}/TEXMF = {\$TEXMFCONFIG,\$TEXMFVAR,\$TEXMFHOME,\$TEXMFSYSCONFIG,\$TEXMFSYSVAR,\$TEXMFLOCAL,\$TEXMFMAIN,!!\$TEXMFDIST}/g' $SRC/texk/kpathsea/texmf.in-teTeX

# enlarge buffer size for Babel (imported from Web2C-7.5.5)
# http://oku.edu.mie-u.ac.jp/~okumura/texfaq/qa/37404.html
# http://oku.edu.mie-u.ac.jp/~okumura/texfaq/qa/37707.html
for f in $SRC/texk/web2c/tex.ch \
         $SRC/texk/web2c/omegadir/com16bit.ch \
	 $SRC/texk/web2c/alephdir/com16bit-rc2.ch
  do perlprint 's/(\@d ssup_trie_size ==) 262143/\1 4194303/g' $f
done


if test "$JAPANESE" != "without"; then
## for pTeX
tarx archive/ptex-src-3.1.10-Beta2.tar.gz $SRC/texk/web2c
mv $SRC/texk/web2c/ptex-src-* $SRC/texk/web2c/ptex || exit
cpatch archive/ptex-src-3.1.10-fmtutil.diff   1 $SRC/texk/web2c/ptex
cpatch archive/ptex-src-3.1.10-utf8.patch     1 $SRC/texk/web2c/ptex
cpatch archive/ptex-src-3.1.10-jbibutf8.patch 1 $SRC/texk/web2c/ptex
# comment out TEXINPUTS.platex (not to be erased by mkconf)
perlprint 's/^(TEXINPUTS.platex)/% \1/g' $SRC/texk/kpathsea/texmf.in-teTeX
# rewrite 'platex2e_inputs' macro
perlprint 's|/\{ptex/\{platex,generic,\},tex/\{latex,generic,\}\}|/{ptex/platex,{p,}tex/latex,{p,}tex/generic,{p,}tex}|g; s/\| uniq//g' $SRC/texk/web2c/ptex/mkconf
# for Japanese font setting
cpatch archive/updmap-3.0-4.diff 0 $SRC/texk/tetex
# for UTF/OTF package
cpatch archive/tetex-src-3.0-omegaware.patch 1 $SRC

## for platex209
perlnoprint 's|(platex-euc platex-sjis)|\1 platex209|g; print; print "	echo  \"platex209	ptex		language.dat	plplain.ini\" >> \$\@\n" if /Japanese pTeX:/' \
    $SRC/texk/web2c/ptex/Makefile.in

## for mendexk
tarx archive/mendexk2.6d.tar.gz $SRC/texk
mv $SRC/texk/mendexk* $SRC/texk/mendexk || exit
cpatch archive/mendexk2.6d-utf8.patch 1 $SRC/texk/mendexk

## for jmpost
tarx archive/jmpost-0.04b.tar.gz $SRC/texk/web2c/ptex
mv $SRC/texk/web2c/ptex/jmpost-* $SRC/texk/web2c/ptex/jmpost || exit
cpatch archive/jmpost-0.04b-fmtutil.diff 1 $SRC/texk/web2c/ptex/jmpost
perlprint 's|^getjobname\(strnumber name\)$|getjobname()|;
    s|strnumber ret = name;$|strnumber ret = curname;|' \
    $SRC/texk/web2c/ptex/jmpost/jmpextra.c
perlprint 's|\.\./kanji\.o |../kanji.o ../jisx0208.o |' \
    $SRC/texk/web2c/ptex/jmpost/Makefile.in
perlprint 's/mpost\)/mpost|jmpost\)/g' $SRC/texk/tetex/fmtutil 
perlprint 'print "MPXCOMMAND.jmpost = pmakempx\n" if /MPXCOMMAND/' \
    $SRC/texk/kpathsea/texmf.in-teTeX

## for dvipdfmx
tarx archive/dvipdfmx-20050831.tar.gz $SRC/texk
mv $SRC/texk/dvipdfmx-* $SRC/texk/dvipdfmx || exit
cpatch archive/dvipdfmx-20050831-p.patch    1 $SRC/texk/dvipdfmx
cpatch archive/dvipdfmx-20050831-leak.patch 1 $SRC/texk/dvipdfmx
perlprint "s/ cid-x.map\$/ kanjix.map/g;
s|^%(D  \"gs .*%o) (%i .*\")|\1 -dNOKANJI -c '.setpdfwrite << /NeverEmbed [/Courier /Courier-Bold /Courier-Oblique /Courier-BoldOblique /Helvetica /Helvetica-Bold /Helvetica-Oblique /Helvetica-BoldOblique /Times-Roman /Times-Bold /Times-Italic /Times-BoldItalic /Symbol /ZapfDingbats /Ryumin-Light /GothicBBB-Medium] >> setdistillerparams' -f \2|" \
    $SRC/texk/dvipdfmx/data/config/dvipdfmx.cfg
$RM $SRC/texk/dvipdfmx/data/config/cid-x.map


if test "$JAPANESE" = "international"; then
    $MKDIR $SRC/texk/pdvipsk
    $CP $SRC/texk/dvipsk/* $SRC/texk/pdvipsk/
    $MKDIR $SRC/texk/pxdvik
    $CP -r $SRC/texk/xdvik/* $SRC/texk/pxdvik/
    P=p
fi
## for dvipsk
tarx archive/dvipsk-5.95b-p1.7a.tar.gz                $SRC/texk/${P}dvipsk
cpatch $SRC/texk/${P}dvipsk/dvipsk-5.95b-p1.7a.diff 1 $SRC/texk/${P}dvipsk
#tarx archive/dvipsk-jpatch-p1.7a.tar.gz          $SRC/texk/${P}dvipsk
#cpatch $SRC/texk/${P}dvipsk/dvipsk-p1.7a.patch 1 $SRC/texk/${P}dvipsk
# disable psfonts_jp.map
perlprint 's/^(p \+psfonts\_jp\.map)/* \1/g' $SRC/texk/${P}dvipsk/config.ps
perlnoprint '$a=1 if /^# psfonts_jp.map/; $a=0 if /^# Info files/;
	print unless $a' $SRC/texk/${P}dvipsk/Makefile.in

## for xdvik
zpatch archive/xdvik-tetex-3.0-200?????.diff.gz 3 $SRC/texk/${P}xdvik
# fix for FC5
perlprint 's/^typedef\subyte/typedef unsigned int/' $SRC/texk/${P}xdvik/xdvi.h
cat <<EOF >> $SRC/texk/${P}xdvik/texmf/XDvi || exit 1


!!! ------- added by ptetex -------

!*.shrinkFactor: 5
!*.geometry: 950x700+0+0
!*.expert: true
!*.smallPanel: false


*.editor: emacsclient --no-wait +%l %f
!*.editor: gnuclient -q +%l %f
!*.editor: gvim --servername xdvi --remote +%l %f
!*.editor: nc -noask +%l %f
EOF

if test "$JAPANESE" = "international"; then
    ### pdvipsk
    perlprint  's|program = dvips|program = pdvips|g;
		s|programs = afm2tfm|programs = |g;
		s|dvips.info||g;
		s|.*o\$\(program\).*||g;
		s|install-data: \$\(program\).info|install-data:|g;
		s|install-info.*\$\(program\).info|echo|g;
		s|\$\(INSTALL_DATA\) \$\$i \$\(infodir\)/\$\$i||g;' \
	$SRC/texk/pdvipsk/Makefile.in
    perlnoprint '$a=1 if /^# Info files/; $a=0 if /^# TeX macros/;
	$a=1 if /install-info/;
	print unless $a;
	$a=0 if /else true/;' $SRC/texk/pdvipsk/Makefile.in
    # noomega for pxdvi
    perlprint 's|^(Boolean noomega) = 0|\1 = 1|g' $SRC/texk/pdvipsk/dvips.c
    ### pxdvik
    for f in $SRC/texk/pxdvik/configure.in \
	     $SRC/texk/pxdvik/configure; do
      perlprint  's|^(program_transform_name=s,x,)(x,)|\1p\2|;' $f
    done
    perlprint  's|manpage = xdvi|manpage = pxdvi|g;
		s|.*o\$.*||g;
		s|.*o\@.*||g;
		s/\$\(INSTALL_DATA\).*(manext\)|pixmaps)//g;
		s|xdvizilla|pxdvizilla|g;' \
	$SRC/texk/pxdvik/Makefile.in
    mv $SRC/texk/pxdvik/xdvizilla $SRC/texk/pxdvik/pxdvizilla
    perlprint 's|xdvi|pxdvi|g' $SRC/texk/pxdvik/pxdvizilla
fi

## freetype for xdvi-jp
if test "$SYSTEM_FREETYPE2" = "no"; then
    tarx archive/freetype-2.2.1.tar.gz $SRC
    mv $SRC/freetype-* $SRC/freetype || exit
    perlprint 's/# (AUX_MODULES \+= otvalid)/\1/' $SRC/freetype/modules.cfg
fi
fi # "$JAPANESE" != "without"


## security fix
# Don't use tmpnam() in dvipdfm. (impoted from FC4)
cpatch security/tetex-2.0.2-dvipdfm-security.patch 1 $SRC
# Fix xpdf overfows CVE-2005-3193 (impoted from FC4)
cpatch security/tetex-3.0-CVE-2005-3193.patch      1 $SRC

#exit # uncomment if 'mktemp' command doesn't exist
# Don't use PID for temporary file names in scripts. (impoted from FC4)
cpatch security/tetex-3.0-badscript.patch          1 $SRC

## post
echo ""


## check
cat md5sum/texsrc.$JAPANESE | (cd $SRC; md5check) && exit
cat <<EOF

$0: Some processes were performed improperly.
Check if you have GNU patch.
Some environment variables (TEXMF, LD_LIBRARY_PATH, etc) may make side effect.

EOF
exit 1
