# for Red Hat Enterprise Linux v.4
%define fontsjp ttfonts-ja

%define exec_texhash [ -x %{_bindir}/texconfig-sys ] && PATH=%{_bindir}:$PATH %{_bindir}/texconfig-sys rehash 2>/dev/null
%define exec_updmap  [ -x %{_bindir}/updmap-sys ]    && PATH=%{_bindir}:$PATH %{_bindir}/updmap-sys --nostop 2>/dev/null

Summary: TeX distribution teTeX with Japanese patch collection 'ptetex'
Name: tetex
Version: 3.0
Release: 20060615
Source1: http://tutimura.ath.cx/~nob/tex/ptetex/ptetex3/ptetex3-%{release}.tar.gz
Source0: http://www.ring.gr.jp/pub/text/CTAN/systems/unix/teTeX/3.0/distrib/tetex-src-3.0.tar.gz
Source2: http://www.ring.gr.jp/pub/text/CTAN/systems/unix/teTeX/3.0/distrib/tetex-texmf-3.0po.tar.gz
URL: http://www.nn.iij4u.or.jp/~tutimura/tex/ptetex.html
License: distributable
Buildroot: %{_tmppath}/%{name}-%{version}-root
Group: Applications/Publishing
Requires: ed mktemp
PreReq:        ghostscript %{fontsjp}
BuildRequires: ghostscript %{fontsjp}
BuildRequires: bison flex
BuildRequires: zlib-devel libpng-devel gd-devel libjpeg-devel ncurses-devel
BuildRequires: xorg-x11-devel openmotif-devel
Provides: tetex-latex tetex-fonts tetex-afm
Provides: tetex-dvips tetex-xdvi  tetex-doc
#PreReq:        tetex-texmf
#BuildRequires: tetex-texmf

%description
TeTeX is an implementation of TeX for Linux or UNIX systems.

%prep
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%setup -q -n tetex-src-3.0 -a 1
mv ptetex3-* ptetex3
cd ptetex3
cat <<EOF > my_option
SRC_DIR=%{_sourcedir}
REAL_PREFIX=%{_prefix}
REAL_DATA=%{_datadir}
TEXSRC_EXTRACT=no
#TEXMFDIST=%{_datadir}/texmf-dist
export CFLAGS="$RPM_OPT_FLAGS"

CONF_OPTION="\$CONF_OPTION --without-dviljk"
CONF_OPTION="\$CONF_OPTION --without-info"
CONF_OPTION="\$CONF_OPTION --without-texi2html"
CONF_OPTION="\$CONF_OPTION --without-texinfo"

CONF_OPTION="\$CONF_OPTION --with-system-zlib"
CONF_OPTION="\$CONF_OPTION --with-system-pnglib"
CONF_OPTION="\$CONF_OPTION --with-system-gd"
CONF_OPTION="\$CONF_OPTION --with-system-ncurses"
CONF_OPTION="\$CONF_OPTION --enable-shared"

MAKE_OPTION="\$MAKE_OPTION vartexfonts=%{_var}/lib/texmf"
EOF
# change SRC_DIR, ommit file check
perl -pi -e "s|^(SRC_DIR).*|\1 = %{_builddir}|g; s|(\./1check-archive\.sh)|\1 notetex|g" Makefile
# remove useless entry in 7font-search.sh
perl -ni -e 'print unless /^X11TTF / or /^Acrobat/' 7font-search.sh
# extract files
make PREFIX=`pwd` x
# modify input method for xdvi
perl -pi -e 's/(\*inputMethod: kinput2)/! \1/' \
    ../texk/xdvik/texmf/XDvi
# avoid dependency on perl-Tk
rm -rf teTeX/share/texmf-dist/scripts/context/perl

%build
cd ptetex3
make PREFIX=`pwd` c macro otf babel fonty

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_prefix}
mkdir -p $RPM_BUILD_ROOT%{_var}/lib/texmf
cp -a ptetex3/teTeX/* $RPM_BUILD_ROOT%{_prefix}

### Files list
find %{buildroot} -type f -or -type l | \
    sed -e "s|%{buildroot}||g" \
	-e "s|.*\.cnf$|%config(noreplace) &|" \
	-e "s|.*\.cfg$|%config(noreplace) &|" \
	-e "s|.*/ls-R$|%ghost &|" \
	-e "s|.*/texmf-var/.*\.log$|%ghost &|" \
	-e "s|.*/texmf-var/.*map$|%ghost &|" \
	-e "s|.*/texmf-var/.*\.fmt$|%verify(not size md5 mtime) &|" \
	-e "s|.*/texmf-var/.*\.mem$|%verify(not size md5 mtime) &|" \
	-e "s|.*/texmf-var/.*\.base$|%verify(not size md5 mtime) &|" \
	-e "s|.*/man/man.*|&*|" \
	-e "s|.*/info/.*|&*|" \
						> filelist.full
find %{buildroot}%{_datadir}/texmf* -type d | \
    sed -e "s|^%{buildroot}|%dir |" \
	-e "s|$|/|"				>> filelist.full
echo "%dir %{_includedir}/kpathsea"		>> filelist.full

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT


%preun
rm -rf %{_var}/lib/texmf/*
exit 0

%post
/sbin/ldconfig
%{exec_texhash}
%{exec_updmap}
exit 0

%postun
/sbin/ldconfig
exit 0


%files -f filelist.full
%defattr(-,root,root)
%attr(1777,root,root) %dir %{_var}/lib/texmf


%changelog
* Mon Mar 20 2006 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added %verify() attribute to *.fmt and *.mem and *.base.

* Mon Dec  5 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- automatic yes in make font (target "fonty").

* Sat Dec  3 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- enhanced %exec_texhash macro (check if the command exist).

* Tue Aug 30 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- added 'babel' target for make.

* Thu Jun 16 2005 Nobuyuki Tsuchimura <tutimura(a)nn.iij4u.or.jp>
- 1st release.
