;;; ujisx0208ex.el --- tables between UCS and JIS X 0208 Extenstion -*- coding: shift_jis -*-

;; Copyright (C) 2004  ARISAWA Akihiro

;; Author: ARISAWA Akihiro <ari@mbf.sphere.ne.jp>
;; Keywords: CCL, mule, multilingual, character set, coding-system,
;;           ISO10646, Unicode, JIS X 0208, NEC special characters,
;;           NEC selection of IBM extension characters

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(defvar unicode-assoc-for-jisx0208ex
  `(assoc
    (char-1 . ucs-generic)
    ,(transformate-list-structure
      (identity . c-notated-string-to-number)
      (
       ;; NEC special characters
       (?@ . "0x2460") ; CIRCLED DIGIT ONE
       (?A . "0x2461") ; CIRCLED DIGIT TWO
       (?B . "0x2462") ; CIRCLED DIGIT THREE
       (?C . "0x2463") ; CIRCLED DIGIT FOUR
       (?D . "0x2464") ; CIRCLED DIGIT FIVE
       (?E . "0x2465") ; CIRCLED DIGIT SIX
       (?F . "0x2466") ; CIRCLED DIGIT SEVEN
       (?G . "0x2467") ; CIRCLED DIGIT EIGHT
       (?H . "0x2468") ; CIRCLED DIGIT NINE
       (?I . "0x2469") ; CIRCLED NUMBER TEN
       (?J . "0x246A") ; CIRCLED NUMBER ELEVEN
       (?K . "0x246B") ; CIRCLED NUMBER TWELVE
       (?L . "0x246C") ; CIRCLED NUMBER THIRTEEN
       (?M . "0x246D") ; CIRCLED NUMBER FOURTEEN
       (?N . "0x246E") ; CIRCLED NUMBER FIFTEEN
       (?O . "0x246F") ; CIRCLED NUMBER SIXTEEN
       (?P . "0x2470") ; CIRCLED NUMBER SEVENTEEN
       (?Q . "0x2471") ; CIRCLED NUMBER EIGHTEEN
       (?R . "0x2472") ; CIRCLED NUMBER NINETEEN
       (?S . "0x2473") ; CIRCLED NUMBER TWENTY
       (?T . "0x2160") ; ROMAN NUMERAL ONE
       (?U . "0x2161") ; ROMAN NUMERAL TWO
       (?V . "0x2162") ; ROMAN NUMERAL THREE
       (?W . "0x2163") ; ROMAN NUMERAL FOUR
       (?X . "0x2164") ; ROMAN NUMERAL FIVE
       (?Y . "0x2165") ; ROMAN NUMERAL SIX
       (?Z . "0x2166") ; ROMAN NUMERAL SEVEN
       (?[ . "0x2167") ; ROMAN NUMERAL EIGHT
       (?\ . "0x2168") ; ROMAN NUMERAL NINE
       (?] . "0x2169") ; ROMAN NUMERAL TEN
       (?_ . "0x3349") ; SQUARE MIRI
       (?` . "0x3314") ; SQUARE KIRO
       (?a . "0x3322") ; SQUARE SENTI
       (?b . "0x334D") ; SQUARE MEETORU
       (?c . "0x3318") ; SQUARE GURAMU
       (?d . "0x3327") ; SQUARE TON
       (?e . "0x3303") ; SQUARE AARU
       (?f . "0x3336") ; SQUARE HEKUTAARU
       (?g . "0x3351") ; SQUARE RITTORU
       (?h . "0x3357") ; SQUARE WATTO
       (?i . "0x330D") ; SQUARE KARORII
       (?j . "0x3326") ; SQUARE DORU
       (?k . "0x3323") ; SQUARE SENTO
       (?l . "0x332B") ; SQUARE PAASENTO
       (?m . "0x334A") ; SQUARE MIRIBAARU
       (?n . "0x333B") ; SQUARE PEEZI
       (?o . "0x339C") ; SQUARE MM
       (?p . "0x339D") ; SQUARE CM
       (?q . "0x339E") ; SQUARE KM
       (?r . "0x338E") ; SQUARE MG
       (?s . "0x338F") ; SQUARE KG
       (?t . "0x33C4") ; SQUARE CC
       (?u . "0x33A1") ; SQUARE M SQUARED
       (?~ . "0x337B") ; SQUARE ERA NAME HEISEI
       (? . "0x301D") ; REVERSED DOUBLE PRIME QUOTATION MARK
       (? . "0x301F") ; LOW DOUBLE PRIME QUOTATION MARK
       (? . "0x2116") ; NUMERO SIGN
       (? . "0x33CD") ; SQUARE KK
       (? . "0x2121") ; TELEPHONE SIGN
       (? . "0x32A4") ; CIRCLED IDEOGRAPH HIGH
       (? . "0x32A5") ; CIRCLED IDEOGRAPH CENTRE
       (? . "0x32A6") ; CIRCLED IDEOGRAPH LOW
       (? . "0x32A7") ; CIRCLED IDEOGRAPH LEFT
       (? . "0x32A8") ; CIRCLED IDEOGRAPH RIGHT
       (? . "0x3231") ; PARENTHESIZED IDEOGRAPH STOCK
       (? . "0x3232") ; PARENTHESIZED IDEOGRAPH HAVE
       (? . "0x3239") ; PARENTHESIZED IDEOGRAPH REPRESENT
       (? . "0x337E") ; SQUARE ERA NAME MEIZI
       (? . "0x337D") ; SQUARE ERA NAME TAISYOU
       (? . "0x337C") ; SQUARE ERA NAME SYOUWA
       (? . "0x2252") ; APPROXIMATELY EQUAL TO OR THE IMAGE OF
       (? . "0x2261") ; IDENTICAL TO
       (? . "0x222B") ; INTEGRAL
       (? . "0x222E") ; CONTOUR INTEGRAL
       (? . "0x2211") ; N-ARY SUMMATION
       (? . "0x221A") ; SQUARE ROOT
       (? . "0x22A5") ; UP TACK
       (? . "0x2220") ; ANGLE
       (? . "0x221F") ; RIGHT ANGLE
       (? . "0x22BF") ; RIGHT TRIANGLE
       (? . "0x2235") ; BECAUSE
       (? . "0x2229") ; INTERSECTION
       (? . "0x222A") ; UNION
       ;; NEC selection of IBM extension characters
       (?@ . "0x7E8A") ; CJK UNIFIED IDEOGRAPH
       (?A . "0x891C") ; CJK UNIFIED IDEOGRAPH
       (?B . "0x9348") ; CJK UNIFIED IDEOGRAPH
       (?C . "0x9288") ; CJK UNIFIED IDEOGRAPH
       (?D . "0x84DC") ; CJK UNIFIED IDEOGRAPH
       (?E . "0x4FC9") ; CJK UNIFIED IDEOGRAPH
       (?F . "0x70BB") ; CJK UNIFIED IDEOGRAPH
       (?G . "0x6631") ; CJK UNIFIED IDEOGRAPH
       (?H . "0x68C8") ; CJK UNIFIED IDEOGRAPH
       (?I . "0x92F9") ; CJK UNIFIED IDEOGRAPH
       (?J . "0x66FB") ; CJK UNIFIED IDEOGRAPH
       (?K . "0x5F45") ; CJK UNIFIED IDEOGRAPH
       (?L . "0x4E28") ; CJK UNIFIED IDEOGRAPH
       (?M . "0x4EE1") ; CJK UNIFIED IDEOGRAPH
       (?N . "0x4EFC") ; CJK UNIFIED IDEOGRAPH
       (?O . "0x4F00") ; CJK UNIFIED IDEOGRAPH
       (?P . "0x4F03") ; CJK UNIFIED IDEOGRAPH
       (?Q . "0x4F39") ; CJK UNIFIED IDEOGRAPH
       (?R . "0x4F56") ; CJK UNIFIED IDEOGRAPH
       (?S . "0x4F92") ; CJK UNIFIED IDEOGRAPH
       (?T . "0x4F8A") ; CJK UNIFIED IDEOGRAPH
       (?U . "0x4F9A") ; CJK UNIFIED IDEOGRAPH
       (?V . "0x4F94") ; CJK UNIFIED IDEOGRAPH
       (?W . "0x4FCD") ; CJK UNIFIED IDEOGRAPH
       (?X . "0x5040") ; CJK UNIFIED IDEOGRAPH
       (?Y . "0x5022") ; CJK UNIFIED IDEOGRAPH
       (?Z . "0x4FFF") ; CJK UNIFIED IDEOGRAPH
       (?[ . "0x501E") ; CJK UNIFIED IDEOGRAPH
       (?\ . "0x5046") ; CJK UNIFIED IDEOGRAPH
       (?] . "0x5070") ; CJK UNIFIED IDEOGRAPH
       (?^ . "0x5042") ; CJK UNIFIED IDEOGRAPH
       (?_ . "0x5094") ; CJK UNIFIED IDEOGRAPH
       (?` . "0x50F4") ; CJK UNIFIED IDEOGRAPH
       (?a . "0x50D8") ; CJK UNIFIED IDEOGRAPH
       (?b . "0x514A") ; CJK UNIFIED IDEOGRAPH
       (?c . "0x5164") ; CJK UNIFIED IDEOGRAPH
       (?d . "0x519D") ; CJK UNIFIED IDEOGRAPH
       (?e . "0x51BE") ; CJK UNIFIED IDEOGRAPH
       (?f . "0x51EC") ; CJK UNIFIED IDEOGRAPH
       (?g . "0x5215") ; CJK UNIFIED IDEOGRAPH
       (?h . "0x529C") ; CJK UNIFIED IDEOGRAPH
       (?i . "0x52A6") ; CJK UNIFIED IDEOGRAPH
       (?j . "0x52C0") ; CJK UNIFIED IDEOGRAPH
       (?k . "0x52DB") ; CJK UNIFIED IDEOGRAPH
       (?l . "0x5300") ; CJK UNIFIED IDEOGRAPH
       (?m . "0x5307") ; CJK UNIFIED IDEOGRAPH
       (?n . "0x5324") ; CJK UNIFIED IDEOGRAPH
       (?o . "0x5372") ; CJK UNIFIED IDEOGRAPH
       (?p . "0x5393") ; CJK UNIFIED IDEOGRAPH
       (?q . "0x53B2") ; CJK UNIFIED IDEOGRAPH
       (?r . "0x53DD") ; CJK UNIFIED IDEOGRAPH
       (?s . "0xFA0E") ; CJK COMPATIBILITY IDEOGRAPH
       (?t . "0x549C") ; CJK UNIFIED IDEOGRAPH
       (?u . "0x548A") ; CJK UNIFIED IDEOGRAPH
       (?v . "0x54A9") ; CJK UNIFIED IDEOGRAPH
       (?w . "0x54FF") ; CJK UNIFIED IDEOGRAPH
       (?x . "0x5586") ; CJK UNIFIED IDEOGRAPH
       (?y . "0x5759") ; CJK UNIFIED IDEOGRAPH
       (?z . "0x5765") ; CJK UNIFIED IDEOGRAPH
       (?{ . "0x57AC") ; CJK UNIFIED IDEOGRAPH
       (?| . "0x57C8") ; CJK UNIFIED IDEOGRAPH
       (?} . "0x57C7") ; CJK UNIFIED IDEOGRAPH
       (?~ . "0xFA0F") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0xFA10") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x589E") ; CJK UNIFIED IDEOGRAPH
       (? . "0x58B2") ; CJK UNIFIED IDEOGRAPH
       (? . "0x590B") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5953") ; CJK UNIFIED IDEOGRAPH
       (? . "0x595B") ; CJK UNIFIED IDEOGRAPH
       (? . "0x595D") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5963") ; CJK UNIFIED IDEOGRAPH
       (? . "0x59A4") ; CJK UNIFIED IDEOGRAPH
       (? . "0x59BA") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5B56") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5BC0") ; CJK UNIFIED IDEOGRAPH
       (? . "0x752F") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5BD8") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5BEC") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5C1E") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5CA6") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5CBA") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5CF5") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5D27") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5D53") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA11") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x5D42") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5D6D") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5DB8") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5DB9") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5DD0") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5F21") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5F34") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5F67") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5FB7") ; CJK UNIFIED IDEOGRAPH
       (? . "0x5FDE") ; CJK UNIFIED IDEOGRAPH
       (? . "0x605D") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6085") ; CJK UNIFIED IDEOGRAPH
       (? . "0x608A") ; CJK UNIFIED IDEOGRAPH
       (? . "0x60DE") ; CJK UNIFIED IDEOGRAPH
       (? . "0x60D5") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6120") ; CJK UNIFIED IDEOGRAPH
       (? . "0x60F2") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6111") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6137") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6130") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6198") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6213") ; CJK UNIFIED IDEOGRAPH
       (? . "0x62A6") ; CJK UNIFIED IDEOGRAPH
       (? . "0x63F5") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6460") ; CJK UNIFIED IDEOGRAPH
       (? . "0x649D") ; CJK UNIFIED IDEOGRAPH
       (? . "0x64CE") ; CJK UNIFIED IDEOGRAPH
       (? . "0x654E") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6600") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6615") ; CJK UNIFIED IDEOGRAPH
       (? . "0x663B") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6609") ; CJK UNIFIED IDEOGRAPH
       (? . "0x662E") ; CJK UNIFIED IDEOGRAPH
       (? . "0x661E") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6624") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6665") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6657") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6659") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA12") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x6673") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6699") ; CJK UNIFIED IDEOGRAPH
       (? . "0x66A0") ; CJK UNIFIED IDEOGRAPH
       (? . "0x66B2") ; CJK UNIFIED IDEOGRAPH
       (? . "0x66BF") ; CJK UNIFIED IDEOGRAPH
       (? . "0x66FA") ; CJK UNIFIED IDEOGRAPH
       (? . "0x670E") ; CJK UNIFIED IDEOGRAPH
       (? . "0xF929") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x6766") ; CJK UNIFIED IDEOGRAPH
       (? . "0x67BB") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6852") ; CJK UNIFIED IDEOGRAPH
       (? . "0x67C0") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6801") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6844") ; CJK UNIFIED IDEOGRAPH
       (? . "0x68CF") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA13") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x6968") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA14") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x6998") ; CJK UNIFIED IDEOGRAPH
       (? . "0x69E2") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6A30") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6A6B") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6A46") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6A73") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6A7E") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6AE2") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6AE4") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6BD6") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6C3F") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6C5C") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6C86") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6C6F") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6CDA") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6D04") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6D87") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6D6F") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6D96") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6DAC") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6DCF") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6DF8") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6DF2") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6DFC") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6E39") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6E5C") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6E27") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6E3C") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6EBF") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6F88") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6FB5") ; CJK UNIFIED IDEOGRAPH
       (? . "0x6FF5") ; CJK UNIFIED IDEOGRAPH
       (? . "0x7005") ; CJK UNIFIED IDEOGRAPH
       (? . "0x7007") ; CJK UNIFIED IDEOGRAPH
       (? . "0x7028") ; CJK UNIFIED IDEOGRAPH
       (? . "0x7085") ; CJK UNIFIED IDEOGRAPH
       (? . "0x70AB") ; CJK UNIFIED IDEOGRAPH
       (? . "0x710F") ; CJK UNIFIED IDEOGRAPH
       (? . "0x7104") ; CJK UNIFIED IDEOGRAPH
       (? . "0x715C") ; CJK UNIFIED IDEOGRAPH
       (? . "0x7146") ; CJK UNIFIED IDEOGRAPH
       (? . "0x7147") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA15") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x71C1") ; CJK UNIFIED IDEOGRAPH
       (? . "0x71FE") ; CJK UNIFIED IDEOGRAPH
       (? . "0x72B1") ; CJK UNIFIED IDEOGRAPH
       (?@ . "0x72BE") ; CJK UNIFIED IDEOGRAPH
       (?A . "0x7324") ; CJK UNIFIED IDEOGRAPH
       (?B . "0xFA16") ; CJK COMPATIBILITY IDEOGRAPH
       (?C . "0x7377") ; CJK UNIFIED IDEOGRAPH
       (?D . "0x73BD") ; CJK UNIFIED IDEOGRAPH
       (?E . "0x73C9") ; CJK UNIFIED IDEOGRAPH
       (?F . "0x73D6") ; CJK UNIFIED IDEOGRAPH
       (?G . "0x73E3") ; CJK UNIFIED IDEOGRAPH
       (?H . "0x73D2") ; CJK UNIFIED IDEOGRAPH
       (?I . "0x7407") ; CJK UNIFIED IDEOGRAPH
       (?J . "0x73F5") ; CJK UNIFIED IDEOGRAPH
       (?K . "0x7426") ; CJK UNIFIED IDEOGRAPH
       (?L . "0x742A") ; CJK UNIFIED IDEOGRAPH
       (?M . "0x7429") ; CJK UNIFIED IDEOGRAPH
       (?N . "0x742E") ; CJK UNIFIED IDEOGRAPH
       (?O . "0x7462") ; CJK UNIFIED IDEOGRAPH
       (?P . "0x7489") ; CJK UNIFIED IDEOGRAPH
       (?Q . "0x749F") ; CJK UNIFIED IDEOGRAPH
       (?R . "0x7501") ; CJK UNIFIED IDEOGRAPH
       (?S . "0x756F") ; CJK UNIFIED IDEOGRAPH
       (?T . "0x7682") ; CJK UNIFIED IDEOGRAPH
       (?U . "0x769C") ; CJK UNIFIED IDEOGRAPH
       (?V . "0x769E") ; CJK UNIFIED IDEOGRAPH
       (?W . "0x769B") ; CJK UNIFIED IDEOGRAPH
       (?X . "0x76A6") ; CJK UNIFIED IDEOGRAPH
       (?Y . "0xFA17") ; CJK COMPATIBILITY IDEOGRAPH
       (?Z . "0x7746") ; CJK UNIFIED IDEOGRAPH
       (?[ . "0x52AF") ; CJK UNIFIED IDEOGRAPH
       (?\ . "0x7821") ; CJK UNIFIED IDEOGRAPH
       (?] . "0x784E") ; CJK UNIFIED IDEOGRAPH
       (?^ . "0x7864") ; CJK UNIFIED IDEOGRAPH
       (?_ . "0x787A") ; CJK UNIFIED IDEOGRAPH
       (?` . "0x7930") ; CJK UNIFIED IDEOGRAPH
       (?a . "0xFA18") ; CJK COMPATIBILITY IDEOGRAPH
       (?b . "0xFA19") ; CJK COMPATIBILITY IDEOGRAPH
       (?c . "0xFA1A") ; CJK COMPATIBILITY IDEOGRAPH
       (?d . "0x7994") ; CJK UNIFIED IDEOGRAPH
       (?e . "0xFA1B") ; CJK COMPATIBILITY IDEOGRAPH
       (?f . "0x799B") ; CJK UNIFIED IDEOGRAPH
       (?g . "0x7AD1") ; CJK UNIFIED IDEOGRAPH
       (?h . "0x7AE7") ; CJK UNIFIED IDEOGRAPH
       (?i . "0xFA1C") ; CJK COMPATIBILITY IDEOGRAPH
       (?j . "0x7AEB") ; CJK UNIFIED IDEOGRAPH
       (?k . "0x7B9E") ; CJK UNIFIED IDEOGRAPH
       (?l . "0xFA1D") ; CJK COMPATIBILITY IDEOGRAPH
       (?m . "0x7D48") ; CJK UNIFIED IDEOGRAPH
       (?n . "0x7D5C") ; CJK UNIFIED IDEOGRAPH
       (?o . "0x7DB7") ; CJK UNIFIED IDEOGRAPH
       (?p . "0x7DA0") ; CJK UNIFIED IDEOGRAPH
       (?q . "0x7DD6") ; CJK UNIFIED IDEOGRAPH
       (?r . "0x7E52") ; CJK UNIFIED IDEOGRAPH
       (?s . "0x7F47") ; CJK UNIFIED IDEOGRAPH
       (?t . "0x7FA1") ; CJK UNIFIED IDEOGRAPH
       (?u . "0xFA1E") ; CJK COMPATIBILITY IDEOGRAPH
       (?v . "0x8301") ; CJK UNIFIED IDEOGRAPH
       (?w . "0x8362") ; CJK UNIFIED IDEOGRAPH
       (?x . "0x837F") ; CJK UNIFIED IDEOGRAPH
       (?y . "0x83C7") ; CJK UNIFIED IDEOGRAPH
       (?z . "0x83F6") ; CJK UNIFIED IDEOGRAPH
       (?{ . "0x8448") ; CJK UNIFIED IDEOGRAPH
       (?| . "0x84B4") ; CJK UNIFIED IDEOGRAPH
       (?} . "0x8553") ; CJK UNIFIED IDEOGRAPH
       (?~ . "0x8559") ; CJK UNIFIED IDEOGRAPH
       (? . "0x856B") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA1F") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x85B0") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA20") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0xFA21") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x8807") ; CJK UNIFIED IDEOGRAPH
       (? . "0x88F5") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8A12") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8A37") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8A79") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8AA7") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8ABE") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8ADF") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA22") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x8AF6") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8B53") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8B7F") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8CF0") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8CF4") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8D12") ; CJK UNIFIED IDEOGRAPH
       (? . "0x8D76") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA23") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x8ECF") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA24") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0xFA25") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x9067") ; CJK UNIFIED IDEOGRAPH
       (? . "0x90DE") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA26") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x9115") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9127") ; CJK UNIFIED IDEOGRAPH
       (? . "0x91DA") ; CJK UNIFIED IDEOGRAPH
       (? . "0x91D7") ; CJK UNIFIED IDEOGRAPH
       (? . "0x91DE") ; CJK UNIFIED IDEOGRAPH
       (? . "0x91ED") ; CJK UNIFIED IDEOGRAPH
       (? . "0x91EE") ; CJK UNIFIED IDEOGRAPH
       (? . "0x91E4") ; CJK UNIFIED IDEOGRAPH
       (? . "0x91E5") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9206") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9210") ; CJK UNIFIED IDEOGRAPH
       (? . "0x920A") ; CJK UNIFIED IDEOGRAPH
       (? . "0x923A") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9240") ; CJK UNIFIED IDEOGRAPH
       (? . "0x923C") ; CJK UNIFIED IDEOGRAPH
       (? . "0x924E") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9259") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9251") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9239") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9267") ; CJK UNIFIED IDEOGRAPH
       (? . "0x92A7") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9277") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9278") ; CJK UNIFIED IDEOGRAPH
       (? . "0x92E7") ; CJK UNIFIED IDEOGRAPH
       (? . "0x92D7") ; CJK UNIFIED IDEOGRAPH
       (? . "0x92D9") ; CJK UNIFIED IDEOGRAPH
       (? . "0x92D0") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA27") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x92D5") ; CJK UNIFIED IDEOGRAPH
       (? . "0x92E0") ; CJK UNIFIED IDEOGRAPH
       (? . "0x92D3") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9325") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9321") ; CJK UNIFIED IDEOGRAPH
       (? . "0x92FB") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA28") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x931E") ; CJK UNIFIED IDEOGRAPH
       (? . "0x92FF") ; CJK UNIFIED IDEOGRAPH
       (? . "0x931D") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9302") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9370") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9357") ; CJK UNIFIED IDEOGRAPH
       (? . "0x93A4") ; CJK UNIFIED IDEOGRAPH
       (? . "0x93C6") ; CJK UNIFIED IDEOGRAPH
       (? . "0x93DE") ; CJK UNIFIED IDEOGRAPH
       (? . "0x93F8") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9431") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9445") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9448") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9592") ; CJK UNIFIED IDEOGRAPH
       (? . "0xF9DC") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0xFA29") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x969D") ; CJK UNIFIED IDEOGRAPH
       (? . "0x96AF") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9733") ; CJK UNIFIED IDEOGRAPH
       (? . "0x973B") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9743") ; CJK UNIFIED IDEOGRAPH
       (? . "0x974D") ; CJK UNIFIED IDEOGRAPH
       (? . "0x974F") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9751") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9755") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9857") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9865") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA2A") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0xFA2B") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x9927") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA2C") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x999E") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9A4E") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9AD9") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9ADC") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9B75") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9B72") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9B8F") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9BB1") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9BBB") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9C00") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9D70") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9D6B") ; CJK UNIFIED IDEOGRAPH
       (? . "0xFA2D") ; CJK COMPATIBILITY IDEOGRAPH
       (? . "0x9E19") ; CJK UNIFIED IDEOGRAPH
       (? . "0x9ED1") ; CJK UNIFIED IDEOGRAPH
       (? . "0x2170") ; SMALL ROMAN NUMERAL ONE
       (? . "0x2171") ; SMALL ROMAN NUMERAL TWO
       (? . "0x2172") ; SMALL ROMAN NUMERAL THREE
       (? . "0x2173") ; SMALL ROMAN NUMERAL FOUR
       (? . "0x2174") ; SMALL ROMAN NUMERAL FIVE
       (? . "0x2175") ; SMALL ROMAN NUMERAL SIX
       (? . "0x2176") ; SMALL ROMAN NUMERAL SEVEN
       (? . "0x2177") ; SMALL ROMAN NUMERAL EIGHT
       (? . "0x2178") ; SMALL ROMAN NUMERAL NINE
       (? . "0x2179") ; SMALL ROMAN NUMERAL TEN
       (? . "0xFFE2") ; FULLWIDTH NOT SIGN
       (? . "0xFFE4") ; FULLWIDTH BROKEN BAR
       (? . "0xFF07") ; FULLWIDTH APOSTROPHE
       (? . "0xFF02") ; FULLWIDTH QUOTATION MARK
      ))))

(tae-declare-translation
 'unicode-translation-rule-for-jisx0208ex
 unicode-assoc-for-jisx0208ex)

(provide 'ujisx0208ex)
;;; ujisx0208ex.el ends here
