;;; un-jisx0208ex.el --- translation rule for JIS X 0208 Extention and Unicode

;; Copyright (C) 2004  ARISAWA Akihiro

;; Author: ARISAWA Akihiro <ari@mbf.sphere.ne.jp>
;; Keywords: mule, multilingual, character set, coding-system,
;;           ISO10646, Unicode, JIS X 0208, NEC special characters,
;;           NEC selection of IBM extension characters

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Code:

(require 'tae)
(require 'un-define)

(eval-when-compile
  (require 'un-trbase)
  (mucs-require-data 'ujisx0208ex)
  (mucs-require-data 'ujisx0212ex))

(eval-and-compile
  (defun un-jisx0208ex-add-translation ()
    (let ((tr (copy-sequence (tae-get-translation-definition
			       'unicode-basic-translation-rule)))
	  (l '((unicode-translation-rule-for-jisx0208ex	. japanese-jisx0208)
	       (unicode-translation-rule-for-jisx0212ex . japanese-jisx0212)))
	  ins)
      (while l
	(when (setq ins (memq (unicode-get-translation-rule-from-charset
			       (cdar l)) tr))
	  (setcdr ins (cons (caar l) (cdr ins))))
	(setq l (cdr l)))
      tr)))

(mucs-define-package
 un-jisx0208ex
 (mucs-import-package un-define)
 (tae-embed-for-dynamic-modification
  'unicode-basic-translation-rule
  (un-jisx0208ex-add-translation)))

(tae-modify-translation
 'unicode-basic-translation-rule
 (un-jisx0208ex-add-translation))

(provide 'un-jisx0208ex)
;;; un-jisx0208ex.el ends here
