/*
 * Copyright 2004-2006 Luc Verhaegen.
 * Copyright 2004-2005 The Unichrome Project  [unichrome.sf.net]
 * Copyright 1998-2003 VIA Technologies, Inc. All Rights Reserved.
 * Copyright 2001-2003 S3 Graphics, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sub license,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef _VIA_DRIVER_H_
#define _VIA_DRIVER_H_ 1

#include "vgaHW.h"
#include "xf86.h"
#include "xf86Resources.h"

#include "xf86Pci.h"
#include "xf86PciInfo.h"
#include "xf86_OSproc.h"
#include "compiler.h"
#include "xf86Cursor.h"
#include "mipointer.h"
#include "micmap.h"

#define USE_FB
#ifdef USE_FB
#include "fb.h"
#else
#include "cfb.h"
#include "cfb16.h"
#include "cfb32.h"
#endif

#include "xf86cmap.h"
#include "xaa.h"

#include "via_regs.h"
#include "via_memory.h"

#ifdef XvExtension
#include "via_video.h"
#endif

#ifdef XF86DRI
#define _XF86DRI_SERVER_
#include "sarea.h"
#include "dri.h"
#include "GL/glxint.h"
#include "via_dri.h"
#endif

#define DRIVER_NAME     "via"
#define VERSION_MAJOR   0
#define VERSION_MINOR   2
#define PATCHLEVEL      6
#define VIA_VERSION     ((VERSION_MAJOR<<24) | (VERSION_MINOR<<16) | PATCHLEVEL)

#define VIA_MAX_ACCEL_X         (2047)
#define VIA_MAX_ACCEL_Y         (2047)
#ifdef X_USE_LINEARFB
#define VIA_PIXMAP_CACHE_SIZE   (4 * (VIA_MAX_ACCEL_X + 1) * (VIA_MAX_ACCEL_Y +1))
#else
#define VIA_PIXMAP_CACHE_SIZE   (256 * 1024)
#endif /* X_USE_LINEARFB */
#define VIA_VQ_SIZE             (256 * 1024)
#define VIA_CBUFFERSIZE         512

/* For pVia->ActiveDevice */
#define VIA_DEVICE_NONE  0x00
#define VIA_DEVICE_CRT   0x01
#define VIA_DEVICE_LCD   0x02
#define VIA_DEVICE_TV    0x04
#define VIA_DEVICE_DVI   0x08

/* For pVia->MemClk */
#define VIA_MEM_DDR200  0x00
#define VIA_MEM_DDR266  0x01
#define VIA_MEM_DDR333  0x02
#define VIA_MEM_DDR400  0x03
#define VIA_MEM_END     0x04
#define VIA_MEM_NONE    0xFF

/* For Scratch->TVStandard */
#define TVSTANDARD_NONE  0x00
#define TVSTANDARD_NTSC  0x01
#define TVSTANDARD_PAL   0x02

struct ViaScratch {
    int  VideoRam;
    CARD8  MemClk;
    CARD8  ActiveDevice;
    CARD8  PanelSize;
    CARD8  TVStandard;
};

typedef struct {
    CARD8   SR08, SR0A, SR0F;

    /*   extended Sequencer registers */
    CARD8   SR10, SR11, SR12, SR13,SR14,SR15,SR16;
    CARD8   SR17, SR18, SR19, SR1A,SR1B,SR1C,SR1D,SR1E;
    CARD8   SR1F, SR20, SR21, SR22,SR23,SR24,SR25,SR26;
    CARD8   SR27, SR28, SR29, SR2A,SR2B,SR2C,SR2D,SR2E;
    CARD8   SR2F, SR30, SR31, SR32,SR33,SR34,SR40,SR41;
    CARD8   SR42, SR43, SR44, SR45,SR46,SR47;

    /*   extended CRTC registers */
    CARD8   CR13, CR30, CR31, CR32, CR33, CR34, CR35, CR36;
    CARD8   CR37, CR38, CR39, CR3A, CR40, CR41, CR42, CR43;
    CARD8   CR44, CR45, CR46, CR47, CR48, CR49, CR4A;
    CARD8   CRTCRegs[68];

    CARD8   CR97, CR99;
/*    CARD8   LCDRegs[0x40];*/
} VIARegRec, *VIARegPtr;

/*
 * varables that need to be shared among different screens.
 */
typedef struct {
    Bool b3DRegsInitialized;
} ViaSharedRec, *ViaSharedPtr;

typedef struct _twodContext {
    CARD32 mode;
} ViaTwodContext;

typedef struct{
    unsigned curPos;
    CARD32 buffer[VIA_CBUFFERSIZE];
    int status;
} ViaCBuffer;

typedef struct _VIA {
    int			scrnIndex;
    VIARegRec           SavedReg;
    int                 Bpp, Bpl;
    unsigned            PlaneMask;

    unsigned long       videoRambytes;
    int                 videoRamKbytes;
    int                 FBFreeStart;
    int                 FBFreeEnd;
    int                 VQStart;
    int                 VQEnd;

    /* These are physical addresses. */
    unsigned long       FrameBufferBase;
    unsigned long       MmioBase;

    /* These are linear addresses. */
    unsigned char*      MapBase;
    unsigned char*      BltBase;
    unsigned char*      MapBaseDense;
    unsigned char*      FBBase;

    CARD8               MemClk;
    CARD32              Bandwidth; /* available memory bandwidth */

#ifndef X_USE_LINEARFB
    /* memory "management" */
    struct ViaMem *Mem[VIA_MEM_SLOTS];
#endif

    /* Here are all the Options */
    Bool                VQEnable;
    Bool                pci_burst;
    Bool                NoPCIRetry;
    Bool                hwcursor;
    Bool                NoAccel;
    Bool                shadowFB;
    int                 rotate;

    CloseScreenProcPtr  CloseScreen;
    pciVideoPtr         PciInfo;
    PCITAG              PciTag;
    int                 Chipset;
    int                 ChipId;
    int                 ChipRev;
    int                 EntityIndex;

    /* Support for shadowFB and rotation */
    unsigned char*      ShadowPtr;
    int                 ShadowPitch;
    void                (*PointerMoved)(int index, int x, int y);

    /* Support for XAA acceleration */
    XAAInfoRecPtr       AccelInfoRec;
    xRectangle          Rect;
    CARD32              SavedCmd;
    CARD32              SavedFgColor;
    CARD32              SavedBgColor;
    CARD32              SavedPattern0;
    CARD32              SavedPattern1;
    CARD32              SavedPatternAddr;
    int                 justSetup;
    ViaTwodContext      td;
    ViaCBuffer          cBuf;

    struct ViaScratch   *Scratch;
    struct ViaCardId    *Id;

    /* ModeSetting and Output devices */
    Bool  ClockSlave; /* is the unichrome the master or the slave? */
    CARD32  PanelClock; /* need to clean up that crap */
    MonPtr              Monitor;
    struct ViaOutput    *Outputs;

    /* Support for DGA */
    int                 numDGAModes;
    DGAModePtr          DGAModes;
    Bool                DGAactive;
    int                 DGAViewportStatus;
    int			DGAOldDisplayWidth;
    int			DGAOldBitsPerPixel;
    int			DGAOldDepth;

    /* I2C & DDC */
    I2CBusPtr           pI2CBus1;    
    I2CBusPtr           pI2CBus2;    
    I2CBusPtr           pI2CBus3;
    xf86MonPtr          DDC1;

    /* MHS */
    Bool                IsSecondary;
    Bool                HasSecondary;
    Bool                SAMM;

#ifdef XF86DRI
    Bool		directRenderingEnabled;
    DRIInfoPtr		pDRIInfo;
    int 		drmFD;
    CARD32              drmVersion; /* major << 16 | minor << 8 | patch */
    int 		numVisualConfigs;
    __GLXvisualConfig* 	pVisualConfigs;
    VIAConfigPrivPtr 	pVisualConfigsPriv;
    drm_handle_t 	agpHandle;
    drm_handle_t 	registerHandle;
    unsigned long 	agpAddr;
    drmAddress          agpMappedAddr;
    unsigned char 	*agpBase;
    unsigned int 	agpSize;
    Bool 		IsPCI;
    Bool 		drixinerama;
#endif
    Bool		DRIIrqEnable;
    Bool                agpEnable;
    Bool                dma2d;
    Bool                UseDMACopy;

    CARD8               ActiveDevice;	/* Option */

    /* cursor */
    xf86CursorInfoPtr   Cursor;
    int                 CursorAddress;
    int                 CursorSize;
    unsigned char       *CursorImage;
    CARD32              CursorFG;
    CARD32              CursorBG;
    CARD32              CursorMC;

    /* Video */
#ifdef _VIA_VIDEO_H_
    struct ViaSwov      Swov[1];
#endif
    
    ViaSharedPtr	sharedData;

    Bool  PrintVGARegs;
    Bool  PrintTVRegs;
    Bool  PrintSwovRegs;
    Bool  I2CScan;
} VIARec, *VIAPtr;

#define VIAPTR(p) ((VIAPtr)((p)->driverPrivate))

typedef struct
{
    Bool IsDRIEnabled;

    Bool HasSecondary;
    Bool BypassSecondary;
    /*These two registers are used to make sure the CRTC2 is
      retored before CRTC_EXT, otherwise it could lead to blank screen.*/
    Bool IsSecondaryRestored;
    Bool RestorePrimary;

    ScrnInfoPtr pSecondaryScrn;
    ScrnInfoPtr pPrimaryScrn;
} VIAEntRec, *VIAEntPtr;

/* Prototypes. */
#ifdef XF86DRI
void VIAInitialize3DEngine(ScrnInfoPtr pScrn);
#endif 

/* In via_cursor.c. */
Bool ViaCursorInit(ScrnInfoPtr pScrn, ScreenPtr pScreen);
void ViaCursorStore(ScrnInfoPtr pScrn);
void ViaCursorRestore(ScrnInfoPtr pScrn);

/* In via_accel.c. */
Bool VIAInitAccel(ScrnInfoPtr pScrn, ScreenPtr pScreen);
void VIAInitialize2DEngine(ScrnInfoPtr);
void VIAAccelSync(ScrnInfoPtr);
void ViaVQEnable(ScrnInfoPtr pScrn);
void ViaVQDisable(ScrnInfoPtr pScrn);

/* In via_shadow.c */
void ViaShadowFBInit(ScrnInfoPtr pScrn, ScreenPtr pScreen);

/* In via_dga.c */
Bool VIADGAInit(ScrnInfoPtr pScrn, ScreenPtr pScreen);

/*In via_video.c*/
#ifdef XvExtension
void ViaVideoInit(ScrnInfoPtr pScrn, ScreenPtr pScreen);
#endif

/* via_i2c.c */
void ViaI2CInit(ScrnInfoPtr pScrn);

/* via_dri.c */
#ifdef XF86DRI
Bool VIADRIScreenInit(ScrnInfoPtr pScrn, ScreenPtr pScreen);
void VIADRICloseScreen(ScrnInfoPtr pScrn, ScreenPtr pScreen);
Bool VIADRIFinishScreenInit(ScrnInfoPtr pScrn, ScreenPtr pScreen);
void VIADRIRingBufferCleanup(ScrnInfoPtr pScrn);
Bool VIADRIRingBufferInit(ScrnInfoPtr pScrn);
#endif /* XF86DRI */

/* via_bandwidth.c */
void ViaSetPrimaryFIFO(ScrnInfoPtr pScrn, DisplayModePtr mode);
void ViaSetSecondaryFIFO(ScrnInfoPtr pScrn, DisplayModePtr mode);
void ViaDisablePrimaryFIFO(ScrnInfoPtr pScrn);

/* Extra debug verbosity */

/* __func__ is really nice, but not universal */
#if !defined(__GNUC__) && !defined(C99)
#define __func__ "unknown"
#endif

#define LOG_DEBUG 7
#define LOG_DEBUG_XV LOG_DEBUG + 1

void ViaDebug(int scrnIndex, const char *format, ...);
#define VIAFUNC(scrnIndex) (ViaDebug(scrnIndex, "FUNCTION: %s\n", __func__))

#endif /* _VIA_DRIVER_H_ */
