/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _NEG_OPTIONS_INTERNAL
#include "neg_options.h"

static int displayPrivateIndex;

static CompMetadata negOptionsMetadata;

static CompPluginVTable *negPluginVTable = NULL;
CompPluginVTable negOptionsVTable;

#define GET_NEG_OPTIONS_DISPLAY(d) \
        ((NegOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define NEG_OPTIONS_DISPLAY(d) \
        NegOptionsDisplay *od = GET_NEG_OPTIONS_DISPLAY (d)

#define GET_NEG_OPTIONS_SCREEN(s, od) \
        ((NegOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define NEG_OPTIONS_SCREEN(s) \
        NegOptionsScreen *os = GET_NEG_OPTIONS_SCREEN (s, GET_NEG_OPTIONS_DISPLAY (s->display))

typedef struct _NegOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[NegDisplayOptionNum];
    negDisplayOptionChangeNotifyProc notify[NegDisplayOptionNum];
} NegOptionsDisplay;

typedef struct _NegOptionsScreen
{
    CompOption opt[NegScreenOptionNum];
    negScreenOptionChangeNotifyProc notify[NegScreenOptionNum];
} NegOptionsScreen;

CompAction * negGetWindowToggle (CompDisplay *d)
{
    NEG_OPTIONS_DISPLAY(d);
    return &od->opt[NegDisplayOptionWindowToggle].value.action;
}

void negSetWindowToggleInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    NEG_OPTIONS_DISPLAY(d);
    od->opt[NegDisplayOptionWindowToggle].value.action.initiate = init;
}

void negSetWindowToggleTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    NEG_OPTIONS_DISPLAY(d);
    od->opt[NegDisplayOptionWindowToggle].value.action.terminate = term;
}

CompOption * negGetWindowToggleOption (CompDisplay *d)
{
    NEG_OPTIONS_DISPLAY(d);
    return &od->opt[NegDisplayOptionWindowToggle];
}

void negSetWindowToggleNotify (CompDisplay *d, negDisplayOptionChangeNotifyProc notify)
{
    NEG_OPTIONS_DISPLAY(d);
    od->notify[NegDisplayOptionWindowToggle] = notify;
}

CompAction * negGetScreenToggle (CompDisplay *d)
{
    NEG_OPTIONS_DISPLAY(d);
    return &od->opt[NegDisplayOptionScreenToggle].value.action;
}

void negSetScreenToggleInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    NEG_OPTIONS_DISPLAY(d);
    od->opt[NegDisplayOptionScreenToggle].value.action.initiate = init;
}

void negSetScreenToggleTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    NEG_OPTIONS_DISPLAY(d);
    od->opt[NegDisplayOptionScreenToggle].value.action.terminate = term;
}

CompOption * negGetScreenToggleOption (CompDisplay *d)
{
    NEG_OPTIONS_DISPLAY(d);
    return &od->opt[NegDisplayOptionScreenToggle];
}

void negSetScreenToggleNotify (CompDisplay *d, negDisplayOptionChangeNotifyProc notify)
{
    NEG_OPTIONS_DISPLAY(d);
    od->notify[NegDisplayOptionScreenToggle] = notify;
}

CompMatch * negGetNegMatch (CompScreen *s)
{
    NEG_OPTIONS_SCREEN(s);
    return &os->opt[NegScreenOptionNegMatch].value.match;
}

CompOption * negGetNegMatchOption (CompScreen *s)
{
    NEG_OPTIONS_SCREEN(s);
    return &os->opt[NegScreenOptionNegMatch];
}

void negSetNegMatchNotify (CompScreen *s, negScreenOptionChangeNotifyProc notify)
{
    NEG_OPTIONS_SCREEN(s);
    os->notify[NegScreenOptionNegMatch] = notify;
}

CompMatch * negGetExcludeMatch (CompScreen *s)
{
    NEG_OPTIONS_SCREEN(s);
    return &os->opt[NegScreenOptionExcludeMatch].value.match;
}

CompOption * negGetExcludeMatchOption (CompScreen *s)
{
    NEG_OPTIONS_SCREEN(s);
    return &os->opt[NegScreenOptionExcludeMatch];
}

void negSetExcludeMatchNotify (CompScreen *s, negScreenOptionChangeNotifyProc notify)
{
    NEG_OPTIONS_SCREEN(s);
    os->notify[NegScreenOptionExcludeMatch] = notify;
}

CompOption * negGetDisplayOption (CompDisplay *d, NegDisplayOptions num)
{
    NEG_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

CompOption * negGetScreenOption (CompScreen *s, NegScreenOptions num)
{
    NEG_OPTIONS_SCREEN(s);
    return &os->opt[num];
}

static const CompMetadataOptionInfo negOptionsDisplayOptionInfo[] = {
    { "window_toggle", "action", 0, 0, 0 },
    { "screen_toggle", "action", 0, 0, 0 },
};

static Bool negOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    NEG_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, NegDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case NegDisplayOptionWindowToggle:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[NegDisplayOptionWindowToggle])
                (*od->notify[NegDisplayOptionWindowToggle]) (d, o, NegDisplayOptionWindowToggle);
            return TRUE;
        }
        break;
     case NegDisplayOptionScreenToggle:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[NegDisplayOptionScreenToggle])
                (*od->notify[NegDisplayOptionScreenToggle]) (d, o, NegDisplayOptionScreenToggle);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * negOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    NEG_OPTIONS_DISPLAY(d);
    *count = NegDisplayOptionNum;
    return od->opt;
}

static const CompMetadataOptionInfo negOptionsScreenOptionInfo[] = {
    { "neg_match", "match", 0, 0, 0 },
    { "exclude_match", "match", 0, 0, 0 },
};

static Bool negOptionsSetScreenOption (CompPlugin *plugin, CompScreen *s, char *name, CompOptionValue *value)
{
    NEG_OPTIONS_SCREEN(s);
    CompOption *o;
    int        index;

    o = compFindOption (os->opt, NegScreenOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case NegScreenOptionNegMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[NegScreenOptionNegMatch])
                (*os->notify[NegScreenOptionNegMatch]) (s, o, NegScreenOptionNegMatch);
            return TRUE;
        }
        break;
     case NegScreenOptionExcludeMatch:
        if (compSetScreenOption (s, o, value))
        {
            if (os->notify[NegScreenOptionExcludeMatch])
                (*os->notify[NegScreenOptionExcludeMatch]) (s, o, NegScreenOptionExcludeMatch);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * negOptionsGetScreenOptions (CompPlugin *plugin, CompScreen *s, int *count)
{
    NEG_OPTIONS_SCREEN(s);
    *count = NegScreenOptionNum;
    return os->opt;
}

static Bool negOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    NegOptionsScreen *os;
    
    NEG_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(NegOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

    if (!compInitScreenOptionsFromMetadata (s, &negOptionsMetadata, negOptionsScreenOptionInfo, os->opt, NegScreenOptionNum))
    {
        free (os);
        return FALSE;
    }
    if (negPluginVTable && negPluginVTable->initScreen)
        return negPluginVTable->initScreen (p, s);
    return TRUE;
}

static void negOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (negPluginVTable && negPluginVTable->finiScreen)
        return negPluginVTable->finiScreen (p, s);

    NEG_OPTIONS_SCREEN (s);


    compFiniScreenOptions (s, os->opt, NegScreenOptionNum);

    free (os);
}

static Bool negOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    NegOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(NegOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &negOptionsMetadata, negOptionsDisplayOptionInfo, od->opt, NegDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (negPluginVTable && negPluginVTable->initDisplay)
        return negPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void negOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (negPluginVTable && negPluginVTable->finiDisplay)
        return negPluginVTable->finiDisplay (p, d);

    NEG_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, NegDisplayOptionNum);

    free (od);
}

static Bool negOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&negOptionsMetadata, "neg",negOptionsDisplayOptionInfo, NegDisplayOptionNum, negOptionsScreenOptionInfo, NegScreenOptionNum))
        return FALSE;

    compAddMetadataFromFile (&negOptionsMetadata, "neg");
    if (negPluginVTable && negPluginVTable->init)
        return negPluginVTable->init (p);
    return TRUE;
}

static void negOptionsFini (CompPlugin *p)
{
    if (negPluginVTable && negPluginVTable->fini)
        return negPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&negOptionsMetadata);
}

static CompMetadata *
negOptionsGetMetadata (CompPlugin *plugin)
{
    return &negOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!negPluginVTable)
    {
        negPluginVTable = negOptionsGetCompPluginInfo ();
        memcpy(&negOptionsVTable, negPluginVTable, sizeof(CompPluginVTable));
        negOptionsVTable.getMetadata = negOptionsGetMetadata;
        negOptionsVTable.init = negOptionsInit;
        negOptionsVTable.fini = negOptionsFini;
        negOptionsVTable.initDisplay = negOptionsInitDisplay;
        negOptionsVTable.finiDisplay = negOptionsFiniDisplay;
        negOptionsVTable.initScreen = negOptionsInitScreen;
        negOptionsVTable.finiScreen = negOptionsFiniScreen;
        negOptionsVTable.getDisplayOptions = negOptionsGetDisplayOptions;
	negOptionsVTable.setDisplayOption = negOptionsSetDisplayOption;
	negOptionsVTable.getScreenOptions = negOptionsGetScreenOptions;
	negOptionsVTable.setScreenOption = negOptionsSetScreenOption;
	
    }
    return &negOptionsVTable;
}

