/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <compiz.h>

#define _SNOW_OPTIONS_INTERNAL
#include "snow_options.h"

static int displayPrivateIndex;

static CompMetadata snowOptionsMetadata;

static CompPluginVTable *snowPluginVTable = NULL;
CompPluginVTable snowOptionsVTable;

#define GET_SNOW_OPTIONS_DISPLAY(d) \
        ((SnowOptionsDisplay *) (d)->privates[displayPrivateIndex].ptr)

#define SNOW_OPTIONS_DISPLAY(d) \
        SnowOptionsDisplay *od = GET_SNOW_OPTIONS_DISPLAY (d)

#define GET_SNOW_OPTIONS_SCREEN(s, od) \
        ((SnowOptionsScreen *) (s)->privates[(od)->screenPrivateIndex].ptr)

#define SNOW_OPTIONS_SCREEN(s) \
        SnowOptionsScreen *os = GET_SNOW_OPTIONS_SCREEN (s, GET_SNOW_OPTIONS_DISPLAY (s->display))

typedef struct _SnowOptionsDisplay
{
    int screenPrivateIndex;

    CompOption opt[SnowDisplayOptionNum];
    snowDisplayOptionChangeNotifyProc notify[SnowDisplayOptionNum];
} SnowOptionsDisplay;

typedef struct _SnowOptionsScreen
{
} SnowOptionsScreen;

int snowGetNumSnowflakes (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionNumSnowflakes].value.i;
}

CompOption * snowGetNumSnowflakesOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionNumSnowflakes];
}

void snowSetNumSnowflakesNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionNumSnowflakes] = notify;
}

float snowGetSnowSize (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionSnowSize].value.f;
}

CompOption * snowGetSnowSizeOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionSnowSize];
}

void snowSetSnowSizeNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionSnowSize] = notify;
}

int snowGetSnowSpeed (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionSnowSpeed].value.i;
}

CompOption * snowGetSnowSpeedOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionSnowSpeed];
}

void snowSetSnowSpeedNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionSnowSpeed] = notify;
}

int snowGetSnowUpdateDelay (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionSnowUpdateDelay].value.i;
}

CompOption * snowGetSnowUpdateDelayOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionSnowUpdateDelay];
}

void snowSetSnowUpdateDelayNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionSnowUpdateDelay] = notify;
}

int snowGetScreenBoxing (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionScreenBoxing].value.i;
}

CompOption * snowGetScreenBoxingOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionScreenBoxing];
}

void snowSetScreenBoxingNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionScreenBoxing] = notify;
}

int snowGetScreenDepth (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionScreenDepth].value.i;
}

CompOption * snowGetScreenDepthOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionScreenDepth];
}

void snowSetScreenDepthNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionScreenDepth] = notify;
}

Bool snowGetSnowOverWindows (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionSnowOverWindows].value.b;
}

CompOption * snowGetSnowOverWindowsOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionSnowOverWindows];
}

void snowSetSnowOverWindowsNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionSnowOverWindows] = notify;
}

Bool snowGetSnowRotation (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionSnowRotation].value.b;
}

CompOption * snowGetSnowRotationOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionSnowRotation];
}

void snowSetSnowRotationNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionSnowRotation] = notify;
}

int snowGetSnowDirection (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionSnowDirection].value.i;
}

CompOption * snowGetSnowDirectionOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionSnowDirection];
}

void snowSetSnowDirectionNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionSnowDirection] = notify;
}

CompListValue * snowGetSnowTextures (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionSnowTextures].value.list;
}

CompOption * snowGetSnowTexturesOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionSnowTextures];
}

void snowSetSnowTexturesNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionSnowTextures] = notify;
}

Bool snowGetUseBlending (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionUseBlending].value.b;
}

CompOption * snowGetUseBlendingOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionUseBlending];
}

void snowSetUseBlendingNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionUseBlending] = notify;
}

Bool snowGetUseTextures (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return od->opt[SnowDisplayOptionUseTextures].value.b;
}

CompOption * snowGetUseTexturesOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionUseTextures];
}

void snowSetUseTexturesNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionUseTextures] = notify;
}

CompAction * snowGetToggle (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionToggle].value.action;
}

void snowSetToggleInitiate (CompDisplay *d, CompActionCallBackProc init)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->opt[SnowDisplayOptionToggle].value.action.initiate = init;
}

void snowSetToggleTerminate (CompDisplay *d, CompActionCallBackProc term)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->opt[SnowDisplayOptionToggle].value.action.terminate = term;
}

CompOption * snowGetToggleOption (CompDisplay *d)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[SnowDisplayOptionToggle];
}

void snowSetToggleNotify (CompDisplay *d, snowDisplayOptionChangeNotifyProc notify)
{
    SNOW_OPTIONS_DISPLAY(d);
    od->notify[SnowDisplayOptionToggle] = notify;
}

CompOption * snowGetDisplayOption (CompDisplay *d, SnowDisplayOptions num)
{
    SNOW_OPTIONS_DISPLAY(d);
    return &od->opt[num];
}

static const CompMetadataOptionInfo snowOptionsDisplayOptionInfo[] = {
    { "num_snowflakes", "int", "<min>0</min><max>10000</max>", 0, 0 },
    { "snow_size", "float", "<min>0.0</min><max>50.0</max>", 0, 0 },
    { "snow_speed", "int", "<min>0</min><max>100</max>", 0, 0 },
    { "snow_update_delay", "int", "<min>10</min><max>200</max>", 0, 0 },
    { "screen_boxing", "int", "<min>-2000</min><max>2000</max>", 0, 0 },
    { "screen_depth", "int", "<min>0</min><max>2000</max>", 0, 0 },
    { "snow_over_windows", "bool", 0, 0, 0 },
    { "snow_rotation", "bool", 0, 0, 0 },
    { "snow_direction", "int", "<min>0</min><max>3</max>", 0, 0 },
    { "snow_textures", "list", "<type>string</type>", 0, 0 },
    { "use_blending", "bool", 0, 0, 0 },
    { "use_textures", "bool", 0, 0, 0 },
    { "toggle", "action", 0, 0, 0 },
};

static Bool snowOptionsSetDisplayOption (CompPlugin *plugin, CompDisplay *d, char *name, CompOptionValue *value)
{
    SNOW_OPTIONS_DISPLAY(d);
    CompOption *o;
    int        index;

    o = compFindOption (od->opt, SnowDisplayOptionNum, name, &index);

    if (!o)
        return FALSE;

    switch (index)
    {
     case SnowDisplayOptionNumSnowflakes:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionNumSnowflakes])
                (*od->notify[SnowDisplayOptionNumSnowflakes]) (d, o, SnowDisplayOptionNumSnowflakes);
            return TRUE;
        }
        break;
     case SnowDisplayOptionSnowSize:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionSnowSize])
                (*od->notify[SnowDisplayOptionSnowSize]) (d, o, SnowDisplayOptionSnowSize);
            return TRUE;
        }
        break;
     case SnowDisplayOptionSnowSpeed:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionSnowSpeed])
                (*od->notify[SnowDisplayOptionSnowSpeed]) (d, o, SnowDisplayOptionSnowSpeed);
            return TRUE;
        }
        break;
     case SnowDisplayOptionSnowUpdateDelay:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionSnowUpdateDelay])
                (*od->notify[SnowDisplayOptionSnowUpdateDelay]) (d, o, SnowDisplayOptionSnowUpdateDelay);
            return TRUE;
        }
        break;
     case SnowDisplayOptionScreenBoxing:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionScreenBoxing])
                (*od->notify[SnowDisplayOptionScreenBoxing]) (d, o, SnowDisplayOptionScreenBoxing);
            return TRUE;
        }
        break;
     case SnowDisplayOptionScreenDepth:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionScreenDepth])
                (*od->notify[SnowDisplayOptionScreenDepth]) (d, o, SnowDisplayOptionScreenDepth);
            return TRUE;
        }
        break;
     case SnowDisplayOptionSnowOverWindows:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionSnowOverWindows])
                (*od->notify[SnowDisplayOptionSnowOverWindows]) (d, o, SnowDisplayOptionSnowOverWindows);
            return TRUE;
        }
        break;
     case SnowDisplayOptionSnowRotation:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionSnowRotation])
                (*od->notify[SnowDisplayOptionSnowRotation]) (d, o, SnowDisplayOptionSnowRotation);
            return TRUE;
        }
        break;
     case SnowDisplayOptionSnowDirection:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionSnowDirection])
                (*od->notify[SnowDisplayOptionSnowDirection]) (d, o, SnowDisplayOptionSnowDirection);
            return TRUE;
        }
        break;
     case SnowDisplayOptionSnowTextures:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionSnowTextures])
                (*od->notify[SnowDisplayOptionSnowTextures]) (d, o, SnowDisplayOptionSnowTextures);
            return TRUE;
        }
        break;
     case SnowDisplayOptionUseBlending:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionUseBlending])
                (*od->notify[SnowDisplayOptionUseBlending]) (d, o, SnowDisplayOptionUseBlending);
            return TRUE;
        }
        break;
     case SnowDisplayOptionUseTextures:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionUseTextures])
                (*od->notify[SnowDisplayOptionUseTextures]) (d, o, SnowDisplayOptionUseTextures);
            return TRUE;
        }
        break;
     case SnowDisplayOptionToggle:
        if (compSetDisplayOption (d, o, value))
        {
            if (od->notify[SnowDisplayOptionToggle])
                (*od->notify[SnowDisplayOptionToggle]) (d, o, SnowDisplayOptionToggle);
            return TRUE;
        }
        break;
    default:
        break;
    }
    return FALSE;
}

static CompOption * snowOptionsGetDisplayOptions (CompPlugin *plugin, CompDisplay *d, int *count)
{
    SNOW_OPTIONS_DISPLAY(d);
    *count = SnowDisplayOptionNum;
    return od->opt;
}

static Bool snowOptionsInitScreen (CompPlugin *p, CompScreen *s)
{
    SnowOptionsScreen *os;
    
    SNOW_OPTIONS_DISPLAY (s->display);

    os = calloc (1, sizeof(SnowOptionsScreen));
    if (!os)
        return FALSE;

    s->privates[od->screenPrivateIndex].ptr = os;

        if (snowPluginVTable && snowPluginVTable->initScreen)
        return snowPluginVTable->initScreen (p, s);
    return TRUE;
}

static void snowOptionsFiniScreen (CompPlugin *p, CompScreen *s)
{
    if (snowPluginVTable && snowPluginVTable->finiScreen)
        return snowPluginVTable->finiScreen (p, s);

    SNOW_OPTIONS_SCREEN (s);

    free (os);
}

static Bool snowOptionsInitDisplay (CompPlugin *p, CompDisplay *d)
{
    SnowOptionsDisplay *od;
   
    
    od = calloc (1, sizeof(SnowOptionsDisplay));
    if (!od)
        return FALSE;

    od->screenPrivateIndex = allocateScreenPrivateIndex(d);
    if (od->screenPrivateIndex < 0)
    {
        free(od);
        return FALSE;
    }

    d->privates[displayPrivateIndex].ptr = od;

    if (!compInitDisplayOptionsFromMetadata (d, &snowOptionsMetadata, snowOptionsDisplayOptionInfo, od->opt, SnowDisplayOptionNum))
    {
        free (od);
        return FALSE;
    }
    if (snowPluginVTable && snowPluginVTable->initDisplay)
        return snowPluginVTable->initDisplay (p, d);
    return TRUE;
}

static void snowOptionsFiniDisplay (CompPlugin *p, CompDisplay *d)
{
    if (snowPluginVTable && snowPluginVTable->finiDisplay)
        return snowPluginVTable->finiDisplay (p, d);

    SNOW_OPTIONS_DISPLAY (d);

    freeScreenPrivateIndex(d, od->screenPrivateIndex);

    compFiniDisplayOptions (d, od->opt, SnowDisplayOptionNum);

    free (od);
}

static Bool snowOptionsInit (CompPlugin *p)
{
    displayPrivateIndex = allocateDisplayPrivateIndex();
    if (displayPrivateIndex < 0)
        return FALSE;

    if (!compInitPluginMetadataFromInfo (&snowOptionsMetadata, "snow",snowOptionsDisplayOptionInfo, SnowDisplayOptionNum, 0, 0))
        return FALSE;

    compAddMetadataFromFile (&snowOptionsMetadata, "snow");
    if (snowPluginVTable && snowPluginVTable->init)
        return snowPluginVTable->init (p);
    return TRUE;
}

static void snowOptionsFini (CompPlugin *p)
{
    if (snowPluginVTable && snowPluginVTable->fini)
        return snowPluginVTable->fini (p);

    if (displayPrivateIndex >= 0)
        freeDisplayPrivateIndex(displayPrivateIndex);

    compFiniMetadata (&snowOptionsMetadata);
}

static CompMetadata *
snowOptionsGetMetadata (CompPlugin *plugin)
{
    return &snowOptionsMetadata;
}

CompPluginVTable *getCompPluginInfo (void)
{
    if (!snowPluginVTable)
    {
        snowPluginVTable = snowOptionsGetCompPluginInfo ();
        memcpy(&snowOptionsVTable, snowPluginVTable, sizeof(CompPluginVTable));
        snowOptionsVTable.getMetadata = snowOptionsGetMetadata;
        snowOptionsVTable.init = snowOptionsInit;
        snowOptionsVTable.fini = snowOptionsFini;
        snowOptionsVTable.initDisplay = snowOptionsInitDisplay;
        snowOptionsVTable.finiDisplay = snowOptionsFiniDisplay;
        snowOptionsVTable.initScreen = snowOptionsInitScreen;
        snowOptionsVTable.finiScreen = snowOptionsFiniScreen;
        snowOptionsVTable.getDisplayOptions = snowOptionsGetDisplayOptions;
	snowOptionsVTable.setDisplayOption = snowOptionsSetDisplayOption;
	
    }
    return &snowOptionsVTable;
}

