#!/bin/sh

usage()
{
	# Title
	echo "Title: Recording date & time subtitles generator"

	# Usable?
	which dv2sub > /dev/null
	[ $? = 0 ] && echo Status: Active || echo Status: Inactive

	# Type
	echo Flags: single-pass

	# Profiles
	echo "Profile: MicroDVD subtitles into <file>.txt"
}

execute()
{
	# Arguments
	normalisation="$1"
	length="$2"
	profile="$3"
	file="$4"
	smil_file="$5"

        # generate filename if missing
        [ "x$file" = "x" ] && file="kino_export_$(date +%Y-%m-%d_%H.%M.%S)"

	# Run the command
	case "$profile" in
	    "0") dv2sub --subtitles-out "${file}.txt" > /dev/null ;;
	esac
}

[ "x$1" = "x--usage" -o -z "$1" ] && usage "$@" || execute "$@"
