// K-3D
// Copyright (c) 1995-2006, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Timothy M. Shead (tshead@k-3d.com)
*/

#include <k3dsdk/i18n.h>
#include <k3dsdk/irenderman.h>
#include <k3dsdk/module.h>
#include <k3dsdk/node.h>
#include <k3dsdk/persistent.h>

namespace libk3dpixie
{

/////////////////////////////////////////////////////////////////////////////
// raytrace_map

class raytrace_map :
	public k3d::persistent<k3d::node>,
	public k3d::ri::itexture
{
	typedef k3d::persistent<k3d::node> base;

public:
	raytrace_map(k3d::idocument& Document) :
		base(Document)
	{
	}

	void setup_renderman_texture(k3d::irender_frame& Frame, k3d::ri::irender_engine& Engine, k3d::ri::ishader_collection& Shaders)
	{
	}

	const boost::filesystem::path renderman_texture_path(const k3d::ri::render_state& State)
	{
		return boost::filesystem::path("raytrace");
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<
			k3d::document_plugin<raytrace_map>,
			k3d::interface_list<k3d::ri::itexture> > factory(
				k3d::uuid(0x896ac401, 0x5fae47ce, 0x92836627, 0x934dacdc),
				"PixieRaytraceMap",
				_("Dummy shadow map source for raytracing with Pixie"),
				"RenderMan Pixie",
				k3d::iplugin_factory::STABLE);

		return factory;
	}
};

/////////////////////////////////////////////////////////////////////////////
// raytrace_map_factory

k3d::iplugin_factory& raytrace_map_factory()
{
	return raytrace_map::get_factory();
}

} // namespace libk3dpixie

