import string
import SCons.Node
import SCons.Node.FS
import SCons.Scanner
import SCons.Util
def ProgScan(fs=SCons.Node.FS.default_fs):
    pf=SCons.Scanner.FindPathDirs('LIBPATH', fs)
    ps=SCons.Scanner.Base(scan, "ProgScan", path_function=pf)
    return ps
def scan(node, env, libpath=(), fs=SCons.Node.FS.default_fs):
    try:
        libs=env.Dictionary('LIBS')
    except KeyError:
        return []
    if SCons.Util.is_String(libs):
        libs=string.split(libs)
    elif not SCons.Util.is_List(libs):
        libs=[libs]
    try:
        prefix=env.Dictionary('LIBPREFIXES')
        if not SCons.Util.is_List(prefix):
            prefix=[ prefix ]
    except KeyError:
        prefix=[ '' ]
    try:
        suffix=env.Dictionary('LIBSUFFIXES')
        if not SCons.Util.is_List(suffix):
            suffix=[ suffix ]
    except KeyError:
        suffix=[ '' ]
    find_file=SCons.Node.FS.find_file
    adjustixes=SCons.Util.adjustixes
    result=[]
    for suf in map(env.subst, suffix):
        for pref in map(env.subst, prefix):
            for lib in libs:
                if SCons.Util.is_String(lib):
                    lib=env.subst(lib)
                    lib=adjustixes(lib, pref, suf)
                    lib=find_file(lib, libpath, fs.File)
                    if lib:
                        result.append(lib)
                else:
                    result.append(lib)
    return result
