/***************************************************************************
 *   Copyright (C) 2005 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FLOWLAYOUT_H
#define FLOWLAYOUT_H

#include <qlayout.h>
#include <qptrlist.h>

class Source;
class KConfig;

class FlowLayout : public QLayout{
	Q_OBJECT //macro which activates signals and slots (moc)
public:
	/**
	 * the direction for moveItem
	 */
	enum DIRECTION {
		ABOVE = 0,
		BELOW = 1
	};
	FlowLayout( QWidget* parent, Qt::Orientation orientation=Qt::Horizontal, int border=0, int space=-1, const char* name=0 );
	FlowLayout( QLayout* parent, Qt::Orientation orientation=Qt::Horizontal, int space=-1, const char* name=0 );
	FlowLayout( Qt::Orientation=Qt::Horizontal, int space=-1, const char* name=0 );
	virtual ~FlowLayout();
	/**
	 * tells all sources their positions
	 */
	void updatePositions(KConfig * inKConfig);
	void addItem(QLayoutItem* item);
	void addSource(Source* src);
	void remove(QWidget* widget);
	/**
	 * Returns the number of items in the layout
	 */
	uint count();
	/**
	 * moves the item \c which above/beneath item \c relate
	 * \param dir ABOVE if above, BENEATH if beneath
	 * \return the new Position or -1 if no real move was made
	 */
	bool moveItem(const QLayoutItem* which, const QLayoutItem* relate, DIRECTION direction);
	bool hasHeightForWidth() const;
	int heightForWidth(int w) const;
	bool hasWidthForHeight() const;
	int widthForHeight(int h) const;
	QSize sizeHint() const;
	QSize minimumSize() const;
	QLayoutIterator iterator();
	QSizePolicy::ExpandData expanding() const;
	Qt::Orientation getOrientation() const;
public slots:
	void setOrientation(Qt::Orientation orientation);

protected:
	void setGeometry(const QRect&);

private:
	int doLayout( const QRect&, bool testOnly = FALSE );
	int doLayoutHorizontal( const QRect&, bool testOnly );
	int doLayoutVertical( const QRect&, bool testOnly );
	Qt::Orientation mOrientation;
	QPtrList<QLayoutItem> mLayoutItems;
	// this is the connection between a layout item and its source.
	QMap<QLayoutItem*, Source*> mSources;
	QLayoutItem* mLastItem; // the item that was last added
};
#endif
