/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "triggeredsource.h"
#include "updateevent.h"
#include <qapplication.h>

//#include "kdebug.h"

TriggeredSource::TriggeredSource(QWidget* inParent):
		Source(inParent){
}

TriggeredSource::~TriggeredSource(){
}

void TriggeredSource::customEvent(QCustomEvent* event){
	if(event->type() == UpdateEvent::TYPE ){
		UpdateEvent* ue = static_cast<UpdateEvent*>(event);
		// update mValue
		mValue = ue->getMessage();
		//kdDebug() << "emit valueUpdated(mValue); value: " << mValue << endl;
		emit valueUpdated(mValue);
	}else{
		Source::customEvent(event);
	}
}

QString TriggeredSource::getValue() const{
	return mValue;
}
