/*
	links.h - A link creator/remover
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __LINKS_H__
#define __LINKS_H__

#include <qvbox.h>

class KPushButton;
class QComboBox;

/** @short A link creator/remover. */
class Links: public QVBox
{
	Q_OBJECT
public:
	/**
	 * Constructor.
	 * @param parent A parent widget
	 */
	Links(QWidget *parent);

	/**
	 * Creates a new <b>.desktop</b> file.
	 * @param path A path to the <b>.desktop</b> file
	 * @param command A command to execute
	 * @param icon An icon name
	 * @param name A link name
	 * @param comment A comment
	 */
	static void createLink(
		const QString &path,
		const QString &command,
		const QString &icon,
		const QString &name,
		const QString &comment
	);

	/**
	 * Removes a <b>.desktop</b> file.
	 * @param path A <b>.desktop</b> file to remove
	 */
	static void removeLink(const QString &path);
private:
	KPushButton *b_addRemoveLink;
	QComboBox
		*cb_location,
		*cb_type;
	QString getCurrentLocationPath() const;
	QString getCurrentTypeCommand() const;
	QString getCurrentTypeIcon() const;
	void updateAddRemoveButton();
private slots:
	void slotActivated(int index);
	void slotAddRemoveLink();
};

#endif // __LINKS_H__
