/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#ifndef KDIALUPCONFIGDLG_H
#define KDIALUPCONFIGDLG_H

#include "kdialupconfig.h"


#define CONNECT_ISDN "ISDN"
#define CONNECT_PPPOE "PPPOE (DSL)"
#define CONNECT_ANALOG "Analog"

class SuProcessBase;
class dialupClass;

class KDialupConfigDlg : public dialupConfig
{
    Q_OBJECT

    public:
        KDialupConfigDlg(QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
        ~KDialupConfigDlg();
        bool init(QString profile);
        dialupClass* getData()
        {
            return m_data;
        }
        /*$PUBLIC_FUNCTIONS$*/
    public slots:
        /*$PUBLIC_SLOTS$*/
        virtual void          cancel();
        virtual void          ok();
        virtual void          fillInterfaces(const QString& networkType);
        void slotNetworksChanged();
    
    signals:
        void dialupNetworksUpdated();
  

    private:
        void setData();
        dialupClass *m_data;
        QString m_profile;
        bool m_newProfile;
        
    protected:
        /*$PROTECTED_FUNCTIONS$*/

    protected slots:
        /*$PROTECTED_SLOTS$*/

};

#endif

