/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>
        Copyright (c) 2006 Valentine Sinitsyn <e_val@inbox.ru>. Distributed under the same terms as Kwlan

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#ifndef KWLANSUPROCESS_H
#define KWLANSUPROCESS_H

#include "suprocessbase.h"

class KwlanSuProcess: public SuProcessBase {
  Q_OBJECT
  
  
    public:
        KwlanSuProcess(QObject *parent = 0, const char *name = 0);
        virtual ~KwlanSuProcess();
    
        virtual bool start(RunMode runmode = NotifyOnExit, Communication comm = NoCommunication);
    
        void setDescription(const QString &desc);
        void setRestart(bool restart);
    signals:
        void processExited(KwlanSuProcess *);
    
    public slots:
        void slotProcessExited(SuProcessBase *);
    

    private:    
        enum PasswordStates {
            PasswordRequired = 0x01,
            PasswordEntered = 0x02,
            PasswordRefused = 0x04
        };
    
        int m_pwstate, m_keep;
        bool m_restart;
        QCString m_desc, m_password;
        QObject * m_parent;
};

#endif
