/* 
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/
#ifndef _WLANLIB_
#define _WLANLIB_

#include <qstring.h>
#include <qstringlist.h>
#include <qwidget.h>
#include <kdebug.h>

#include "kwlnetworklist.h"

#define PROC_NET_WIRELESS	"/proc/net/wireless"
#define PROC_NET_WIRED	"/proc/net/dev"
#define MAX_SSID_SIZE 100

struct interfaceData
{
    interfaceData()
    : existing( false ),
    available( false ),
    connected( false),
    wirelessDevice( false ),
    //incomingBytes( 0L ),
    //outgoingBytes( 0L ),
    prevRxBytes( 0L ),
    prevTxBytes( 0L ),
    rxBytes( 0L ),
    txBytes( 0L )
    {}

    bool existing;
    bool available;
    bool connected;
    bool up;
    bool wirelessDevice;
    //unsigned long incomingBytes;
    //unsigned long outgoingBytes;
    unsigned long rxPackets;
    unsigned long txPackets;
    unsigned long prevRxBytes;
    unsigned long prevTxBytes;
    QString ipAddress;
    QString subnetMask;
    QString hwAddress;
    QString ptpAddress;
    QString broadcastAddress;
    QString defaultGateway;
    QString rxString;
    QString txString;
    unsigned long rxBytes;
    unsigned long txBytes;
};

struct wirelessData
{
    QString essid;
    QString mode;
    QString frequency;
    QString channel;
    QString bitRate;
    QString signal;
    QString noise;
    QString linkQuality;
    int linkQualityNum;
    bool radioOff;
};


///not wireless related, but needed from several classes: executes program using kdesud
bool executeSuCommand(QString command);
/// lists all wireless interfaces
QStringList getInterfaces();
/// lists all wired interfaces
QStringList getWiredInterfaces();
/// return full path for a file "file"
QString getPath(QString file);
/// Returns true is there is a nameserver entry in /etc/resolv.conf
bool hasNameserver();
/// Returns true if there is default gateway on an active interface
bool hasGateway();

int str_match(const char *a, const char *b);

void kwlan_msg_cb(char *msg, size_t);

/// class to request information about wireless status
class IwLib {
    public:
        IwLib(const QString &ifname);
        virtual ~IwLib();
	
        int getQuality();
        QString getBitrate();
        QString getESSID();
        bool setWepAuth(int authMode);
    private:
        int m_socket;
        QString m_ifname;
};

void kwireless_scan(kwlNetworkList & profiles, char *ifname);

#endif
