#!/bin/sh
#
# ptetex -- Japanese patch collection for teTeX-3.0
#  Nobuyuki Tsuchimura
#
# This script searches following automatically.
# -- Japanese TrueType font for xdvi
# -- CMap for dvipdfmx
# It also install essential CMaps which can't found in system directory.

. ./common.sh
test "$JAPANESE" = "without" && exit 0
YES=$1
    CMAP=$TEXMF/fonts/cmap
TRUETYPE=$TEXMF/fonts/truetype
OPENTYPE=$TEXMF/fonts/opentype

yesno() {
    test "$YES" = "yes" && return 0
    read REPLY <&2
    case $REPLY in
	y*|Y*) true;;
	*) false;;
    esac
}

# usage: lns dist-link src-dir1 src-dir2 ...
lns() {
    DIST="$1"
    shift
    #echo "DIST=$DIST"
    test -h "$DIST" && return
    while test -n "$1"; do
	#echo "  $1"
	if test -f "$1" -o -d "$1"; then
	    echo ""
	    echo "[$1]"
	    ls -F "$1"
	    echo "exec '$LN \"$1\" \"$DIST\"' ? [y/N] "
	    yesno && $LN "$1" "$DIST"
	fi
	shift
    done
}

mksymlink(){
    $MKDIR $1
    while read line; do
	case $line in \#*) continue;; esac # skip comment
	eval lns $1/$line
    done
}


setrmlgbm() {
    if test -n "$2"; then
	echo "set '$2' as $1."
	$UPDMAP --quiet --nomkmap --setoption $1 $2 2> /dev/null
    else
	echo "Warning: No font was found as $1."
    fi
}

rmlgbm() {
    while read FONT; do
	case $FONT in
	    \#*) continue;;
	esac
	case $MINGOTH in
	    xdviRml) MINGOTH=xdviGbm;;
	    *)       MINGOTH=xdviRml;;
	esac
	g=0
	kpsewhich -format 'truetype fonts' $FONT > /dev/null && g=1
	kpsewhich -format 'opentype fonts' $FONT > /dev/null && g=1
	if test $g != 0; then
	    echo "'$FONT' was found as '$MINGOTH'"
	    eval $MINGOTH=$FONT
	fi
    done
    setrmlgbm xdviRml $xdviRml
    setrmlgbm xdviGbm $xdviGbm
}


## check if exsit, and install
cmapinstall() {
CMAPDIR=$CMAP/ptetex
# Don't 'cd $1', because kpsewhich searches current directory, too.
    for f in `ls $1`; do
	if kpsewhich --format="cmap files" $f > /dev/null; then
	    echo "'$f' OK"
	else
	    echo "'$f' copying to '$CMAPDIR'"
	    test -d "$CMAPDIR" || mkdir "$CMAPDIR"
	    cp -p $1/$f "$CMAPDIR"
	fi
    done
}

# -----------------------------------

mksymlink $CMAP <<EOF
### ̾  ǥ쥯ȥ/ե
Acrobat4    /usr{,/local,/sfw}{,/lib}/Acrobat4/Resource/CMap
Acrobat5    /usr{,/local,/sfw}{,/lib}/Acrobat5/Resource/Font
Acrobat7    /usr{,/local,/sfw}{,/lib}{,/Adobe}/Acrobat7.0/Resource/CMap
ghostscript /usr{,/local,/sfw}/{share,lib}/ghostscript{,/*}/Resource/CMap
openwinja   /usr/openwin/lib/locale/ja/X11/Resource/CMap
openwinko   /usr/openwin/lib/locale/ko/X11/Resource/CMap
openwinzh   /usr/openwin/lib/locale/zh/X11/Resource/CMap
openwintw   /usr/openwin/lib/locale/zh_TW.BIG5/X11/Resource/CMap
EOF

mksymlink $TRUETYPE <<EOF
### ̾  ǥ쥯ȥ/ե
x11       /usr/X11R6/lib/X11/fonts/truetype
X11       /usr/X11R6/lib/X11/fonts/TrueType
X11TTF    /usr/X11R6/lib/X11/fonts/TTF
openwin   /usr/openwin/lib/locale/ja/X11/fonts/TT
truetype  /usr/share/fonts/truetype
ja        /usr/share/fonts/ja/TrueType
japanese  /usr/share/fonts/japanese/TrueType
QtPalmtop /opt/QtPalmtop/lib/X11/fonts/TrueType
EOF

mksymlink $OPENTYPE <<EOF
### ̾  ǥ쥯ȥ/ե
# for test (contains white space)
hoge "/tmp/hoge hoge"
QtPalmtop /opt/QtPalmtop/lib/X11/fonts/opentype
EOF

if test -d /System/Library/Fonts; then # Mac OS X
LC_ALL=ja_JP.UTF-8
cat <<EOF | /usr/bin/iconv -f EUC-JP -t UTF-8-MAC | mksymlink $OPENTYPE
HiraMinPro-W3.otf  "/System/Library/Fonts/ҥ饮ī Pro W3.otf"
HiraMinPro-W6.otf  "/System/Library/Fonts/ҥ饮ī Pro W6.otf"
HiraKakuPro-W3.otf "/System/Library/Fonts/ҥ饮γѥ Pro W3.otf"
HiraKakuPro-W6.otf "/System/Library/Fonts/ҥ饮γѥ Pro W6.otf"
HiraKakuStd-W8.otf "/System/Library/Fonts/ҥ饮γѥ Std W8.otf"
HiraMaruPro-W4.otf "/System/Library/Fonts/ҥ饮δݥ Pro W4.otf"
EOF
fi

if test -d /cygdrive; then # cygwin
mksymlink $CMAP <<EOF
Acrobat5 "`cygpath --mixed "$PROGRAMFILES"`/Adobe/Acrobat 5.0/Resource/Cmap"
Acrobat6 "`cygpath --mixed "$PROGRAMFILES"`/Adobe/Acrobat 6.0/Resource/CMap"
Acrobat7 "`cygpath --mixed "$PROGRAMFILES"`/Adobe/Acrobat 7.0/Resource/CMap"
EOF
mksymlink $TRUETYPE <<EOF
windows  "`cygpath --mixed -W`/Fonts"
EOF
fi

echo ""
echo "searching xdvi fonts..."
$MKTEXLSR 2> /dev/null

# xdvi ǻȤեȥե̾Υꥹ
# īΤȥåΤ򣲹԰Ȥ󤹤롣
# Ǹ˸ĤäΤѤ롣
#  the former, more general
#  the latter, higher quality
rmlgbm <<EOF
# kochi (distribution stopped)
	kochi-mincho.ttf
	kochi-gothic.ttf
# kochi-subst (former of sazanami)
	kochi-mincho-subst.ttf
	kochi-gothic-subst.ttf
# sazanami http://wiki.fdiary.net/font/?sazanami
	sazanami-mincho.ttf
	sazanami-gothic.ttf
# IPA font https://sourceforge.jp/projects/opfc/
# (opfc-ModuleHP-1.1.1_withIPAFonts.tar.gz)
	ipam.ttf
	ipag.ttf
# DynaLab
	dfmimp3.ttc
	dfgotp5.ttc
# Windows native
	msmincho.ttc
	msgothic.ttc
# Ricoh TTF
	lxmincho.ttc
	lxgothic.ttc
# Turbo Linux 10
	tlmincho.ttc
	tlgothic.ttc
# Solaris 9
	HG-MinchoL.ttf
	HG-GothicB.ttf
# Solaris 10
	hgmlsun.ttf
	hggbsun.ttf
# Kozuka
	KozMinPro-Regular-Acro.otf
	KozGoStd-Regular.otf
	KozMinProVI-Regular.otf  
	KozGoPro-Medium.otf
# Hiragino
	HiraMinPro-W3.otf
	HiraKakuPro-W3.otf
EOF

echo ""
echo "searching cmaps..."

cmapinstall ./cmap

echo ""
echo "finishing..."

$UPDMAP 2> /dev/null
$MKTEXLSR 2> /dev/null
