/***************************************************************************
    smb4ksuperuseroptions  -  The configuration page for the super user
    settings of Smb4K
                             -------------------
    begin                : Sa Okt 30 2004
    copyright            : (C) 2004-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <qgroupbox.h>
#include <qbuttongroup.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qradiobutton.h>
#include <qcheckbox.h>

// KDE includes
#include <klocale.h>
#include <kpushbutton.h>
#include <kguiitem.h>

// application specific includes
#include "smb4ksuperuseroptions.h"
#include "../core/smb4ksettings.h"


Smb4KSuperUserOptions::Smb4KSuperUserOptions( QWidget *parent, const char *name )
: QWidget( parent, name )
{
  QGridLayout *grid =           new QGridLayout( this );
  grid->setSpacing( 10 );

  QButtonGroup *suid_progs =    new QButtonGroup( 1, QButtonGroup::Horizontal,
                                i18n( "Programs" ), this, "kcfg_SuperUserProgram" );
  suid_progs->setInsideSpacing( 5 );

  new QLabel( i18n( "Use the following program to gain super user privileges:" ), suid_progs );
  suid_progs->insert( new QRadioButton( "sudo", suid_progs, "SudoButton" ), Smb4KSettings::EnumSuperUserProgram::Sudo );
  suid_progs->insert( new QRadioButton( "super", suid_progs, "SuperButton" ), Smb4KSettings::EnumSuperUserProgram::Super );

  QButtonGroup *suid_actions =  new QButtonGroup( 1, QButtonGroup::Horizontal, i18n( "Actions" ), this, "SUIDActions" );
  suid_actions->setInsideSpacing( 5 );
#ifdef __linux__
  (void) new QCheckBox( i18n( "Use super user privileges to force the unmounting of (inaccessible) shares" ), suid_actions, "kcfg_UseForceUnmount" );
#endif
  (void) new QCheckBox( i18n( "Use super user privileges to mount and unmount shares" ), suid_actions, "kcfg_AlwaysUseSuperUser" );

  QSpacerItem *spacer1 =        new QSpacerItem( 0, 0, QSizePolicy::Expanding, QSizePolicy::Preferred );
  KGuiItem remove_item =        KGuiItem(  i18n( "Remove Entries" ), "editdelete",
                                i18n( "Remove entries from the configuration file" ),
                                i18n( "Depending on your choice under \"Programs\", all entries that were written by Smb4K will be removed either from /etc/super.tab or /etc/sudoers. Additionally, all your choices under \"Actions\" will be cleared." ) );
  KPushButton *remove =         new KPushButton( remove_item, this, "RemoveButton" );

  QSpacerItem *spacer2 =        new QSpacerItem( 0, 0, QSizePolicy::Preferred, QSizePolicy::Expanding );

  grid->addMultiCellWidget( suid_progs, 0, 0, 0, 3, 0 );
  grid->addMultiCellWidget( suid_actions, 1, 1, 0, 3, 0 );
  grid->addMultiCell( spacer1, 2, 2, 0, 2, 0 );
  grid->addWidget( remove, 2, 3, 0 );
  grid->addMultiCell( spacer2, 3, 3, 0, 3, 0 );

  connect( remove, SIGNAL( clicked() ),
           this,   SLOT( slotRemoveClicked() ) );
}


Smb4KSuperUserOptions::~Smb4KSuperUserOptions()
{
}


/////////////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSuperUserOptions::slotRemoveClicked()
{
  // Emit the signal that the removal of the super user
  // entries has been requested.
  emit removeEntries();
}

#include "smb4ksuperuseroptions.moc"
