
/*
 *  soldevicetypes.h
 *
 *  Copyright (C) 2009 David Hubner <hubnerd@ntlworld.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 */

#ifndef __SOLDEVICETYPES__
#define __SOLDEVICETYPES__

#include "soldevice.h"

class SolProcessorDevice : public SolDevice
{
  
  public:
    SolProcessorDevice(QTreeWidgetItem *, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceIcon();
    void setDefaultDeviceText();
};


class SolStorageDevice : public SolDevice
{
  public:
    SolStorageDevice(QTreeWidgetItem *, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceText();
    void setDefaultDeviceIcon();
};

class SolNetworkDevice : public SolDevice 
{

  public:
    SolNetworkDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceText(QTreeWidgetItem *);
    void setDefaultDeviceIcon();
};

class SolVolumeDevice : public SolDevice 
{

  public:
    SolVolumeDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceIcon();
};

class SolAudioDevice : public SolDevice 
{

  public:
    SolAudioDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceIcon();
};

class SolButtonDevice : public SolDevice 
{

  public:
    SolButtonDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceIcon();
};

class SolMediaPlayerDevice : public SolDevice 
{

  public:
    SolMediaPlayerDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceIcon();
};

class SolCameraDevice : public SolDevice 
{

  public:
    SolCameraDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceIcon();
};

class SolBatteryDevice : public SolDevice 
{

  public:
    SolBatteryDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
    
  private:
    void setDefaultDeviceIcon();
};

class SolAcAdapterDevice : public SolDevice 
{

  public:
    SolAcAdapterDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
};

class SolDvbDevice : public SolDevice 
{

  public:
    SolDvbDevice(QTreeWidgetItem *parent, Solid::Device);
};

class SolSerialDevice : public SolDevice 
{

  public:
    SolSerialDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
};

class SolSmartCardDevice : public SolDevice 
{

  public:
    SolSmartCardDevice(QTreeWidgetItem *parent, Solid::Device);
    QVListLayout *getInfoPanelLayout();
};

class SolVideoDevice : public SolDevice 
{

  public:
    SolVideoDevice(QTreeWidgetItem *parent, Solid::Device);
  
  private:
    void setDefaultDeviceIcon();
    QVListLayout *getInfoPanelLayout();
};


#endif // __SOLDEVICETYPES__