/***************************************************************************
                          babylon.cpp  -  description
	This library is based on the work of Frederic Jolliton on Libbab
	this is a porting to QT library
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <KLocale>

#include <QTextCodec>	//ooo
#include <KMessageBox>	//ooo
#include <QByteArray>	//ooo

#include <QFile>	//ooo
#include <QTextStream>	//ooo
#include <QDebug>	//ooo

#include <QTextDocument>	//ooo
#include <QTextCursor>		//ooo

#include "babylon.h"
#include "utils.h"

#include "babylon_bgl.h"//ooo
#include "stardict.h"	//ooo

//#define DEBUG_1
//#define DEBUG_2
//#define DEBUG_3
//#define DEBUG_4
//#define DEBUG_4a
//#define DEBUG_5
//#define DEBUG_6


/*
inline Q_UINT32 read_val(QDataStream *is,int n_bytes)
{
	Q_UINT8 data8;
	Q_UINT16 data16;
	Q_UINT32 data32;
	switch (n_bytes) {
		case 1 : {
			*is >> data8;
			return data8;
		}
		case 2 : {
			*is >> data16;
			return data16;
		}
		case 4 : {
			*is >> data32;
			return data32;
		}
	}
	return 0;
}
*/

inline Q_UINT32 read_val(istream& is ,int n)
{
	Q_UINT32 r = 0 ;
	for (int i=0; i<n; ++i)
		r |= ((Q_UINT32)(Q_UINT8)is.get() ) << 8*i ;
	return r ;
}

Babylon::Babylon()
{

}

Babylon::~Babylon()
{
	file_eng.close();
	file_spec.close();
}

bool Babylon::open(QString engDic,QString specDic)
{
	/*--- Using QFile and QDataStream (Temporary disabled) ---*/
	/*
	if (!(file_eng = new QFile(engDic)))
		return false;
	if (!file_eng->open(IO_ReadOnly))
		return false;
	if (!(file_spec = new QFile(specDic)))
		return false;
	if (!file_spec->open(IO_ReadOnly))
		return false;
	stream_eng = new QDataStream(file_eng);
	stream_spec = new QDataStream(file_spec);
	return true;
	*/
	
	//file_eng.open(engDic.latin1(),ios::in);
	file_eng.open(engDic.toLatin1(),ios::in);
	//file_spec.open(specDic.latin1(),ios::in);
	file_spec.open(specDic.toLatin1(),ios::in);
	if (!(file_eng && file_spec))
		return false;
	return true;
}


inline QString Babylon::bab_to_char_jap_2(int lsb, int msb) {

	QString def = "";

	if ( lsb == 32 ) {
		if ( msb == 35 ) {
			def += /*"<***>" ;*/ ";" ;   // aged
		} else if ( msb == 40 ) {            // feed: "("
			def += QChar(0xA1);
			def += QChar(0xCA);
		} else {
			def += "";
		}
	} else if ( lsb == 41 ) {                    // feed: ")"
		if ( msb == 32 ) {
			def += QChar(0xA1);
			def += QChar(0xCB);
		}
	} else if ( lsb == 129 ) {                   //Unified Ideographs Extension
		if ( msb == 65 ) {
			def += QChar(0x2C);
		} else if ( msb == 70 ) {
			def += QChar(0x3B);
		} else if ( msb == 71 ) {
			def += QChar(0x3B);
		} else if ( msb == 88 ) {
			def += QChar(0xA1);
			def += QChar(0xB9);
		} else if ( msb == 96 ) {
			def += QChar(0xA1);
			def += QChar(0xC1);
		} else if ( msb == 99 ) {
			def += QChar(0xA1);
			def += QChar(0xC4);
		} else
			def += QChar(0x27);
	} else if ( lsb == 130 ) {                          //Hiragana
		def += bab_to_char_jap_hiragana( msb - 159 ) ;
	} else if ( ( lsb >= 136 && lsb <= 159 ) || ( lsb >= 224 && lsb <= 234 ) ) {
		if ( lsb == 136) {
			if ( msb < 158 )
				def += QChar(0xAF) ;
			else
				def += QChar(0xB0) ;
		} else if ( lsb == 137 ) {
			if ( msb <= 158 )
				def += QChar(0xB1) ;
			else
				def += QChar(0xB2) ;
		} else if ( lsb == 138 ) {
			if ( msb <= 158 )
				def += QChar(0xB3) ;
			else
				def += QChar(0xB4) ;
		} else if ( lsb == 139 ) {
			if ( msb <= 158 )
				def += QChar(0xB5) ;
			else
				def += QChar(0xB6) ;
		} else if ( lsb == 140 ) {
			if ( msb <= 158 )
				def += QChar(0xB7) ;
			else
				def += QChar(0xB8) ;
		} else if ( lsb == 141 ) {
			if ( msb <= 158 )
				def += QChar(0xB9) ;
			else
				def += QChar(0xBA) ;
		} else if ( lsb == 142 ) {
			if ( msb <= 158 )
				def += QChar(0xBB) ;
			else
				def += QChar(0xBC) ;
		} else if ( lsb == 143 ) {
			if ( msb <= 158 )
				def += QChar(0xBD) ;
			else
				def += QChar(0xBE) ;
		} else if ( lsb == 144 ) {
			if ( msb <= 158 )
				def += QChar(0xBF) ;
			else
				def += QChar(0xC0) ;
		} else if ( lsb == 145 ) {
			if ( msb <= 158 )
				def += QChar(0xC1) ;
			else
				def += QChar(0xC2) ;
		} else if ( lsb == 146 ) {
			if ( msb <= 158 )
				def += QChar(0xC3) ;
			else
				def += QChar(0xC4) ;
		} else if ( lsb == 147 ) {
			if ( msb <= 158 )
				def += QChar(0xC5) ;
			else
				def += QChar(0xC6) ;
		} else if ( lsb == 148 ) {
			if ( msb <= 158 )
				def += QChar(0xC7) ;
			else
				def += QChar(0xC8) ;
		} else if ( lsb == 149 ) {
			if ( msb <= 158 )
				def += QChar(0xC9) ;
			else
				def += QChar(0xCA) ;
		} else if ( lsb == 150 ) {
			if ( msb <= 158 )
				def += QChar(0xCB) ;
			else
				def += QChar(0xCC) ;
		} else if ( lsb == 151 ) {
			if ( msb <= 158 )
				def += QChar(0xCD) ;
			else
				def += QChar(0xCE) ;
		} else if ( lsb == 152 ) {
			if ( msb <= 158 )
				def += QChar(0xCF) ;
			else
				def += QChar(0xD0) ;
		} else if ( lsb == 153 ) {	//puppet
			if ( msb <= 158 )
				def += QChar(0xD1) ;
			else
				def += QChar(0xD2) ;
		} else if ( lsb == 154 ) {
			if ( msb <= 158 )
				def += QChar(0xD3) ;
			else
				def += QChar(0xD4) ;
		} else if ( lsb == 155 ) {	//maintainer
			if ( msb <= 158 )
				def += QChar(0xD5) ;
			else
				def += QChar(0xD6) ;
		} else if ( lsb == 156 ) {
			if ( msb <= 158 )
				def += QChar(0xD7) ;
			else
				def += QChar(0xD8) ;
		} else if ( lsb == 157 ) {
			if ( msb <= 158 )
				def += QChar(0xD9) ;
			else
				def += QChar(0xDA) ;
		} else if ( lsb == 158 ) {
			if ( msb <= 96 )
				def += QChar(0xDB) ;
			else
				def += QChar(0xDC) ;
		} else if ( lsb == 159 ) {
			if ( msb <= 96 )
				def += QChar(0xDD) ;
			else
				def += QChar(0xDE) ;
		} else if ( lsb == 224 ) {
			if ( msb <= 96 )
				def += QChar(0xDF) ;
			else
				def += QChar(0xE0) ;
		} else if ( lsb == 225 ) {
			if ( msb <= 96 )
				def += QChar(0xE1) ;
			else
				def += QChar(0xE2) ;
		} else if ( lsb == 226 ) {
			if ( msb <= 96 )
				def += QChar(0xE3) ;
			else
				def += QChar(0xE4) ;
		} else if ( lsb == 227 ) {
			if ( msb <= 96 )
				def += QChar(0xE5) ;
			else
				def += QChar(0xE6) ;
		} else if ( lsb == 228 ) {
			if ( msb <= 96 )
				def += QChar(0xE7) ;
			else
				def += QChar(0xE8) ;
		} else if ( lsb == 229 ) {
			if ( msb <= 96 )
				def += QChar(0xE9) ;
			else
				def += QChar(0xEA) ;
		} else if ( lsb == 230 ) {
			if ( msb <= 96 )
				def += QChar(0xEB) ;
			else
				def += QChar(0xEC) ;
		} else if ( lsb == 231 ) {
			if ( msb <= 96 )
				def += QChar(0xED) ;
			else
				def += QChar(0xEE) ;
		} else if ( lsb == 232 ) {
			if ( msb <= 96 )
				def += QChar(0xEF) ;
			else
				def += QChar(0xF0) ;
		} else if ( lsb == 233 ) {
			if ( msb <= 96 )
				def += QChar(0xF1) ;
			else
				def += QChar(0xF2) ;
		} else if ( lsb == 234 ) {
			if ( msb <= 96 )
				def += QChar(0xF3) ;
			else
				def += QChar(0xF4) ;
		}

		if ( msb < 128 )
			def += QChar( msb + 97 ) ;
		else if ( msb <= 158 )
			def += QChar( msb + 96 ) ;
		else if ( msb <= 252 )
			def += QChar( msb + 2 ) ;

	} else if ( lsb == 179 ) {	 //chars which occures 2 or 3 times
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xF4);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 182 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xAC);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 183 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xAE);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 184 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xB0);
		} else if ( msb == 223 ) {	//?
			def += QChar(0xA5);
			def += QChar(0xB1);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 185 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xB2);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 186 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xB4);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 187 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xB6);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 188 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xB8);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 189 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xBA);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 190 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xBC);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 191 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xBE);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 192 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xC0);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 193 ) {			//without example
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xC2);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 194 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xC5);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 195 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xC7);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 196 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xC9);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 202 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xD0);
		} else if ( msb == 223 ) {
			def += QChar(0xA5);
			def += QChar(0xD1);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 203 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xD3);
		} else if ( msb == 223 ) {
			def += QChar(0xA5);
			def += QChar(0xD4);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 204 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xD6);
		} else if ( msb == 223 ) {
			def += QChar(0xA5);
			def += QChar(0xD7);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 205 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xD9);
		} else if ( msb == 223 ) {
			def += QChar(0xA5);
			def += QChar(0xDA);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	} else if ( lsb == 206 ) {
		if ( msb == 222 ) {
			def += QChar(0xA5);
			def += QChar(0xDC);
		} else if ( msb == 223 ) {
			def += QChar(0xA5);
			def += QChar(0xDD);
		} else {
			def += bab_to_char_jap_katakana( lsb - 164 );
		}
	}

	return def;
}

inline QString Babylon::bab_to_char_chinese(int lsb, int msb) {

	QString def = "";

	//Simplified Chinese
	//199: abasement
	//200: aback
	//233: anecdote
	//234: almoner
	//242: anaconda

	if ( lsb >= 161) { 
		if ( lsb == 161 || (lsb >= 163 && lsb <= 249) ) {
			def += QChar(lsb);
			def += QChar(msb);
		} else {
			def += QChar(0x3D);
			def += QChar(0x3D);
		}
	}

/*	if ( lsb == 161 ) {   //cht
		def += QChar(0xA1);
		def += QChar(msb);
		//if ( msb == 78 ) {                    //strand
		//	def += QChar(0xA1);
		//	def += QChar(0x4E);
		//}
	} else if (lsb == 162) {
		def += QChar(0x3D);
		def += QChar(0x3D);
	} else if ( lsb == 163 ) {   //cht
		def += QChar(0xA8);
		def += QChar(msb);
		//if ( msb == 200 ) {
		//	def += QChar(0xA8);
		//	def += QChar(0xC8);
		//}
	} else if ( lsb == 164 ) {   //cht
		def += QChar(0xA4);
		def += QChar(msb);
		//if ( msb == 103 ) {
		//	def += QChar(0xA4);
		//	def += QChar(0x67);
		//} else if ( msb == 104 ) {
		//	def += QChar(0xA4);
		//	def += QChar(0x68);
		//} else if ( msb == 106 ) {
		//	def += QChar(0xA4);
		//	def += QChar(0x6A);
		//} else if ( msb == 164 ) {
		//	def += QChar(0xA4);
		//	def += QChar(0xA4);
		//} else if ( msb == 172 ) {
		//	def += QChar(0xA4);
		//	def += QChar(0xAC);
		//} else if ( msb == 211 ) {
		//	def += QChar(0xA4);
		//	def += QChar(0xD3);
		//}
	} else if ( lsb == 165 ) {   //cht
		def += QChar(0xA5);
		def += QChar(msb);
		//if ( msb == 113 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0x71);
		//}
	} else if ( lsb == 166 ) {   //cht
		def += QChar(0xA6);
		def += QChar(msb);
		//if ( msb == 184 ) {
		//	def += QChar(0xA6);
		//	def += QChar(0xB8);
		//} else if ( msb == 227 ) {
		//	def += QChar(0xA6);
		//	def += QChar(0xE3);
		//}
	} else if ( lsb == 167 ) {   //cht
		def += QChar(0xA7);
		def += QChar(msb);
		//if ( msb == 192 ) {
		//	def += QChar(0xA7);
		//	def += QChar(0xC0);
		//}
	} else if ( lsb == 168 ) {   //cht
		def += QChar(0xA8);
		def += QChar(msb);
		//if ( msb == 200 ) {
		//	def += QChar(0xA8);
		//	def += QChar(0xC8);
		//} else if ( msb == 243 ) {
		//	def += QChar(0xA8);
		//	def += QChar(0xF3);
		//}
	} else if ( lsb == 169 ) {   //cht
		def += QChar(0xA9);
		def += QChar(msb);
		//if ( msb == 202 ) {
		//	def += QChar(0xA9);
		//	def += QChar(0xCA);
		//} else if ( msb == 243) {   //cht
		//	def += QChar(0xA9);
		//	def += QChar(0XF3);
		//}
	} else if ( lsb == 170 ) {   //cht
		def += QChar(0xAA);
		def += QChar(msb);
		//if ( msb == 186 ) {
		//	def += QChar(0xAA);
		//	def += QChar(0xBA);
		//} else if ( msb == 204) {   //cht
		//	def += QChar(0xAA);
		//	def += QChar(0XCC);
		//} else if ( msb == 249) {
		//	def += QChar(0xAA);
		//	def += QChar(0XF9);
		//}
	} else if ( lsb == 171 ) {   //cht
		def += QChar(0xAB);
		def += QChar(msb);
		//if ( msb == 68 ) {
		//	def += QChar(0xAB);
		//	def += QChar(0x44);
		//} else if ( msb == 225 ) {
		//	def += QChar(0xAB);
		//	def += QChar(0xE1);
		//}
	} else if ( lsb == 172 ) {   //cht
		def += QChar(0xAC);
		def += QChar(msb);
		//if ( msb == 119 ) {
		//	def += QChar(0xAC);
		//	def += QChar(0x77);
		//}
	} else if ( lsb == 173 ) {   //cht
		def += QChar(0xAD);
		def += QChar(msb);
		//if ( msb == 185 ) {
		//	def += QChar(0xAD);
		//	def += QChar(0xB9);
		//} else if ( msb == 219 ) {
		//	def += QChar(0xAD);
		//	def += QChar(0xDB);
		//}
	} else if ( lsb == 174 ) {   //cht
		def += QChar(0xAE);
		def += QChar(msb);
		//if ( msb == 230 ) {
		//	def += QChar(0xAE);
		//	def += QChar(0xE6);
		//}
	} else if ( lsb == 175 ) {   //cht
		def += QChar(0xAF);
		def += QChar(msb);
		//if ( msb == 197 ) {
		//	def += QChar(0xAF);
		//	def += QChar(0xC5);
		//}
	} else if ( lsb == 176 ) {   //cht
		def += QChar(0xB0);
		def += QChar(msb);
		//if ( msb == 115 ) {
		//	def += QChar(0xB0);
		//	def += QChar(0x73);
		//}
	} else if ( lsb == 177 ) {   //cht
		def += QChar(0xB1);
		def += QChar(msb);
		//if ( msb == 208 ) {
		//	def += QChar(0xB1);
		//	def += QChar(0xD0);
		//}
	} else if ( lsb == 178 ) {   //cht
		def += QChar(0xB2);
		def += QChar(msb);
		//if ( msb == 189 ) {
		//	def += QChar(0xB2);
		//	def += QChar(0xBD);
		//} else if ( msb == 211 ) {
		//	def += QChar(0xB2);
		//	def += QChar(0xD3);
		//}
	} else if ( lsb == 179 ) {	 //chars which occures 2 or 3 times
		def += QChar(0xB3);
		def += QChar(msb);
		//if ( msb == 98 ) {   //cht
		//	def += QChar(0xB3);
		//	def += QChar(0x62);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xF4);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 180 ) {   //cht
		def += QChar(0xB4);
		def += QChar(msb);
		//if ( msb == 76 ) {
		//	def += QChar(0xB4);
		//	def += QChar(0x4C);
		//}
	} else if ( lsb == 181 ) {   //cht
		def += QChar(0xB5);
		def += QChar(msb);
		//if ( msb == 83 ) {
		//	def += QChar(0xB5);
		//	def += QChar(0x53);
		//} else if ( msb == 223 ) {
		//	def += QChar(0xB5);
		//	def += QChar(0xDF);
		//}
	} else if ( lsb == 182 ) {
		def += QChar(0xB6);
		def += QChar(msb);
		//if ( msb == 221 ) {   //cht
		//	def += QChar(0xB6);
		//	def += QChar(0xDD);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xAC);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 183 ) {
		def += QChar(0xB7);
		def += QChar(msb);
		//if ( msb == 124 ) {   //cht
		//	def += QChar(0xB7);
		//	def += QChar(0x7C);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xAE);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 184 ) {
		def += QChar(0xB8);
		def += QChar(msb);
		//if ( msb == 199 ) {   //cht
		//	def += QChar(0xB8);
		//	def += QChar(0xC7);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xB0);
		//} else if ( msb == 223 ) {	//?
		//	def += QChar(0xA5);
		//	def += QChar(0xB1);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 185 ) {
		def += QChar(0xB9);
		def += QChar(msb);
		//if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xB2);
		//} else if ( msb == 239 ) {
		//	def += QChar(0xB9);
		//	def += QChar(0xEF);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 186 ) {
		def += QChar(0xBA);
		def += QChar(msb);
		//if ( msb == 77 ) {
		//	def += QChar(0xBA);
		//	def += QChar(0x4D);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xB4);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 187 ) {
		def += QChar(0xBB);
		def += QChar(msb);
		//if ( msb == 124 ) {   //cht
		//	def += QChar(0xBB);
		//	def += QChar(0x7C);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xB6);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 188 ) {
		def += QChar(0xBC);
		def += QChar(msb);
		//if ( msb == 175 ) {   //cht
		//	def += QChar(0xBC);
		//	def += QChar(0xAF);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xB8);
		//} else if ( msb == 246 ) {
		//	def += QChar(0xBC);
		//	def += QChar(0xF6);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 189 ) {
		def += QChar(0xBD);
		def += QChar(msb);
		//if ( msb == 119 ) {
		//	def += QChar(0xBD);
		//	def += QChar(0x77);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xBA);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 190 ) {
		def += QChar(0xBE);
		def += QChar(msb);
		//if ( msb == 109 ) {   //cht
		//	def += QChar(0xBE);
		//	def += QChar(0x6D);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xBC);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 191 ) {
		def += QChar(0xBF);
		def += QChar(msb);
		//if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xBE);
		//} else if ( msb == 242 ) {   //cht
		//	def += QChar(0xBF);
		//	def += QChar(0xF2);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 192 ) {
		def += QChar(0xC0);
		def += QChar(msb);
		//if ( msb == 100 ) {   //cht
		//	def += QChar(0xC0);
		//	def += QChar(0x64);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xC0);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 193 ) {			//without example
		def += QChar(0xC1);
		def += QChar(msb);
		//if ( msb == 97 ) {   //cht
		//	def += QChar(0xC1);
		//	def += QChar(0x61);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xC2);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 194 ) {
		def += QChar(0xC2);
		def += QChar(msb);
		//if ( msb == 180 ) {   //cht
		//	def += QChar(0xC2);
		//	def += QChar(0xB4);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xC5);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 195 ) {
		def += QChar(0xC3);
		def += QChar(msb);
		//if ( msb == 126 ) {   //cht
		//	def += QChar(0xC3);
		//	def += QChar(0x7E);
		//} else if ( msb == 198 ) {   //cht
		//	def += QChar(0xC3);
		//	def += QChar(0xC6);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xC7);
		//} else if ( msb == 246 ) {   //cht
		//	def += QChar(0xC3);
		//	def += QChar(0xF6);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 196 ) {
		def += QChar(0xC4);
		def += QChar(msb);
		//if ( msb == 199 ) {
		//	def += QChar(0xC4);
		//	def += QChar(0xC7);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xC9);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if (lsb == 197) {
		def += QChar(0xC5);
		def += QChar(msb);
		//if ( msb == 75 ) {
		//	def += QChar(0xC5);
		//	def += QChar(0x4B);
		//}
	} else if (lsb == 198) {                        //basic
		def += QChar(0xC6);
		def += QChar(msb);
		//if ( msb == 80 ) {
		//	def += QChar(0xC6);
		//	def += QChar(0x50);
		//}
	} else if ( lsb >= 199 && lsb <= 200  ) {
		def += QChar(0x3D);
		def += QChar(0x3D);
	} else if ( lsb == 201 ) {
		def += QChar(0xC8);
		def += QChar(msb);
		//if ( msb == 97 ) {                    //pant
		//	def += QChar(0xC8);
		//	def += QChar(0x61);
		//}
	} else if ( lsb == 202 ) {
		def += QChar(0x3D);
		def += QChar(0x3D);
		//if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xD0);
		//} else if ( msb == 223 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xD1);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 203 ) {
		def += QChar(0xCB);
		def += QChar(msb);
		//if ( msb == 83 ) {                  //gurgle
		//	def += QChar(0xCB);
		//	def += QChar(0x53);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xD3);
		//} else if ( msb == 223 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xD4);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 204 ) {
		def += QChar(0xCC);
		def += QChar(msb);
		//if ( msb == 97 ) {                   //headland
		//	def += QChar(0xCC);
		//	def += QChar(0x61);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xD6);
		//} else if ( msb == 223 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xD7);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 205 ) {
		def += QChar(0xCD);
		def += QChar(msb);
		//if ( msb == 97 ) {
		//	def += QChar(0xCD);
		//	def += QChar(0x61);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xD9);
		//} else if ( msb == 223 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xDA);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if ( lsb == 206 ) {
		def += QChar(0xCE);
		def += QChar(msb);
		//if ( msb == 238 ) {                  //honeyed
		//	def += QChar(0xCE);
		//	def += QChar(0xEE);
		//} else if ( msb == 222 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xDC);
		//} else if ( msb == 223 ) {
		//	def += QChar(0xA5);
		//	def += QChar(0xDD);
		//} else {
		//	def += bab_to_char_jap_katakana( lsb - 164 );
		//}
	} else if (lsb == 207) {
		def += QChar(0xCF);
		def += QChar(msb);
		//if ( msb == 69 ) {                  //pillory
		//	def += QChar(0xCF);
		//	def += QChar(0x45);
		//}
	} else if (lsb == 208) {
		def += QChar(0xD0);
		def += QChar(msb);
		//if ( msb == 85 ) {                  //slouch
		//	def += QChar(0xD0);
		//	def += QChar(0x55);
		//}
	} else if (lsb == 209) {
		def += QChar(0xD1);
		def += QChar(msb);
		//if ( msb == 182 ) {                  //poke
		//	def += QChar(0xD1);
		//	def += QChar(0xB6);
		//}
	} else if (lsb == 210) {
		def += QChar(0xD2);
		def += QChar(msb);
		//if ( msb == 178 ) {                  //plover
		//	def += QChar(0xD2);
		//	def += QChar(0xB2);
		//}
	} else if (lsb == 211) {
		def += QChar(0xD3);
		def += QChar(msb);
		//if ( msb == 125 ) {                  //nancy
		//	def += QChar(0xD3);
		//	def += QChar(0x7D);
		//}
	} else if (lsb == 212) {
		def += QChar(0xD4);
		def += QChar(msb);
		//if ( msb == 71 ) {                  //hawk
		//	def += QChar(0xD4);
		//	def += QChar(0x47);
		//}
	} else if (lsb == 213) {
		def += QChar(0xD5);
		def += QChar(msb);
		//if ( msb == 122 ) {
		//	def += QChar(0xD5);
		//	def += QChar(0x7A);
		//}
	} else if (lsb == 214) {
		def += QChar(0xD6);
		def += QChar(msb);
		//if ( msb == 185 ) {
		//	def += QChar(0xD6);
		//	def += QChar(0xB9);
		//}
	} else if (lsb == 215) {
		def += QChar(0xD7);
		def += QChar(msb);
		//if ( msb == 72 ) {                 //shin
		//	def += QChar(0xD7);
		//	def += QChar(0x48);
		//}
	} else if (lsb == 216) {
		def += QChar(0xD8);
		def += QChar(msb);
		//if ( msb == 112 ) {                 //mew
		//	def += QChar(0xD8);
		//	def += QChar(0x70);
		//}
	} else if (lsb == 217) {
		def += QChar(0xD9);
		def += QChar(msb);
		//if ( msb == 177 ) {                 //prism
		//	def += QChar(0xD9);
		//	def += QChar(0xB1);
		//}
	} else if (lsb == 218) {
		def += QChar(0xDA);
		def += QChar(msb);
		//if ( msb == 181 ) {                 //acne
		//	def += QChar(0xDA);
		//	def += QChar(0xB5);
		//}
	} else if (lsb == 219) {
		def += QChar(0xDB);
		def += QChar(msb);
		//if ( msb == 163 ) {                 //mushroom
		//	def += QChar(0xDB);
		//	def += QChar(0xA3);
		//}
	} else if (lsb == 220) {
		def += QChar(0xDC);
		def += QChar(msb);
		//if ( msb == 188 ) {                 //rickets
		//	def += QChar(0xDC);
		//	def += QChar(0xBC);
		//}
	} else if (lsb == 221) {
		def += QChar(0xDD);
		def += QChar(msb);
		//if ( msb == 220 ) {                 //rafter
		//	def += QChar(0xDD);
		//	def += QChar(0xDC);
		//}
	} else if (lsb == 222) {
		def += QChar(0xDE);
		def += QChar(msb);
		//if ( msb == 205 ) {                 //palsy
		//	def += QChar(0xDE);
		//	def += QChar(0xCD);
		//}
	} else if (lsb == 223) {
		def += QChar(0xDF);
		def += QChar(msb);
		//if ( msb == 236 ) {                 //mayfly
		//	def += QChar(0xDF);
		//	def += QChar(0xEC);
		//}
	} else if (lsb == 224) {
		def += QChar(0xE0);
		def += QChar(msb);
		//if ( msb == 72 ) {                 //pope
		//	def += QChar(0xE0);
		//	def += QChar(0x48);
		//}
	} else if (lsb == 225) {
		def += QChar(0xE1);
		def += QChar(msb);
		//if ( msb == 78 ) {                 //twitter
		//	def += QChar(0xE1);
		//	def += QChar(0x4E);
		//}
	} else if (lsb == 226) {
		def += QChar(0xE2);
		def += QChar(msb);
		//if ( msb == 192 ) {                 //reek
		//	def += QChar(0xE2);
		//	def += QChar(0xC0);
		//}
	} else if (lsb == 227) {                    //mounted
		def += QChar(0xE3);
		def += QChar(msb);
		//if ( msb == 247 ) {
		//	def += QChar(0xE3);
		//	def += QChar(0xF7);
		//}
	} else if (lsb == 228) {                    //nausea
		def += QChar(0xE4);
		def += QChar(msb);
		//if ( msb == 250 ) {
		//	def += QChar(0xE4);
		//	def += QChar(0xFA);
		//}
	} else if (lsb == 229) {
		def += QChar(0xE5);
		def += QChar(msb);
		//if ( msb == 252 ) {                 //waterlogged
		//	def += QChar(0xE5);
		//	def += QChar(0xFC);
		//}
	} else if (lsb == 230) {
		def += QChar(0xE6);
		def += QChar(msb);
		//if ( msb == 121 ) {                 //tusk
		//	def += QChar(0xE6);
		//	def += QChar(0x79);
		//}
	} else if (lsb == 231) {                    //mace
		def += QChar(0xE7);
		def += QChar(msb);
		//if ( msb == 77 ) {
		//	def += QChar(0xE7);
		//	def += QChar(0x4D);
		//}
	} else if (lsb == 232) {
		def += QChar(0xE8);
		def += QChar(msb);
		//if ( msb == 111 ) {                 //desperate
		//	def += QChar(0xE8);
		//	def += QChar(0x6F);
		//}
	} else if (lsb >= 233 && lsb <= 234) {
		def += QChar(0x3D);
		def += QChar(0x3D);
	} else if (lsb == 235) {
		def += QChar(0xEB);
		def += QChar(msb);
		//if ( msb == 166 ) {
		//	def += QChar(0xEB);
		//	def += QChar(0xA6);
		//}
	} else if (lsb == 236) {
		def += QChar(0xEC);
		def += QChar(msb);
		//if ( msb == 169 ) {                //robin
		//	def += QChar(0xEC);
		//	def += QChar(0xA9);
		//}
	} else if (lsb == 237) {
		def += QChar(0xED);
		def += QChar(msb);
		//if ( msb == 235 ) {
		//	def += QChar(0xED);
		//	def += QChar(0xEB);
		//}
	} else if (lsb == 238) {
		def += QChar(0xEE);
		def += QChar(msb);
		//if ( msb == 103 ) {                //pincer
		//	def += QChar(0xEE);
		//	def += QChar(0x67);
		//}
	} else if (lsb == 239) {
		def += QChar(0xEF);
		def += QChar(msb);
		//if ( msb == 191 ) {                //mate
		//	def += QChar(0xEF);
		//	def += QChar(0xBF);
		//}
	} else if (lsb == 240) {
		def += QChar(0xF0);
		def += QChar(msb);
		//if ( msb == 227 ) {                //revile
		//	def += QChar(0xF0);
		//	def += QChar(0xE3);
		//}
	} else if (lsb == 241) {
		def += QChar(0xF1);
		def += QChar(msb);
		//if ( msb == 70 ) {                 //rumble
		//	def += QChar(0xF1);
		//	def += QChar(0x46);
		//}
	} else if (lsb == 242) {
		def += QChar(0x3D);
		def += QChar(0x3D);
	} else if (lsb == 243) {
		def += QChar(0xF3);
		def += QChar(msb);
		//if ( msb == 240 ) {                //merle
		//	def += QChar(0xF3);
		//	def += QChar(0xF0);
		//}
	} else if (lsb == 244) {
		def += QChar(0xF4);
		def += QChar(msb);
		//if ( msb == 213 ) {                //abuse
		//	def += QChar(0xF4);
		//	def += QChar(0xD5);
		//}
	} else if (lsb == 245) {
		def += QChar(0xF5);
		def += QChar(msb);
		//if ( msb == 221 ) {                //wolverine
		//	def += QChar(0xF5);
		//	def += QChar(0xDD);
		//}
	} else if (lsb == 246) {
		def += QChar(0xF6);
		def += QChar(msb);
		//if ( msb == 227 ) {                //accumulate
		//	def += QChar(0xF6);
		//	def += QChar(0xE5);
		//}
	} else if (lsb == 247) {
		def += QChar(0xF7);
		def += QChar(msb);
		//if ( msb == 171 ) {                   //pout
		//	def += QChar(0xF7);
		//	def += QChar(0xAB);
		//}
	} else if (lsb == 248) {
		def += QChar(0xF8);
		def += QChar(msb);
		//if ( msb == 102 ) {                 //snipe
		//	def += QChar(0xF8);
		//	def += QChar(0x66);
		//}
	} else if (lsb == 249) {
		def += QChar(0xF9);
		def += QChar(msb);
		//if ( msb == 75 ) {                  //sandal
		//	def += QChar(0xF9);
		//	def += QChar(0x4B);
		//}
	} else if (lsb >= 250) {
		def += QChar(0x3D);
		def += QChar(0x3D);
	}
*/
	return def;
}

inline QString Babylon::bab_to_char_jap_hiragana(int c)   //ooo
{

		QString str[86];

		str[0]  = "?";
		str[1]  = QChar(0xA4); str[1]  += QChar(0xA2);	//160
		str[3]  = QChar(0xA4); str[3]  += QChar(0xA4);	//162
		str[4]  = "?";
		str[5]  = QChar(0xA4); str[5]  += QChar(0xA6);	//164
		str[6]  = "?";
		str[7]  = QChar(0xA4); str[7]  += QChar(0xA8);	//166
		str[8]  = "?";
		str[9]  = QChar(0xA4); str[9]  += QChar(0xAA);	//168
		str[10] = QChar(0xA4); str[10] += QChar(0xAB);	//169
		str[11] = QChar(0xA4); str[11] += QChar(0xAC);	//170
		str[12] = QChar(0xA4); str[12] += QChar(0xAD);	//171
		str[13] = QChar(0xA4); str[13] += QChar(0xAE);	//172
		str[14] = QChar(0xA4); str[14] += QChar(0xAF);	//173
		str[15] = QChar(0xA4); str[15] += QChar(0xB0);	//174
		str[16] = QChar(0xA4); str[16] += QChar(0xB1);	//175
		str[17] = QChar(0xA4); str[17] += QChar(0xB2);	//176
		str[18] = QChar(0xA4); str[18] += QChar(0xB3);	//177
		str[19] = QChar(0xA4); str[19] += QChar(0xB4);	//178
		str[20] = QChar(0xA4); str[20] += QChar(0xB5);	//179
		str[21] = QChar(0xA4); str[21] += QChar(0xB6);	//180
		str[22] = QChar(0xA4); str[22] += QChar(0xB7);	//181
		str[23] = QChar(0xA4); str[23] += QChar(0xB8);	//182
		str[24] = QChar(0xA4); str[24] += QChar(0xB9);	//183
		str[25] = QChar(0xA4); str[25] += QChar(0xBA);	//184
		str[26] = QChar(0xA4); str[26] += QChar(0xBB);	//185
		str[27] = QChar(0xA4); str[27] += QChar(0xBC);	//186
		str[28] = QChar(0xA4); str[28] += QChar(0xBD);	//187
		str[29] = QChar(0xA4); str[29] += QChar(0xBE);	//188   //ghastly //? please
		str[30] = QChar(0xA4); str[30] += QChar(0xBF);	//189
		str[31] = QChar(0xA4); str[31] += QChar(0xC0);	//190
		str[32] = QChar(0xA4); str[32] += QChar(0xC1);	//191
		str[33] = "?";
		str[34] = QChar(0xA4); str[34] += QChar(0xC3);	//193
		str[35] = QChar(0xA4); str[35] += QChar(0xC4);	//194
		str[36] = QChar(0xA4); str[36] += QChar(0xC5);	//195
		str[37] = QChar(0xA4); str[37] += QChar(0xC6);	//196
		str[38] = QChar(0xA4); str[38] += QChar(0xC7);	//197
		str[39] = QChar(0xA4); str[39] += QChar(0xC8);	//198
		str[40] = QChar(0xA4); str[40] += QChar(0xC9);	//199
		str[41] = QChar(0xA4); str[41] += QChar(0xCA);	//200
		str[42] = QChar(0xA4); str[42] += QChar(0xCB);	//201
		str[43] = QChar(0xA4); str[43] += QChar(0xCC);	//202
		str[44] = QChar(0xA4); str[44] += QChar(0xCD);	//203
		str[45] = QChar(0xA4); str[45] += QChar(0xCE);	//204
		str[46] = QChar(0xA4); str[46] += QChar(0xCF);	//205
		str[47] = QChar(0xA4); str[47] += QChar(0xD0);	//206
		str[48] = QChar(0xA4); str[48] += QChar(0xD1);	//207
		str[49] = QChar(0xA4); str[49] += QChar(0xD2);	//208
		str[50] = QChar(0xA4); str[50] += QChar(0xD3);	//209
		str[51] = QChar(0xA4); str[51] += QChar(0xC3);	//210   //gimcrack
		str[52] = QChar(0xA4); str[52] += QChar(0xD5);	//211
		str[53] = QChar(0xA4); str[53] += QChar(0xD6);	//212
		str[54] = QChar(0xA4); str[54] += QChar(0xD7);	//213
		str[55] = QChar(0xA4); str[55] += QChar(0xD8);	//214
		str[56] = QChar(0xA4); str[56] += QChar(0xD9);	//215
		str[57] = QChar(0xA4); str[57] += QChar(0xDA);	//216
		str[58] = QChar(0xA4); str[58] += QChar(0xDB);	//217
		str[59] = QChar(0xA4); str[59] += QChar(0xDC);	//218
		str[60] = QChar(0xA4); str[60] += QChar(0xDD);	//219
		str[61] = QChar(0xA4); str[61] += QChar(0xDE);	//220
		str[62] = QChar(0xA4); str[62] += QChar(0xDF);	//221
		str[63] = QChar(0xA4); str[63] += QChar(0xE0);	//222
		str[64] = QChar(0xA4); str[64] += QChar(0xE1);	//223
		str[65] = QChar(0xA4); str[65] += QChar(0xE2);	//224
		str[66] = QChar(0xA4); str[66] += QChar(0xE3);	//225
		str[67] = QChar(0xA4); str[67] += QChar(0xE4);	//226
		str[68] = QChar(0xA4); str[68] += QChar(0xE5);	//227
		str[69] = QChar(0xA4); str[69] += QChar(0xE6);	//228
		str[70] = QChar(0xA4); str[70] += QChar(0xE7);	//229
		str[71] = QChar(0xA4); str[71] += QChar(0xE8);	//230
		str[72] = QChar(0xA4); str[72] += QChar(0xE9);	//231
		str[73] = QChar(0xA4); str[73] += QChar(0xEA);	//232
		str[74] = QChar(0xA4); str[74] += QChar(0xEB);	//233
		str[75] = QChar(0xA4); str[75] += QChar(0xEC);	//234
		str[76] = QChar(0xA4); str[76] += QChar(0xED);	//235
		str[77] = "?";
		str[78] = QChar(0xA4); str[78] += QChar(0xEF);	//237
		str[79] = "?";
		str[80] = "?";
		str[81] = QChar(0xA4); str[81] += QChar(0xF2);	//240
		str[82] = QChar(0xA4); str[82] += QChar(0xF3);	//241
		str[83] = "?";
		str[84] = "?";
		str[85] = "?";

	return str[c];
}

inline QString Babylon::bab_to_char_jap_katakana(int c)   //ooo
{

		QString str[70];

		/*str[164] = QChar(0xA4); str[164] += QChar(0xA4);*/   str[0] = "";   //164     //shell
		str[1]  = QChar(0xA4);  str[1] += QChar(0xC8);   //165	//A4
		str[2]  = "!";
		str[3]  = QChar(0xA5);  str[3] += QChar(0xA1);   //167
		str[4]  = QChar(0xA5);  str[4] += QChar(0xA3);   //168
		/*str[5] = QChar(0xA4); str[5] += QChar(0xAB);*/   str[5] = "!";   //169
		str[6]  = QChar(0xA5);  str[6] += QChar(0xA7);   //170
		str[7]  = QChar(0xA5);  str[7] += QChar(0xA9);   //171
		str[8]  = QChar(0xA5);  str[8] += QChar(0xE3);   //172
		str[9]  = QChar(0xA5);  str[9] += QChar(0xE5);   //173
		str[10] = QChar(0xA5); str[10] += QChar(0xE7);   //174
		str[11] = QChar(0xA5); str[11] += QChar(0xC3);   //175
		str[12] = QChar(0xA1); str[12] += QChar(0xBC);   //176
		str[13] = QChar(0xA5); str[13] += QChar(0xA2);   //177
		str[14] = QChar(0xA5); str[14] += QChar(0xA4);   //178
		str[15] = QChar(0xA5); str[15] += QChar(0xA6);   //179
		str[16] = QChar(0xA5); str[16] += QChar(0xA8);   //180
		str[17] = QChar(0xA5); str[17] += QChar(0xAA);   //181
		str[18] = QChar(0xA5); str[18] += QChar(0xAB);   //182
		str[19] = QChar(0xA5); str[19] += QChar(0xAD);   //183
		str[20] = QChar(0xA5); str[20] += QChar(0xAF);   //184
		str[21] = QChar(0xA5); str[21] += QChar(0xB1);   //185
		str[22] = QChar(0xA5); str[22] += QChar(0xB3);   //186
		str[23] = QChar(0xA5); str[23] += QChar(0xB5);   //187
		str[24] = QChar(0xA5); str[24] += QChar(0xB7);   //188
		str[25] = QChar(0xA5); str[25] += QChar(0xB9);   //189
		str[26] = QChar(0xA5); str[26] += QChar(0xBB);   //190
		str[27] = QChar(0xA5); str[27] += QChar(0xBD);   //191
		str[28] = QChar(0xA5); str[28] += QChar(0xBF);   //192
		str[29] = QChar(0xA5); str[29] += QChar(0xC1);   //193
		str[30] = QChar(0xA5); str[30] += QChar(0xC4);   //194
		str[31] = QChar(0xA5); str[31] += QChar(0xC6);   //195
		str[32] = QChar(0xA5); str[32] += QChar(0xC8);   //196
		str[33] = QChar(0xA5); str[33] += QChar(0xCA);   //197
		str[34] = QChar(0xA5); str[34] += QChar(0xCB);   //198
		str[35] = QChar(0xA5); str[35] += QChar(0xCC);   //199
		str[36] = QChar(0xA5); str[36] += QChar(0xCD);   //200
		str[37] = QChar(0xA5); str[37] += QChar(0xCE);   //201
		str[38] = QChar(0xA5); str[38] += QChar(0xCF);   //202
		str[39] = QChar(0xA5); str[39] += QChar(0xD2);   //203
		str[40] = QChar(0xA5); str[40] += QChar(0xD5);   //204
		str[41] = QChar(0xA5); str[41] += QChar(0xD8);   //205
		str[42] = QChar(0xA5); str[42] += QChar(0xDB);   //206
		str[43] = QChar(0xA5); str[43] += QChar(0xDE);   //207
		str[44] = QChar(0xA5); str[44] += QChar(0xDF);   //208
		str[45] = QChar(0xA5); str[45] += QChar(0xE0);   //209
		str[46] = QChar(0xA5); str[46] += QChar(0xE1);   //210
		str[47] = QChar(0xA5); str[47] += QChar(0xE2);   //211
		str[48] = QChar(0xA5); str[48] += QChar(0xE4);   //212
		str[49] = QChar(0xA5); str[49] += QChar(0xE6);   //213
		str[50] = QChar(0xA5); str[50] += QChar(0xE8);   //214
		str[51] = QChar(0xA5); str[51] += QChar(0xE9);   //215
		str[52] = QChar(0xA5); str[52] += QChar(0xEA);   //216
		str[53] = QChar(0xA5); str[53] += QChar(0xEB);   //217
		str[54] = QChar(0xA5); str[54] += QChar(0xEC);   //218
		str[55] = QChar(0xA5); str[55] += QChar(0xED);   //219
		str[56] = QChar(0xA5); str[56] += QChar(0xEF);   //220
		str[57] = QChar(0xA5); str[57] += QChar(0xF3);   //221
		str[58] = "!";
		str[59] = "!";
		str[60] = "!";
		str[61] = "!";
		str[62] = "!";
		str[63] = "!";
		str[64] = "!";
		str[65] = "!";
		str[66] = "!";
		str[67] = "!";
		str[68] = "!";
		str[69] = "!";

	return str[c];
}

inline QChar Babylon::bab_to_char_heb(int c)   //ooo
{

	QChar str[] = { QChar(0xe0),QChar(0xe1),QChar(0xe2),QChar(0xe3),QChar(0xe4),QChar(0xe5),QChar(0xe6),QChar(0xe7),
			QChar(0xe8),QChar(0xe9),QChar(0xea),QChar(0xeb),QChar(0xec),QChar(0xed),QChar(0xee),QChar(0xef),
			QChar(0xf0),QChar(0xf1),QChar(0xf2),QChar(0xf3),QChar(0xf4),QChar(0xf5),QChar(0xf6),QChar(0xf7),
			//QChar(0xf8),QChar(0xf9),QChar(0xfa),        ' ',        ';',        ',',       '\'',        '.'
			QChar(0xf8),QChar(0xf9),QChar(0xfa),QChar(0x20),QChar(0x3b),QChar(0x2c),QChar(0x27),QChar(0x2e)
		};
	return str[c];

//	return "��������������������������� ;,'."[ c ] ;	// *** iso 8859-1
//	return "àáâãäåæçèéêëìíîïðñòóôõö÷øùú ;,'."[ c ] ;	// *** utf8
}

inline char Babylon::bab_to_char(int c)
{
	return "abcdefghijklmnopqrstuvwxyz* **'*"[c];
}

/* Compute a index from word's first 3 characters */
long Babylon::word_index(QString word)
{
	long idx = 0 ;
	switch(word.length()) {
		default:
			idx += word.toLatin1()[2]-'a'+2;
		case 2:
			idx += (word.toLatin1()[1]-'a'+2) *28;
		case 1:
			idx += (word.toLatin1()[0]-'a'+2) *28*28;
		case 0:
			break ;
	}
	return idx ;
}

QString Babylon::read_word_jap(uint word_length)   //ooo
{

	QString str = "";   //ooo
	QString def = "";
	Q_UINT16 data;
	int msb_store = 0;   //ooo 
	int msb_free = 1;   //ooo
	
	def.reserve( word_length ) ;   //ooo

#ifdef DEBUG_1   //ooo
	//ofstream file;
	//file.open("/home/gons/qtrans.html",ios_base::app);
	//file << " japan!!! " << endl;
	//file << "word_length = " << word_length << endl;
#endif

	while (word_length > 0) {
		data = (Q_UINT16)read_val(file_spec,2);
#ifdef DEBUG
		//cout << "&#x" << QString::number(data,16)
		//	<< "; Length: "<<word_length<<"\n";
#endif

		#ifdef DEBUG_1   //ooo
			//file << "data*** = " << data << endl;
			//file << /*"&#x"*/ "x" << QString::number(data,16) << "; Length: " << word_length << "\n";
			//file << "y" << QString::number(data & /*0x1F*/0xFF,16) << endl;
			std::cout << "word_length: " << word_length << endl;
		#endif
		if (data < 32768) {

			int lsb_1 = (int)( data & 0xFF ) ;
			int msb_1 = (int)( (data >> 8 ) & 0xFF ) ;

			#ifdef DEBUG_1   //ooo
				//file << "lsb_1:" << lsb_1 << ":x" << QString::number(lsb_1,16) << endl;
				//file << "msb_1:" << msb_1 << ":x" << QString::number(msb_1,16) << endl;
				//file << "msb_store_1 = " << msb_store ;
				std::cout << "lsb_1 = " << (int)(data & 0xFF) << endl;
				std::cout << "msb_1 = " << (int)((data >> 8 ) & 0xFF) << endl;
			#endif

			if ( msb_store != 0 ) {

				#ifdef DEBUG_1   //ooo
					//file << "lsb* = " << lsb_1 << endl;
					std::cout << "msb_store != 0 " << endl;
				#endif

				def += bab_to_char_jap_2( msb_store, lsb_1 ) ;

				if ( ( msb_store == 179 || ( ( msb_store >= 182 && msb_store <= 196 ) || ( msb_store >= 202 && msb_store <= 206 ) ) ) && lsb_1 != 222 && lsb_1 != 223 ) {
					msb_store = 0 ;
				} else if ( (msb_store == 32 && lsb_1 != 35 && lsb_1 != 40) ||
						(msb_store == 41 && lsb_1 != 32) ) {
					msb_store = 0 ;
				} else {
					msb_free = 1 ;
				}
			}

			#ifdef DEBUG_1   //ooo
				//file << "; " << msb_store << endl ;
			#endif

			if ( msb_store == 0 ) {

				#ifdef DEBUG_1   //ooo
					//file << "lsb* = " << lsb_1 << endl;
					std::cout << "msb_store == 0 " << endl;
				#endif

				str = bab_to_char_jap_2( lsb_1, msb_1 ) ;

				if ( str != "" ) {

					#ifdef DEBUG_1   //ooo
						//file << "lsb* = " << lsb_1 << endl;
						std::cout << "str != \"\" " << endl;
					#endif

					//msb is used
					def += str;
					if ( ( lsb_1 == 179 || ( ( lsb_1 >= 182 && lsb_1 <= 196 ) || ( lsb_1 >= 202 && lsb_1 <= 206 ) ) ) && msb_1 != 222 && msb_1 != 223 )
						msb_free = 1 ;
					else {
						msb_free = 0 ;
						-- word_length ;
					}
				} else {

					#ifdef DEBUG_1   //ooo
						//file << "lsb* = " << lsb_1 << endl;
						std::cout << "str == \"\" " << endl;
					#endif

					if ( lsb_1 <= 126 ) {
						def += QChar( lsb_1 );
						msb_free = 1 ;
					} else if ( ( lsb_1 >= 136 && lsb_1 <= 159 ) || ( lsb_1 >= 224 && lsb_1 <= 234 ) ) {
						def += bab_to_char_jap_2( lsb_1, msb_1 ) ;
						msb_free = 0 ;
						-- word_length ;
					} else if ( lsb_1 >= 164 ) {
						def += bab_to_char_jap_katakana( lsb_1 - 164 ) ;
						msb_free = 1 ;
					} else {
						def += "+" ;
					}
				}
				str = "";
			}

			#ifdef DEBUG_1   //ooo
				//file << "def_1 = " << def << "   Length: " << word_length << endl;
				std::cout << "msb_free = " << msb_free << endl;
			#endif

			-- word_length ;

			if ( word_length > 0 && msb_free ) {

				if ( msb_1 <= 126 ) {
					if ( msb_1 != 32 )
						def += QChar( msb_1 );
					else
						msb_store = msb_1 ;
				} else {
					def += "?";
				}
				-- word_length ;
			}

			if ( msb_1 != 32 )
				msb_store = 0 ;

		} else {
			int lsb = (int)(data & 0xFF);
			int msb = (int)((data >> 8 ) & 0xFF);

			#ifdef DEBUG_1   //ooo
				//file << "lsb:" << lsb << ":x" << QString::number(data & 0xFF,16) << endl;
				//file << "msb:" << msb << ":x" << QString::number(msb,16) << endl;
				std::cout << "lsb = " << (int)(data & 0xFF) << endl;
				std::cout << "msb = " << (int)((data >> 8 ) & 0xFF) << endl;
			#endif
	
			if ( lsb >= 32 ) {   //ooo

				#ifdef DEBUG_1   //ooo
					//file << "msb_store_2 = " << msb_store ;
				#endif

				if ( msb_store != 0 ) {

					#ifdef DEBUG_1   //ooo
						//file << "lsb* = " << lsb_1 << endl;
						std::cout << "msb_store != 0 " << endl;
					#endif

					def += bab_to_char_jap_2( msb_store, lsb ) ;
					if ( ( msb_store == 179 || ( ( msb_store >= 182 && msb_store <= 196 ) || ( msb_store >= 202 && msb_store <= 206 ) ) ) && lsb != 222 && lsb != 223 )
						msb_store = 0 ;
					else if ( (msb_store == 32 && lsb != 35 && lsb != 40) ||
							(msb_store == 41 && lsb != 32) ) {
						msb_store = 0 ;
					} else {
						msb_free = 1 ;
					}
				}

				#ifdef DEBUG_1   //ooo
					//file << "; " << msb_store << endl ;
				#endif

				//lsb will be evaluated
				if ( msb_store == 0 ) {

					#ifdef DEBUG_1   //ooo
						//file << "lsb** = " << lsb << endl;
						std::cout << "msb_store == 0 " << endl;
					#endif

					str = bab_to_char_jap_2( lsb, msb ) ;
					if ( str != "" ) {

						#ifdef DEBUG_1   //ooo
							//file << "lsb* = " << lsb_1 << endl;
							std::cout << "str != \"\" " << endl;
						#endif

						//msb is used
						def += str;
						if ( ( lsb == 179 || ( ( lsb >= 182 && lsb <= 196 ) || ( lsb >= 202 && lsb <= 206 ) ) ) && msb != 222 && msb != 223 )
							msb_free = 1 ;
						else {
							msb_free = 0 ;
							-- word_length ;
						}
					} else {
						if ( lsb <= 126 ) {
							if ( lsb != 32 )
								def += QChar( lsb );
							msb_free = 1 ;
						} else if ( ( lsb >= 136 && lsb <= 159 ) || ( lsb >= 224 && lsb <= 234 ) ) {
							def += bab_to_char_jap_2( lsb, msb ) ;
							msb_free = 0 ;
							-- word_length ;
						} else if ( lsb >= 164 ) {
							def += bab_to_char_jap_katakana( lsb - 164 ) ;
							msb_free = 1 ;
						} else {
							def += "+" ;
						}
					}
					str = "";
				}

			-- word_length ;

			} else {  // if ( lsb >= 32 )
				def += "+" ;
				-- word_length ;
			}

			if ( word_length == 0 || word_length >= 100000 )
				break ;
			//if ( word_length < 0 ) {
			//}

			#ifdef DEBUG_1   //ooo
				//file << "def_ = " << def << "   msb_free = " << msb_free << endl;
			#endif

			if ( msb >= 32 ) {

				if ( msb_free ) {
					if ( msb == 32 || msb == 41 ) {
						msb_store = msb ;
					} else if ( msb == 129 ) {
						msb_store = msb ;
					} else if ( msb == 130 ) {
						//hiragana
						msb_store = msb ;
					} else if ( ( msb >= 136 && msb <= 159 ) || ( msb >= 224 && msb <= 234 ) ) {
						//pictures
						msb_store = msb ;
					} else if ( msb == 179 || ( msb >= 182 && msb <= 196 ) || ( msb >= 202 && msb <= 206 ) ) {
						//char occurs 2 or 3 times
						msb_store = msb ;
					} else {
						if ( msb <= 126 ) {
							def += QChar( msb );
						} else if ( msb >= 164 ) {
							def += bab_to_char_jap_katakana( msb - 164 );
						} else {
							def += "+" ;
						}
						msb_store = 0 ;
					}
					-- word_length ;

					#ifdef DEBUG_1   //ooo
						//file << "msb_store_3 = " << msb_store << endl;
						std::cout << "msb_store_3 = " << msb_store << endl;
					#endif

				} else {
					msb_store = 0 ;
				}				
			} else if ( msb > 0 ) {
				def += "+" ;
			}
		}
		#ifdef DEBUG_1   //ooo
			//file << "def = " << def << endl;
		#endif
	}
#ifdef DEBUG
	//cout << def << "\n";
#endif

#ifdef DEBUG_1   //ooo
	//file << "def = " << def.length() << endl;

	//KMessageBox::about(this, tr("The <b>Menu</b> example shows how to translate "
        //                        "a word from the ComboBox."), tr("About Menu"));
	//KMessageBox::about(this, def, i18n("About Menu"));
#endif

	return def;
}

QString Babylon::read_word_chinese(uint word_length)   //ooo
{

	QString str = "";   //ooo
	QString def = "";
	Q_UINT16 data;
	int msb_store = 0;   //ooo 
	int msb_free = 1;   //ooo
	
	def.reserve( word_length ) ;   //ooo

#ifdef DEBUG_4   //ooo
	//ofstream file;
	//file.open("/home/gons/qtrans.html",ios_base::app);
	//file << " chinese_t!!! " << endl;
	//file << "word_length = " << word_length << endl;
#endif

	while (word_length > 0) {
		data = (Q_UINT16)read_val(file_spec,2);

		#ifdef DEBUG_4
			//cout << "&#x" << QString::number(data,16)
			//	<< "; Length: "<<word_length<<"\n";
			std::cout << "word_length: " << word_length << endl;
		#endif

		#ifdef DEBUG_4   //ooo
			//file << "data*** = " << data << endl;
			//file << /*"&#x"*/ "x" << QString::number(data,16) << "; Length: " << word_length << "\n";
			//file << "y" << QString::number(data & /*0x1F*/0xFF,16) << endl;
		#endif
		if (data < 32768) {

			int lsb_1 = (int)( data & 0xFF ) ;
			int msb_1 = (int)( (data >> 8 ) & 0xFF ) ;

			#ifdef DEBUG_4   //ooo
				//file << "lsb_1:" << lsb_1 << ":x" << QString::number(lsb_1,16) << endl;
				//file << "msb_1:" << msb_1 << ":x" << QString::number(msb_1,16) << endl;
				//file << "msb_store_1 = " << msb_store ;
				//std::cout << "data = " << (int)(data & 0x1F) << endl;
				std::cout << "lsb_1 = " << (int)(data & 0xFF) << endl;
				std::cout << "msb_1 = " << (int)((data >> 8 ) & 0xFF) << endl;
				//std::cout << "def** = " << bab_to_char_heb((int)(data & 0x1F)).toLatin1() << endl;
			#endif

			if ( msb_store != 0 ) {

				#ifdef DEBUG_4   //ooo
					//file << "lsb* = " << lsb_1 << endl;
					std::cout << "msb_store != 0 " << endl;
				#endif

				def += bab_to_char_chinese( msb_store, lsb_1 ) ;
				msb_free = 1 ;
			}

			#ifdef DEBUG_4   //ooo
				//file << "; " << msb_store << endl ;
			#endif

			if ( msb_store == 0 ) {

				#ifdef DEBUG_4   //ooo
					//file << "lsb* = " << lsb_1 << endl;
					std::cout << "msb_store == 0 " << endl;
				#endif

				str = bab_to_char_chinese( lsb_1, msb_1 ) ;
				if ( str != "" ) {

					#ifdef DEBUG_4   //ooo
						//file << "lsb* = " << lsb_1 << endl;
						std::cout << "str != \"\" " << endl;
					#endif

					//msb is used
					def += str;
					msb_free = 0 ;
					-- word_length ;
				} else {

					#ifdef DEBUG_4   //ooo
						//file << "lsb* = " << lsb_1 << endl;
						std::cout << "str == \"\" " << endl;
					#endif

					if ( lsb_1 <= 126 ) {
						def += QChar( lsb_1 );
						msb_free = 1 ;
					} else {
						def += "+" ;
					}
				}
				str = "";
			}

			#ifdef DEBUG_4   //ooo
				//file << "def_1 = " << def << "   Length: " << word_length << endl;
				std::cout << "msb_free = " << msb_free << endl;
			#endif

			-- word_length ;

			if ( word_length > 0 && msb_free ) {

				if ( msb_1 <= 126 ) {
					def += QChar( msb_1 );
				} else {
					def += "+";
				}
				-- word_length ;
			}

			//if ( msb_1 != 32 )
				msb_store = 0 ;

		} else {
			int lsb = (int)(data & 0xFF);
			int msb = (int)((data >> 8 ) & 0xFF);

			#ifdef DEBUG_4   //ooo
				//file << "lsb:" << lsb << ":x" << QString::number(data & 0xFF,16) << endl;
				//file << "msb:" << msb << ":x" << QString::number(msb,16) << endl;
				std::cout << "lsb = " << (int)(data & 0xFF) << endl;
				std::cout << "msb = " << (int)((data >> 8 ) & 0xFF) << endl;
			#endif
	
			if ( lsb >= 32 ) {   //ooo

				#ifdef DEBUG_4   //ooo
					//file << "msb_store_2 = " << msb_store ;
				#endif

				if ( msb_store != 0 ) {

					#ifdef DEBUG_4   //ooo
						//file << "lsb* = " << lsb_1 << endl;
						std::cout << "msb_store != 0 " << endl;
					#endif

					def += bab_to_char_chinese( msb_store, lsb ) ;
					msb_free = 1 ;
				}

				#ifdef DEBUG_4   //ooo
					//file << "; " << msb_store << endl ;
				#endif

				//lsb will be evaluated
				if ( msb_store == 0 ) {

					#ifdef DEBUG_4   //ooo
						//file << "lsb** = " << lsb << endl;
						std::cout << "msb_store == 0 " << endl;
					#endif

					str = bab_to_char_chinese( lsb, msb ) ;
					if ( str != "" ) {

						#ifdef DEBUG_4   //ooo
							//file << "lsb* = " << lsb_1 << endl;
							std::cout << "str != \"\" " << endl;
						#endif

						//msb is used
						def += str;
						msb_free = 0 ;
						-- word_length ;
					} else {
						if ( lsb <= 126 ) {
							def += QChar( lsb );
							msb_free = 1 ;
						} else {
							def += "+" ;
						}
					}
					str = "";
				}
			-- word_length ;
			} else {  // if ( lsb >= 32 )
				def += "+" ;
			}

			if ( word_length == 0 || word_length >= 100000 )
				break ;
			//if ( word_length < 0 ) {
			//}

			#ifdef DEBUG_4   //ooo
				//file << "def_ = " << def << "   msb_free = " << msb_free << endl;
			#endif

			if ( msb >= 32 ) {

				if ( msb_free ) {
					if ( msb == 161 || (msb >= 163 && msb <= 249) ) {	//Simplified Chinese: 199, 200, 233, 234, 242
						//pictures
						msb_store = msb ;
					} else {
						if ( msb <= 126 ) {
							def += QChar( msb );
						} else {
							def += "+" ;
						}
						msb_store = 0 ;
					}
					-- word_length ;

					#ifdef DEBUG_4   //ooo
						//file << "msb_store_3 = " << msb_store << endl;
						std::cout << "msb_store_3 = " << msb_store << endl;
					#endif

				} else {
					msb_store = 0 ;
				}				
			} else if ( msb > 0 ) {
				def += "+" ;
			}
		}
		#ifdef DEBUG_4   //ooo
			//file << "def = " << def << endl;
		#endif
	}
#ifdef DEBUG
	//cout << def << "\n";
#endif

#ifdef DEBUG_4   //ooo
	//file << "def = " << def.length() << endl;

	//KMessageBox::about(this, tr("The <b>Menu</b> example shows how to translate "
        //                        "a word from the ComboBox."), tr("About Menu"));
	//KMessageBox::about(this, def, i18n("About Menu"));
#endif

	return def;
}


QString Babylon::read_word_heb(uint word_length)   //ooo
{

	static QString  s1 = QChar(0xee);  s1 += QChar(0xe5);
	static QString  s2 = QChar(0xe5);  s2 += QChar(0xee);
	static QString  s3 = QChar(0xe0);  s3 += QChar(0xe5);
	static QString  s4 = QChar(0xe5);  s4 += QChar(0xe0);
	static QString  s5 = QChar(0xe0);  s5 += QChar(0xee);
	static QString  s6 = QChar(0xee);  s6 += QChar(0xe0);
	static QString  s7 = QChar(0xee);  s7 += QChar(0xec);

	static QString   s8 = QChar(0xec);   s8 += QChar(0xee);
	static QString   s9 = QChar(0xe5);   s9 += QChar(0xec);
	static QString  s10 = QChar(0xec);  s10 += QChar(0xe5);
	static QString  s11 = QChar(0xe4);  s11 += QChar(0xec);
	static QString  s12 = QChar(0xec);  s12 += QChar(0xe4);
	static QString  s13 = QChar(0xe5);  s13 += QChar(0xfa);
	static QString  s14 = QChar(0xfa);  s14 += QChar(0xe5);
	static QString  s15 = QChar(0xe9);  s15 += QChar(0xe4);

	static QString  s16 = QChar(0xf0);  s16 += QChar(0xe5);
	static QString  s17 = QChar(0xe5);  s17 += QChar(0xf0);
	static QString  s18 = QChar(0xe9);  s18 += QChar(0xee);
	static QString  s19 = QChar(0xee);  s19 += QChar(0xe9);
	static QString  s20 = QChar(0xe9);  s20 += QChar(0xec);
	static QString  s21 = QChar(0xec);  s21 += QChar(0xe9);
	static QString  s22 = QChar(0xe9);  s22 += QChar(0xf0);
	static QString  s23 = QChar(0xf0);  s23 += QChar(0xe9);

	static QString  s24 = QChar(0xe4);  s24 += QChar(0xfa);
	static QString  s25 = QChar(0xfa);  s25 += QChar(0xe4);
	static QString  s26 = QChar(0xe5);  s26 += QChar(0xe9);
	static QString  s27 = QChar(0xe9);  s27 += QChar(0xe5);
	static QString  s28 = QChar(0xe5);  s28 += QChar(0xe5);
	static QString  s29 = QChar(0xe9);  s29 += QChar(0xe9);
	static QString  s30 = QChar(0xe9);  s30 += QChar(0xed);
	static QString  s31 = QChar(0xe5);  s31 += QChar(0xed);

	static const QString compact_table[32] = {
		"XX", s1,  s2,  s3,  s4,  s5,  s6,  s7,
		  s8, s9, s10, s11, s12, s13, s14, s15,
		s16, s17, s18, s19, s20, s21, s22, s23,
		s24, s25, s26, s27, s28, s29, s30, s31
	} ;

/*	static const QString compact_table[32] = {	// *** iso 8859-1
	"XX", "��", "��", "��", "��", "��", "��", "��",		//  0 ..  7
	"��", "��", "��", "��", "��", "��", "��", "��",		//  8 .. 15
	"��", "��", "��", "��", "��", "��", "��", "��",		// 16 .. 23
	"��", "��", "��", "��", "��", "��", "��", "��"		// 24 .. 31
	} ;
*/

/*	static const QString compact_table[32] = {	// *** utf8
	"XX", "îå", "åî", "àå", "åà", "àî", "îà", "îì",		//  0 ..  7
	"ìî", "åì", "ìå", "äì", "ìä", "åú", "úå", "éä",		//  8 .. 15
	"ðå", "åð", "éî", "îé", "éì", "ìé", "éð", "ðé",		// 16 .. 23
	"äú", "úä", "åé", "éå", "åå", "éé", "éí", "åí"		// 24 .. 31
	};
*/

/*	static const char* compact_table[32] = {
	"XX", "��", "��", "��", "��", "��", "��", "��",		//  0 ..  7
	"��", "��", "��", "��", "��", "��", "��", "��",		//  8 .. 15
	"��", "��", "��", "��", "��", "��", "��", "��",		// 16 .. 23
	"��", "��", "��", "��", "��", "��", "��", "��"		// 24 .. 31
	} ;
*/
#ifdef DEBUG_3   //ooo
	ofstream file;
	file.open("/home/gons/qtrans.html",ios_base::app);
	file << " hebrew!!! " << endl;
#endif

	QString def = "";
	QString def_1 = "";   /* latin expressions */
	Q_UINT16 data;

	def.reserve( word_length ) ;

	while (word_length > 0) {
		data = (Q_UINT16)read_val(file_spec,2);

		#ifdef DEBUG_3   //ooo
			std::cout << "word_length: " << word_length << endl;
		#endif

		#ifdef DEBUG_3   //ooo
			//file << "data** = " << data << endl;
			//file << /*"&#x"*/ "x" << QString::number(data,16) << "; Length: "<< word_length << "\n";
			//file << "y" << QString::number(data & 0x1F,16) << endl;
		#endif
		if (data < 32768) {
			if (def_1 != "") {
				def += reverseString(def_1);
				def_1 = "";
			}
			def += bab_to_char_heb((int)(data & 0x1F));
			#ifdef DEBUG_3   //ooo
				//file << "def** = " << def << endl;
				std::cout << "data = " << (int)(data & 0x1F) << endl;
				std::cout << "def** = " << bab_to_char_heb((int)(data & 0x1F)).toLatin1() << endl;
				//std::cout << "def** = " << def.toLatin1() << endl;
				//file << " data = " << data << endl;
				//file << "x" << QString::number(data,16) << endl;
				//file << "y" << QString::number(data & 0x1F,16) << endl;
			#endif
			data >>= 5;
			def += bab_to_char_heb((int)(data & 0x1F));
			#ifdef DEBUG_3   //ooo
				std::cout << "data = " << (int)(data & 0x1F) << endl;
				std::cout << "def** = " << bab_to_char_heb((int)(data & 0x1F)).toLatin1() << endl;
				//file << "def** = " << def;
				//file << " data = " << data << endl;
				//file << "x" << QString::number(data,16) << endl;
				//file << "y" << QString::number(data & 0x1F,16) << endl;
			#endif
			data >>= 5;
			def += bab_to_char_heb((int)(data & 0x1F));
			#ifdef DEBUG_3   //ooo
				std::cout << "data = " << (int)(data & 0x1F) << endl;
				std::cout << "def** = " << bab_to_char_heb((int)(data & 0x1F)).toLatin1() << endl;
				//file << "x" << QString::number(data,16) << endl;
				//file << "def** = " << def;
				//file << " data = " << data << endl;
				//file << "y" << QString::number(data & 0x1F,16) << endl;
			#endif
			word_length -= 3;
		} else {
			int lsb = (int)(data & 0xFF);
			int msb = (int)((data >> 8 ) & 0x7F);

			#ifdef DEBUG_3   //ooo
				//file << "lsb:" << lsb << ":x" << QString::number(data & 0xFF,16) << endl;
				//file << "msb:" << msb << ":x" << QString::number((data >> 8) & 0x7F,16) << endl;
				std::cout << "lsb = " << lsb << endl;
				std::cout << "msb = " << msb << endl;
			#endif
	
			if (lsb >= 32) {
				if (lsb <= 126) {
					//def += (char)lsb ;
					if ((def_1 != "") && !(lsb >= 48 && lsb <= 57) && !(lsb >= 65 && lsb <= 90) && !(lsb >= 97 && lsb <= 122)) {
						def += reverseString(def_1);
						def_1 = "";
					}
						
					if (lsb == 40)              //"("
						def += QChar(41);   //")"
					else if (lsb == 41)
						def += QChar(40);
					else if (lsb == 91)         //"["
						def += QChar(93);   //"]"
					else if (lsb == 93)
						def += QChar(91);
					else if (lsb == 123)        //"{"
						def += QChar(125);  //"}"
					else if (lsb == 125)
						def += QChar(123);
					else {
						if ((lsb >= 48 && lsb <= 57) || (lsb >= 65 && lsb <= 90) || (lsb >= 97 && lsb <= 122))
							def_1 += QChar(lsb);
						else {
							if (def_1 != "") {
								def += reverseString(def_1);
								def_1 = "";
							}
							def += QChar(lsb);   //ooo
						}
					}
					#ifdef DEBUG_3   //ooo
						std::cout << "def(1a): " << QChar(lsb).toLatin1() << endl;
						//std::cout << QString("Destroying Person: %1").arg("Dilt").toLatin1() << endl;
					#endif
				} else {
					if (def_1 != "") {
						def += reverseString(def_1);
						def_1 = "";
					}
					if (lsb <= 128 + 32) {
						def += bab_to_char_heb( (int)( lsb - 128 ) ) ;
						#ifdef DEBUG_3   //ooo
							std::cout << "def(1b): " << bab_to_char_heb( (int)( lsb - 128 ) ).toLatin1() << endl;
						#endif
					} else
						def += "X" ;
				}
			-- word_length ;
			} else {
				if (def_1 != "") {
					def += reverseString(def_1);
					def_1 = "";
				}
				def += compact_table[ lsb ] ;
				#ifdef DEBUG_3   //ooo
					//std::cout << "def(1c): " << compact_table[ lsb ]/*.toLatin1()*/ << endl;
				#endif
				word_length -= 2 ;
			}

			if (word_length == 0) {
				if (def_1 != "") {
					def += reverseString(def_1);
					def_1 = "";
				}
				break ;
			}

			//if (word_length < 0) {
			//}

			if (msb >= 32) {
				if ((def_1 != "") && !(msb >= 48 && msb <= 57) && !(msb >= 65 && msb <= 90) && !(msb >= 97 && msb <= 122)) {
					def += reverseString(def_1);
					def_1 = "";
				}

				if (msb == 40)
					def += QChar(41);
				else if (msb == 41)
					def += QChar(40);
				else if (msb == 91)
					def += QChar(93);
				else if (msb == 93)
					def += QChar(91);
				else if (msb == 123)
					def += QChar(125);
				else if (msb == 125)
					def += QChar(123);
				else {
					if ((msb >= 48 && msb <= 57) || (msb >= 65 && msb <= 90) || (msb >= 97 && msb <= 122))
						def_1 += QChar(msb);
					else {
						if (def_1 != "") {
							def += reverseString(def_1);
							def_1 = "";
						}
						def += QChar(msb) ;
					}
				}
				#ifdef DEBUG_3   //ooo
					std::cout << "def(2a): " << QChar(msb).toLatin1() << endl;
				#endif
				-- word_length ;
			} else if (msb > 0) {
				if (def_1 != "") {
					def += reverseString(def_1);
					def_1 = "";
				}
				def += compact_table[ msb ] ;
				word_length -= 2 ;
			} /* Note that in hebrew, msb==0 => no output at all */

			if (word_length == 0) {
				if (def_1 != "") {
					def += reverseString(def_1);
					def_1 = "";
				}
			}
        	}
		#ifdef DEBUG_3   //ooo
			//file << "def = " << def << endl;
		#endif
	}

    return def ;
}

QString Babylon::read_word(uint word_length)
{
	static const QString compact_table[] = {
		"<0>", "ion", "ies", "ing", "ous", "ses",       /*  0 ..  5 */
		"al", "an",                                     /*  6 ..  7 */
		"at", "ed", "en", "er", "es", "ia", "ic", "ie", /*  8 .. 15 */
		"in", "io", "is", "it", "le", "ly", "ne", "on", /* 16 .. 23 */
		"or", "ra", "se", "ss", "st", "te", "ti", "th"  /* 24 .. 31 */
	};

#ifdef DEBUG_   //ooo
	ofstream file;
	file.open("/home/gons/qtrans.html",ios_base::app);
	file << " other!!! " << endl;
#endif

	QString def="";
	Q_UINT16 data;
	
	def.reserve( word_length ) ;   //ooo

	while (word_length > 0) {
		data = (Q_UINT16)read_val(file_spec,2);
#ifdef DEBUG
		//cout << "&#x" << QString::number(data,16)
		//	<< "; Length: "<<word_length<<"\n";
#endif

		#ifdef DEBUG_   //ooo
			file << "data* = " << data << endl;
			file << /*"&#x"*/"x" << QString::number(data,16) << "; Length: " << word_length << "\n";
			file << "y" << QString::number(data & 0x1F,16) << endl;
		#endif
		if (data < 32768) {
			def += bab_to_char((int)(data & 0x1F));
			data >>= 5;
			#ifdef DEBUG_   //ooo
				file << "def* = " << def;
				file << " data = " << data << endl;
				file << "x" << QString::number(data,16) << endl;
				file << "y" << QString::number(data & 0x1F,16) << endl;
			#endif
			def += bab_to_char((int)(data & 0x1F));
			data >>= 5;
			#ifdef DEBUG_   //ooo
				file << "def* = " << def;
				file << " data = " << data << endl;
				file << "x" << QString::number(data,16) << endl;
				file << "y" << QString::number(data & 0x1F,16) << endl;
			#endif
			def += bab_to_char((int)(data & 0x1F));
			#ifdef DEBUG_   //ooo
				file << "x" << QString::number(data,16) << endl;
				file << "def*** = " << def;
				file << " data = " << data << endl;
				file << "y" << QString::number(data & 0x1F,16) << endl;
			#endif
			word_length -= 3;
		} else {
			int lsb = (int)(data & 0x7F);
			int msb = (int)((data >> 8 ) & 0x7F);

			#ifdef DEBUG_   //ooo
				file << "lsb:" << lsb << ":x" << QString::number(data & 0x7F,16) << endl;
				file << "msb:" << msb << ":x" << QString::number((data >> 8) & 0x7F,16) << endl;
			#endif

			if (lsb >= 32) {
				def += QChar(lsb);
				-- word_length;
			} else if (lsb >= 6) {
				def += compact_table[lsb];
				word_length -= 2;
			} else {
				def += compact_table[lsb];
				word_length -= 3;
			}
			if (word_length == 0)
				break;
				
			if (msb >= 32) {
				def += QChar(msb);
				-- word_length;
			} else if (msb >= 6) {
				def += compact_table[msb];
				word_length -= 2;
			} else {
				def += compact_table[msb];
				word_length -= 3;
			}
		}
	}
#ifdef DEBUG
	//cout << def << "\n";
#endif
#ifdef DEBUG_   //ooo
	file << "def = " << def << endl;
#endif
	return def;
}

/*bool Babylon::translate(QString word, QList<Babylon::Item>& lst )
{
	//string::size_type   beg , end ;

	if  ( trimed_word.size() >= MAX_WORD_LENGTH ) {
		lst.clear() ;
		return true ;
	}
	for ( size_t i = 0 ; i < trimed_word.size() ; ++ i )
		trimed_word[ i ] = tolower( trimed_word[ i ] ) ;

	while ( trimed_word.length() < 3 )
		trimed_word += '_' ;

	return translate_priv(word,lst);
}*/

Item Babylon::make_definition_jap(Q_UINT32 pos)   //ooo
{
	Item def;
	file_spec.seekg(pos);

	def.attribute = "";
	for (int i=0; i<7; ++i) {
		Q_UINT8 v = (Q_UINT8)read_val(file_spec,1);
		def.attribute += "0123456789ABCDEF"[v/16];
		def.attribute += "0123456789ABCDEF"[v%16];
	}

	int sz = (Q_UINT8)read_val(file_spec,1);
	def.word = read_word(sz);
	sz = (Q_UINT8)read_val(file_spec,1);

	def.definition = read_word_jap(sz);

#ifdef DEBUG_2   //ooo
	//ofstream file;
	//file.open("/home/gons/qtrans.html",ios_base::app);
	//file << "def.word = " << def.word << endl;
	//file << "def.definition = " << def.definition << endl;
	//file << "def.definition = " << def.definition.length() << endl;
#endif

	return def;
}

Item Babylon::make_definition_chinese(Q_UINT32 pos)   //ooo
{
	Item def;
	file_spec.seekg(pos);

	def.attribute = "";
	for (int i=0; i<7; ++i) {
		Q_UINT8 v = (Q_UINT8)read_val(file_spec,1);
		def.attribute += "0123456789ABCDEF"[v/16];
		def.attribute += "0123456789ABCDEF"[v%16];
	}

	int sz = (Q_UINT8)read_val(file_spec,1);
	def.word = read_word(sz);
	sz = (Q_UINT8)read_val(file_spec,1);

	def.definition = read_word_chinese(sz);

#ifdef DEBUG_4   //ooo
	//ofstream file;
	//file.open("/home/gons/qtrans.html",ios_base::app);
	//file << "def.word = " << def.word << endl;
	//file << "def.definition = " << def.definition << endl;
	//file << "def.definition = " << def.definition.length() << endl;
#endif

	return def;
}


Item Babylon::make_definition_heb(Q_UINT32 pos)   //ooo
{
	Item def;
	file_spec.seekg(pos);

	def.attribute = "";
	for (int i=0; i<7; ++i) {
		Q_UINT8 v = (Q_UINT8)read_val(file_spec,1);
		def.attribute += "0123456789ABCDEF"[v/16];
		def.attribute += "0123456789ABCDEF"[v%16];
	}

	int sz = (Q_UINT8)read_val(file_spec,1);
	def.word = read_word(sz);
	sz = (Q_UINT8)read_val(file_spec,1);

	def.definition = read_word_heb(sz);

#ifdef DEBUG_3   //ooo
	ofstream file;
	file.open("/home/gons/qtrans.html",ios_base::app);
	//file << "def.word = " << def.word << endl;
	//file << "def.definition = " << def.definition << endl;
#endif

	return def;
}

Item Babylon::make_definition(Q_UINT32 pos)
{
	Item def;
	file_spec.seekg(pos);

	def.attribute = "";
	for (int i=0; i<7; ++i) {
		Q_UINT8 v = (Q_UINT8)read_val(file_spec,1);
		def.attribute += "0123456789ABCDEF"[v/16];
		def.attribute += "0123456789ABCDEF"[v%16];
	}

	int sz = (Q_UINT8)read_val(file_spec,1);
	def.word = read_word(sz);
	sz = (Q_UINT8)read_val(file_spec,1);

	int mask = 0;
	int c = 0;
	int prev_c;
	QString definition;

	while (sz > 0) {
		prev_c = c;
		c = (Q_UINT8)read_val(file_spec,1) ^ mask ;

		mask ^= 0x80;
		if (c == 0)
			continue ;
#ifdef DEBUG
		/*if (c==' ')
			cout << '\n';
		else
			cout << QChar(c) << "  " << QString::number(c,16) << "\n";
		*/
		//cout << QChar(c) << ": 0x" << QString::number(c,16) << ";  ";
#endif
		if ( prev_c == 0x7D ) {
			if ( c == 0XEF ) {
				definition += ",  ";
				sz -= 3;
			} else {
				definition += prev_c;
				definition += c;
				sz -= 2;
			}
		} else if (prev_c == 0x7F) {
			if (c == 0xEF) {
				definition += ". ";
				sz -= 3; // Considered as 3 chars.. Hum..
			}
		} else if (prev_c == 0xFF) {
			if (c == 0xF3) { // [FF F3]
				definition += "..;";
			} else if (c == 0xEF) { // [FF EF]
				definition += ".. ";
			} else if (c == 0xFF) { // [FF FF]
				definition += "...";
			}
			sz -= 3;
			c = 0; // 'clear previous char'
		} else if (prev_c == 0xFB) {
			if (c == 0xFF) {
				definition += "..";
				sz -= 3; // Considered as 3 chars.. Hum..
				c = 0; // 'clear previous char'
			} else {
				definition += prev_c;
				definition += c;
				sz -= 2;
			}
			continue ;
		} else if (c==0xFB || c==0xFF || c==0x7D || c==0x7F) {
			;   //wait
		} else {
			definition += c;
			--sz;
		}
	}
	if (definition == QString::null)
		def.definition = "";
	else def.definition = definition;
	return def;
}

/*-- Call translate() and format the
     output in HTML into a QString --*/
//QString Babylon::translateAndFormat(QString word)
//QString Babylon::translateAndFormat(QString word, QString dictionary)   //ooo
//QString Babylon::translateAndFormat(QString word, QString dictionary, int codec_id)   //ooo
//QString Babylon::translateAndFormat(QString word, QString dictionary, int codec_id, int direction_id)   //ooo
//QString Babylon::translateAndFormat(QString word, Dictionary item, int& lineCounter)   //ooo
QString Babylon::translateAndFormat(QString word, Dictionary item, int& lineCounter, bool wordStartsWith, bool wordContains, bool wholeWordsOnly)   //ooo
{

	#ifdef DEBUG_   //ooo
		ofstream file;
		file.open("/home/gons/qtrans.html",ios_base::app);
	#endif

	#ifdef DEBUG_   //ooo
		file << "word = " << word.length() << endl;
	#endif

	QString dictionary = item.fileName;	//ooo
	//int codec_id = item.codecID;		//ooo
	int encodingDefinition_id = item.encodingDefinitionID;		//ooo
	int direction_id = item.directionID;	//ooo
	//int encoding_id = item.encodingID;	//ooo
	int encodingExpression_id = item.encodingExpressionID;	//ooo

	QString str = dictionary.toLower();	//ooo
	QString text = "";
	lineCounter = 0;

	//QTextDocument document;		//ooo
	//QTextDocument document/*(wordExpressionString, 0)*/;			//ooo
	//QTextCursor highlightCursor/*(&document)*/;					//ooo
	//QTextCursor cursor(&document);						//ooo
	bool foundWholeWord;				//ooo

	if (str.endsWith(".dic.txt")) {	//ooo

		QByteArray encodedString;
		QTextCodec *languageCodec;
		QString wordExpressionString = "";
		QString definitionString = "";
		int word_exist = 0;
		QString line = "";

		//QFile file("in.txt");
		QFile file(dictionary);
		if (!file.open(QIODevice::ReadOnly | QIODevice::Text)) {
			return text = "error";
		}

		QTextStream in(&file);
		//in.setCodec("KOI8-R");

		// utf-8 encoded files
		if (encodingDefinition_id != 0 && encodingExpression_id == 0) {	//ooo
			in.setCodec(Codec[encodingDefinition_id].toLatin1());
			//qDebug() << word;
		}

		//QString line = in.readLine();
		line = in.readLine();

		if (direction_id) {
			text += "<p dir=\"rtl\"><b><u><a href=""tr:"+word+""">"
				+word+"</a> :</u></b></p>";
		} else {
			text += "<b><u><a href=""tr:"+word+""">"
				+word+"</a> :</u></b>";
		}

		while (!line.isNull()) {

			foundWholeWord = false;			//ooo

			wordExpressionString = line.section("\t", 0, 0);
			definitionString = line.section("\t", 1, 1);

			// iso-8859-1 encoded file
			if (encodingDefinition_id != 0 && Codec[encodingExpression_id] == "iso-8859-1") {	//ooo
				//encodedString = word_expression.toAscii();
				encodedString = wordExpressionString.toLatin1();
				languageCodec = QTextCodec::codecForName(Codec[encodingDefinition_id].toLatin1());
				wordExpressionString = languageCodec->toUnicode(encodedString);

				//encodedString = definitionString.toLatin1();
				//definitionString = codec->toUnicode(encodedString);
			}

			if (Codec[encodingExpression_id] == "cp-1255") {	//ooo
				//encodedString = word_expression.toAscii();
				encodedString = definitionString.toLatin1();
				languageCodec = QTextCodec::codecForName(Codec[encodingExpression_id].toLatin1());
				wordExpressionString = languageCodec->toUnicode(encodedString);
			}

			if (wholeWordsOnly && wordExpressionString.contains(word, Qt::CaseInsensitive)) {

				QTextDocument document(wordExpressionString, 0);		//ooo
				QTextCursor highlightCursor(&document);				//ooo
				//QTextCursor cursor(&document);					//ooo

				while (!highlightCursor.isNull() && !highlightCursor.atEnd()) {
        				highlightCursor = document.find(word, highlightCursor, QTextDocument::FindWholeWords);

        				if (!highlightCursor.isNull()) {
						foundWholeWord = true;
						break;
					}
				}
			}

			if ( (wordStartsWith && (wordExpressionString.startsWith(word, Qt::CaseInsensitive) || wordExpressionString.contains(" "+word, Qt::CaseInsensitive)))
				|| (wordContains && wordExpressionString.contains(word, Qt::CaseInsensitive))
				|| (wholeWordsOnly && /*(wordExpressionString.startsWith(word+" ", Qt::CaseInsensitive) || wordExpressionString.contains(" "+word+" ", Qt::CaseInsensitive) || wordExpressionString.endsWith(" "+word, Qt::CaseInsensitive) || ((wordExpressionString.startsWith(word, Qt::CaseInsensitive) && (wordExpressionString.size() == word.size())) || wordExpressionString.startsWith(word+"$", Qt::CaseInsensitive)) )*/ foundWholeWord /*= document.find(word, 0, QTextDocument::FindWholeWords)*/
				) ) {

				#ifdef DEBUG_4a
					qDebug() << "wordStartsWith = " << wordStartsWith << ", wordContains = " << wordContains << ", wholeWordsOnly = " << wholeWordsOnly;
				#endif

				word_exist = 1;
				lineCounter += 1;

				// iso-8859-1 encoded file
				if (encodingDefinition_id != 0 && Codec[encodingExpression_id] == "iso-8859-1") {	//ooo
					encodedString = definitionString.toLatin1();
					definitionString = languageCodec->toUnicode(encodedString);
				}

				if (definitionString.startsWith("n. ")) {						//space <-> http:/...n.com
					//definitionString.replace(QString("n. "), QString("<i>n.</i> "));
					definitionString.replace(0, 2, QString("<i>n.</i>"));
				} else if (definitionString.startsWith("v. ")) {
					definitionString.replace(0, 2, QString("<i>v.</i>"));
				} else if (definitionString.startsWith("adj. ")) {
					definitionString.replace(0, 4, QString("<i>adj.</i>"));
				} else if (definitionString.startsWith("adv. ")) {
					definitionString.replace(0, 4, QString("<i>adv.</i>"));
				} else if (definitionString.startsWith("conj. ")) {
					definitionString.replace(0, 5, QString("<i>conj.</i>"));
				} else if (definitionString.startsWith("interj. ")) {
					definitionString.replace(0, 7, QString("<i>interj.</i>"));
				} else if (definitionString.startsWith("prep. ")) {
					definitionString.replace(0, 5, QString("<i>prep.</i>"));
				} else if (definitionString.startsWith("pron. ")) {
					definitionString.replace(0, 5, QString("<i>pron.</i>"));
				}

				//if (word_expression.contains("$")) {
				//	line1.remove(word_expression.indexOf("$")+3, (word_expression.indexOf("$", -1)-word_expression.indexOf("$"))+1);
				//if (wordExpressionString.endsWith("$")) {
				//	wordExpressionString.remove(wordExpressionString.lastIndexOf("$",-3), (wordExpressionString.indexOf("$", -1)-wordExpressionString.lastIndexOf("$",-3))+1);
				//}

				if (direction_id) {
					text += "<p dir=\"rtl\"><l>"+
						//str_2(wordExpressionString)+
						wordExpressionString+
						" : </l>"+
						//str_2(definitionString)+
						definitionString+
						"</p>";
				} else {
					text += "<p class=text><l>"+
						//str_2(wordExpressionString)+
						wordExpressionString+
						" : </l>"+
						//str_2(definitionString)+
						definitionString+
						"</p>";
				}
			}

			line = in.readLine();
		}

		if (word_exist) {
			return text;
		} else {
			return "";
		}
	}

	if (str.endsWith(".ifo")) {	//ooo
		StarDict *dlg = new StarDict();
		text = dlg->printMessage();
		delete dlg;
		return text;
	}

	if (str.endsWith(".bgl")) {	//ooo

/*		QFile file_out("Babylon_bgl.txt");
		if (!file_out.open(QIODevice::WriteOnly)) {
			cout << "\n *** cannot open OUTPUT_FILE (*.txt) !!!\n";
		}
		QTextStream out(&file_out);
*/

		t.start();	//ooo

		int word_exist = 0;

		if (direction_id) {
			text += "<p dir=\"rtl\"><b><u><a href=""tr:"+word+""">"
				+word+"</a> :</u></b></p>";
		} else {
			text += "<b><u><a href=""tr:"+word+""">"
				+word+"</a> :</u></b>";
		}

		Babylon_bgl *m_babylon_bgl = new Babylon_bgl(dictionary);
		//text = m_babylon_bgl->printMessage();

		if( !m_babylon_bgl->open() )
  		{
    			printf( "Error openning %s\n", m_babylon_bgl->filename().c_str() );
			return false;
		}

		m_babylon_bgl->read();
		if( !m_babylon_bgl->read() )
		{
			printf( "Error reading %s\n", m_babylon_bgl->filename().c_str() );
			return false;
		}

		bgl_entry entry;
		entry = m_babylon_bgl->readEntry();
		QString line = "";
		QString wordExpressionString = "";
		QString	alternateExpressionString = "";		//ooo
		bool wordFound;					//ooo
		bool alternativesFound;				//ooo
		bool foundWholeAlternativeWord;			//ooo
		QString definitionString = "";
		QString str_alternates_bgl;			//ooo
		//QByteArray locallyEncoded;
		QByteArray encodedWordExpressinString;
		QByteArray encodedDefinitionEncoded;
		QByteArray encodedAlternateString;
		QTextCodec *languageCodec;
		QTextCodec *languageDefinitionCodec;

		#ifdef DEBUG_5   //ooo
			int j = 0;
			int counter = 0;
			int length = 0;
		#endif

		if (encodingExpression_id != 0) {	//ooo
			languageCodec = QTextCodec::codecForName(Codec[encodingExpression_id].toLatin1());
		}

		if (encodingDefinition_id != 0) {	//ooo
			languageDefinitionCodec = QTextCodec::codecForName(Codec[encodingDefinition_id].toLatin1());
		}

		while( entry.headword != "" )
		{

			foundWholeWord = false;			//ooo
			wordFound = false;			//ooo
			alternativesFound = false;		//ooo
			foundWholeAlternativeWord = false;	//ooo
			str_alternates_bgl = "";		//ooo
			wordExpressionString = "";
			alternateExpressionString = "";
			encodedWordExpressinString = "";
			encodedDefinitionEncoded = "";
			encodedAlternateString = "";

			wordExpressionString = entry.headword.data();

			for (int i=0; i < entry.alternates.size(); i++) {	//ooo

				str_alternates_bgl = QString(" %1 ").arg(entry.alternates[i].data());

				if (encodingExpression_id != 0) {	//ooo
					//encodedString = str_expression_bgl.toAscii();
					encodedAlternateString = str_alternates_bgl.toLatin1();
					//languageCodec = QTextCodec::codecForName(Codec[encodingExpression_id].toLatin1());
					str_alternates_bgl = languageCodec->toUnicode(encodedAlternateString);
				}

				if (str_alternates_bgl.contains(word, Qt::CaseInsensitive)) {
					alternativesFound = true;
					break;
				}
			}

			alternateExpressionString = str_alternates_bgl;	//ooo

			//if (alternateExpressionString.isEmpty()) {			//ooo
			//	alternateExpressionString = "";
			//} else {
			//	alternateExpressionString = entry.alternates[2].data();	//ooo
			//}


/*			while (!highlightCursor.isNull() && !highlightCursor.atEnd()) {
        			highlightCursor = document->find(searchString, highlightCursor, QTextDocument::FindWholeWords);

        			if (!highlightCursor.isNull()) {
					found = true;
					highlightCursor.movePosition(QTextCursor::WordRight,QTextCursor::KeepAnchor);
					highlightCursor.mergeCharFormat(colorFormat);
				}
			}
*/

			if (encodingExpression_id != 0) {	//ooo
				//encodedString = str_expression_bgl.toAscii();
				encodedWordExpressinString = wordExpressionString.toLatin1();
				//languageCodec = QTextCodec::codecForName(Codec[encodingExpression_id].toLatin1());
				wordExpressionString = languageCodec->toUnicode(encodedWordExpressinString);
			}

			wordFound = wordExpressionString.contains(word, Qt::CaseInsensitive);

			//if (wholeWordsOnly && (wordExpressionString.contains(word, Qt::CaseInsensitive) || alternativesFound) ) {
			if (wholeWordsOnly && (wordFound || alternativesFound) ) {

				if (wordFound) {

					QTextDocument document(wordExpressionString, 0);			//ooo
					QTextCursor highlightCursor(&document);					//ooo
					//QTextCursor cursor(&document);					//ooo

					while (!highlightCursor.isNull() && !highlightCursor.atEnd()) {
        					highlightCursor = document.find(word, highlightCursor, QTextDocument::FindWholeWords);

        					if (!highlightCursor.isNull()) {
							foundWholeWord = true;
							break;
						}
					}
				}

				if (!foundWholeWord && alternativesFound) { 

					QTextDocument document_alternatives(alternateExpressionString, 0);	//ooo
					QTextCursor highlightCursor_alternatives(&document_alternatives);	//ooo


					while (!highlightCursor_alternatives.isNull() && !highlightCursor_alternatives.atEnd()) {
        					highlightCursor_alternatives = document_alternatives.find(word, highlightCursor_alternatives, QTextDocument::FindWholeWords);

        					if (!highlightCursor_alternatives.isNull()) {
							foundWholeAlternativeWord = true;
							break;
						}
					}
				}
			}

//			if (wordExpressionString.contains(word, Qt::CaseInsensitive)) {
			if ( (wordStartsWith && ((wordExpressionString.startsWith(word, Qt::CaseInsensitive) || wordExpressionString.contains(" "+word, Qt::CaseInsensitive)) || (alternateExpressionString.startsWith(word, Qt::CaseInsensitive) || alternateExpressionString.contains(" "+word, Qt::CaseInsensitive))))
				|| (wordContains && (wordExpressionString.contains(word, Qt::CaseInsensitive) || alternativesFound))
				//|| (wordContains && alternateExpressionString.contains(word, Qt::CaseInsensitive))	//ooo
				|| (wholeWordsOnly && (/*(wordExpressionString.startsWith(word+" ", Qt::CaseInsensitive) || wordExpressionString.contains(" "+word+" ", Qt::CaseInsensitive) || wordExpressionString.endsWith(" "+word, Qt::CaseInsensitive) || ((wordExpressionString.startsWith(word, Qt::CaseInsensitive) && (wordExpressionString.size() == word.size())) || wordExpressionString.startsWith(word+"$", Qt::CaseInsensitive)) )*/ foundWholeWord /*= document.find(word, 0, QTextDocument::FindWholeWords)*/ || foundWholeAlternativeWord))
				) {

				word_exist = 1;
				lineCounter += 1;

				if (wordExpressionString.endsWith("$")) {

					#ifdef DEBUG_5   //ooo
						counter += 1;
						j += wordExpressionString.lastIndexOf("$",-3);
						length += (wordExpressionString.indexOf("$", -1)-wordExpressionString.lastIndexOf("$",-3))+1;
					#endif

					//wordExpressionString.remove(wordExpressionString.indexOf("$"), (wordExpressionString.indexOf("$", -1)-wordExpressionString.indexOf("$"))+1);
					wordExpressionString.remove(wordExpressionString.lastIndexOf("$",-3), (wordExpressionString.indexOf("$", -1)-wordExpressionString.lastIndexOf("$",-3))+1);
				}

				definitionString = entry.definition.data();
				//str_alternates_bgl = " *(0)* ";			//ooo
				//str_alternates_bgl += entry.alternates[0].data();	//ooo
				//str_alternates_bgl += " *(1)* ";			//ooo
				//str_alternates_bgl += entry.alternates[1].data();	//ooo
				//str_alternates_bgl += " *(2)* ";			//ooo
				//str_alternates_bgl += entry.alternates[2].data();	//ooo
				//str_alternates_bgl += " *(3)* ";			//ooo
				//str_alternates_bgl += entry.alternates[3].data();	//ooo

				str_alternates_bgl = "";	//ooo

				/*for (int i=0; i < entry.alternates.size(); i++) {	//ooo

					str_alternates_bgl += QString(" *(%1)* %2 ").arg(i).arg(entry.alternates[i].data());

					if (encodingExpression_id != 0 && i == entry.alternates.size()-1) {	//ooo
						//encodedString = str_expression_bgl.toAscii();
						encodedString = str_alternates_bgl.toLatin1();
						languageAlternateCodec = QTextCodec::codecForName(Codec[encodingExpression_id].toLatin1());
						str_alternates_bgl = languageAlternateCodec->toUnicode(encodedString);
					}

				}*/

				/*if (definitionString.startsWith("n. ")) {						//space <-> http:/...n.com
					//definitionString.replace(QString("n. "), QString("<i>n.</i> "));
					definitionString.replace(0, 2, QString("<i>n.</i>"));
				} else if (definitionString.startsWith("v. ")) {
					definitionString.replace(0, 2, QString("<i>v.</i>"));
				} else if (definitionString.startsWith("adj. ")) {
					definitionString.replace(0, 4, QString("<i>adj.</i>"));
				} else if (definitionString.startsWith("adv. ")) {
					definitionString.replace(0, 4, QString("<i>adv.</i>"));
				} else if (definitionString.startsWith("conj. ")) {
					definitionString.replace(0, 5, QString("<i>conj.</i>"));
				} else if (definitionString.startsWith("interj. ")) {
					definitionString.replace(0, 7, QString("<i>interj.</i>"));
				} else if (definitionString.startsWith("prep. ")) {
					definitionString.replace(0, 5, QString("<i>prep.</i>"));
				} else if (definitionString.startsWith("pron. ")) {
					definitionString.replace(0, 5, QString("<i>pron.</i>"));
				} else if (definitionString.startsWith("nf. ")) {
					definitionString.replace(0, 3, QString("<i>nf.</i>"));
				} else if (definitionString.startsWith("nm. ")) {
					definitionString.replace(0, 3, QString("<i>nm.</i>"));
				}*/

				if (encodingDefinition_id != 0) {	//ooo
					encodedDefinitionEncoded = definitionString.toLatin1();
					//languageDefinitionCodec = QTextCodec::codecForName(Codec[encodingDefinition_id].toLatin1());
					definitionString = languageDefinitionCodec->toUnicode(encodedDefinitionEncoded);
				}

				if (direction_id) {
					text += "<p dir=\"rtl\"><l>"+
						//str_2(wordExpressionString)+
						wordExpressionString+
						" : </l>"+
						str_2(definitionString)+
						//definitionString+
						"</p>";
				} else {
					text += "<p class=text><l>"+
						//str_2(wordExpressionString)+
						wordExpressionString+
						" : </l>"+
						str_2(definitionString)+
						//definitionString+
						//str_alternates_bgl+	//ooo
						//" <a href=\"["+str_alternates_bgl+"]\">alternates</a>"+		//ooo
						//"<font size=QString::number(Size-2)>"+str_alternates_bgl+"</font>"+	//ooo
						//"<font size=-2pt"+str_alternates_bgl+"</font>"+			//ooo
						"</p>";
				}
			}/* else {

			}*/
			entry = m_babylon_bgl->readEntry();
		}

		#ifdef DEBUG_5   //ooo
			if (counter != 0) {
				qDebug() << "text.size() = " << text.size() << " counter = " << counter << " untill first ..$ meanvalue = " << j/counter << "$..$ meanlength = " << length/counter;
			} else {
				qDebug() << "counter = " << counter;
			}
		#endif

		#ifdef DEBUG_6
			 qDebug("Time elapsed: %d ms", t.elapsed());
		#endif

		delete m_babylon_bgl;

		if (word_exist) {
			return text;
		} else {
			return "";
		}
	}

	QList<Item> *lst = new QList<Item>;
	QList<Item>::const_iterator itr;   //ooo
	
	//if (!
	//translate(word,*lst);
	translate(word, *lst, dictionary);   //ooo
	/*	cout << "Error translating!!\n";
		delete Dic;
		return;
	} */
	QString prev = "", prev_def = "";
	//Item *it;
	Item it;   //ooo
	

	//for (it = lst->first(); it!=0; it++/*=lst->next()*/) {
	for ( itr = lst->constBegin(); itr != lst->constEnd(); ++itr ) {   //ooo
		//it.attribute = (*itr).attribute();   //ooo
		QString  attribute;
		//if ( it->attribute.length() < 10 ) {
		if ( itr->attribute.length() < 10 ) {   //ooo
			return QString::null;
		}
		if (itr->attribute[3] == '8' && itr->attribute[8] == '8') {
			/* esclamazione */
			attribute = (i18n("inter."));  // interjection
		} else if (itr->attribute[3] == '2' && itr->attribute[8] == '8') {
			/* preposizione */
			attribute = (i18n("prep."));  // Preposition
		} else if ( itr->attribute[2] > '1' || itr->attribute[3] != '0'
			|| itr->attribute[4] == '8' || itr->attribute[4]=='A'
			|| itr->attribute[5]=='2') {
			/* sostantivo (s.) */
			attribute = (i18n("n."));   // Noun
		} else if ( itr->attribute[6] != '0' || itr->attribute[ 9 ] != '0' ) {
			/* verbo */
			attribute = (i18n("v."));   //  Verb
		} else if ( itr->attribute[7] != '0' ) {
			/* aggettivo (agg.) */
			attribute = (i18n("adj."));  // Adjective
		} else if ( itr->attribute[8] == '1' ) {
			/* avverbio (avv) */
			attribute = (i18n("adv."));   // Adverb
		} else if (itr->attribute[4] == '4' ||
			itr->attribute[4] == '2' || itr->attribute[8]=='8') {
			/* niente!! */
			attribute = ("");
		} else
			attribute = itr->attribute; /******** Must be "" !!!
			otherwise it display a number if cannot find the attribute
			however, for now i use it for debug */
		if (attribute!="")
			attribute = "("+attribute+") ";
			
		//if ( itr->definition.stripWhiteSpace() != "" ) {
		if ( itr->definition.trimmed() != "" ) {	//ooo
			//QString str = dictionary.lower();	//ooo
			//QString str = dictionary.toLower();	//ooo
			if ( prev != itr->word ) {
				//if ( itr != lst->/*getFirst()*/takeFirst() ) {
				//	text += "</p><hr align=center><p>";
				//}
				//else text += "src=\"/home/mat/documenti/img/it.png\">";
				if (str.endsWith("engtoheb.dic")) {					//ooo
					//text += "<p align=right><b><u><a href=""tr:"+itr->word+""">"	//ooo
						//+itr->word+"</a> :</u></b></p>";   //ooo
					//text += "<p dir=\"rtl\"><b><u>"+itr->word+" :</u></b></p>";   //ooo
					text += "<p dir=\"rtl\"><b><u><a href=""tr:"+itr->word+""">"	//ooo
						+itr->word+"</a> :</u></b></p>";			//ooo
					prev=itr->word;							//ooo
				} else if (str.endsWith("engtojpn.dic")){				//ooo
					//text += "<b>" +itr->word+ " :</b>";				//ooo
					//text += "<b><u>" +itr->word+ " :</u></b>";			//ooo
					text += "<b><u><a href=""tr:"+itr->word+""">"			//ooo
						+itr->word+"</a> :</u></b>";				//ooo
					prev=itr->word;							//ooo
				} else {								//ooo
					text += "<b><u><a href=""tr:"+itr->word+""">"
						+itr->word+"</a> :</u></b>";
					prev=itr->word;
				}									//ooo
			}
			if (prev_def != itr->definition) {
				#ifdef DEBUG_   //ooo
					file << "itr->definition = " << itr->definition.length() << endl;
				#endif
				if (str.endsWith("engtoheb.dic")) {  //ooo
					QTextCodec *hebrewCodec = QTextCodec::codecForName("ISO8859-8");	//ooo
						//QString locallyEncoded2 = itr->definition;
					QByteArray locallyEncoded2 = itr->definition.toAscii();
						//QString def_text = reverseString(it->definition);
					QString unicodeString2 = hebrewCodec->toUnicode( locallyEncoded2 );
						//delete hebrewCodec;	//ooo
						//QString str2 = reverseString(unicodeString2);

					#ifdef DEBUG_3   //ooo
						//file << "it->definition = " << it->definition << endl;
						//file << "unicodeString2 = " << unicodeString2 << endl;
						//file << "str2 = " << str2 << endl;
					#endif

					//text += "<p class=text align=right><i>"+attribute+"</i></p>"
//						"<p class=text align=right>"+str2+"</p>";
						//"<p dir=\"rtl\">"+str_2(str2)+"</p>";   //it works!!!
					text += "<p dir=\"rtl\"><i>"+attribute+"</i>"
					//text += "<p align=right><i>"+attribute+"</i>"
//						"<p class=text align=right>"+str2+"</p>";
						//+str_2(str2)+"</p>";
						+str_2(unicodeString2)+"</p>";
				} else if (str.endsWith("engtojpn.dic")) {  //ooo
					QTextCodec *japanCodec = QTextCodec::codecForName("eucJP");	//ooo
					//QString locallyEncoded3 = itr->definition;
					QByteArray locallyEncoded3 = itr->definition.toAscii();
					QString unicodeString3 = japanCodec->toUnicode( locallyEncoded3 );
					//delete japanCodec;	//ooo

					#ifdef DEBUG_2   //ooo
						//file << "it->definition = " << it->definition << endl;
						//file << "unicodeString3 = " << unicodeString3.length() << endl;
					#endif

					text += "<p class=text><i>"+attribute+"</i>"+
						//reverseString(
						str_2(unicodeString3)+//":"+str_2(locallyEncoded3)+
						"</p>";
					#ifdef DEBUG_2
						//file << "text = " << text.length() << endl;
					#endif
				} else if (str.endsWith("engtocht.dic")) {  //ooo
					QTextCodec *chinese_t_Codec = QTextCodec::codecForName("big5");		//ooo
					//QString locallyEncoded3 = itr->definition;
					QByteArray locallyEncoded4 = itr->definition.toAscii();
					QString unicodeString4 = chinese_t_Codec->toUnicode( locallyEncoded4 );
					//delete *chinese_t_Codec;	//ooo

					#ifdef DEBUG_4   //ooo
						//file << "it->definition = " << it->definition << endl;
						//file << "unicodeString4 = " << unicodeString4.length() << endl;
					#endif

					text += "<p class=text><i>"+attribute+"</i>"+
						//reverseString(
						str_2(unicodeString4)+//":"+str_2(locallyEncoded3)+
						"</p>";
					#ifdef DEBUG_4
						//file << "text = " << text.length() << endl;
					#endif
				} else if (str.endsWith("engtochs.dic")) {					//ooo
					QTextCodec *chinese_s_Codec = QTextCodec::codecForName("gbk");		//ooo
					//QString locallyEncoded3 = itr->definition;
					QByteArray locallyEncoded5 = itr->definition.toAscii();
					QString unicodeString5 = chinese_s_Codec->toUnicode( locallyEncoded5 );
					//delete chinese_s_Codec;	//ooo

					#ifdef DEBUG_5   //ooo
						//file << "it->definition = " << it->definition << endl;
						//file << "unicodeString4 = " << unicodeString4.length() << endl;
					#endif
					text += "<p class=text><i>"+attribute+"</i>"+
						//reverseString(
						str_2(unicodeString5)+//":"+str_2(locallyEncoded3)+
						"</p>";
					#ifdef DEBUG_5
						//file << "text = " << text.length() << endl;
					#endif
				} else {   //ooo
					text += "<p class=text><i>"+attribute+"</i>"+
						//reverseString(
						str_2(itr->definition)+
						"</p>";
				}   //ooo
				prev_def = itr->definition;
			}
		#ifdef DEBUG_   //ooo
			QString def_text = it->definition;
			QString unicodeString = hebrewCodec->toUnicode( def_text.latin1() );
			file << "unicodeString = " << unicodeString.utf8().data() << endl;
		#endif
		}
	}
#ifdef DEBUG_   //ooo
	file << "Babylon::translateAndFormat" << endl;
	file << "text = " << text.length() << endl;
	//QString locallyEncoded = hebrewCodec->toUnicode( text.latin1() );
	//file << "locallyEncoded = " << locallyEncoded << endl;
	//QString unicodeString = codec->toUnicode( text.latin1() );
	//text = unicodeString.utf8().data();
        file.close();
#endif
	delete lst;   //ooo

	return text;
}

//bool Babylon::translate(QString word, QList<Item> &lst)
bool Babylon::translate(QString word, QList<Item> &lst, QString dictionary)   //ooo
{
	Q_UINT32 main_index;
	Q_UINT32 idx_idx, idx_def;
	int wc;
	uint byte_to_skip;
	
	word = word.toLower();
	while (word.length() < 3)
		word += '_' ;

	/* 1) Compute main index .. */
	main_index = 100 + 4 * word_index(word);

	/* 2) .. then seek to both file */
	file_eng.seekg(main_index);
	file_spec.seekg(main_index);
	
	/* 3) Read corresponding indexes */
	idx_idx = read_val(file_eng,4);
	idx_def = read_val(file_spec,4);
	if (idx_def == read_val(file_spec,4))
		return false ;

	file_eng.seekg(idx_idx);
	
	Q_UINT8 min_size, max_size;
	min_size = (Q_UINT8)read_val(file_eng,1);
	max_size = (Q_UINT8)read_val(file_eng,1);

#ifdef DEBUG_   //ooo
	ofstream file;
	file.open("/home/gons/qtrans.html",ios_base::app);
	//file << "min_size = " << min_size << endl;
	//file << "max_size = " << max_size << endl;
	//file << "word.length() = " << word.length() << endl;
#endif

	if ((word.length() < min_size) || (word.length() > max_size))
		return false;

	Q_UINT16 nw ; /* number of word */

	wc = 0 ;
	byte_to_skip = 0 ;
	for (uint i=min_size; i<word.length(); ++i) {
		nw = (Q_UINT16)read_val(file_eng,2);
		wc += nw ;
		byte_to_skip += (i-3) *nw;
	}
	nw = (Q_UINT16)read_val(file_eng,2);
	byte_to_skip += (max_size - word.length())*2;

	file_eng.seekg(byte_to_skip,ifstream::cur);
	
	//Q_UINT8 n8;
	/* Search word index */
	for (int i=0; i<(int)nw; ++i) {
		uint j=3;
		/*do {
			*stream_eng >> n8;
			j++;
		} while ((j < word.length()) && (word[j] == n8));*/
		for ( j=3;
		((j < word.length()) && (word[j] == (Q_UINT8)read_val(file_eng,1)));
		 ++j)
		;
		if ( j == word.length() ) {
			Q_UINT32 def ;
			file_spec.seekg(idx_def + 4 * wc);
			def = read_val(file_spec,4);
				
			if (def & 0xFF000000) { /* Another definition reference */
				main_index = 100 + 4 * ((def >> 16) & 0xFFFF);
				file_spec.seekg(main_index);
				idx_def = read_val(file_spec,4);
					
				file_spec.seekg(idx_def + 4 * (def & 0xFFFF));
				def = read_val(file_spec,4);
			}

			Item *current = new Item;
			QString str = dictionary.toLower();   						//ooo

			if ( str.endsWith("engtoheb.dic") ) {						//ooo
				*current = make_definition_heb(def);					//ooo
			} else if ( str.endsWith("engtojpn.dic") ) {					//ooo
				*current = make_definition_jap(def);					//ooo
			} else if ( str.endsWith("engtocht.dic") || str.endsWith("engtochs.dic") ) {	//ooo
				*current = make_definition_chinese(def);				//ooo
			} else {									//ooo
				*current = make_definition(def);
			}

#ifdef DEBUG_   //ooo
	file << "Babylon::translate" << endl;
	file << "current->definition = " << current->definition.length() << endl;
	//file << "dictionary = " << dictionary << endl;
#endif
			//lst.append(current);
			lst.append(*current);	//ooo

			delete current;		//ooo

		} else {
			/* A character has been read without j incremented */
			file_eng.seekg(word.length() -j -1, ifstream::cur);
		}
		++ wc ;
	}
	return true ;
}

#include "babylon.moc"
