/***************************************************************************
                          qtrans.cpp  -  description
                             -------------------
    begin                : December 2007
    copyright            : (c) 2007 by Roland Suchan
    email                : vmp@arcor.de
    license              : GPL v 2.0
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This file is part of QTrans.                                          *
 *                                                                         *
 *   QTrans is free software; you can redistribute it and/or modify        *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 *   QTrans is distributed in the hope that it will be useful,             *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with QTrans. If not, see <http://www.gnu.org/licenses/> or      *
 *   write to the Free Software Foundation, Inc.,                          *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.         *
 *                                                                         *
 ***************************************************************************/

#include <KApplication>
#include <KAction>
#include <KLocale>

#include <KAboutApplicationDialog>

#include <KDebug>
#include <KMessageBox>

#include <KStandardShortcut>
#include <KIcon>
//#include <KHTMLView>
#include <KWindowSystem>
#include <KToolBarPopupAction>

//#include <kdialog.h>		//ooo
#include <kconfiggroup.h>	//ooo

//#include "babylon.h"
#include "qtrans.h"
#include "settings.h"		//ooo
//#include "settings_widg.h"	//ooo
//#include "html_widget.h"	//ooo   view()
#include "utils.h"

//#define DEBUG_1
//#define DEBUG_2
//#define DEBUG_3
//#define DEBUG_4
//#define DEBUG_4a
//#define DEBUG_4b

//#define DEBUG_4c
//#define DEBUG_4d

QTrans::QTrans(QWidget *parent, KAboutData *aboutData) : KMainWindow(parent)
{
	Par_aboutData = aboutData;

	bab_dict = new QList<Dictionary>;

	//Out = new Html_Widget(this, this);

	Out = new Html_Widget(this);
	//centralWidget = new Previewer(this);	//ooo
	/*QWebView **///view = new QWebView(this);	//ooo


	languageMenu = new QMenu(this);
	//languageGroup = new QActionGroup(this);		//ooo

	readConfig();

	//setMinimumSize(160, 160);
	//resize(600, 230);

	progressBar = new QProgressBar(this);	//ooo
	progressBar->setRange(0, 100);		//ooo
	progressBar->setMaximumSize(100, 16);	//ooo
	//progressBar->setMaximumWidth(100);	//ooo
	progressBar->hide();			//ooo

	connect(Out, SIGNAL(loadProgress(int)), progressBar, SLOT(show()));		//ooo
	connect(Out, SIGNAL(loadProgress(int)), progressBar, SLOT(setValue(int)));	//ooo
	connect(Out, SIGNAL(loadFinished(bool)), progressBar, SLOT(hide()));		//ooo

	createActions();
	createMenus();
	createTrayIcon();
	setupActions();
	createStatusBar();	//ooo

	//kapp->setTopWidget( this );

	//HelpMenu = new KHelpMenu(this, aboutDataFunction());
	HelpMenu = new KHelpMenu(this, aboutData);

	//HelpMenu = new KMenu(this);
	KAction *helpAct = new KAction(KIcon("help-contents"), i18n("&Contents"), this);
	KAction *reportBugAct = new KAction(/*KIcon("tools-report-bug"),*/ i18n("&Report Bug..."), this);
	KAction *aboutApplicationAct = new KAction(KIcon("help-about"/*"qtrans"*/), i18n("&About QTrans"), this);
	KAction *aboutKdeAct = new KAction(KIcon("kde"), i18n("About &KDE"), this);

	connect(helpAct, SIGNAL(triggered()), SLOT(slot_Help()));
	connect(reportBugAct, SIGNAL(triggered()), HelpMenu, SLOT(reportBug()));
	//connect(aboutApplicationAct, SIGNAL(triggered()), HelpMenu, SLOT(aboutApplication()));
	connect(aboutApplicationAct, SIGNAL(triggered()), this, SLOT(slot_About()));
	connect(aboutKdeAct, SIGNAL(triggered()), HelpMenu, SLOT(aboutKDE()));

	KAction *translateAct = new KAction(KIcon(/*"qtrans"*/"view-refresh"), i18n("&Translate"),this);
	KAction *settingsAct = new KAction(KIcon("configure"), i18n("&Settings"), this);
	KAction *exitAct = new KAction(KIcon("window-close"), i18n("&Exit"/*"&Close"*/), this);

	connect(translateAct, SIGNAL(triggered(bool)), SLOT(slot_Ok()));
	connect(settingsAct, SIGNAL(triggered(bool)), SLOT(slot_Config()));
	connect(exitAct, SIGNAL(triggered(bool)), SLOT(slot_Quit()));
	//KStandardAction::quit(kapp, SLOT(quit()), actionCollection());

	copyAct = new QAction(tr("&Copy"), this);
	copyAct->setShortcut(tr("Ctrl+C"));
	copyAct->setStatusTip(tr("Copy the current selection's contents to the "
                             "clipboard"));
	//connect(copyAct, SIGNAL(triggered()), Out/*this*/, SLOT(sack()));

	ToolBar = new KToolBar(this);
	ToolBar->setToolButtonStyle(Qt::ToolButtonIconOnly);

/*	progressBar = new QProgressBar(this);	//ooo
	progressBar->setMaximumWidth(100);	//ooo

	connect(Out,SIGNAL(loadProgress(int)),progressBar,SLOT(setValue(int)));	//ooo
*/
	//progressBar->setValue(50);	//ooo

	//menubar = new QMenuBar(this);	//ooo

	//helpMenu = new QMenu(this);	//ooo
	//helpMenu = menuBar()->addMenu(tr("&Help"));	//ooo

	//menubar->addMenu(helpMenu);	//ooo

	//connect( aboutAct, SIGNAL(triggered()), HelpMenu, SLOT(aboutApplication())); //ooo
	//connect( aboutAct, SIGNAL(triggered()), this, SLOT(slot_About()));

	combo = new QComboBox( this );
	combo->setStyleSheet("QComboBox{font: 14px;}");		//ooo
	combo->setEditable( true );
	combo->setMinimumContentsLength(15);
	combo->setInsertPolicy(QComboBox::InsertAtTop);

	//connect(combo,SIGNAL(returnPressed(const QString&)),   //KComboBox
	//			this,SLOT(slot_Combo(const QString&)));

	//connect(combo, SIGNAL(activated(const QString&)), this, SLOT(slot_Combo(const QString&)));			//QComboBox
	//connect(combo, SIGNAL(currentIndexChanged(const QString&)), this, SLOT(slot_Combo(const QString&)));		//ooo
	//connect(combo, SIGNAL(editTextChanged(const QString&)), this, SLOT(slot_Combo(const QString&)));		//ooo

	connect(combo, SIGNAL(currentIndexChanged(int)), this, SLOT(slot_Combo_2(int)));				//ooo
	connect(combo, SIGNAL(activated(int)), this, SLOT(slot_Combo_3(int)));						//ooo
	//connect(combo, SIGNAL(highlighted(int)), this, SLOT(slot_Combo_4(int)));					//ooo

	KToolBarPopupAction* helpPopupAct = new KToolBarPopupAction(KIcon("help-browser"), i18n("&Help"), this);
	helpPopupAct->menu()->addAction(helpAct);
	helpPopupAct->menu()->addSeparator();
	helpPopupAct->menu()->addAction(reportBugAct);
	helpPopupAct->menu()->addSeparator();
	helpPopupAct->menu()->addAction(aboutApplicationAct);
	helpPopupAct->menu()->addAction(aboutKdeAct);
	//helpPopupAct->menu()->addMenu(HelpMenu);
	//connect( helpPopupAct, SIGNAL(triggered()), this, SLOT(slot_About()));
	//connect( helpPopupAct, SIGNAL(triggered()), this, SLOT(slot_About()));

	ToolBar->addAction(translateAct);
	ToolBar->addAction(helpPopupAct);
	//ToolBar->addAction(helpAct);
	ToolBar->addAction(settingsAct);
	ToolBar->addAction(exitAct);
	ToolBar->addSeparator();
	ToolBar->addWidget(combo);
	ToolBar->addSeparator();		//ooo
	//ToolBar->addWidget(progressBar);	//ooo

/*	Out->setFont(fontType.family(), fontType.pointSize(), Charset);
	Out->bgColor = bgColor;
	Out->txtColor = txtColor;
	Out->expressionTxtColor = expressionTxtColor;	//ooo
	Out->sentencePartTxtColor = sentencePartTxtColor;	//ooo
*/
	//Out->setFont(fontType.family(), fontType.pointSize(), Charset);
	Out->setFont(fontType.family(), fontType.pointSize(), fontType.style(), fontType.weight(), Charset);	//ooo
	Out->bgColor = bgColor;
	Out->txtColor = txtColor;
	Out->expressionTxtColor = expressionTxtColor;	//ooo
	Out->sentencePartTxtColor = sentencePartTxtColor;	//ooo

	//setCentralWidget(Out->view());
	//setCentralWidget(view->view());	//ooo
	setCentralWidget(Out);	//ooo

	//view->load(QUrl("/work6b/_download/_qtrans/_html/_QWebView/_1/forum-83-274609-2568557-qt-4-4-xcode-ne-reconnait-pas-qwebview.html"));	//ooo
	//view->show();	//ooo
	//setCentralWidget(view);	//ooo

	//textEdit = new QTextEdit;	//ooo
	//setCentralWidget(textEdit);	//ooo
	//setCentralWidget(centralWidget);	//ooo
	//Out->clear();
	Out->clear();	//ooo

	if (stayOnTop) {
		stayOnTop = false;
		slot_OnTop();
	}

	if (wordStartsWith) {			//ooo
		wordStartsWith = false;
		slot_WordStartsWith();
	} else if (wholeWordsOnly) {		//ooo
		wholeWordsOnly = false;
		slot_WholeWordsOnly();
	} else {
		wordContains = true;		//ooo
	}

	//comboCurrentIndexChanged = false;	//ooo
	comboActivatedIndexStack = 0;		//ooo

	//translate if a word is copied to clipboard
	clip = kapp->clipboard();
	connect(clip,SIGNAL(dataChanged()),this,SLOT(slot_ClipChanged()));
	Prev_Clip = clip->text();

	Dock = new SystemTray(this/*, aboutData*/);
	if (DockIcon)
		Dock->show();

	/*-- Needed for catching selection in Gtk widgets --*/
	Time = new QTimer(this);
	connect(Time,SIGNAL(timeout()),this,SLOT(slot_ClipChanged()));
	//Time->start(1000,false);
	Time->start(1000);
	enabled = true;
	if (compactMode) {
		compactMode = false;
		toggleMode();
	}

/*	connect(trayIcon, SIGNAL(messageClicked()), this, SLOT(messageClicked()));
	connect(trayIcon, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
            this, SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));

	connect(Dock, SIGNAL(messageClicked()), SLOT(messageClicked()));
	connect(Dock, SIGNAL(activated(QSystemTrayIcon::ActivationReason)),
            this, SLOT(iconActivated(QSystemTrayIcon::ActivationReason)));
*/
	trayIcon->setIcon(KIcon("qtrans"));

}


QTrans::~QTrans()
{
}


void QTrans::slot_Copy()
{
//infoLabel->setText(tr("Invoked <b>Edit|Copy</b>"));
	KMessageBox::sorry(this, i18n("copy()!"));
	std::cout << "I'm in!" << endl;
}


void QTrans::createStatusBar()			//ooo
{
	if (StatusBarSelected) {
		QMainWindow::statusBar()->showMessage(tr("Ready"));
		QMainWindow::statusBar()->insertPermanentWidget(0, progressBar, 0);
	}

/*	if (Dic != NULL) {
		QMainWindow::statusBar()->showMessage(tr("Ready"));
	} else {
		QMainWindow::statusBar()->showMessage("Time elapsed: %d ms", Dic->t.elapsed());
	}
*/
}


void QTrans::mousePressEvent(QMouseEvent *event)	//ooo
{
/*	KMessageBox::sorry(this, i18n("mousePressEvent!"));
        if (event->y() <25) {
                //isDraged=true;
                xPos=event->globalX();
                yPos=event->globalY();
		KMessageBox::sorry(this, i18n("mousePressEvent (1)!"));
        }
	std::cout << "I'm in!" << endl;
*/
        if (event->y() < 25 && event->x() > 350) {

		if ( QContextMenuEvent::Mouse) {
			KMessageBox::sorry(this, i18n("mousePressEvent!"));	
		}

		QList<Dictionary>::const_iterator itr;	//ooo

		languageGroup = new QActionGroup(this);

		int i = 0;

		for (itr = bab_dict->constBegin(); itr != bab_dict->constEnd(); ++itr) {
			if ((*itr).disableID) {
				actionsList.at(i)->setVisible(false);
			}
			//languageMenu->addAction(actionsList.at(i));
			languageGroup->addAction(actionsList.at(i));
			i++;
		}

/*		for (int i = 0; i < actionsList.size(); i++) {
			//languageMenu->addAction(actionsList.at(i));
			//languageGroup->addAction(actionsList.at(i));

		}
*/

		connect(languageGroup, SIGNAL(triggered(QAction *)), this, SLOT(chooseLibrary(QAction *)));

		//languageMenu->addSeparator();
		//languageMenu->addAction(copyAct);
		languageMenu->addSeparator();
		if (compactMode) {
			languageMenu->addAction(normalModeAct);
		} else {
			languageMenu->addAction(compactModeAct);
		}
		languageMenu->addAction(stayOnTopAct);
		//languageMenu->addSeparator();
		languageMenu->addAction(wordStartsWithAct);	//ooo
		languageMenu->addAction(wholeWordsOnlyAct);	//ooo
		languageMenu->addAction(searchAllAct);		//ooo
		languageMenu->addAction(searchEveryDictAct);	//ooo
		languageMenu->addSeparator();
		if (enabled) {
			languageMenu->addAction(Dock->disableAct);
		} else {
			languageMenu->addAction(Dock->enableAct);
		}

		languageMenu->exec(event->globalPos());

		delete languageGroup;
	}

}


/*-- Translate a QString and Update the View --*/
//void QTrans::Translate(QString EngWord, int ind)
void QTrans::Translate(QString EngWord, int ind, bool allDict, bool inEveryDict)	//ooo
{

	QString strStatusBar;		//ooo
	QString strTimeElapsed;		//ooo
	QString text_check;		//ooo
	int comboIndex = -1;		//ooo
	NumOfLines = 0;
	QString text = "";
	QList<Dictionary>::const_iterator itr;   //ooo

	//QMessageBox::about(this, tr("About Diagram Scene"), tr("Translate(: 1"));
	//Out->clear();

	if (StatusBarSelected) {			//ooo
		QMainWindow::statusBar()->showMessage(tr("Ready"));
	}

	//Out->clear();	//ooo

	//Babylon *Dic = new Babylon();
	Dic = new Babylon();			//ooo

	if (bab_dict->count()==0) {
		KMessageBox::sorry(this,i18n("No dictionary is defined"));
		return;
	}

	Dictionary Item = bab_dict->at(ind);

	if (allDict) {

		t.start();	//ooo

		//for (int i = 0; i < actionsList.size(); i++) {
		for ( itr = bab_dict->constBegin(); itr != bab_dict->constEnd(); ++itr ) {   //ooo

			//Dictionary Item = bab_dict->at(i);

			#ifdef DEBUG_4b
				qDebug() << "English_Path = " << English_Path << " itr->fileName = " << itr->fileName;
			#endif

			if ( inEveryDict ) {
				if (!Dic->open(English_Path,itr->fileName)) {
					KMessageBox::sorry(this, i18n("Could not open the dics!"));
					return;
				}

				text_check = Dic->translateAndFormat(EngWord, *itr, NumOfLines, wordStartsWith, wordContains, wholeWordsOnly);   //ooo

				if (text_check != "") {

					text += "<p>"+(*itr).fileName.section("/", -1)+"</p>";
					//text += Dic->translateAndFormat(EngWord, *itr, NumOfLines, wordStartsWith, wordContains, wholeWordsOnly);   //ooo
					text += text_check;
					//text += "<hr>";
					text += "<hr width=5 size=1 align=left>";
					//text += "<p><spacer type=vertical size=30></p>";
					text_check = "";
				}

				Dic->file_eng.close();
				Dic->file_spec.close();
			} else {

				if ( (*itr).disableID ) {
					;
				} else {
					if (!Dic->open(English_Path,itr->fileName)) {
						KMessageBox::sorry(this, i18n("Could not open the dics!"));
						return;
					}

					text_check = Dic->translateAndFormat(EngWord, *itr, NumOfLines, wordStartsWith, wordContains, wholeWordsOnly);   //ooo

					if (text_check != "") {

						text += "<p>"+(*itr).fileName.section("/", -1)+"</p>";
						//text += Dic->translateAndFormat(EngWord, *itr, NumOfLines, wordStartsWith, wordContains, wholeWordsOnly);   //ooo
						text += text_check;
						//text += "<hr>";
						text += "<hr width=5 size=1 align=left>";
						//text += "<p><spacer type=vertical size=30></p>";
						text_check = "";
					}

					Dic->file_eng.close();
					Dic->file_spec.close();
				}
			}
		}

	} else {


		//Dictionary Item = bab_dict->at(ind);

		#ifdef DEBUG_4b
			qDebug() << "English_Path = " << English_Path << " Item.fileName = " << Item.fileName;
		#endif


		if (!Dic->open(English_Path,Item.fileName)) {
			KMessageBox::sorry(this, i18n("Could not open the dics!"));
			return;
		}

		t.start();	//ooo

		#ifdef DEBUG_4a
			qDebug() << "wordStartsWith = " << wordStartsWith << ", wordContains = " << wordContains << ", wholeWordsOnly = " << wholeWordsOnly;
		#endif

		//QString text= Dic->translateAndFormat(EngWord);
		//QString text = Dic->translateAndFormat(EngWord, Item.fileName);   //ooo
		//QString text = Dic->translateAndFormat(EngWord, Item.fileName, Item.codecID);   //ooo
		//QString text = Dic->translateAndFormat(EngWord, Item.fileName, Item.codecID, Item.directionID);   //ooo
		//QString text = Dic->translateAndFormat(EngWord, Item, NumOfLines);   //ooo
		text = Dic->translateAndFormat(EngWord, Item, NumOfLines, wordStartsWith, wordContains, wholeWordsOnly);   //ooo

	}

	if (text==QString::null)
		return;
	if (AutoPopUp && text != "")
		Popup();
	else if (!isVisible())
		return;
	delete Dic;

	//QMainWindow::statusBar()->showMessage("Time elapsed: %d ms", t.elapsed());	//ooo

/*	strStatusBar = "Time elapsed: ";			//ooo
	strStatusBar += strTimeElapsed.setNum(t.elapsed());	//ooo
	strStatusBar += " ms";					//ooo
*/
	//strStatusBar.sprintf("Time elapsed: %d ms	%s", t.elapsed(), "Dictionary Name");	//ooo

	if (StatusBarSelected) {
		//strStatusBar = QString("Time elapsed: %1 ms %2 %3").arg(t.elapsed()).arg("	").arg(Item.fileName.section("/", -1));		//ooo
		//strStatusBar = QString("Time elapsed: %1 ms %2 %3 %4 %5 %6").arg(t.elapsed()).arg(" * ").arg(Item.fileName.section("/", -1)).arg(" * ").arg("Number of lines: ").arg(NumOfLines);		//ooo
		strStatusBar = QString("Time elapsed: %1 ms %2 %3 %4 Number of lines: %6").arg(t.elapsed()).arg(" * ").arg(Item.fileName.section("/", -1)).arg(" * ").arg(NumOfLines);		//ooo
		//strStatusBar = QString("Time elapsed: %1 ms * %2 * Number of lines: %3").arg(t.elapsed()).arg(Item.fileName.section("/", -1)).arg(NumOfLines);		//ooo
		QMainWindow::statusBar()->showMessage(strStatusBar);	//ooo
		//QMainWindow::statusBar()->addWidget(progressBar);	//ooo
	}

	#ifdef DEBUG_4
		qDebug() << "Item.fileName: " << Item.fileName;
	#endif

	//QMessageBox::about(this, tr("About Diagram Scene"), tr("Translate(: 2"));
	//Out->setOut(text);
	Out->setOut(text);	//ooo

	//QMainWindow::statusBar()->showMessage("Time elapsed: %d ms", t.elapsed());	//ooo

	if ( isVisible() && (EngWord != combo->currentText()) ) {

		comboIndex = combo->findText(EngWord, Qt::MatchCaseSensitive);	//ooo

		#ifdef DEBUG_4d
			qDebug() << "comboIndex (Translate) = " << comboIndex;
		#endif

		if (comboIndex == -1) {				//ooo
			combo->insertItem(0, EngWord);
			combo->setCurrentIndex(0);
		} else {
			//combo->removeItem(comboIndex);
			combo->setCurrentIndex(comboIndex);
		}

		//combo->insertItem(0, EngWord);
		   //combo->setCurrentItem(0);   //KComboBox
		//combo->setCurrentIndex(0);
	}

	if ( combo->count() > 10 )
		combo->removeItem(10);
}


void QTrans::slot_Quit()
{
	//QMessageBox::about(this, tr("About Diagram Scene"), tr("slot_Quit(: 1"));
	close();
}


/*--Monitor the Clipboard and try to translate its content --*/
void QTrans::slot_ClipChanged()
{
	//QString S = clip->text();
	//S = clip->text();

	QString S = "";	//ooo

	if (!MouseSelected) {	//ooo
		// text is retrieved from the global clipboard
		//S = QApplication::clipboard()->text(QClipboard::Clipboard);
		S = clip->text();
	} else {
		//global mouse selection
		//S = QApplication::clipboard()->text(QClipboard::Selection);
		S = clip->text(QClipboard::Selection);
	}

	if ((S!=NULL) && (S!=Prev_Clip)) {
		Prev_Clip = S;
		Translate(tr_str(S));
	}
}


void QTrans::contextMenuEvent(QContextMenuEvent *event)
{
/*
	if ( QContextMenuEvent::Mouse) {
		KMessageBox::sorry(this, i18n("mousePressEvent!"));	
	}

	languageGroup = new QActionGroup(this);

	for (int i = 0; i < actionsList.size(); ++i) {
		languageMenu->addAction(actionsList.at(i));
		languageGroup->addAction(actionsList.at(i));
	}

	connect(languageGroup, SIGNAL(triggered(QAction *)), this, SLOT(chooseLibrary(QAction *)));

	languageMenu->addSeparator();
	languageMenu->addAction(copyAct);
	languageMenu->addSeparator();
	if (compactMode)
		languageMenu->addAction(normalModeAct);
	else
		languageMenu->addAction(compactModeAct);
	languageMenu->addAction(stayOnTopAct);
	languageMenu->addSeparator();
	if (enabled)
		languageMenu->addAction(Dock->disableAct);
	else
		languageMenu->addAction(Dock->enableAct);

	languageMenu->exec(event->globalPos());

	delete languageGroup;
*/
	//std::cout << "I'm in!" << endl;

/*	Out->languageGroup1 = new QActionGroup(this);

	for (int i = 0; i < actionsList.size(); ++i) {
		Out->popMenu->addAction(actionsList.at(i));
		Out->languageGroup1->addAction(actionsList.at(i));
	}

	connect(Out->languageGroup1, SIGNAL(triggered(QAction *)), this, SLOT(chooseLibrary(QAction *)));

	Out->popMenu->addSeparator();
	if (compactMode)
		Out->popMenu->addAction(normalModeAct);
	else
		Out->popMenu->addAction(compactModeAct);
	Out->popMenu->addAction(stayOnTopAct);
	Out->popMenu->addSeparator();
	if (enabled)
		Out->popMenu->addAction(disableAct);
	else
		Out->popMenu->addAction(enableAct);

	Out->popMenu->exec(event->globalPos());

	delete Out->languageGroup1;
*/
}


void QTrans::setupActions()
{
}


void QTrans::createActions()
{
	normalModeAct = new QAction( KIcon("view-fullscreen"), i18n("&Normal mode"), this );
	compactModeAct = new QAction( KIcon("view-restore"), i18n("&Compact Mode"), this );

	stayOnTopAct = new QAction( i18n("&Stay on Top"), this );
	stayOnTopAct->setCheckable(true);

	wordStartsWithAct = new QAction( i18n("&Word begins with ..."), this );				//ooo
	wordStartsWithAct->setCheckable(true);

	wholeWordsOnlyAct = new QAction( i18n("&Whole words only"), this );				//ooo
	wholeWordsOnlyAct->setCheckable(true);

	searchAllAct = new QAction( KIcon("edit-find"), i18n("&Look up in all dic"), this );		//ooo
	searchEveryDictAct = new QAction( KIcon("system-search"), i18n("&Look up in hidden too"), this );	//ooo

	disableAct = new QAction( i18n("&Disable"), this );
	enableAct = new QAction( i18n("&Enable"), this );

	connect( compactModeAct, SIGNAL(triggered()), SLOT(toggleMode()) );
	connect( normalModeAct, SIGNAL(triggered()), SLOT(toggleMode()) );
	connect( stayOnTopAct, SIGNAL(triggered()), SLOT(slot_OnTop()) );

	connect( wordStartsWithAct, SIGNAL(triggered()), SLOT(slot_WordStartsWith()) );			//ooo
	connect( wholeWordsOnlyAct, SIGNAL(triggered()), SLOT(slot_WholeWordsOnly()) );			//ooo

	connect( searchAllAct, SIGNAL(triggered()), SLOT(slot_searchInAllDictionaries()) );		//ooo
	connect( searchEveryDictAct, SIGNAL(triggered()), SLOT(slot_searchInEveryDictionary()) );	//ooo

	connect( disableAct, SIGNAL(triggered()), SLOT(slot_Enable()) );
	connect( enableAct, SIGNAL(triggered()), SLOT(slot_Enable()) );

	//connect( disableAct, SIGNAL(triggered()), SLOT(disable_application()) );
	//connect( enableAct, SIGNAL(triggered()), SLOT(enable_application()) );

	trayExitAct = new QAction( KIcon("application-exit"), i18n("&Exit"), this );
	connect( trayExitAct, SIGNAL(triggered()), SLOT(slot_Exit()) );

	//aboutAct = new QAction( KIcon("qtrans"), i18n("&About QTrans"), this );
	//connect( aboutAct, SIGNAL(triggered()), SLOT(slot_About()) );

	trayAboutAct = new QAction( KIcon("help-about"/*"qtrans"*/), i18n("&About QTrans"), this );
	connect( trayAboutAct, SIGNAL(triggered()), SLOT(slot_About()) );

	configAct = new QAction( KIcon("configure"), i18n("&Settings"/*"&Configure"*/), this );
	connect( configAct, SIGNAL(triggered()), SLOT(slot_Config()) );
}


void QTrans::createMenus()
{/*
    fileMenu = menuBar()->addMenu(tr("&File"));
    fileMenu->addAction(exitAction);

    itemMenu = menuBar()->addMenu(tr("&Item"));
    itemMenu->addAction(deleteAction);
    itemMenu->addSeparator();
    itemMenu->addAction(toFrontAction);
    itemMenu->addAction(sendBackAction);
*/
/*
    aboutMenu = menuBar()->addMenu(tr("&Help"));
    aboutMenu->addAction(aboutAction);
    aboutMenu->addAction(aboutQtAct);
    aboutMenu->addAction(aboutKDEAct);
*/
}


/*-- Switch to compact mode or return to normal --*/
void QTrans::toggleMode()
{
	int w, h;

	if (!compactMode) {
		KWindowSystem::setType(winId(),NET::PopupMenu);
		hide();
		show();
		w = Out->/*view()->*/width();
		h = Out->/*view()->*/height();
		ToolBar->hide();

		if (StatusBarSelected) {			//ooo
			QMainWindow::statusBar()->hide();
			resize(w, h + ToolBar->height()+QMainWindow::statusBar()->height());
		} else {
			resize(w, h + ToolBar->height());
		}

		compactMode = true;
		compactModeAct->setVisible(false);
		normalModeAct->setVisible(true);
	} else {
		w = width();
		h = height();
		KWindowSystem::setType(winId(),NET::Normal);
		hide();
		show();
		ToolBar->show();

		if (StatusBarSelected) {			//ooo
			QMainWindow::statusBar()->show();
			QMainWindow::statusBar()->showMessage(tr("Ready"));
		}

		resize(w,h);
		compactMode = false;
		compactModeAct->setVisible(true);
		normalModeAct->setVisible(false);
	}
}


void QTrans::slot_OnTop()
{
	if (!stayOnTop) {
		KWindowSystem::activateWindow(winId());
		stayOnTop = true;
		stayOnTopAct->setChecked(true);
	} else {
		KWindowSystem::forceActiveWindow(winId());
		stayOnTop = false;
		stayOnTopAct->setChecked(false);
	}
}


void QTrans::slot_WordStartsWith()	//ooo
{
	if (!wordStartsWith) {
		wordStartsWith = true;
		wordContains = false;
		wholeWordsOnly = false;
		wordStartsWithAct->setChecked(true);
		wholeWordsOnlyAct->setChecked(false);
	} else {
		wordStartsWith = false;
		wordContains = true;
		wholeWordsOnly = false;
		wordStartsWithAct->setChecked(false);
		wholeWordsOnlyAct->setChecked(false);
	}
}


void QTrans::slot_WholeWordsOnly()	//ooo
{
	if (!wholeWordsOnly) {
		wordStartsWith = false;
		wordContains = false;
		wholeWordsOnly = true;
		wordStartsWithAct->setChecked(false);
		wholeWordsOnlyAct->setChecked(true);
	} else {
		wordStartsWith = false;
		wordContains = true;
		wholeWordsOnly = false;
		wordStartsWithAct->setChecked(false);
		wholeWordsOnlyAct->setChecked(false);
	}
}


void QTrans::slot_Combo(const QString &Str)
{
	Translate(Str);
}


void QTrans::slot_Combo_2(int comboIndex)	//ooo
{

	#ifdef DEBUG_4c
		qDebug() << "comboIndex               = " << comboIndex;
		qDebug() << "combo->currentIndex()    = " << combo->currentIndex();
		qDebug() << "combo->currentText()     = " << combo->currentText();
		qDebug() << "comboCurrentIndexChanged = " << comboCurrentIndexChanged;
		qDebug() << "translationExecuted      = " << translationExecuted;
		qDebug() << "combo->count()           = " << combo->count();
	#endif

	translationEnabled = false;

	switch (comboIndex) {
		case 0:
			if (combo->count() >=2  && !comboCurrentIndexChanged) {
				translationExecuted = false;	//translation of first element in comboBox if combo->count() >= 2
				break;
			}

			if (combo->count() == 1) {		//first entry in combo

				#ifdef DEBUG_4c
					qDebug() << "   * Translate *(1)* ";
				#endif

				Translate(combo->itemText(comboIndex));
				translationExecuted = true;
				break;
			}

			if (comboCurrentIndexChanged) {

				#ifdef DEBUG_4c
					qDebug() << "   ** Translate *(2)* ";
				#endif

				Translate(combo->itemText(comboIndex));
				translationExecuted = true;
				comboCurrentIndexChanged = false;
				break;
			}

			break;
		case 1:
			comboCurrentIndexChanged = true;	//important by entering new words into the comboBox manually
			translationExecuted = false;
			break;
		default:
			//comboCurrentIndexChanged = true;
			translationExecuted = false;
	}

/*	if (comboIndex > 0) {
		//combo->insertItem(0, combo->itemText(comboIndex));
		   //combo->addItem(combo->itemText(comboIndex));
		//combo->removeItem(comboIndex+1);
		//combo->setCurrentIndex(0);
		combo->setCurrentIndex(comboIndex);
		//Translate(combo->itemText(0));
		Translate(combo->itemText(comboIndex));
	}
*/
	#ifdef DEBUG_4c
		//qDebug() << "comboCurrentIndexChanged = " << comboCurrentIndexChanged;
		qDebug() << "translationExecuted      = " << translationExecuted;
		qDebug() << "   slot_Combo_2(END)";
	#endif

}


void QTrans::slot_Combo_3(int comboActivatedIndex)	//ooo
{

	#ifdef DEBUG_4c
		qDebug() << "comboActivatedIndexStack = " << comboActivatedIndexStack;
		qDebug() << "comboActivatedIndex      = " << comboActivatedIndex;
		qDebug() << "translationExecuted      = " << translationExecuted;
		qDebug() << "**************************";
		//qDebug() << "combo->currentIndex() = " << combo->currentIndex();
		//qDebug() << "combo->currentText() = " << combo->currentText();
	#endif

	if (translationEnabled && comboActivatedIndexStack == comboActivatedIndex) {
		Translate(combo->itemText(comboActivatedIndex));
	}

	if (!translationExecuted && comboActivatedIndexStack == comboActivatedIndex) {	//first after the second passage is executed

		#ifdef DEBUG_4c
			qDebug() << "   *** Translate *(3)* ";
		#endif

		Translate(combo->itemText(comboActivatedIndex));
		translationExecuted = true;
		translationEnabled = true;
	}

	if (!translationExecuted /*&& comboActivatedIndex >= 0*/) {	//an entry >= 1 chosen
		comboActivatedIndexStack = comboActivatedIndex;
	}

	if (translationExecuted) {					//(word chosen from combo + enter) + enter + enter + ..
		translationExecuted = false;
	}

	comboCurrentIndexChanged = false;

	#ifdef DEBUG_4c
		qDebug() << "comboActivatedIndexStack = " << comboActivatedIndexStack;
		qDebug() << "comboActivatedIndex      = " << comboActivatedIndex;
		qDebug() << "translationExecuted      = " << translationExecuted;
		qDebug() << "translationEnabled       = " << translationEnabled;
		qDebug() << "slot_Combo_3(END)";
		qDebug() << "                 ";
	#endif
}


void QTrans::slot_Combo_4(int comboHighlightedIndex)	//ooo
{
	#ifdef DEBUG_4c
		qDebug() << "slot_Combo_4(BEGIN)";
		qDebug() << "comboHighlightedIndex    = " << comboHighlightedIndex;
	#endif


	#ifdef DEBUG_4c
		qDebug() << "slot_Combo_4(END)";
		qDebug() << "                 ";
	#endif
}


/*-- Intercept the Close Event and decide
  if had to close or minimize --*/
void QTrans::closeEvent(QCloseEvent *event)
//void QTrans::closeEvent(QEvent *event)
{
/*
	if (!isVisible() || (!DontClose))
		slot_Exit();
	else if (DockIcon) hide();
		else showMinimized();
*/
/*	if (!isVisible() || (!DontClose)) {
		QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 1"));

		#ifdef DEBUG_3   //ooo
			ofstream file;
			file.open("/home/gons/qtrans.html",ios_base::app);
			file << " *** !!! " << endl;
		#endif

		slot_Exit();
	//} else if (trayIcon->isVisible() && DockIcon) {
	} else if (DockIcon) {
		QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 2"));
		hide();
		//showMinimized();
		//event->ignore();   //otherwise trayIcon disappear too
	} else {
		QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 3"));
		//showMinimized();
	}

	event->ignore();
*/
/*	if (!DontClose) {
		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 1"));
		slot_Exit();
		//event->ignore();
		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 1a"));
	} else if (DockIcon) {
		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 3"));
		hide();
		//event->ignore();
	} else {
		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 4"));
		if (isMinimized()) {
			//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 5"));
			slot_Exit();
		} else {
			showMinimized();
			//event->ignore();
		}
	}
*/

/*	e->ignore();
	if(!Settings::enableSystemTray()) {
		slotQuit();
	}
	else {
		hide();
	}
*/
	//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 2"));

	//event->ignore();
	//event->accept();
	if (!DockIcon) {
		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 2a"));
		if (!kapp->sessionSaving()) {
			event->ignore();
		}
		slot_Exit();
	//} else if (!menuQuit && !kapp->sessionSaving()) {
	} else if (!kapp->sessionSaving()) {

		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 2b"));

		hide();
		event->ignore();
	} else if (kapp->sessionSaving()) {

		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 2c"));

		KConfigGroup cg( KGlobal::config().data(), "QTrans" );
		if ( cg.readEntry("size",QSize(420, 120)) != this->size() ) {
			cg.writeEntry("size", this->size());
		}
		if ( cg.readEntry("compactMode",false) != compactMode ) {
			cg.writeEntry("compactMode",compactMode);
		}
		if ( cg.readEntry("stayOnTop",false) != stayOnTop ) {
			cg.writeEntry("stayOnTop",stayOnTop);
		}
		if ( cg.readEntry("wordStartsWith",false) != wordStartsWith ) {		//ooo
			cg.writeEntry("wordStartsWith",wordStartsWith);
		}
		if ( cg.readEntry("wholeWordsOnly",false) != wholeWordsOnly ) {		//ooo
			cg.writeEntry("wholeWordsOnly",wholeWordsOnly);
		}
		cg.sync();

		//if (event->KeyPress)
		//	hide();
		//else
		//	event->accept();
		//}
		//event->ignore();
	}


/*	if (DontClose) {   //minimize
		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 1"));
		if (isMinimized() || !isVisible()) {
			slot_Exit();
		} else {
			showMinimized();
		}
	} else {
		QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 2"));
		if (DockIcon) {
			QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 2a"));

			KConfigGroup cg( KGlobal::config().data(), "QTrans" );

			//if ( (cg.readEntry("size",QSize(420, 120)) != this->size()) 
			//	|| (cg.readEntry("compactMode",false) != compactMode)
			//	|| (cg.readEntry("stayOnTop",false) != stayOnTop) ) {
			//	cg.writeEntry("size", this->size());
			//	cg.writeEntry("compactMode",compactMode);
			//	cg.writeEntry("stayOnTop",stayOnTop);
			//}

			if ( cg.readEntry("size",QSize(420, 120)) != this->size() ) {
				cg.writeEntry("size", this->size());
			}
			if ( cg.readEntry("compactMode",false) != compactMode ) {
				cg.writeEntry("compactMode",compactMode);
			}
			if ( cg.readEntry("stayOnTop",false) != stayOnTop ) {
				cg.writeEntry("stayOnTop",stayOnTop);
			}

			cg.sync();

			hide();

		} else {
			slot_Exit();
		}
	}

	event->ignore();
*/

	//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 6"));

/*	if (DockIcon) {
		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 1"));
		hide();
		event->ignore();   //otherwise trayIcon disappear too
	//} else if (DontClose) {
		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 1"));
	} else {
		//QMessageBox::about(this, tr("About Diagram Scene"), tr("closeEvent(: 2"));
		slot_Exit();
	}
*/
}


/*-- Save size and exit --*/
void QTrans::slot_Exit(bool ask)
{
	//QMessageBox::about(this, tr("About Diagram Scene"), tr("slot_Exit(: 1"));

	//if (DockIcon || (!DockIcon && !DontClose)) {
	if (DockIcon /*|| (!DockIcon && !kapp->sessionSaving())*/) {
		//QMessageBox::about(this, tr("About Diagram Scene"), tr("slot_Exit(: 1a ask = %1").arg(ask));
		if (ask && KMessageBox::warningContinueCancel(this,
			i18n("<qt>Are you sure you want to quit <b>QTrans</b>?</qt>"),
			i18n("Confirm Quit From System"), KStandardGuiItem::cont(),
			KStandardGuiItem::cancel(), i18n("Do not ask again")) == KMessageBox::Cancel) {
			//QMessageBox::about(this, tr("About Diagram Scene"), tr("slot_Exit(: 1b"));
			return;
		}
	}

	//QMessageBox::about(this, tr("About Diagram Scene"), tr("slot_Exit(: 2"));

	KConfigGroup cg( KGlobal::config().data(), "QTrans" );

	cg.writeEntry("size", this->size());
	cg.writeEntry("compactMode",compactMode);
	//settings.setValue("enabled",enabled);
	cg.writeEntry("stayOnTop",stayOnTop);
	cg.writeEntry("wordStartsWith",wordStartsWith);		//ooo
	cg.writeEntry("wholeWordsOnly",wholeWordsOnly);		//ooo

	cg.sync();

/**************/
/*	QSettings settings("MySoft", "Qtrans");

	settings.beginGroup("QTrans");
	settings.setValue("size", this->size());
	settings.setValue("compactMode",compactMode);
	//settings.setValue("enabled",enabled);
	settings.setValue("stayOnTop",stayOnTop);
	settings.endGroup();
*/
	//QMessageBox::about(this, tr("About Diagram Scene"), tr("slot_Exit(: 2"));

	if (!DockIcon && kapp->sessionSaving()) {

	} else {
		kapp->quit();
	}
}


/*-- PopUp the main window --*/
void QTrans::Popup()
{
	//QMessageBox::about(this, tr("About Diagram Scene"), tr("Popup(: 1"));
	if ( !KWindowSystem::windowInfo( winId(), NET::WMDesktop ).isOnCurrentDesktop() ) {
		KWindowSystem::setOnDesktop(winId(),KWindowSystem::currentDesktop());
	}

	show();

	if (hideTask) {
		KWindowSystem::setState(winId(),NET::SkipTaskbar);
		//QMessageBox::about(Par, tr("About Diagram Scene"), tr("Popup(: 2a"));
	} else {
		KWindowSystem::clearState(winId(),NET::SkipTaskbar);
		//QMessageBox::about(Par, tr("About Diagram Scene"), tr("Popup(: 2b"));
	}

	if (!stayOnTop) {
		KWindowSystem::activateWindow(winId());
	} else {
		KWindowSystem::forceActiveWindow(winId());
	}
}


/*-- Enable and disable the ClipBoard monitoring --*/
void QTrans::slot_Enable()
{
	KStandardDirs sd;
	QString IconPath = sd.findResource("icon","highcolor/16x16/apps/qtrans-disabled.png");
	if (enabled) {
		trayIcon->setIcon(KIcon("qtrans-disabled"));
		//Dock->setIcon(KIcon("qtrans-disabled"));   //SystemTray
		disableAct->setVisible(false);
		enableAct->setVisible(true);
		Dock->disableAct->setVisible(false);   //SystemTray
		Dock->enableAct->setVisible(true);
		enabled=false;
		disconnect(clip,SIGNAL(dataChanged()),this,SLOT(slot_ClipChanged()));
		disconnect(Time,SIGNAL(timeout()),this,SLOT(slot_ClipChanged()));
		setCaption(i18n("(disabled)"));
	} else {
		trayIcon->setIcon(KIcon("qtrans"));
		//Dock->setIcon(KIcon("qtrans"));   //SystemTray
		disableAct->setVisible(true);
		enableAct->setVisible(false);
		Dock->disableAct->setVisible(true);   //SystemTray
		Dock->enableAct->setVisible(false);
		enabled=true;
		Prev_Clip = clip->text();
		connect(clip,SIGNAL(dataChanged()),this,SLOT(slot_ClipChanged()));
		connect(Time,SIGNAL(timeout()),this,SLOT(slot_ClipChanged()));
		setCaption(i18n("QTrans"));
	}
	trayIcon->setContextMenu(trayIconMenu);
}

/*
void QTrans::iconActivated(QSystemTrayIcon::ActivationReason reason)
{
#ifdef DEBUG_1   //ooo
	ofstream file;
	std::cout << "iconActivated( " << endl;
#endif
	QMessageBox::about(this, tr("About Diagram Scene"), tr("iconActivated(: 0"));
	switch (reason) {
	case QSystemTrayIcon::Trigger:
		if ( isVisible() ) {
			hide();
		} else {
			if ( !KWindowSystem::windowInfo(winId(), NET::WMDesktop).isOnCurrentDesktop() ) {
				KWindowSystem::setOnDesktop(winId(), KWindowSystem::currentDesktop());
			}
			//show();
			QMessageBox::about(this, tr("About Diagram Scene"), tr("iconActivated(: 1"));
			if (hideTask) {
				KWindowSystem::setState(winId(),NET::SkipTaskbar);
				QMessageBox::about(this, tr("About Diagram Scene"), tr("iconActivated(: 2a"));
			} else {
				KWindowSystem::clearState(winId(),NET::SkipTaskbar);
				QMessageBox::about(this, tr("About Diagram Scene"), tr("iconActivated(: 2b"));
			}
			//show();
			KWindowSystem::activateWindow(winId());
		}
		break;
	case QSystemTrayIcon::DoubleClick:
		//iconComboBox->setCurrentIndex((iconComboBox->currentIndex() + 1)
		//                              % iconComboBox->count());
//		if ( !KWindowSystem::windowInfo(winId(), NET::WMDesktop).isOnCurrentDesktop() ) {
//			KWindowSystem::setOnDesktop(winId(), KWindowSystem::currentDesktop());
//		}
//		KWindowSystem::activateWindow(winId());
//		break;
	case QSystemTrayIcon::MiddleClick:
		//showMessage();
		break;
	case QSystemTrayIcon::Context:
		//trayIcon->showMessage(tr("QTrans"), tr("Babylon translator"), QSystemTrayIcon::Information, 10000);
		break;
	default:
        	break;
	}
}
*/

void QTrans::chooseLibrary(QAction *action)
{
	for (int i = 0; i < actionsList.size(); ++i) {
		if (action == actionsList.at(i)) {
			Translate(combo->currentText(), i);
			break;
		}
	}
}


void QTrans::slot_searchInAllDictionaries()
{
	/*for (int i = 0; i < actionsList.size(); ++i) {
		Translate(combo->currentText(), i);
	}*/
	Translate(combo->currentText(), 0, true, false);
}


void QTrans::slot_searchInEveryDictionary()
{
	/*for (int i = 0; i < actionsList.size(); ++i) {
		Translate(combo->currentText(), i);
	}*/
	Translate(combo->currentText(), 0, true, true);
}


void QTrans::slot_About()
{
	KAboutApplicationDialog *dlg = new KAboutApplicationDialog(Par_aboutData, this);
	dlg->setInitialSize(QSize(350, 350));
	//dlg->show();
	dlg->exec();
	delete dlg;
}


void QTrans::slot_aboutKDE()
{
	//KAboutKDE *aDial = new KAboutKDE(this,"aDial");
	//KAboutKdeDialog *aDial = new KAboutKdeDialog(this,"aDial");
	//aDial->show();
	//QMessageBox::about(this, tr("About Diagram Qtrans"),
	//	tr("About <b>Application</b>"));
	//helpMenu->aboutApplication();
}


void QTrans::slot_Config()
{
	Settings *dlg = new Settings(this);
	//wizard->show();
	dlg->exec();
	delete dlg;
}


/*-- If the window isn't visible, then show it;
   otherwise hide the window --*/
void QTrans::slot_ShortCut()
{
	//QMessageBox::about(this, tr("About Diagram Scene"), tr("slot_ShortCut(: 1"));
	if (!isVisible() || !isActiveWindow()) {
		Popup();
	} else {
		if (DockIcon) hide();
		else showMinimized();
	}
}


/*-- Translate the content of the ComboBox --*/
void QTrans::slot_Ok()
{
	QString s = combo->currentText();

	//if ( combo->findText(s) ) {
	//	combo->removeItem(0);
	//}

	if ( combo->count() > 10 ) {
		combo->removeItem(10);
	}

	Translate(s);
}


void QTrans::createTrayIcon()
{
	trayIconMenu = new KMenu(this);   //with KMenu error by enable by trayIcon
	trayIconMenu->addTitle(KIcon("qtrans"), tr("QTrans"));
	//trayIconMenu->setTitle(tr("QTrans"));
	//trayIconMenu->setIcon(KIcon("qtrans"));
	trayIconMenu->addAction(trayExitAct);
	trayIconMenu->addSeparator();
	//trayIconMenu->addAction(aboutAct);
	trayIconMenu->addAction(trayAboutAct);
	trayIconMenu->addAction(configAct);
	trayIconMenu->addSeparator();
	trayIconMenu->addAction(disableAct);
	trayIconMenu->addAction(enableAct);
	//disableAct->setVisible(true);
	enableAct->setVisible(false);

	trayIcon = new QSystemTrayIcon(this);
	trayIcon->setContextMenu(trayIconMenu);
}


void QTrans::slot_Help()
{
	Out->clear();
	
	/*-- Temporary stuff  --*/
	/*-- Show README file --*/
	KStandardDirs sd;
	QString Path = sd.findResource("data","qtrans/README");
	if (Path==QString::null) {
		KMessageBox::sorry(this,i18n("README file was not found."));
		return;
	}
	ifstream file;
	char c;
	QString text = "";
	//file.open(Path,ios::in);
	//file.open("/work6b/_prog/_kde4/qtrans-0.2.0.1/README",ios_base::in);
	file.open(Path.toAscii(), ios_base::in);
	while ((c=file.get()) != EOF)
		if (c=='\n') text += "<br>";
		else if (c==' ') text += "&nbsp;";
		else if (c=='\t') text += "&nbsp;&nbsp;&nbsp;&nbsp;";
		else if (c=='"') text += "&quot;";
		else if (c=='<') text += "&lt;";
		else if (c=='>') text += "&gt;";
		else text += QChar(c);
	file.close();
	//Out->begin();
	//Out->write("<html><body><pre><code>"+text+"</code></pre></body></html>");
	//Out->end();
	//Out->openURL("/home/mat/documenti/index.html");
	Out->setHtml("<html><body><pre><code>"+text+"</code></pre></body></html>");
}


void QTrans::keyPressEvent(QKeyEvent * event)
{
	if (event->key() == Qt::Key_Escape && DontClose) {
		hide();
	} else {
		if (event->modifiers() == Qt::ControlModifier) {
			switch (event->key()) {
				case Qt::Key_F:
 				//QMessageBox::about(this, tr("About Diagram Scene"), tr("Ctrl+F"));
				Out->slot_findMenu();
				break;
			}
		}
	}
}


/*bool QTrans::queryClose()
{
	QMessageBox::about(this, tr("About Diagram Scene"), tr("queryClose(: 1"));

  //if( !menuQuit && !kapp->sessionSaving() )
  //{
	if (DockIcon) {
		hide();
    		return false;
	}

  //}
	return true;
}
*/
#include "qtrans.moc"
