;; summary-color.el --- Coloring mew summary buffers and mh-e folder buffers

;; Copyright (C) 1997 Masatake YAMATO.

;; Author: Masatake (jet) YAMATO <masata-y@is.aist-nara.ac.jp>
;; Created: Tue May 13 18:14:21 1997
;; Proposer : Hirokazu TAGAITO <hiroka-t@aist-nara.ac.jp>
;; Maintainer: Masatake (jet) YAMATO <masata-y@is.aist-nara.ac.jp>
;;	       Hiroshi YOKOTA <yokota@netlab.is.tsukuba.ac.jp>
;; Content-Type: text/plain; charset=x-euc-jp
;; Version: 1.0

;; Keywords: mail, mh-e, mew

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.	If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:
;; [English]
;; This program is painting "Mew"(http://www.mew.org/) summary mode or "mh-e"
;; folder mode. It's useful for ordering your mails.
;;
;; [Japanese]
;; ΥץϡMewΥޥ⡼ɤ뤤MH-EΥե⡼ɤˤ
;; Υ֥Ȥ뤤ϺФͤΥ᡼˿դޤ
;; (ԤΤ褦)inboxˤۤä餫Ƥͤ᡼򤵤
;; Ȥ˥᡼θʬդ䤹Ȼפޤ

;; Install:
;; [English]
;; [1] Mew or MH
;;   Which do you want to use?
;;
;;   "Mew"  => (setq summary-color-mailer 'mew)
;;   "mh-e" => (setq summary-color-mailer 'mh-e)
;;
;; [2]Colors
;;   Set up paint pattern. Background color is opptional.
;;
;;  (setq summary-color-list
;;    '((*regexp1* *foreground-color1* *background-color1*)
;;	(*regexp2* *foreground-color2*)
;;	(*regexp3* *foreground-color3* *background-color3*)
;;	... ))
;;
;;  Example:
;;   (setq summary-color-list
;;	'(("GYVE"  "Yellow" "black") ; foreground:yellow, background: black
;;	  ("foo@bar\\.com" "Red")    ; foreground:red, background: same as default
;;	  ("{mew,mhe}" "Gray")))     ; foreground:gray, background: same as default
;;
;; [3]Do "require"
;;   (require 'summary-color)
;;
;;
;; Install:
;; [1] Mew or MH
;; ޤʤmh-emew, ɤȤäƤ뤫Ʋ. 
;; 
;; mewȤäƤ:
;; (setq summary-color-mailer 'mew)
;; mh-eȤäƤ:
;; (setq summary-color-mailer 'mh-e)
;;
;; [2]Colors
;; ˿ꤷޤ.	
;; Υ֥Ȥ뤤ϺФͤꤹɽ, foreground color
;; background colorȤѤƿԤʤޤ.
;; 
;; ηǰĤȤޤ
;; (*ɽ* *foreground-color* *background-color*)
;; *background-color*ϾάǤޤ
;; άȤbackground color summary-default-background-color 
;; ͿƤ뿧ˤʤޤǥեȤϥե졼background colorǤ
;; ƤȤꥹ summary-color-list˲äϿޤ.
;;
;; [3]Require
;; ǸˤΥեɤिλؼäޤ.
;; (require 'summary-color)
;;
;; [4] Example 
;; (setq summary-color-mailer 'mew)		  ; MewȤäƤޤ.
;; (setq summary-color-list 
;;		     '(("GYVE"	"Yellow" "black") ; ʸ:,	ط: 
;;		       ("Geena" "Red")		  ; ʸ:,  ط: Ѥʤ.
;;		       ("Renny" "Gray")))	  ; ʸ:,	ط: Ѥʤ.
;; (require 'summary-color)
;;
;; [5] Warning
;;  (taka@airlab.cs.ritsumei.ac.jp)mew-diredȤäƤϡ
;; Υե뤬mew-diredload/require褦ˤƲ

;;; Known bugs, todo and excuses:
;; summary-color-listemacs/muleѹ(setq)Ƥ⿧դ
;; ޤ. ѹ, M-x summary-color-build-faces-interactive 
;; Ʋ. ޤrequireΤautoloadȤ褦ˤǤ, 
;; ΥΥץΤˤޤǤʤƤ⤤Ǥ礦. 
;;
;; ɮԤMewȤäƤΤMHǤϤޤƥȤƤޤ. 
;; ⤷꤬äƤ, ʤelisp狼ʤ, Υץ
;; ȾˤhookΤȤ򸫤Ʋ. Ŭhookmh-*.elΥ
;; õ, summary-coloringƤӤޤ.  hookʤ, defadvice
;; ȤɬפǤ礦. Ʊͤˤ, ¾Υᥤ顼ˤŬѤǤ뤫
;; ޤ. 

;;
;; X-켡:
;;				     Sun Jun 22 16:37:32 1997 --- jet
;;
;; ȯɽ, 郎ޤʹƤ꤬Ȥޤ. 
;;
;; {mizuho-i, hiroka-t, chihok-s, ryuuta-t, tooru-t, kazuh-fu, takes-sa, fumita-m}
;; @is.aist-nara.ac.jp
;;
;; rikiya@airlab.cs.ritsumei.ac.jp, 
;; hayakawa@cv.cs.ritsumei.ac.jp, satosh-k
;;

;; X-Working-song:
;; 1st (Sarah Crackenll, lisplide, downtown)
;; 2nd (PAPERMOON, Luch's eyes(live))


;;; History:
;; summary-color.el for Color-Mate Ver.1.0.2
;;  o ۤ򤷤Τǥ᡼륢ɥ쥹񤭴롣
;; summary-color.el for Color-Mate Ver.1.0.1
;;  o History Υץ󶡼Ԥְ̾äƤΤ
;; summary-color.el for Color-Mate Ver.1.0
;;  o Masatake (jet) YAMATO <masata-y@is.aist-nara.ac.jp>  color-mate 
;;    ˤȥץ󶡤롣
;;  o Ѹɲ
;; Sun Jul 27 04:09:52 1997 Masatake YAMATO <masata-y@is.aist-nara.ac.jp>
;;	* ȤꤢMH-EǤư褦ˤ. 
;;	* Ȥꤢmandara-misc

;; $Id: summary-color.el,v 1.2 2002/05/11 02:32:13 elca Exp $

;;; Codes:

;;
;; --- User Options ---
;;

;; Select for your own mailer.
(defvar summary-color-mailer (cond ((fboundp 'mew) 'mew)
				  ((fboundp 'mh-e) 'mh-e)
				  (t (error 
				      "%s"
				      "summary-color runs on mew or mh-e!")
				     nil))
  "*mailerλ. ܥ mew  ܥ mh-eꤹ. ")

;; Set colors
(defvar summary-color-list nil
  "*Ǥ\(ɽ	foreground-color background-color\)Ȥꥹ
MewsummaryХåե˿դΤ˻Ȥ. ")
;;
(defvar summary-default-background-color (cdr (assoc 'background-color
						     (frame-parameters
						      (selected-frame))))
  "*summary-color-listbackground-colorά줿ǤФŬѤ뿧
⤷nilǤ, mewΥޥХåեΥե졼طʿ򤽤Τޤ޻Ȥ. ")

;; Select folders to be colored.
(defvar summary-folders-to-be-colored t
  "*դfolderλ. 
o tǤ+inboxǤΤ߿դ. 
o ʸǤȤꥹȤǤ, ΥС̾бե˿
  դ. . :
(setq summary-folders-to-be-colored '(\"+inbox\" \"+Backup\" \"+drafts/\"))

o nilǤФ٤ƤΥХåե˿դ. ")

;;
;; --- Internal Vars ---
;;

;; Regexp -> face
(defvar summary-face-alist nil)		

;; Face names
(defconst summary-face-symbol-prefix "summary-face") 


;;
;; --- Functions ---
;;

;; Checking the duplication of faces.
(defun summary-check-face-dup (sym)
  (let ((list (face-list))
	elt
	r)
    (while list
      (setq elt (car list)
	    list (cdr list))
      (if (string= (symbol-name sym) (symbol-name elt))
	  (setq r elt)))
    r))

;;
(defun summary-color-generate-face-name (prefix foreground background)
  (format "%s-fg:%s-bg:%s" 
	  prefix foreground background))

;; (PREFIX for face names)
(defun summary-color-build-faces (prefix list)
  (setq summary-face-alist nil)		; Reset the variable
  (let ((tmplist list)
	name 
	fcolor 
	bcolor
	face 
	sym)
    (while tmplist
      (setq name (car (car tmplist))
	    fcolor (car (cdr (car tmplist)))
	    bcolor (car (cdr (cdr (car tmplist)))))
      (if (not bcolor) (setq bcolor summary-default-background-color))
      (if (not bcolor) (setq bcolor (cdr (assoc 'background-color
							 (frame-parameters
							  (selected-frame))))))
      (setq sym (make-symbol (summary-color-generate-face-name prefix 
							       fcolor bcolor))
	    face (summary-check-face-dup sym))
      (if (not face)
	  (setq face (make-face sym)))
      (set-face-foreground face fcolor)
      (set-face-background face bcolor)
      (setq summary-face-alist (cons 
				(cons name face) 
				summary-face-alist)
	    tmplist (cdr tmplist)))))

;; 
(defun summary-strmember (elt list)
  "Assoc using string= instead of equal."
  (let (r 
	target 
	(list2 list))
    (while list
      (setq target (car list))
      (if (string= elt target)
	  (setq r list2))
      (setq list (cdr list)))
    r))

;; 
(defun summary-coloring ()
"Mew  ޥХåե뤤mh-efoldersХåեˤդ뤿δؿ"
(cond
 ((eq summary-folders-to-be-colored t) ; inbox only
  (if (string= (buffer-name) "+inbox")
	(summary-coloring-core)))
 ((eq summary-folders-to-be-colored nil) ; any folder 
  (summary-coloring-core))
 ((summary-strmember (buffer-name) summary-folders-to-be-colored)
  (summary-coloring-core))))

;;	 
(defun summary-coloring-core ()
  (save-excursion
    (let (name 
	  face (tail summary-face-alist)
	  b 
	  e
	  (buffer-read-only nil))
      (while tail
	(setq name (car (car tail))
	      face (cdr (car tail))
	      tail (cdr tail))
	(goto-char (point-min))
	(while (re-search-forward name nil t)
	  (beginning-of-line) (setq b (point))
	  (end-of-line) (setq e (point))
	  (put-text-property b e
			     'face face))
	)
      ;; ?
      ;; (set-buffer-modified-p nil)
      ;;
      )))

;;
;; --- Adding functions on the hooks ---
;;
(cond ( ;; MEW
       (eq summary-color-mailer 'mew)
       (add-hook 'mew-summary-inc-sentinel-hook
		 (function summary-coloring))
       (add-hook 'mew-summary-scan-sentinel-hook
		 (function summary-coloring))
       (add-hook 'mew-summary-mode-hook
		 (function summary-coloring)) ;???ɬפʤ󤫤ʤ...
       )
      ( ;; MH-E
       (eq summary-color-mailer 'mh-e)
       ;; Ŭhookʤ! (after scanning)
       (defadvice mh-scan-folder (after add-summary-color:mh-folder first activate)
	 (summary-coloring))
       ;;
       (add-hook 'mh-inc-folder-hook
		 (function summary-coloring))
       ;; ɬ?
       (add-hook 'mh-refile-msg-hook
		 (function summary-coloring))	    
       ))
;;
;; Building faces...
;; 
(defun summary-color-build-faces-interactive ()
  (interactive)
  (summary-color-build-faces summary-face-symbol-prefix 
			     summary-color-list))
(summary-color-build-faces-interactive)


(provide 'summary-color)
;; summary-color.el ends here.
