#ifndef GVN_CHECKOUT_H
#define GVN_CHECKOUT_H

#include <svn_opt.h>
#include <glib.h>

/* this structure is the the only interface between the
 * thread doing the work and the user interface.
 */
struct _worker_comms {
    const char *repository_url;
    const char *destination_path;
    const char *working_copy_name;

    svn_opt_revision_t revision;

    gboolean recursive;
    gboolean ignore_externals;

    GnubVersionProgressWindow *progressWindow;
    // Communication from gtk main loop to worker thread
    volatile gboolean cancel_requested;
};
typedef struct _worker_comms worker_comms_t;

extern void dialog_init (
    const char *repository, 
    const char *revision, 
    gboolean ignore_externals,
    gboolean recursive,
    const char *destination_path,
    const char *sandbox
    );

extern gpointer checkout_thread_main (gpointer data);
extern int dialog_noninteractive_start(void);
extern gboolean non_interactive;

#endif
