#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include <gnubversion.h>
#include <assert.h>
#include <unistd.h>

#include "gvn-checkout.h"

#define APP_NAME "gvn-checkout"

int 
main (
    int argc, 
    char **argv, 
    char **env
    )
{
    GString *repository;
    GString *into;
    GString *revision;
    gboolean ignore_externals = FALSE;
    gboolean non_recursive = FALSE;
    GString *sandbox;
    
    repository = g_string_new( "https://gnubversion.svn.sourceforge.net/svnroot/gnubversion/trunk" );

    {
        char *cwd;
        cwd = getcwd (NULL, 0);
        into = g_string_new(cwd);
        free (cwd);
    }

    revision = g_string_new("HEAD");
    sandbox = g_string_new("");
    
    #ifdef ENABLE_NLS
        bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
        textdomain (PACKAGE);
    #endif

    gchar **remaining_args = NULL;
    GOptionEntry option_entries[] = 
    {
        /* ... your application's command line options go here ... */
        {
            "into", 0,
            0, 
            G_OPTION_ARG_STRING,
            into,
            _("directory to check out into"),
            _("directory")
        },
        { 
            "revision", 'r',  
            0 /* flags */, 
            G_OPTION_ARG_STRING /* arg */, 
            revision /* arg_data */, 
            _("Revision number to use.\n"
              "\t'arg' can be one of:\n"
              "\t  NUMBER       revision number\n"
              "\t  '{' DATE '}' revision at start of the date\n"
              "\t  'HEAD'       latest in repository (default)"
            ), 
            _("arg" )
        },
        {
            "ignore-externals", 0,
            0, 
            G_OPTION_ARG_NONE,
            &ignore_externals,
            _("ignore externals definitions"),
            NULL
        },
        {
            "non-recursive", 'N',
            0, 
            G_OPTION_ARG_NONE,
            &non_recursive,
            _("operate on single directory only"),
            NULL
        },
        /* last but not least a special option that collects filenames */
        { G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_FILENAME_ARRAY,
          &remaining_args,
          "Special option that collects any remaining arguments for us" },
        // { _("repository-url [ sandbox-dir ]") },
        { NULL }
    };

    GOptionContext *option_context;
    GnomeProgram *my_app;

    option_context = g_option_context_new ( "repository-url [ sandbox-dir ]" );

    /* if you are using any libraries that have command line options
     * of their own and provide a GOptionGroup with them, you can
     * add them here as well using g_option_context_add_group()
     */

    /* now add our own application's command-line options. If you
     * are using gettext for translations, you should be using
     * GETTEXT_PACKAGE here instead of NULL
     */
    g_option_context_add_main_entries (option_context, option_entries, GETTEXT_PACKAGE);

    g_option_context_add_group( option_context, gnubversion_get_option_group() );

    /* We assume PACKAGE and VERSION are set to the program name and version
     * number respectively. Also, assume that 'option_entries' is a global
     * array of GOptionEntry structures.
     */
    my_app = gnome_program_init(APP_NAME, VERSION,
                                LIBGNOMEUI_MODULE, argc, argv,
                                GNOME_PARAM_GOPTION_CONTEXT, option_context,
                                GNOME_PARAM_NONE);

    /* parse remaining command-line arguments that are not
     * options (e.g. filenames or URIs or whatever), if any
     */
    if (remaining_args != NULL) 
    {
        gint num_args;
        for (num_args = 0; remaining_args[num_args] != NULL; num_args++)
            ;

        if (num_args >= 1)
            g_string_assign (repository, remaining_args[0]);

        if (num_args >= 2)
            g_string_assign (sandbox, remaining_args[1]);

        g_strfreev (remaining_args);
        remaining_args = NULL;
    }

    gnubversion_init_with_glade ( APP_NAME );

    gvn_debug("repository: \"%s\"", repository->str);
    gvn_debug("revision: \"%s\"", revision->str);
    gvn_debug("into: \"%s\"", into->str);
    gvn_debug("ignore_externals: %s", ignore_externals ? "true" : "false");
    gvn_debug("recursive: %s", !non_recursive ? "true" : "false");
    gvn_debug("sandbox: \"%s\"", sandbox->str);

    int rc = 0;

    dialog_init(repository->str, 
                revision->str, 
                ignore_externals, 
                !non_recursive, 
                into->str, 
                sandbox->str);

    if (gnubversion_get_options()->non_interactive)
        rc = dialog_noninteractive_start();
    else
        gtk_main ();

    gnubversion_shutdown ();
    g_object_unref ( my_app );
    return rc;
}
