#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "gnubversion-private.h"
#include "gnubversion-about.h"
#include "gnubversion-widgets.h"

#include <glade/glade.h>
#include <gtk/gtkdialog.h>
#include <assert.h>

void 
aboutmenuitem_activate_cb (GtkWidget *parent, gpointer userdata)
{
    GladeXML *xml;
    GString *str = gladefile("about.glade", NULL);

    xml = glade_xml_new (str->str, "aboutDialog", NULL);
    g_string_free(str, TRUE);
    assert(xml != NULL);
    glade_xml_signal_autoconnect (xml);

    GtkWidget *dialog = glade_xml_get_widget (xml, "aboutDialog");
    GtkWidget *window = gtk_widget_get_ancestor(parent, GTK_TYPE_WINDOW);

    gtk_window_set_transient_for (GTK_WINDOW(dialog), GTK_WINDOW(window));
    gtk_dialog_run(GTK_DIALOG(dialog));
}

void 
aboutDialog_response_cb (GtkWidget *parent, gpointer userdata)
{
    gtk_widget_destroy(parent);
}
