#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "gnubversion-private.h"
#include "gnubversion-error.h"

#include <assert.h>
#include <string.h>

#define ERR_BUF_SIZE  3000

void gnubversion_error(GtkWindow *window, const char *format, ...)
{
    va_list ap;
    va_start(ap, format);
    GString *str = g_string_new("");

    g_string_vprintf(str, format, ap);

    GtkWidget *dialog = gnome_error_dialog_parented(str->str, window);
    assert(dialog != NULL);
    gnome_dialog_run(GNOME_DIALOG(dialog));

    g_string_free(str, TRUE);
    va_end(ap);
}

void gnubversion_linux_error(GtkWindow *window, int errnum, const char *format, ...)
{
    va_list ap;
    va_start(ap, format);
    GString *str = g_string_new("");

    g_string_vprintf(str, format, ap);
    g_string_append(str, ": ");
#ifndef NDEBUG
    printf("Error message1: %s\n", str->str);
#endif

    g_string_append(str, strerror(errnum));
   
#ifndef NDEBUG
    printf("Error message: %s\n", str->str);
#endif

    GtkWidget *dialog = gnome_error_dialog_parented(str->str, window);
    assert(dialog != NULL);
    gnome_dialog_run(GNOME_DIALOG(dialog));

    va_end(ap);
}

void gnubversion_svn_error(GtkWindow *window, svn_error_t *err, const char *format, ...)
{
    va_list ap;
    va_start(ap, format);
    GString *str = g_string_new("");

    char *buf = g_malloc(ERR_BUF_SIZE);
    const char *errbuf = svn_err_best_message(err, buf, ERR_BUF_SIZE);

    g_string_vprintf(str, format, ap);
    g_string_append(str, ": ");
    g_string_append(str, errbuf);
    g_free(buf);

    GtkWidget *dialog = gnome_error_dialog_parented(str->str, window);
    assert(dialog != NULL);
    gnome_dialog_run(GNOME_DIALOG(dialog));

    g_string_free(str, TRUE);
    va_end(ap);
}

void gnubversion_apr_error( GtkWindow *window, apr_status_t err, const char *format, ...)
{
    va_list ap;
    va_start(ap, format);
    GString *str = g_string_new("");

    char *buf = g_malloc(ERR_BUF_SIZE);
    const char *errbuf = apr_strerror(err, buf, ERR_BUF_SIZE);

    g_string_vprintf(str, format, ap);
    g_string_append(str, ": ");
    g_string_append(str, errbuf);
    g_free(buf);

    GtkWidget *dialog = gnome_error_dialog_parented(str->str, window);
    assert(dialog != NULL);
    gnome_dialog_run(GNOME_DIALOG(dialog));

    g_string_free(str, TRUE);

    va_end(ap);
}
