#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnubversion.h>
#include <gnome.h>
#include <assert.h>

#define APP_NAME "test-commonoptions"

static void options_changed(GnubVersionCommonOptions *options, gpointer data);
static void dump_options(GnubVersionCommonOptions *options);

int 
main (
    int argc, 
    char **argv, 
    char **env
    )
{
    gboolean non_recursive = FALSE;
    gboolean ignore_externals = FALSE;
    gchar **remaining_args = NULL;

    #ifdef ENABLE_NLS
        bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
        textdomain (PACKAGE);
    #endif

    GOptionEntry option_entries[] = 
    {
        {
            "ignore-externals", 0,
            0, 
            G_OPTION_ARG_NONE,
            &ignore_externals,
            _("ignore externals definitions"),
            NULL
        },
        {
            "non-recursive", 'N',
            0, 
            G_OPTION_ARG_NONE,
            &non_recursive,
            _("operate on single directory only"),
            NULL
        },
        /* last but not least a special option that collects filenames */
        { G_OPTION_REMAINING, 0, 0, G_OPTION_ARG_FILENAME_ARRAY,
          &remaining_args,
          "Special option that collects any remaining arguments for us" },
        { NULL }
    };

    GOptionContext *option_context;
    GnomeProgram *my_app;

    option_context = g_option_context_new ( "" );
    g_option_context_add_main_entries (option_context, option_entries, GETTEXT_PACKAGE);
    g_option_context_add_group( option_context, gnubversion_get_option_group() );

    my_app = gnome_program_init(APP_NAME, VERSION,
                                LIBGNOMEUI_MODULE, argc, argv,
                                GNOME_PARAM_GOPTION_CONTEXT, option_context,
                                GNOME_PARAM_NONE);
    if (remaining_args != NULL)
    {
        g_error("bad parameters");
        gvn_debug("bye bye");
        exit(2);
    }
    gnubversion_init_with_glade(APP_NAME);

    GnubVersionCommonOptions *options = GNUBVERSION_COMMONOPTIONS( gnubversion_get_widget("options"));
    gtk_widget_show (gnubversion_get_widget("window"));

    gnubversion_commonoptions_set_recursive(options, !non_recursive);
    gnubversion_commonoptions_set_ignore_externals(options, ignore_externals);

    gnubversion_commonoptions_connect__options_changed(options, options_changed, NULL);
    gtk_main();

    gvn_debug("End of dialog:");
    dump_options(options);

    gnubversion_shutdown();
    g_object_unref (my_app);
    return 0;
}

static void options_changed(GnubVersionCommonOptions *options, gpointer data)
{
    gvn_debug("Options changed signal received:");
    dump_options(options);
}

static void dump_options(GnubVersionCommonOptions *options)
{
    gvn_debug("  Recursive:        %s", gnubversion_commonoptions_get_recursive(options) 
                            ? "Yes" : "No" );
    gvn_debug("  Ignore Externals: %s", gnubversion_commonoptions_get_ignore_externals(options) 
                            ? "Yes" : "No" );
}
