//
// C++ Implementation: k9tools
//
// Description:
//
//
// Author: Jean-Michel PETIT <k9copy@free.fr>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "k9tools.h"
#include "k9common.h"
#include <kstandarddirs.h>
#include <qdir.h>
#include <QComboBox>
#ifdef __FreeBSD__
#include <sys/mount.h>
#else
#include <sys/vfs.h>
#endif
#include <KMessageBox>
#include <KLocale>
#include "k9dialogs.h"
#include <kdesu/su.h>
#include <KPasswordDialog>
#include <KUser>
#include <QDebug>

QStringList m_temporaryDirs;
QString g_password="";

void k9Tools::addTemporaryDir(const QString & dir) {
    m_temporaryDirs << dir;
}
bool k9Tools::checkProgram(QString _progName,bool _msg) {
    bool res= KStandardDirs::findExe( _progName,NULL,false) !=NULL ;
    if (_msg && !res)
        k9Dialogs::error(i18n("Error starting program %1",_progName),i18n("Running program"));
    return res;
}

bool k9Tools::runAsRoot(const QString &_command,const QString &_description) {
    KDESu::SuProcess suprocess("root",_command.toUtf8());
    int res=3;
    while (res==3) {
        if (suprocess.checkInstall(g_password.toUtf8())!=0) {
            KPasswordDialog pwd(k9Dialogs::getMainWidget(),KPasswordDialog::UsernameReadOnly  );
            KUser user;
            QString username=suprocess.useUsersOwnPassword()?user.loginName():QString("root");
            pwd.setUsername(username);
            pwd.setPrompt(i18n("Enter the root password"));
            pwd.addCommentLine("",_description);
            if (!pwd.exec())
                return false;
            g_password=pwd.password();
            res=suprocess.exec(g_password.toUtf8());
        } else
            res=suprocess.exec(g_password.toUtf8());
        if (res==3)
            k9Dialogs::error(i18n("The root password is not valid"),i18n("Running program"));
    }
    return res==0;

}

void k9Tools::clearOutput() {
    foreach(QString dir,m_temporaryDirs) {
        qDebug() << "clear " << dir;
        k9Tools::clearOutput(dir);
    }

}


void k9Tools::clearOutput(QString name) {
    QDir dir(name);
    //delete files in directory
    QStringList lst = dir.entryList(QStringList( "*"),QDir::Files |QDir::Hidden );
    foreach (QString c,lst) {
        //QString c(( *it ).latin1() );
        dir.remove (c);
    }
    //scanning subdir
    QStringList lstdir = dir.entryList( QStringList("*"),QDir::Dirs );
    foreach ( QString c,lstdir) {
        if ((c!=".") && c!="..") {
            clearOutput(dir.absoluteFilePath(c));
            dir.rmdir(c);
        }
    }

}

void k9Tools::setComboText(QComboBox *_cb,const QString &_text) {
    int i = _cb->findText(_text);
    if (i != -1)
        _cb->setCurrentIndex(i);
    else if (_cb->isEditable())
        _cb->setEditText(_text);
    else
        _cb->setItemText(_cb->currentIndex(), _text);
}

long k9Tools::getFreeSpace(const QString &_path) {
    struct statfs sfs;
    if (statfs(_path.toAscii(),&sfs) !=-1) {
        uint64_t fs=((uint64_t)sfs.f_bavail*(uint64_t)sfs.f_bsize);
        fs/=(1024*1024);
        return fs;
    } else
        return -1;
}
