//
// System.Web.UI.ApplicationFileParser.cs
//
// Authors:
//	Gonzalo Paniagua Javier (gonzalo@ximian.com)
//
// (C) 2002,2003 Ximian, Inc (http://www.ximian.com)
// (c) 2004 Novell, Inc. (http://www.novell.com)
//

//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
using System;
using System.Collections;
using System.IO;
using System.Web;
using System.Web.Compilation;

namespace System.Web.UI
{
	sealed class ApplicationFileParser : TemplateParser
	{
		static ArrayList dependencies;
#if NET_2_0
		TextReader reader;
#endif
		
		public ApplicationFileParser (string fname, HttpContext context)
		{
			InputFile = fname;
			Context = context;
#if NET_2_0
			VirtualPath = new VirtualPath ("/" + Path.GetFileName (fname));
#endif
		}

#if NET_2_0
		internal ApplicationFileParser (string virtualPath, TextReader reader, HttpContext context)
			: this (virtualPath, null, reader, context)
		{
		}
		
		internal ApplicationFileParser (string virtualPath, string inputFile, TextReader reader, HttpContext context)
		{
			VirtualPath = new VirtualPath (virtualPath);
			Context = context;
			Reader = reader;

			if (String.IsNullOrEmpty (inputFile)) {
				HttpRequest req = context != null ? context.Request : null;
				if (req != null)
					InputFile = req.MapPath (virtualPath);
			} else
				InputFile = inputFile;
			
			SetBaseType (null);
		}
#endif
		
		protected override Type CompileIntoType ()
		{
			return GlobalAsaxCompiler.CompileApplicationType (this);
		}

		internal static Type GetCompiledApplicationType (string inputFile, HttpContext context)
		{
			ApplicationFileParser parser = new ApplicationFileParser (inputFile, context);
			AspGenerator generator = new AspGenerator (parser);
			Type type = generator.GetCompiledType ();
			dependencies = parser.Dependencies;
			return type;
		}

		internal override void AddDirective (string directive, Hashtable atts)
		{
			if (String.Compare (directive, "application", true) != 0 &&
			    String.Compare (directive, "Import", true) != 0 &&
			    String.Compare (directive, "Assembly", true) != 0)
				ThrowParseException ("Invalid directive: " + directive);

			base.AddDirective (directive, atts);
		}

		internal static ArrayList FileDependencies {
			get { return dependencies; }
		}		

		internal override string DefaultBaseTypeName {
			get { return "System.Web.HttpApplication"; }
		}

		internal override string DefaultDirectiveName {
			get { return "application"; }
		}

		internal override string BaseVirtualDir {
			get { return Context.Request.ApplicationPath; }
		}
		
#if NET_2_0
		 internal override TextReader Reader {
                        get { return reader; }
                        set { reader = value; }
                }
#endif
	}

}

