/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: AccessibleBrowseBoxHeaderCell.hxx,v $
 * $Revision: 1.3 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
#ifndef ACCESSIBILITY_EXT_ACCESSIBLEBROWSEBOXHEADERCELL_HXX
#define ACCESSIBILITY_EXT_ACCESSIBLEBROWSEBOXHEADERCELL_HXX

#include "accessibility/extended/AccessibleBrowseBoxBase.hxx"

namespace accessibility
{
	class AccessibleBrowseBoxHeaderCell : public BrowseBoxAccessibleElement
	{
		sal_Int32	m_nColumnRowId;
	public:
		AccessibleBrowseBoxHeaderCell(sal_Int32 _nColumnRowId,
										  const ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible >& rxParent,
										  ::svt::IAccessibleTableProvider&                  _rBrowseBox,
										  const ::com::sun::star::uno::Reference< ::com::sun::star::awt::XWindow >& _xFocusWindow,
										  ::svt::AccessibleBrowseBoxObjType  _eObjType);
		/** @return  The count of visible children. */
		virtual sal_Int32 SAL_CALL getAccessibleChildCount() throw ( ::com::sun::star::uno::RuntimeException );

		/** @return  The XAccessible interface of the specified child. */
		virtual ::com::sun::star::uno::Reference< ::com::sun::star::accessibility::XAccessible > SAL_CALL
			getAccessibleChild( sal_Int32 nChildIndex ) throw ( ::com::sun::star::lang::IndexOutOfBoundsException,::com::sun::star::uno::RuntimeException );

		/** @return  The index of this object among the parent's children. */
		virtual sal_Int32 SAL_CALL getAccessibleIndexInParent() throw ( ::com::sun::star::uno::RuntimeException );

		/** Grabs the focus to the BrowseBox. */
		virtual void SAL_CALL grabFocus() throw ( ::com::sun::star::uno::RuntimeException );

		inline sal_Bool isRowBarCell() const
		{
			return getType() == ::svt::BBTYPE_ROWHEADERCELL;
		}

		/** @return
				The name of this class.
		*/
		virtual ::rtl::OUString SAL_CALL getImplementationName() throw ( ::com::sun::star::uno::RuntimeException );

		/** Creates a new AccessibleStateSetHelper and fills it with states of the
			current object.
			@return
				A filled AccessibleStateSetHelper.
		*/
		::utl::AccessibleStateSetHelper* implCreateStateSetHelper();

	protected:
		virtual Rectangle implGetBoundingBox();

		virtual Rectangle implGetBoundingBoxOnScreen();
	};
}

#endif // ACCESSIBILITY_EXT_ACCESSIBLEBROWSEBOXHEADERCELL_HXX

