/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: ReportTextDocument.java,v $
 *
 * $Revision: 1.2.36.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package com.sun.star.wizards.report;

import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.text.XRelativeTextContentRemove;
import com.sun.star.text.XTextContent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Vector;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.VclWindowPeerAttribute;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.db.*;
import com.sun.star.wizards.common.*;
import com.sun.star.wizards.ui.*;
import com.sun.star.sdb.CommandType;
// import com.sun.star.table.XCell;
import com.sun.star.text.XTextDocument;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.text.TextTableHandler;
import com.sun.star.wizards.text.TextSectionHandler;
import com.sun.star.wizards.text.TextStyleHandler;
import com.sun.star.wizards.text.TextFieldHandler;
import com.sun.star.wizards.text.ViewHandler;
import com.sun.star.wizards.document.FormHandler;

class ReportTextDocument extends com.sun.star.wizards.text.TextDocument implements Comparator
{
    // private XMultiServiceFactory xMSF;
    // private XMultiServiceFactory xMSFDoc;
    private Object ReportPageStyle;
    private Object FirstPageStyle;
    private int PageWidth;
    private Rectangle PosSize;
    // private String ReportFolderName;
    public Vector DBColumnsVector;
    private RecordTable CurRecordTable;
    private String sMsgTableNotExisting;
    private String sMsgCommonReportError;
    private String ContentTemplatePath;
    private String LayoutTemplatePath;
    // private String sMsgInvalidTextField;
    private String sMsgEndAutopilot;
    public boolean bIsCurLandscape;
    public TextTableHandler oTextTableHandler;
    public TextSectionHandler oTextSectionHandler;
    public FormHandler oFormHandler;
    public TextStyleHandler oTextStyleHandler;
    public TextFieldHandler oTextFieldHandler;
    public ViewHandler oViewHandler;
    public NumberFormatter oNumberFormatter;
    public static final String TBLRECORDSECTION = "Tbl_RecordSection";
    public static final String TBLGROUPSECTION = "Tbl_GroupField";
    public static final String RECORDSECTION = "RecordSection";
    public static final String GROUPSECTION = "GroupField";
    public static final String COPYOFTBLRECORDSECTION = "CopyOf" + TBLRECORDSECTION;
    public static final String COPYOFTBLGROUPSECTION = "CopyOf" + TBLGROUPSECTION;
    public static final String COPYOFRECORDSECTION = "CopyOf" + RECORDSECTION;
    public static final String COPYOFGROUPSECTION = "CopyOf" + GROUPSECTION;
    private RecordParser CurDBMetaData;

    /** Creates new ReportDocument */
    public ReportTextDocument(XMultiServiceFactory xMSF, XTextDocument _textDocument, Resource oResource, RecordParser _aRP)
    {
        super(xMSF, _textDocument, false);
        lateInit(oResource, _aRP);
    }

    public ReportTextDocument(XMultiServiceFactory xMSF, String _sPreviewURL, Resource oResource, RecordParser _aRP)
    {
        super(xMSF, _sPreviewURL, true, null);
        lateInit(oResource, _aRP);
    }

    void lateInit(Resource oResource, RecordParser _aRecordParser)
    {
        oTextTableHandler = new TextTableHandler(xMSFDoc, xTextDocument);
        oTextSectionHandler = new TextSectionHandler(xMSFDoc, xTextDocument);
        oFormHandler = new FormHandler(xMSFDoc, xTextDocument);
        oTextStyleHandler = new TextStyleHandler(xMSFDoc, xTextDocument);
        oViewHandler = new ViewHandler(xMSFDoc, xTextDocument);
        oTextFieldHandler = new TextFieldHandler(xMSFDoc, xTextDocument);
        DBColumnsVector = new java.util.Vector();
        oNumberFormatter = oTextTableHandler.getNumberFormatter();
        // CurDBMetaData = new RecordParser(xMSF); //, CharLocale, oNumberFormatter);
        CurDBMetaData = _aRecordParser;
        long lDateCorrection = oNumberFormatter.getNullDateCorrection();
        oNumberFormatter.setBooleanReportDisplayNumberFormat();
        oNumberFormatter.setNullDateCorrection(lDateCorrection);
        // sMsgInvalidTextField = oResource.getResText(UIConsts.RID_REPORT + 73);
        sMsgTableNotExisting = oResource.getResText(UIConsts.RID_REPORT + 61);
        sMsgCommonReportError = oResource.getResText(UIConsts.RID_REPORT + 72);
        sMsgCommonReportError = JavaTools.replaceSubString(sMsgCommonReportError, String.valueOf((char) 13), "<BR>");
        sMsgEndAutopilot = oResource.getResText(UIConsts.RID_DB_COMMON + 33);
        sMsgTableNotExisting = sMsgTableNotExisting + (char) 13 + sMsgEndAutopilot;
        bIsCurLandscape = true;
        getReportPageStyles();
    }

    public NumberFormatter getNumberFormatter()
    {
        return oNumberFormatter;
    }

    public boolean checkReportLayoutMode(String[] GroupFieldNames)
    {
        try
        {
            XNameAccess xTextSections = oTextSectionHandler.xTextSectionsSupplier.getTextSections();
            Object oTextSection;
            if (GroupFieldNames.length > 0)
            {
                oTextSection = xTextSections.getByName(GROUPSECTION + String.valueOf(1));
            }
            else
            {
                oTextSection = xTextSections.getByName(RECORDSECTION);
            }
            boolean bLayoutMode = AnyConverter.toBoolean(Helper.getUnoPropertyValue(oTextSection, "IsVisible"));
            return bLayoutMode;
        }
        catch (Exception exception)
        {
            exception.printStackTrace(System.out);
            // In doubt we rather suggest this is LayoutMode...
            return true;
        }
    }

    public void swapContentTemplate(String ContentTemplatePath)
    {
//  unlockallControllers();
        //xProgressBar.start("", 10);
        this.ContentTemplatePath = ContentTemplatePath;
        loadSectionsfromTemplate(ContentTemplatePath);
        // xProgressBar.setValue(40);
        oTextStyleHandler.loadStyleTemplates(ContentTemplatePath, "LoadTextStyles");
        // xProgressBar.setValue(70);
        if (CurRecordTable != null)
        {
            CurRecordTable.adjustOptimalTableWidths(xMSF, oViewHandler);
        }
        // xProgressBar.setValue(100);
        oViewHandler.selectFirstPage(oTextTableHandler);
    // xProgressBar.end();
    }

    public void swapLayoutTemplate(String LayoutTemplatePath/*, String BitmapPath*/)
    {
        try
        {
            // xProgressBar.start("", 10);
            this.LayoutTemplatePath = LayoutTemplatePath;
            boolean bOldIsCurLandscape = AnyConverter.toBoolean(Helper.getUnoPropertyValue(ReportPageStyle, "IsLandscape"));
            oTextStyleHandler.loadStyleTemplates(LayoutTemplatePath, "LoadPageStyles");
            // xProgressBar.setValue(60);
            changePageOrientation(bOldIsCurLandscape);
            // xProgressBar.setValue(100);
            oViewHandler.selectFirstPage(oTextTableHandler);
        // xProgressBar.end();
        }
        catch (Exception exception)
        {
            exception.printStackTrace(System.out);
        }
    }

    public void createReportForm(String SOREPORTFORMNAME)
    {
        com.sun.star.container.XNameContainer xNamedForm = oFormHandler.insertFormbyName(SOREPORTFORMNAME);
        XNameAccess xNameAccess = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, xNamedForm);
        oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "CommandType", new String(Integer.toString(CurDBMetaData.getCommandType())));
        if (CurDBMetaData.getCommandType() == CommandType.QUERY)
        {
            oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "QueryName", CurDBMetaData.getCommandName());
            // oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "Command", "");
            DBMetaData.CommandObject oCommand = CurDBMetaData.getQueryByName(CurDBMetaData.getCommandName());
            oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "Command", CurDBMetaData.Command);
        }
        else
        {
            oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "QueryName", "");
            oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "Command", CurDBMetaData.Command);
        }
        oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "GroupFieldNames", JavaTools.ArraytoString(CurDBMetaData.GroupFieldNames));
        oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "FieldNames", JavaTools.ArraytoString(CurDBMetaData.getFieldNames()));
        oFormHandler.insertHiddenControl(xNameAccess, xNamedForm, "RecordFieldNames", JavaTools.ArraytoString(CurDBMetaData.getRecordFieldNames()));
    }

    public void updateReportTitle(String _sTitleName)
    {
        m_xDocProps.setTitle(_sTitleName);
    }

    public void getReportPageStyles()
    {
        try
        {
            Object oPageStyleFamily = oTextStyleHandler.xStyleFamiliesSupplier.getStyleFamilies().getByName("PageStyles");
            ReportPageStyle = Helper.getUnoObjectbyName(oPageStyleFamily, "Standard");
            FirstPageStyle = Helper.getUnoObjectbyName(oPageStyleFamily, "First Page");
        }
        catch (Exception exception)
        {
            exception.printStackTrace(System.out);
        }
    }

    public void changePageOrientation(boolean bNewLandscape)
    {
        try
        {
            com.sun.star.awt.Size oNewSize;
            getReportPageStyles();
            com.sun.star.awt.Size oLocSize = (com.sun.star.awt.Size) Helper.getUnoStructValue(ReportPageStyle, "Size");
            bIsCurLandscape = AnyConverter.toBoolean(Helper.getUnoPropertyValue(ReportPageStyle, "IsLandscape"));
            if (bIsCurLandscape != bNewLandscape)
            {
                oNewSize = new com.sun.star.awt.Size(oLocSize.Height, oLocSize.Width);
                Helper.setUnoPropertyValue(ReportPageStyle, "IsLandscape", new Boolean(bNewLandscape));
                Helper.setUnoPropertyValue(ReportPageStyle, "Size", oNewSize);
                Helper.setUnoPropertyValue(FirstPageStyle, "IsLandscape", new Boolean(bNewLandscape));
                Helper.setUnoPropertyValue(FirstPageStyle, "Size", oNewSize);
                int iLeftMargin = AnyConverter.toInt(Helper.getUnoPropertyValue(ReportPageStyle, "LeftMargin"));
                int iRightMargin = AnyConverter.toInt(Helper.getUnoPropertyValue(ReportPageStyle, "RightMargin"));
                PageWidth = oNewSize.Width - iLeftMargin - iRightMargin;
                if (CurRecordTable != null)
                {
                    CurRecordTable.adjustOptimalTableWidths(xMSF, oViewHandler);
                }
            }
        }
        catch (Exception exception)
        {
            exception.printStackTrace(System.out);
        }
    }

    public boolean loadSectionsfromTemplate(String sTemplateUrl)
    {
        try
        {
            int i;
            DBColumn CurDBColumn;
            int GroupCount = CurDBMetaData.GroupFieldNames.length;
            CurRecordTable = null;
            for (i = 0; i < GroupCount; i++)
            {
                String SectionName = GROUPSECTION + Integer.toString(i + 1);
                oTextTableHandler.renameTextTable("Tbl_" + SectionName, "MyTextTable");
                oTextSectionHandler.linkSectiontoTemplate(sTemplateUrl, SectionName);
                oTextTableHandler.renameTextTable("MyTextTable", "Tbl_" + SectionName);
            }
            if (oTextSectionHandler.xTextSectionsSupplier.getTextSections().getElementNames().length > CurDBMetaData.GroupFieldNames.length)
            {
                oTextSectionHandler.linkSectiontoTemplate(sTemplateUrl, RECORDSECTION);
                CurRecordTable = new RecordTable(oTextTableHandler);
                insertColumnstoRecordTable();
            }
            for (i = 0; i < GroupCount; i++)
            {
                CurDBColumn = new DBColumn(oTextTableHandler, CurDBMetaData, CurDBMetaData.GroupFieldNames[i], i, TBLGROUPSECTION + (i + 1));
                if (CurDBColumn == null)
                {
                    return false;
                }
                else
                {
                    CurDBColumn.formatValueCell();
                    DBColumnsVector.set(i, CurDBColumn);
                    replaceFieldValueInGroupTable(CurDBColumn, i);
                }
            }
            return true;
        }
        catch (Exception exception)
        {
            exception.printStackTrace(System.out);
            return false;
        }
    }

    public void setupRecordSection(String TemplateName)
    {
        this.ContentTemplatePath = TemplateName;
        if (CurDBMetaData.getRecordFieldNames().length > 0)
        {
            boolean bAddParagraph = true;
            if (CurDBMetaData.GroupFieldNames != null)
            {
                bAddParagraph = (CurDBMetaData.GroupFieldNames.length == 0);
            }
            oTextSectionHandler.insertTextSection(RECORDSECTION, TemplateName, bAddParagraph);
            CurRecordTable = new RecordTable(oTextTableHandler);
            insertColumnstoRecordTable();
            if (CurRecordTable != null)
            {
                CurRecordTable.adjustOptimalTableWidths(xMSF, oViewHandler);
            }
        }
        else
        {
            CurRecordTable = null;
        }
    }

    public void refreshGroupFields(String[] _sNewNames)
    {
        int nSize = DBColumnsVector.size();
        for (int i = 0; i < nSize; i++)
        {
            DBColumn CurDBColumn = (DBColumn) DBColumnsVector.elementAt(i);
            String sFieldName = CurDBColumn.CurDBField.m_sFieldName;
            if (!sFieldName.equals(_sNewNames[i]))
            {
                CurDBColumn.CurDBField = CurDBMetaData.getFieldColumnByDisplayName(_sNewNames[i]);
                CurDBColumn.insertColumnData(oTextFieldHandler, bIsCurLandscape);
            }
        }
    }
    //public boolean isGroupField(String _FieldName)
    //    {
    //        return (JavaTools.FieldInList(CurDBMetaData.GroupFieldNames, _FieldName) != -1);
    //    }
    public void replaceFieldValueInRecordSection(int RecordCount)
    {
        int GroupCount = CurDBMetaData.GroupFieldNames.length;
        int FieldCount = CurDBMetaData.getFieldNames().length;
        for (int i = GroupCount; i < FieldCount; i++)
        {
            ((DBColumn) DBColumnsVector.elementAt(i)).insertColumnData(oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public void updateTextSections(String[] SelGroupNames) throws Exception
    {
        String TableName;
        DBColumn OldDBColumn;
        DBColumn CurDBColumn;
        XNameAccess xTableNames = oTextTableHandler.xTextTablesSupplier.getTextTables();
        int GroupFieldCount = SelGroupNames.length;
        for (int i = 0; i < GroupFieldCount; i++)
        {
            TableName = TBLGROUPSECTION + Integer.toString(i + 1);
            OldDBColumn = (DBColumn) DBColumnsVector.get(i);
            CurDBColumn = new DBColumn(oTextTableHandler, CurDBMetaData, SelGroupNames[i], i, TableName, OldDBColumn);
            CurDBColumn.formatValueCell();
            DBColumnsVector.setElementAt(CurDBColumn, i);
            CurDBColumn.insertColumnData(oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public void replaceFieldValueInGroupTable(DBColumn CurDBColumn, int TableIndex)
    {
        String TableName = TBLGROUPSECTION + (TableIndex + 1);
        // Note: for some reason the table might lose its name and has to be renamed therefor
        String OldTableName = CurDBColumn.xTableName.getName();
        if (OldTableName.compareTo(TableName) != 0)
        {
            CurDBColumn.xTableName.setName(TableName);
        }
        CurDBColumn.insertColumnData(oTextFieldHandler, this.bIsCurLandscape);
        CurDBColumn.setCellFont();
    }

    public void replaceFieldValueInRecordTable()
    {
        String TableName = TBLRECORDSECTION;
        String OldTableName = CurRecordTable.xTableName.getName();
        if (OldTableName.compareTo(TableName) != 0)
        {
            CurRecordTable.xTableName.setName(TableName);
        }
        int GroupCount = CurDBMetaData.GroupFieldNames.length;
        int RecordCount = CurDBMetaData.getRecordFieldNames().length;
        for (int i = GroupCount; i < RecordCount; i++)
        {
            ((DBColumn) DBColumnsVector.elementAt(i)).insertColumnData(oTextFieldHandler, this.bIsCurLandscape);
        }
    }

    public void insertColumnstoRecordTable()
    {
        try
        {
            int GroupCount = CurDBMetaData.GroupFieldNames.length;
            DBColumn CurDBColumn;
            // Note for some reason the table might lose its name and has to be renamed therefor
            String OldTableName = CurRecordTable.xTableName.getName();
            if (OldTableName.compareTo(TBLRECORDSECTION) != 0)
            {
                CurRecordTable = new RecordTable(oTextTableHandler);
            }
            com.sun.star.table.XTableColumns xColumns = CurRecordTable.xTextTable.getColumns();
            int ColCount = xColumns.getCount();
            int RecordCount = CurDBMetaData.getRecordFieldNames().length;
            if (ColCount > RecordCount)
            {
                int RemoveCount = ColCount - RecordCount;
                xColumns.removeByIndex(0, RemoveCount);
            }
            else if (ColCount < RecordCount)
            {
                int AddCount = RecordCount - ColCount;
                CurRecordTable.xTextTable.getColumns().insertByIndex(ColCount, AddCount);
            }
            for (int i = 0; i < RecordCount; i++)
            {
                CurDBColumn = new DBColumn(CurRecordTable, oTextTableHandler, CurDBMetaData, i, true);
                CurDBColumn.initializeNumberFormat();
                CurDBColumn.insertColumnData(oTextFieldHandler, this.bIsCurLandscape);
                if (DBColumnsVector.size() <= (i + GroupCount))
                {
                    DBColumnsVector.add(CurDBColumn);
                }
                else
                {
                    DBColumnsVector.set(i + GroupCount, CurDBColumn);
                }
            }
        }
        catch (Exception exception)
        {
            showCommonReportErrorBox(exception);
        }
    }

    public boolean addGroupNametoDocument(String[] GroupNames, String CurGroupTitle, Vector GroupFieldVector, ArrayList ReportPath, int iSelCount)
    {
        DBColumn CurDBColumn = null;
        int GroupCount = GroupFieldVector.size();
        if (GroupCount < 4)
        {
            removeGroupNamesofRecordTable(iSelCount);
            FieldColumn CurFieldColumn = CurDBMetaData.getFieldColumnByTitle(CurGroupTitle);
            GroupFieldVector.addElement(CurFieldColumn.m_sFieldName);
            GroupCount += 1;
            try
            {
                String sPath = FileAccess.getPathFromList(xMSF, ReportPath, "cnt-default.ott");
                oTextSectionHandler.insertTextSection(GROUPSECTION + GroupCount, sPath, GroupCount == 1);
                CurDBColumn = new DBColumn(oTextTableHandler, CurDBMetaData, CurFieldColumn.m_sFieldName, GroupCount - 1, TBLGROUPSECTION + (GroupCount));
                CurDBColumn.formatValueCell();
                if (CurDBColumn != null)
                {
                    DBColumnsVector.addElement(CurDBColumn);
                    replaceFieldValueInGroupTable(CurDBColumn, GroupCount - 1);
                }
                else
                {
                    String sMessage = JavaTools.replaceSubString(sMsgTableNotExisting, TBLGROUPSECTION + (GroupCount), "<TABLENAME>");
                    CurDBMetaData.showMessageBox("ErrorBox", VclWindowPeerAttribute.OK, sMessage);
                }
            }
            catch (Exception exception)
            {
                showCommonReportErrorBox(exception);
            }

        }

        return (CurDBColumn != null);
    }

    public void removeGroupName(String[] NewSelGroupNames, String CurGroupTitle, java.util.Vector GroupFieldVector)
    {
        removeGroupNamesofRecordTable(NewSelGroupNames.length + 1);
        FieldColumn CurFieldColumn = CurDBMetaData.getFieldColumnByTitle(CurGroupTitle);
        GroupFieldVector.removeElement(CurFieldColumn.m_sFieldName);
        try
        {
            oTextSectionHandler.removeLastTextSection();
            oTextTableHandler.removeLastTextTable();
            // if the previously selected item is somewhere in the middle of the listbox (and not at the end) the
            // Textsections have to be updated
            if (JavaTools.FieldInList(NewSelGroupNames, CurGroupTitle) == -1)
            {
                updateTextSections(NewSelGroupNames);
            }
            int iSelItemCount = NewSelGroupNames.length;
            DBColumnsVector.remove(iSelItemCount);
        }
        catch (Exception exception)
        {
            showCommonReportErrorBox(exception);
        }
    }

    public void removeGroupNamesofRecordTable(int GroupFieldCount)
    {
        int CurFieldCount = DBColumnsVector.size();
        if (CurFieldCount > GroupFieldCount)
        {
            for (int i = CurFieldCount - 1; i >= GroupFieldCount; i--)
            {
                DBColumnsVector.removeElementAt(i);
            }
        }
    }

    public void showCommonReportErrorBox(Exception exception)
    {
        String SystemContentPath = JavaTools.convertfromURLNotation(ContentTemplatePath);
        String sMsgCurCommonReportError = JavaTools.replaceSubString(sMsgCommonReportError, SystemContentPath, "%PATH");
        CurDBMetaData.showMessageBox("ErrorBox", VclWindowPeerAttribute.OK, sMsgCurCommonReportError);
        exception.printStackTrace(System.out);
    }

    public void getallDBColumns()
    {
        try
        {
            DBColumn CurDBColumn;
            for (int i = 0; i < CurDBMetaData.FieldColumns.length; i++)
            {
                if (i < CurDBMetaData.GroupFieldNames.length)
                {
                    CurDBColumn = new DBColumn(oTextTableHandler, CurDBMetaData, CurDBMetaData.GroupFieldNames[i], i, COPYOFTBLGROUPSECTION + (i + 1));
                }
                else
                {
                    if (CurRecordTable == null)
                    {
                        CurRecordTable = new RecordTable(oTextTableHandler);
                    }
                    CurDBColumn = new DBColumn(CurRecordTable, oTextTableHandler, CurDBMetaData, i - CurDBMetaData.GroupFieldNames.length);
                }
                if (CurDBColumn != null)
                {
                    if (CurDBColumn.xNameCell != null)
                    {
                        DBColumnsVector.addElement(CurDBColumn);
                    }
                    else
                    {
                        String DelFieldName;
                        if (i < CurDBMetaData.GroupFieldNames.length)
                        {
                            DelFieldName = CurDBMetaData.GroupFieldNames[i];
                            CurDBMetaData.GroupFieldNames = JavaTools.removefromList(CurDBMetaData.GroupFieldNames, new String[]
                                    {
                                        DelFieldName
                                    });
                            CurDBMetaData.GroupFieldColumns = removeFieldColumnByFieldName(DelFieldName, CurDBMetaData.GroupFieldColumns);
                        }
                        else
                        {
                            DelFieldName = CurDBMetaData.getRecordFieldName(i - CurDBMetaData.GroupFieldNames.length);
                            String[] aNewList = JavaTools.removefromList(CurDBMetaData.getRecordFieldNames(), new String[]
                                    {
                                        DelFieldName
                                    });
                            CurDBMetaData.setRecordFieldNames(aNewList);
                            CurDBMetaData.RecordFieldColumns = removeFieldColumnByFieldName(DelFieldName, CurDBMetaData.RecordFieldColumns);
                            CurDBMetaData.FieldColumns = removeFieldColumnByFieldName(DelFieldName, CurDBMetaData.FieldColumns);

                        }
                        i--;
                    }
                }
                else
                {
                    String sMessage = JavaTools.replaceSubString(sMsgTableNotExisting, TBLGROUPSECTION + (CurDBMetaData.GroupFieldNames.length), "<TABLENAME>");
                    CurDBMetaData.showMessageBox("ErrorBox", VclWindowPeerAttribute.OK, sMessage);
                }
            }
            java.util.Arrays.sort(CurDBMetaData.RecordFieldColumns, this);
        }
        catch (Exception exception)
        {
            showCommonReportErrorBox(exception);
        }
    }

    public int compare(Object _oObject1, Object _oObject2)
    {
        FieldColumn oFieldColumn1 = (FieldColumn) _oObject1;
        FieldColumn oFieldColumn2 = (FieldColumn) _oObject2;
        DBColumn oDBColumn1 = getDBColumnByName(oFieldColumn1.m_sFieldName);
        DBColumn oDBColumn2 = getDBColumnByName(oFieldColumn2.m_sFieldName);
        if (oDBColumn1.ValColumn < oDBColumn2.ValColumn)
        {
            return -1;
        }
        else if (oDBColumn1.ValColumn == oDBColumn2.ValColumn)
        {
            return 0;
        }
        else
        {
            return 1;
        }
    }

    private DBColumn getDBColumnByName(String _FieldName)
    {
        for (int i = 0; i < DBColumnsVector.size(); i++)
        {
            DBColumn oDBColumn = (DBColumn) DBColumnsVector.get(i);
            if (oDBColumn.CurDBField.m_sFieldName.equals(_FieldName))
            {
                return oDBColumn;
            }
        }
        return null;
    }

    public static FieldColumn[] removeFieldColumnByFieldName(String _FieldName, FieldColumn[] _FieldColumns)
    {
        try
        {
            Vector aFieldColumns = new Vector();
            for (int i = 0; i < _FieldColumns.length; i++)
            {
                FieldColumn CurFieldColumn = _FieldColumns[i];
                if (!CurFieldColumn.m_sFieldName.equals(_FieldName))
                {
                    aFieldColumns.add(CurFieldColumn);
                }
            }
            FieldColumn[] aRetList = new FieldColumn[aFieldColumns.size()];
            aFieldColumns.toArray(aRetList);
            return aRetList;
        }
        catch (RuntimeException e)
        {
            e.printStackTrace(System.out);
            return null;
        }
    }

    public void removeAllVisibleTextSections()
    {
        int GroupCount = CurDBMetaData.GroupFieldNames.length;
        String[] sInvisibleSectionNames = new String[GroupCount + 1];
        sInvisibleSectionNames[0] = RECORDSECTION;
        for (int i = 1; i <= GroupCount; i++)
        {
            sInvisibleSectionNames[i] = GROUPSECTION + i;
        }
        XNameAccess xNameAccessTextSections = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, oTextSectionHandler.xTextSectionsSupplier.getTextSections());
        String[] sSectionNames = xNameAccessTextSections.getElementNames();
        for (int i = 0; i < sSectionNames.length; i++)
        {
            String sSectionName = sSectionNames[i];
            if (JavaTools.FieldInList(sInvisibleSectionNames, sSectionName) < 0)
            {
                oTextSectionHandler.removeTextSectionbyName(sSectionName);
            }
        }
    }

    private String[] getLayoutTextTableNames()
    {
        int GroupCount = CurDBMetaData.GroupFieldNames.length;
        String[] sLayoutTableNames = new String[GroupCount + 1];
        for (int i = 0; i < GroupCount; i++)
        {
            sLayoutTableNames[i] = TBLGROUPSECTION + (i + 1);
        }
        sLayoutTableNames[GroupCount] = TBLRECORDSECTION;
        return sLayoutTableNames;
    }

    public void removeNonLayoutTextTables()
    {
        String[] sLayoutTableNames = getLayoutTextTableNames();
        XNameAccess xNameAccessTextTables = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, oTextTableHandler.xTextTablesSupplier.getTextTables());
        String[] sTableNames = xNameAccessTextTables.getElementNames();
        for (int i = 0; i < sTableNames.length; i++)
        {
            String sTableName = sTableNames[i];
            if (JavaTools.FieldInList(sLayoutTableNames, sTableName) < 0)
            {
                oTextTableHandler.removeTextTablebyName(sTableName);
            }
        }
    }

    public void removeLayoutTextTables()
    {
        String[] sLayoutTableNames = getLayoutTextTableNames();
        XNameAccess xNameAccessTextTables = (XNameAccess) UnoRuntime.queryInterface(XNameAccess.class, oTextTableHandler.xTextTablesSupplier.getTextTables());
        XRelativeTextContentRemove xRelativeTextContentRemove = (XRelativeTextContentRemove) UnoRuntime.queryInterface(XRelativeTextContentRemove.class, xText);
        String[] sTableNames = xNameAccessTextTables.getElementNames();
        for (int i = 0; i < sTableNames.length; i++)
        {
            String sTableName = sTableNames[i];
            if (JavaTools.FieldInList(sLayoutTableNames, sTableName) > -1)
            {
                if (!sTableName.equals(sLayoutTableNames[0]))
                {
                    XTextContent xTextContent = (XTextContent) UnoRuntime.queryInterface(XTextContent.class, oTextTableHandler.getByName(sTableName));
                    boolean bleaveloop = false;
                    while (!bleaveloop)
                    {
                        try
                        {
//                                xRelativeTextContentRemove.removeTextContentBefore(xTextContent);
                            xRelativeTextContentRemove.removeTextContentAfter(xTextContent);
                        // IllegalArgumentException may be thrown when no paragraphbreak is there
                        }
                        catch (IllegalArgumentException iexception)
                        {
                            bleaveloop = true;
                        }
                    }
                }
                oTextTableHandler.removeTextTablebyName(sTableName);
            }
        }
    }

    public void setLayoutSectionsVisible(boolean _IsVisible)
    {
        try
        {
            XNameAccess xTextSections = oTextSectionHandler.xTextSectionsSupplier.getTextSections();
            Object oTextSection;
            int GroupFieldCount = CurDBMetaData.GroupFieldNames.length;
            for (int i = 0; i < GroupFieldCount; i++)
            {
                oTextSection = xTextSections.getByName(GROUPSECTION + String.valueOf(i + 1));
                Helper.setUnoPropertyValue(oTextSection, "IsVisible", new Boolean(_IsVisible));
            }
            if (xTextSections.hasByName(RECORDSECTION))
            {
                oTextSection = xTextSections.getByName(RECORDSECTION);
                Helper.setUnoPropertyValue(oTextSection, "IsVisible", new Boolean(_IsVisible));
            }
        }
        catch (Exception exception)
        {
            exception.printStackTrace(System.out);
        }
    }

    public void removeCopiedTextSections()
    {
        int GroupCount = CurDBMetaData.GroupFieldNames.length;
        String[] sCopyTextSections = new String[GroupCount + 1];
        String[] sCopyTextTables = new String[GroupCount + 1];
        sCopyTextSections[0] = COPYOFRECORDSECTION;
        sCopyTextTables[0] = COPYOFTBLRECORDSECTION;
        for (int i = 1; i <= GroupCount; i++)
        {
            sCopyTextSections[i] = COPYOFGROUPSECTION + (i);
            sCopyTextTables[i] = COPYOFTBLGROUPSECTION + (i);
        }
        for (int i = 0; i <= GroupCount; i++)
        {
            oTextTableHandler.removeTextTablebyName(sCopyTextTables[i]);
            oTextSectionHandler.removeTextSectionbyName(sCopyTextSections[i]);
        }
    }
}
