/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * CompoundFontStorage.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.merge;

import java.util.HashMap;

import org.pentaho.reporting.libraries.fonts.cache.FirstLevelFontCache;
import org.pentaho.reporting.libraries.fonts.registry.FontContext;
import org.pentaho.reporting.libraries.fonts.registry.FontIdentifier;
import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontMetricsFactory;
import org.pentaho.reporting.libraries.fonts.registry.FontRegistry;
import org.pentaho.reporting.libraries.fonts.registry.FontStorage;
import org.pentaho.reporting.libraries.base.util.DebugLog;

/**
 * Creation-Date: 20.07.2007, 19:35:31
 *
 * @author Thomas Morgner
 */
public class CompoundFontStorage implements FontStorage
{
  private CompoundFontRegistry fontRegistry;
  private HashMap metricsFactories;
  private FirstLevelFontCache firstLevelFontCache;
  private FontKey lookupKey;
  private int hits;
  private int misses;

  public CompoundFontStorage()
  {
    this.fontRegistry = new CompoundFontRegistry();
    this.metricsFactories = new HashMap();
    this.firstLevelFontCache = new FirstLevelFontCache(fontRegistry.getSecondLevelCache());
    this.lookupKey = new FontKey();
  }

  public void addRegistry(final FontRegistry registry)
  {
    fontRegistry.addRegistry(registry);
  }

  public FontRegistry getFontRegistry()
  {
    return fontRegistry;
  }

  public FontMetrics getFontMetrics(final FontIdentifier record, final FontContext context)
  {
    if (record == null)
    {
      throw new NullPointerException();
    }
    if (context == null)
    {
      throw new NullPointerException();
    }

    lookupKey.setAliased(context.isAntiAliased());
    lookupKey.setFontSize(context.getFontSize());
    lookupKey.setIdentifier(record);
    lookupKey.setFractional(context.isFractionalMetrics());

    final FontMetrics cachedMetrics = firstLevelFontCache.getFontMetrics(lookupKey);
    if (cachedMetrics != null)
    {
      hits += 1;
      return cachedMetrics;
    }

    final CompoundFontIdentifier cid = (CompoundFontIdentifier) record;
    final FontRegistry registry = cid.getRegistry();
    FontMetricsFactory metricsFactory = (FontMetricsFactory) metricsFactories.get(registry);
    if (metricsFactory == null)
    {
      metricsFactory = registry.createMetricsFactory();
      metricsFactories.put(registry, metricsFactory);
    }

    misses += 1;

    final FontKey key = new FontKey(record, context.isAntiAliased(),
        context.isFractionalMetrics(), context.getFontSize());
    final FontMetrics metrics = metricsFactory.createMetrics(cid.getIdentifier(), context);
    firstLevelFontCache.putFontMetrics(key, metrics);
    return metrics;
  }

  public void commit()
  {
    DebugLog.log("Font-Storage: hits=" + hits + ", misses=" + misses);
    firstLevelFontCache.commit();
  }
}
