/**
 * =========================================
 * LibFormula : a free Java formula library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libformula/
 *
 * (C) Copyright 2006-2007, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * $Id: ArrayTest.java 6653 2008-12-02 14:53:40Z tmorgner $
 * ------------
 * (C) Copyright 2006-2007, by Pentaho Corporation.
 */
package org.pentaho.reporting.libraries.formula.typing;

import junit.framework.TestCase;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaBoot;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.common.TestFormulaContext;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.parser.ParseException;

/**
 * @author Cedric Pronzato
 */
public class ArrayTest extends TestCase
{
  private FormulaContext context;

  public ArrayTest()
  {
  }

  public ArrayTest(final String s)
  {
    super(s);
  }

  public void setUp()
  {
    context = new TestFormulaContext(TestFormulaContext.testCaseDataset);
    LibFormulaBoot.getInstance().start();
  }

  public void testRowsInlineArrays() throws Exception
  {
    final Formula formula = new Formula("{3|2|1}");
    formula.initialize(context);
    final TypeValuePair evaluation = formula.evaluateTyped();
    assertNotNull(evaluation);
    assertTrue(evaluation.getType().isFlagSet(Type.ARRAY_TYPE));

    final ArrayCallback table = (ArrayCallback) evaluation.getValue();
    assertEquals(table.getColumnCount(), 1);
    assertEquals(table.getRowCount(), 3);
  }

  public void testColumnsInlineArrays() throws Exception
  {
    final Formula formula = new Formula("{3;2;1}");
    formula.initialize(context);
    final TypeValuePair evaluation = formula.evaluateTyped();
    assertNotNull(evaluation);
    assertTrue(evaluation.getType().isFlagSet(Type.ARRAY_TYPE));

    final ArrayCallback table = (ArrayCallback) evaluation.getValue();
    assertEquals(table.getColumnCount(), 3);
    assertEquals(table.getRowCount(), 1);
  }

  public void testInlineArrays() throws Exception
  {
    final Formula formula = new Formula("{3;2;1|2;4;6}");
    formula.initialize(context);

    final TypeValuePair evaluation = formula.evaluateTyped();
    assertNotNull(evaluation);
    assertTrue(evaluation.getType().isFlagSet(Type.ARRAY_TYPE));

    final ArrayCallback table = (ArrayCallback) evaluation.getValue();
    assertEquals(table.getColumnCount(), 3);
    assertEquals(table.getRowCount(), 2);
  }

  public void testInvalidInlineArrays() throws Exception
  {
    final Formula formula = new Formula("{3;2;1|2;6}");
    formula.initialize(context);
    final Object evaluate = formula.evaluate();
    assertEquals(evaluate, LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);

  }

  public void testInvalidInlineArrays2() throws EvaluationException, ParseException
  {
    Formula formula = null;
    formula = new Formula("{3;1|2;6;5;6}");
    formula.initialize(context);
    final Object evaluate = formula.evaluate();
    assertEquals(evaluate, LibFormulaErrorValue.ERROR_ILLEGAL_ARRAY_VALUE);

  }
}
