/**
 * ===========================================
 * LibBase : a free Java utility library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libbase
 *
 * (C) Copyright 2007,2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * LibBaseBoot
 * ------------
 * (C) Copyright 2006, by Pentaho Corporation.
 */



package org.pentaho.reporting.libraries.base;

import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

/**
 * An utility class to safely boot and initialize the LibBase library.
 *
 * @author : Thomas Morgner
 */
public class LibBaseBoot extends AbstractBoot
{
  private static LibBaseBoot instance;

  /**
   * Returns the singleton instance of LibBaseBoot.
   *
   * @return the boot class for Libbase.
   */
  public static synchronized LibBaseBoot getInstance()
  {
    if (instance == null)
    {
      instance = new LibBaseBoot();
    }
    return instance;
  }

  /**
   * Private constructor prevents object creation.
   */
  private LibBaseBoot()
  {
  }

  /**
   * Loads the configuration for LibBase. This will be called exactly once. The configuration is loaded from
   * a file called "libbase.properties" located next to this class. A user overridable properties file is searched
   * on the classpath within all libraries using the name "/libbase.properties".
   *
   * @return The configuration.
   */
  protected Configuration loadConfiguration()
  {
    return createDefaultHierarchicalConfiguration
        ("/org/pentaho/reporting/libraries/base/libbase.properties",
            "/libbase.properties", true, LibBaseBoot.class);
  }

  /**
   * Performs the boot. This method does nothing.
   */
  protected void performBoot()
  {
    // nothing required. Just gather the configuration.
  }

  /**
   * Returns the project info.
   *
   * @return The project info.
   */
  protected ProjectInformation getProjectInfo()
  {
    return LibBaseInfo.getInstance();
  }
}
